/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.RADComponent;
import org.openide.awt.Mnemonics;

public class PropertyPicker
extends JPanel {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    static final long serialVersionUID = 5689122601606238081L;
    private JLabel componentLabel;
    private JComboBox componentsCombo;
    private JLabel listLabel;
    private JScrollPane propertiesScrollPane;
    private JList propertyList;
    private boolean pickerValid = false;
    private RADComponent[] components;
    private Class requiredType;
    private PropertyPickerItem[] items;
    private RADComponent selectedComponent;
    private static Class[] NO_PARAMETERS = new Class[0];

    public PropertyPicker(FormModel formModel, RADComponent rADComponent, Class clazz) {
        this.requiredType = clazz;
        this.initComponents();
        List<RADComponent> list = formModel.getComponentList();
        Collections.sort(list, new ParametersPicker.ComponentComparator());
        this.components = new RADComponent[list.size()];
        list.toArray(this.components);
        int n = -1;
        for (RADComponent rADComponent2 : list) {
            if (rADComponent != null && rADComponent == rADComponent2) {
                n = this.componentsCombo.getItemCount();
            }
            if (rADComponent2 == formModel.getTopRADComponent()) {
                this.componentsCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                continue;
            }
            this.componentsCombo.addItem(rADComponent2.getName());
        }
        if (n >= 0) {
            this.componentsCombo.setSelectedIndex(n);
        }
        this.propertyList.setSelectionMode(0);
        this.updatePropertyList();
        Mnemonics.setLocalizedText((JLabel)this.componentLabel, (String)FormUtils.getBundleString("CTL_CW_Component"));
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)FormUtils.getBundleString("CTL_CW_PropertyList"));
        this.componentsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Component"));
        this.propertyList.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_PropertyList"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_PropertyPicker"));
    }

    public boolean isPickerValid() {
        return this.pickerValid;
    }

    private void setPickerValid(boolean bl) {
        boolean bl2 = this.pickerValid;
        this.pickerValid = bl;
        this.firePropertyChange("pickerValid", bl2, this.pickerValid);
    }

    RADComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    void setSelectedComponent(RADComponent rADComponent) {
        if (rADComponent != null) {
            this.componentsCombo.setSelectedItem(rADComponent.getName());
        }
    }

    PropertyPickerItem getSelectedProperty() {
        if (this.selectedComponent == null || this.propertyList.getSelectedIndex() == -1) {
            return null;
        }
        return this.items[this.propertyList.getSelectedIndex()];
    }

    void setSelectedProperty(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            this.propertyList.setSelectedIndex(-1);
        } else {
            this.propertyList.setSelectedValue(propertyDescriptor.getName(), true);
        }
    }

    private void updatePropertyList() {
        RADComponent rADComponent = this.getSelectedComponent();
        if (rADComponent == null) {
            this.propertyList.setListData(new Object[0]);
            this.propertyList.revalidate();
            this.propertyList.repaint();
        } else {
            PropertyDescriptor[] propertyDescriptorArray = rADComponent.getBeanInfo().getPropertyDescriptors();
            HashMap<String, PropertyPickerItem> hashMap = new HashMap<String, PropertyPickerItem>();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (propertyDescriptorArray[i].getReadMethod() == null || propertyDescriptorArray[i].getPropertyType() == null || !this.requiredType.isAssignableFrom(propertyDescriptorArray[i].getPropertyType())) continue;
                PropertyPickerItem propertyPickerItem = this.createItem(propertyDescriptorArray[i]);
                hashMap.put(propertyPickerItem.getPropertyName(), propertyPickerItem);
            }
            if (rADComponent == rADComponent.getFormModel().getTopRADComponent()) {
                String[] stringArray = FormEditor.getFormJavaSource(rADComponent.getFormModel()).getPropertyReadMethodNames(this.requiredType);
                for (int i = 0; i < stringArray.length; ++i) {
                    PropertyPickerItem propertyPickerItem = this.createItem(stringArray[i]);
                    if (hashMap.keySet().contains(propertyPickerItem.getPropertyName())) continue;
                    hashMap.put(propertyPickerItem.getPropertyName(), propertyPickerItem);
                }
            }
            this.items = new PropertyPickerItem[hashMap.size()];
            hashMap.values().toArray(this.items);
            Arrays.sort(this.items, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((PropertyPickerItem)object).getPropertyName().compareTo(((PropertyPickerItem)object2).getPropertyName());
                }
            });
            String[] stringArray = new String[this.items.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.items[i].getPropertyName();
            }
            this.propertyList.setListData(stringArray);
            this.propertyList.revalidate();
            this.propertyList.repaint();
        }
    }

    private PropertyPickerItem createItem(final PropertyDescriptor propertyDescriptor) {
        return new PropertyPickerItem(){

            public String getPropertyName() {
                return propertyDescriptor.getName();
            }

            public String getReadMethodName() {
                return propertyDescriptor.getReadMethod().getName();
            }

            public boolean providesPropertyDescriptor() {
                return true;
            }

            public PropertyDescriptor getPropertyDescriptor() {
                return propertyDescriptor;
            }
        };
    }

    private PropertyPickerItem createItem(final String string) {
        return new PropertyPickerItem(){

            public String getPropertyName() {
                return FormJavaSource.extractPropertyName(string);
            }

            public String getReadMethodName() {
                return FormUtils.getMethodName(string, NO_PARAMETERS);
            }

            public boolean providesPropertyDescriptor() {
                return false;
            }

            public PropertyDescriptor getPropertyDescriptor() {
                return null;
            }
        };
    }

    private void updateState() {
        this.setPickerValid(this.getSelectedComponent() != null && this.getSelectedProperty() != null);
    }

    private void initComponents() {
        this.componentsCombo = new JComboBox();
        this.propertiesScrollPane = new JScrollPane();
        this.propertyList = new JList();
        this.componentLabel = new JLabel();
        this.listLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.componentsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PropertyPicker.this.componentsComboItemStateChanged(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.componentsCombo, gridBagConstraints);
        this.propertyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PropertyPicker.this.propertyListValueChanged(listSelectionEvent);
            }
        });
        this.propertiesScrollPane.setViewportView(this.propertyList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
        this.componentLabel.setLabelFor(this.componentsCombo);
        this.componentLabel.setText("Component:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 6);
        this.add((Component)this.componentLabel, gridBagConstraints);
        this.listLabel.setLabelFor(this.propertyList);
        this.listLabel.setText("Properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void propertyListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateState();
    }

    private void componentsComboItemStateChanged(ItemEvent itemEvent) {
        this.selectedComponent = this.componentsCombo.getSelectedIndex() == -1 ? null : this.components[this.componentsCombo.getSelectedIndex()];
        this.updatePropertyList();
    }

    static interface PropertyPickerItem {
        public String getPropertyName();

        public String getReadMethodName();

        public PropertyDescriptor getPropertyDescriptor();
    }
}

