/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JScrollPane;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.CopySupport;
import org.netbeans.modules.form.DefaultRADAction;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyCookie;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADMenuComponent;
import org.netbeans.modules.form.RADMenuItemComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.actions.AddAction;
import org.netbeans.modules.form.actions.AlignAction;
import org.netbeans.modules.form.actions.ChooseSameSizeAction;
import org.netbeans.modules.form.actions.CustomCodeAction;
import org.netbeans.modules.form.actions.CustomizeEmptySpaceAction;
import org.netbeans.modules.form.actions.CustomizeLayoutAction;
import org.netbeans.modules.form.actions.DefaultSizeAction;
import org.netbeans.modules.form.actions.EditContainerAction;
import org.netbeans.modules.form.actions.EditFormAction;
import org.netbeans.modules.form.actions.EventsAction;
import org.netbeans.modules.form.actions.InPlaceEditAction;
import org.netbeans.modules.form.actions.PropertyAction;
import org.netbeans.modules.form.actions.SelectLayoutAction;
import org.netbeans.modules.form.actions.SetAnchoringAction;
import org.netbeans.modules.form.actions.SetResizabilityAction;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.layoutsupport.LayoutNode;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.explorer.propertysheet.editors.NodeCustomizer;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class RADComponentNode
extends FormNode
implements RADComponentCookie,
FormPropertyCookie {
    private static final MessageFormat nodeNameFormat = new MessageFormat(FormUtils.getBundleString("FMT_ComponentNodeName"));
    private static final MessageFormat nodeNoNameFormat = new MessageFormat(FormUtils.getBundleString("FMT_UnnamedComponentNodeName"));
    private RADComponent component;
    private Action[] actions;
    private boolean highlightDisplayName;

    public RADComponentNode(RADComponent rADComponent) {
        this((Children)(rADComponent instanceof ComponentContainer ? new RADChildren((ComponentContainer)((Object)rADComponent)) : Children.LEAF), rADComponent);
    }

    public RADComponentNode(Children children, RADComponent rADComponent) {
        super(children, rADComponent.getFormModel());
        this.component = rADComponent;
        rADComponent.setNodeReference(this);
        if (rADComponent instanceof ComponentContainer) {
            this.getCookieSet().add((Node.Cookie)new ComponentsIndex());
        }
        this.updateName();
    }

    void updateName() {
        String string = Utilities.getShortClassName((Class)this.component.getBeanClass());
        if (this.component == this.component.getFormModel().getTopRADComponent()) {
            this.setDisplayName(nodeNoNameFormat.format(new Object[]{string}));
        } else {
            this.setDisplayName(nodeNameFormat.format(new Object[]{this.getName(), string}));
        }
    }

    public void fireComponentPropertiesChange() {
        this.firePropertyChange(null, null, null);
    }

    public void fireComponentPropertySetsChange() {
        this.firePropertySetsChange(null, null);
    }

    public Image getIcon(int n) {
        Image image = BeanSupport.getBeanIcon(this.component.getBeanClass(), n);
        if (image != null) {
            return image;
        }
        BeanInfo beanInfo = this.component.getBeanInfo();
        if (beanInfo != null && (image = beanInfo.getIcon(n)) != null) {
            return image;
        }
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.component-inspector");
    }

    public Node.PropertySet[] getPropertySets() {
        return this.component.getProperties();
    }

    public NewType[] getNewTypes() {
        return this.component.getNewTypes();
    }

    public Action getPreferredAction() {
        if (this.component instanceof RADVisualContainer) {
            return SystemAction.get(EditContainerAction.class);
        }
        return SystemAction.get(DefaultRADAction.class);
    }

    public Action[] getActions(boolean bl) {
        if (this.actions == null) {
            int n;
            Object[] objectArray;
            ArrayList<Object> arrayList = new ArrayList<Object>(20);
            RADComponent rADComponent = this.component.getFormModel().getTopRADComponent();
            if (this.component.isReadOnly()) {
                if (this.component == rADComponent) {
                    arrayList.add(SystemAction.get(TestAction.class));
                    arrayList.add(null);
                }
                objectArray = this.component.getKnownEvents();
                for (n = 0; n < objectArray.length; ++n) {
                    if (!objectArray[n].hasEventHandlers()) continue;
                    arrayList.add(SystemAction.get(EventsAction.class));
                    arrayList.add(null);
                    break;
                }
                arrayList.add(SystemAction.get(CopyAction.class));
            } else {
                objectArray = this.component.getActionProperties();
                for (RADProperty rADProperty : objectArray) {
                    PropertyAction propertyAction = new PropertyAction(rADProperty);
                    arrayList.add(propertyAction);
                }
                if (InPlaceEditLayer.supportsEditingFor(this.component.getBeanClass(), false)) {
                    arrayList.add(SystemAction.get(InPlaceEditAction.class));
                }
                if (this.component != rADComponent) {
                    arrayList.add(SystemAction.get(ChangeVariableNameAction.class));
                }
                if (this.component == rADComponent) {
                    arrayList.add(SystemAction.get(TestAction.class));
                }
                arrayList.add(SystemAction.get(EventsAction.class));
                arrayList.add(null);
                arrayList.add(SystemAction.get(AlignAction.class));
                arrayList.add(SystemAction.get(SetAnchoringAction.class));
                arrayList.add(SystemAction.get(SetResizabilityAction.class));
                arrayList.add(SystemAction.get(ChooseSameSizeAction.class));
                arrayList.add(SystemAction.get(DefaultSizeAction.class));
                arrayList.add(SystemAction.get(CustomizeEmptySpaceAction.class));
                arrayList.add(null);
                if (this.component instanceof RADVisualContainer) {
                    if (!((RADVisualContainer)this.component).hasDedicatedLayoutSupport()) {
                        arrayList.add(SystemAction.get(EditContainerAction.class));
                        if (rADComponent != null && this.component != rADComponent) {
                            arrayList.add(SystemAction.get(EditFormAction.class));
                        }
                        arrayList.add(SystemAction.get(SelectLayoutAction.class));
                        arrayList.add(SystemAction.get(CustomizeLayoutAction.class));
                    }
                    arrayList.add(SystemAction.get(AddAction.class));
                }
                if (this.getNewTypes().length != 0) {
                    arrayList.add(null);
                    arrayList.add(SystemAction.get(NewAction.class));
                }
                if (this.component != rADComponent) {
                    arrayList.add(SystemAction.get(MoveUpAction.class));
                    arrayList.add(SystemAction.get(MoveDownAction.class));
                }
                if (this.component instanceof ComponentContainer) {
                    arrayList.add(SystemAction.get(ReorderAction.class));
                }
                arrayList.add(null);
                if (this.component != rADComponent) {
                    arrayList.add(SystemAction.get(CutAction.class));
                }
                arrayList.add(SystemAction.get(CopyAction.class));
                if (this.component instanceof ComponentContainer) {
                    arrayList.add(SystemAction.get(PasteAction.class));
                }
                if (this.component != rADComponent) {
                    arrayList.add(SystemAction.get(DeleteAction.class));
                }
                arrayList.add(null);
                arrayList.add(SystemAction.get(CustomCodeAction.class));
            }
            arrayList.add(null);
            objectArray = super.getActions(bl);
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(objectArray[n]);
            }
            this.actions = new Action[arrayList.size()];
            arrayList.toArray(this.actions);
        }
        return this.actions;
    }

    public String getName() {
        return this.component.getName();
    }

    public void setName(String string) {
        this.component.setName(string);
    }

    public boolean canRename() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public boolean canDestroy() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public void destroy() throws IOException {
        Object object;
        RADComponent rADComponent = this.component.getParentComponent();
        if (rADComponent != null && (object = rADComponent.getBeanInstance()).getClass() == JScrollPane.class && rADComponent.getAuxValue("autoScrollPane") != null) {
            this.component = rADComponent;
        }
        if (EventQueue.isDispatchThread()) {
            this.component.getFormModel().removeComponent(this.component, true);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RADComponentNode.this.component.getFormModel().removeComponent(RADComponentNode.this.component, true);
                }
            });
        }
        this.component.setNodeReference(null);
        super.destroy();
    }

    public boolean hasCustomizer() {
        return !this.component.isReadOnly() && this.component.getBeanInfo().getBeanDescriptor().getCustomizerClass() != null;
    }

    protected Component createCustomizer() {
        Object obj;
        Class<?> clazz = this.component.getBeanInfo().getBeanDescriptor().getCustomizerClass();
        if (clazz == null) {
            return null;
        }
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            ErrorManager.getDefault().notify(16, (Throwable)instantiationException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(16, (Throwable)illegalAccessException);
            return null;
        }
        if (!(obj instanceof Component) || !(obj instanceof Customizer)) {
            return null;
        }
        if (obj instanceof FormAwareEditor) {
            ((FormAwareEditor)obj).setFormModel(this.component.getFormModel());
        }
        if (obj instanceof NodeCustomizer) {
            ((NodeCustomizer)obj).attach((Node)this.component.getNodeReference());
        }
        Customizer customizer = (Customizer)obj;
        customizer.setObject(this.component.getBeanInstance());
        customizer.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FormProperty[] formPropertyArray;
                if (propertyChangeEvent.getPropertyName() != null) {
                    RADProperty rADProperty = RADComponentNode.this.component.getBeanProperty(propertyChangeEvent.getPropertyName());
                    if (rADProperty == null) return;
                    formPropertyArray = new FormProperty[]{rADProperty};
                } else {
                    formPropertyArray = RADComponentNode.this.component.getAllBeanProperties();
                    propertyChangeEvent = null;
                }
                RADComponentNode.this.updatePropertiesFromCustomizer(formPropertyArray, propertyChangeEvent);
            }
        });
        return (Component)obj;
    }

    private void updatePropertiesFromCustomizer(final FormProperty[] formPropertyArray, final PropertyChangeEvent propertyChangeEvent) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object object = propertyChangeEvent != null ? propertyChangeEvent.getOldValue() : null;
                Object object2 = propertyChangeEvent != null ? propertyChangeEvent.getNewValue() : null;
                for (int i = 0; i < formPropertyArray.length; ++i) {
                    FormProperty formProperty = formPropertyArray[i];
                    try {
                        formProperty.reinstateProperty();
                        formProperty.propertyValueChanged(object, object2);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return !this.component.isReadOnly() && this.component != this.component.getFormModel().getTopRADComponent();
    }

    public Transferable clipboardCopy() throws IOException {
        return new CopySupport.RADTransferable(CopySupport.getComponentCopyFlavor(), this.component);
    }

    public Transferable clipboardCut() throws IOException {
        return new CopySupport.RADTransferable(CopySupport.getComponentCutFlavor(), this.component);
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        if (this.component.isReadOnly()) {
            return;
        }
        boolean bl = transferable.isDataFlavorSupported(CopySupport.getComponentCopyFlavor());
        boolean bl2 = transferable.isDataFlavorSupported(CopySupport.getComponentCutFlavor());
        if (bl || bl2) {
            RADComponent rADComponent = null;
            try {
                Object object = transferable.getTransferData(transferable.getTransferDataFlavors()[0]);
                if (object instanceof RADComponent) {
                    rADComponent = (RADComponent)object;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!(rADComponent == null || bl2 && !CopySupport.canPasteCut(rADComponent, this.component.getFormModel(), this.component) || !MetaComponentCreator.canAddComponent(rADComponent.getBeanClass(), this.component) && (bl2 || !MetaComponentCreator.canApplyComponent(rADComponent.getBeanClass(), this.component)) || this.component instanceof RADMenuComponent && !(rADComponent instanceof RADMenuItemComponent))) {
                list.add(new CopySupport.RADPaste(transferable, this.component.getFormModel(), this.component));
            }
        } else {
            ClassSource classSource = CopySupport.getCopiedBeanClassSource(transferable);
            if (classSource != null) {
                list.add(new CopySupport.ClassPaste(transferable, classSource, this.component.getFormModel(), this.component));
            }
        }
    }

    public RADComponent getRADComponent() {
        return this.component;
    }

    public FormProperty getProperty(String string) {
        return (FormProperty)this.component.getPropertyByName(string, FormProperty.class, true);
    }

    public String getHtmlDisplayName() {
        if (this.highlightDisplayName) {
            return "<html><b>" + this.getDisplayName() + "</b></html>";
        }
        return "<html>" + this.getDisplayName() + "</html>";
    }

    void highlightDisplayName(boolean bl) {
        if (bl != this.highlightDisplayName) {
            this.highlightDisplayName = bl;
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }

    private static final class ChangeVariableNameAction
    extends RenameAction {
        private ChangeVariableNameAction() {
        }

        public String getName() {
            return NbBundle.getMessage(ChangeVariableNameAction.class, (String)"ChangeVariableNameAction");
        }
    }

    private final class ComponentsIndex
    extends Index.Support {
        private ComponentsIndex() {
        }

        public Node[] getNodes() {
            Object object = RADComponentNode.this.component instanceof RADVisualContainer ? ((RADVisualContainer)RADComponentNode.this.component).getSubComponents() : (RADComponentNode.this.component instanceof ComponentContainer ? ((ComponentContainer)((Object)RADComponentNode.this.component)).getSubBeans() : null);
            Node[] nodeArray = new Node[object != null ? ((RADVisualComponent[])object).length : 0];
            for (int i = 0; i < ((RADComponent[])object).length; ++i) {
                nodeArray[i] = object[i].getNodeReference();
            }
            return nodeArray;
        }

        public int getNodesCount() {
            return this.getNodes().length;
        }

        public void reorder(int[] nArray) {
            if (RADComponentNode.this.component instanceof ComponentContainer) {
                ComponentContainer componentContainer = (ComponentContainer)((Object)RADComponentNode.this.component);
                componentContainer.reorderSubComponents(nArray);
                RADComponentNode.this.component.getFormModel().fireComponentsReordered(componentContainer, nArray);
            }
        }
    }

    public static class RADChildren
    extends FormNode.FormNodeChildren {
        private ComponentContainer container;
        private Object keyLayout;

        public RADChildren(ComponentContainer componentContainer) {
            this.container = componentContainer;
            this.updateKeys();
        }

        protected void updateKeys() {
            RADComponent[] rADComponentArray = this.container.getSubBeans();
            ArrayList<Object> arrayList = new ArrayList<Object>(rADComponentArray.length + 2);
            if (this.container instanceof RADVisualContainer) {
                RADVisualContainer rADVisualContainer = (RADVisualContainer)this.container;
                RADMenuComponent rADMenuComponent = rADVisualContainer.getContainerMenu();
                if (rADMenuComponent != null) {
                    arrayList.add(rADMenuComponent);
                }
                if (rADVisualContainer.shouldHaveLayoutNode()) {
                    this.keyLayout = rADVisualContainer.getLayoutSupport().getLayoutDelegate();
                    arrayList.add(this.keyLayout);
                }
                for (int i = 0; i < rADComponentArray.length; ++i) {
                    if (rADComponentArray[i] == rADMenuComponent) continue;
                    arrayList.add(rADComponentArray[i]);
                }
            } else {
                for (int i = 0; i < rADComponentArray.length; ++i) {
                    arrayList.add(rADComponentArray[i]);
                }
            }
            this.setKeys(arrayList);
        }

        protected Node[] createNodes(Object object) {
            FormNode formNode;
            if (object == this.keyLayout) {
                formNode = new LayoutNode((RADVisualContainer)this.container);
            } else {
                formNode = new RADComponentNode((RADComponent)object);
                formNode.getChildren().getNodes();
            }
            return new Node[]{formNode};
        }
    }
}

