/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class RADVisualComponent
extends RADComponent {
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE = "layoutComponentHorizontalSize";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_SIZE = "layoutComponentVerticalSize";
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE = "layoutComponentHorizontalResizable";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE = "layoutComponentVerticalResizable";
    private HashMap constraints = new HashMap();
    private Node.Property[] constraintsProperties;
    private ConstraintsListenerConvertor constraintsListener;
    private MetaAccessibleContext accessibilityData;
    private FormProperty[] accessibilityProperties;

    public final RADVisualContainer getParentContainer() {
        return (RADVisualContainer)this.getParentComponent();
    }

    public final int getComponentIndex() {
        RADVisualContainer rADVisualContainer = (RADVisualContainer)this.getParentComponent();
        return rADVisualContainer != null ? rADVisualContainer.getIndexOf(this) : -1;
    }

    final LayoutSupportManager getParentLayoutSupport() {
        RADVisualContainer rADVisualContainer = (RADVisualContainer)this.getParentComponent();
        return rADVisualContainer != null ? rADVisualContainer.getLayoutSupport() : null;
    }

    public void setLayoutConstraints(Class clazz, LayoutConstraints layoutConstraints) {
        if (layoutConstraints != null) {
            this.constraints.put(clazz.getName(), layoutConstraints);
        }
    }

    public LayoutConstraints getLayoutConstraints(Class clazz) {
        return (LayoutConstraints)this.constraints.get(clazz.getName());
    }

    HashMap getConstraintsMap() {
        return this.constraints;
    }

    void setConstraintsMap(Map map) {
        this.constraints.putAll(map);
    }

    protected void createPropertySets(List list) {
        super.createPropertySets(list);
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        if (this.constraintsProperties != null && this.constraintsProperties.length > 0) {
            list.add(list.size() - 1, new Node.PropertySet("layout", FormUtils.getBundleString("CTL_LayoutTab"), FormUtils.getBundleString("CTL_LayoutTabHint")){

                public Node.Property[] getProperties() {
                    return RADVisualComponent.this.getConstraintsProperties();
                }
            });
        }
        if (this.accessibilityProperties == null) {
            this.createAccessibilityProperties();
        }
        if (this.accessibilityProperties.length > 0) {
            list.add(new Node.PropertySet("accessibility", FormUtils.getBundleString("CTL_AccessibilityTab"), FormUtils.getBundleString("CTL_AccessibilityTabHint")){

                public Node.Property[] getProperties() {
                    return RADVisualComponent.this.getAccessibilityProperties();
                }
            });
        }
    }

    public Node.Property getPropertyByName(String string, Class clazz, boolean bl) {
        if (bl && this.accessibilityProperties == null) {
            this.createAccessibilityProperties();
        }
        return super.getPropertyByName(string, clazz, bl);
    }

    protected void clearProperties() {
        super.clearProperties();
        this.constraintsProperties = null;
        this.accessibilityData = null;
        this.accessibilityProperties = null;
    }

    public Node.Property[] getConstraintsProperties() {
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        return this.constraintsProperties;
    }

    public void resetConstraintsProperties() {
        if (this.constraintsProperties != null) {
            for (int i = 0; i < this.constraintsProperties.length; ++i) {
                this.nameToProperty.remove(this.constraintsProperties[i].getName());
            }
            this.constraintsProperties = null;
            this.propertySets = null;
            RADComponentNode rADComponentNode = this.getNodeReference();
            if (rADComponentNode != null) {
                rADComponentNode.fireComponentPropertySetsChange();
            }
        }
    }

    private void createConstraintsProperties() {
        Object object;
        this.constraintsProperties = null;
        LayoutSupportManager layoutSupportManager = this.getParentLayoutSupport();
        if (layoutSupportManager != null) {
            object = layoutSupportManager.getConstraints(this);
            if (object != null) {
                this.constraintsProperties = object.getProperties();
            }
        } else if (this.getParentContainer() != null) {
            object = this.getFormModel().getLayoutModel().getLayoutComponent(this.getId());
            if (object == null) {
                return;
            }
            this.constraintsProperties = new Node.Property[]{new LayoutComponentSizeProperty((LayoutComponent)object, 0), new LayoutComponentSizeProperty((LayoutComponent)object, 1), new LayoutComponentResizableProperty((LayoutComponent)object, 0), new LayoutComponentResizableProperty((LayoutComponent)object, 1)};
            ((LayoutComponent)object).addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RADComponentNode rADComponentNode = RADVisualComponent.this.getNodeReference();
                    if (rADComponentNode != null) {
                        String string = propertyChangeEvent.getPropertyName();
                        if ("horizontalPrefSize".equals(string)) {
                            rADComponentNode.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE, null, null);
                        } else if ("verticalPrefSize".equals(string)) {
                            rADComponentNode.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_SIZE, null, null);
                        } else if ("horizontalMaxSize".equals(string)) {
                            rADComponentNode.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE, null, null);
                        } else if ("verticalMaxSize".equals(string)) {
                            rADComponentNode.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE, null, null);
                        }
                    }
                }
            });
        }
        if (this.constraintsProperties == null) {
            this.constraintsProperties = NO_PROPERTIES;
            return;
        }
        for (int i = 0; i < this.constraintsProperties.length; ++i) {
            if (!(this.constraintsProperties[i] instanceof FormProperty)) continue;
            FormProperty formProperty = (FormProperty)this.constraintsProperties[i];
            formProperty.addVetoableChangeListener(this.getConstraintsListener());
            formProperty.addPropertyChangeListener(this.getConstraintsListener());
            formProperty.addValueConvertor(this.getConstraintsListener());
            formProperty.setPropertyContext(new RADProperty.RADPropertyContext(this));
            if (this.isReadOnly() || !this.isValid()) {
                int n = formProperty.getAccessType() | 0xA;
                formProperty.setAccessType(n);
            }
            this.nameToProperty.put(formProperty.getName(), formProperty);
        }
    }

    private ConstraintsListenerConvertor getConstraintsListener() {
        if (this.constraintsListener == null) {
            this.constraintsListener = new ConstraintsListenerConvertor();
        }
        return this.constraintsListener;
    }

    public FormProperty[] getAccessibilityProperties() {
        if (this.accessibilityProperties == null) {
            this.createAccessibilityProperties();
        }
        return this.accessibilityProperties;
    }

    private void createAccessibilityProperties() {
        Object object = this.getBeanInstance();
        if (object instanceof Accessible && ((Accessible)object).getAccessibleContext() != null) {
            if (this.accessibilityData == null) {
                this.accessibilityData = new MetaAccessibleContext();
            }
            this.accessibilityProperties = this.accessibilityData.getProperties();
            for (int i = 0; i < this.accessibilityProperties.length; ++i) {
                FormProperty formProperty = this.accessibilityProperties[i];
                this.setPropertyListener(formProperty);
                formProperty.setPropertyContext(new RADProperty.RADPropertyContext(this));
                this.nameToProperty.put(formProperty.getName(), formProperty);
            }
        } else {
            this.accessibilityData = null;
            this.accessibilityProperties = NO_PROPERTIES;
        }
    }

    public static class AccessibleParentEditor
    extends ComponentChooserEditor {
        public AccessibleParentEditor() {
            this.setBeanTypes(new Class[]{Accessible.class});
        }

        public String getDisplayName() {
            return NbBundle.getBundle(this.getClass()).getString("CTL_AccessibleParentEditor_DisplayName");
        }
    }

    private class ConstraintsListenerConvertor
    implements VetoableChangeListener,
    PropertyChangeListener,
    FormProperty.ValueConvertor {
        private ConstraintsListenerConvertor() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof FormProperty && ("propertyValue".equals(string) || "propertyValueAndEditor".equals(string))) {
                RADVisualComponent.this.i18nPropertyChanged(propertyChangeEvent);
                LayoutSupportManager layoutSupportManager = RADVisualComponent.this.getParentLayoutSupport();
                int n = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints layoutConstraints = layoutSupportManager.getConstraints(n);
                propertyChangeEvent = new PropertyChangeEvent(layoutConstraints, ((FormProperty)((Object)object)).getName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                layoutSupportManager.componentLayoutChanged(n, propertyChangeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof FormProperty && "currentEditor".equals(propertyChangeEvent.getPropertyName())) {
                LayoutSupportManager layoutSupportManager = RADVisualComponent.this.getParentLayoutSupport();
                int n = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints layoutConstraints = layoutSupportManager.getConstraints(n);
                propertyChangeEvent = new PropertyChangeEvent(layoutConstraints, null, null, null);
                try {
                    layoutSupportManager.componentLayoutChanged(n, propertyChangeEvent);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public Object convert(Object object, FormProperty formProperty) {
            return RADVisualComponent.this.i18nPropertyConvert(object, formProperty);
        }
    }

    private class LayoutComponentResizableProperty
    extends PropertySupport.ReadWrite {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentResizableProperty(LayoutComponent layoutComponent, int n) {
            super(n == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE, Boolean.class, null, null);
            boolean bl = n == 0;
            this.setDisplayName(FormUtils.getBundleString(bl ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.setShortDescription(FormUtils.getBundleString(bl ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "HINT_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.component = layoutComponent;
            this.dimension = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            Boolean bl = (Boolean)this.getValue();
            Boolean bl2 = (Boolean)object;
            boolean bl3 = bl2;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval layoutInterval = this.component.getLayoutInterval(this.dimension);
            Object object2 = layoutModel.getChangeMark();
            UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
            boolean bl4 = true;
            try {
                layoutModel.setIntervalSize(layoutInterval, bl3 ? -1 : -2, layoutInterval.getPreferredSize(false), bl3 ? Short.MAX_VALUE : -2);
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), bl, bl2);
                bl4 = false;
            }
            finally {
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!object2.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(undoableEdit);
                }
                if (bl4) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
            }
        }

        public Object getValue() {
            int n = this.component.getLayoutInterval(this.dimension).getPreferredSize(false);
            int n2 = this.component.getLayoutInterval(this.dimension).getMaximumSize(false);
            return n2 != n && n2 != -2;
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() {
            this.setValue(Boolean.FALSE);
        }

        public boolean isDefaultValue() {
            return this.getValue().equals(Boolean.FALSE);
        }

        public boolean canWrite() {
            return !RADVisualComponent.this.isReadOnly();
        }
    }

    private class LayoutComponentSizeProperty
    extends PropertySupport.ReadWrite {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentSizeProperty(LayoutComponent layoutComponent, int n) {
            super(n == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_SIZE, Integer.class, null, null);
            boolean bl = n == 0;
            this.setDisplayName(FormUtils.getBundleString(bl ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "PROP_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.setShortDescription(FormUtils.getBundleString(bl ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "HINT_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.component = layoutComponent;
            this.dimension = n;
            this.setValue("canEditAsText", Boolean.TRUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer n = (Integer)this.getValue();
            Integer n2 = (Integer)object;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval layoutInterval = this.component.getLayoutInterval(this.dimension);
            Object object2 = layoutModel.getChangeMark();
            UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
            boolean bl = true;
            try {
                layoutModel.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize(false), n2, layoutInterval.getMaximumSize(false));
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), n, n2);
                bl = false;
            }
            finally {
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!object2.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(undoableEdit);
                }
                if (bl) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
            }
        }

        public Object getValue() {
            int n = this.component.getLayoutInterval(this.dimension).getPreferredSize(false);
            return new Integer(n);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() {
            this.setValue(new Integer(-1));
        }

        public boolean isDefaultValue() {
            return (Integer)this.getValue() == -1;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport(){
                private String notExplicitelyDefined = FormUtils.getBundleString("VALUE_SizeNotExplicitelyDefined");

                public String[] getTags() {
                    return new String[]{this.notExplicitelyDefined};
                }

                public String getAsText() {
                    Integer n = (Integer)this.getValue();
                    if (n == -1) {
                        return this.notExplicitelyDefined;
                    }
                    return n.toString();
                }

                public void setAsText(String string) {
                    if (this.notExplicitelyDefined.equals(string)) {
                        this.setValue(new Integer(-1));
                    } else {
                        try {
                            this.setValue(new Integer(Integer.parseInt(string)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            };
        }

        public boolean canWrite() {
            return !RADVisualComponent.this.isReadOnly();
        }
    }

    private class MetaAccessibleContext {
        private Object accName = BeanSupport.NO_VALUE;
        private Object accDescription = BeanSupport.NO_VALUE;
        private Object accParent = BeanSupport.NO_VALUE;
        private FormProperty[] properties;

        private MetaAccessibleContext() {
        }

        FormProperty[] getProperties() {
            if (this.properties == null) {
                this.properties = new FormProperty[]{new FormProperty("AccessibleContext.accessibleName", String.class, FormUtils.getBundleString("PROP_AccessibleName"), FormUtils.getBundleString("PROP_AccessibleName")){

                    public Object getTargetValue() {
                        return MetaAccessibleContext.this.accName != BeanSupport.NO_VALUE ? MetaAccessibleContext.this.accName : this.getDefaultValue();
                    }

                    public void setTargetValue(Object object) {
                        MetaAccessibleContext.this.accName = (String)object;
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        return MetaAccessibleContext.this.getAccessibleContext().getAccessibleName();
                    }

                    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
                        super.restoreDefaultValue();
                        MetaAccessibleContext.this.accName = BeanSupport.NO_VALUE;
                    }

                    String getPartialSetterCode(String string) {
                        return "getAccessibleContext().setAccessibleName(" + string + ")";
                    }
                }, new FormProperty("AccessibleContext.accessibleDescription", String.class, FormUtils.getBundleString("PROP_AccessibleDescription"), FormUtils.getBundleString("PROP_AccessibleDescription")){

                    public Object getTargetValue() {
                        return MetaAccessibleContext.this.accDescription != BeanSupport.NO_VALUE ? MetaAccessibleContext.this.accDescription : this.getDefaultValue();
                    }

                    public void setTargetValue(Object object) {
                        MetaAccessibleContext.this.accDescription = (String)object;
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        return MetaAccessibleContext.this.getAccessibleContext().getAccessibleDescription();
                    }

                    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
                        super.restoreDefaultValue();
                        MetaAccessibleContext.this.accDescription = BeanSupport.NO_VALUE;
                    }

                    String getPartialSetterCode(String string) {
                        return "getAccessibleContext().setAccessibleDescription(" + string + ")";
                    }
                }, new FormProperty("AccessibleContext.accessibleParent", Accessible.class, FormUtils.getBundleString("PROP_AccessibleParent"), FormUtils.getBundleString("PROP_AccessibleParent")){

                    public Object getTargetValue() {
                        return MetaAccessibleContext.this.accParent != BeanSupport.NO_VALUE ? MetaAccessibleContext.this.accParent : this.getDefaultValue();
                    }

                    public void setTargetValue(Object object) {
                        MetaAccessibleContext.this.accParent = object;
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        Container container;
                        RADVisualContainer rADVisualContainer;
                        Accessible accessible = MetaAccessibleContext.this.getAccessibleContext().getAccessibleParent();
                        if (accessible != null && (rADVisualContainer = RADVisualComponent.this.getParentContainer()) != null && (container = rADVisualContainer.getContainerDelegate(rADVisualContainer.getBeanInstance())) == accessible) {
                            return rADVisualContainer;
                        }
                        return accessible;
                    }

                    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
                        super.restoreDefaultValue();
                        MetaAccessibleContext.this.accParent = BeanSupport.NO_VALUE;
                    }

                    public PropertyEditor getExpliciteEditor() {
                        return new AccessibleParentEditor();
                    }

                    String getPartialSetterCode(String string) {
                        return string == null ? null : "getAccessibleContext().setAccessibleParent(" + string + ")";
                    }
                }};
            }
            return this.properties;
        }

        private AccessibleContext getAccessibleContext() {
            return ((Accessible)RADVisualComponent.this.getBeanInstance()).getAccessibleContext();
        }
    }
}

