/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.codestructure;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructureChange;
import org.netbeans.modules.form.codestructure.CodeSupport;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.codestructure.DefaultCodeExpression;
import org.netbeans.modules.form.codestructure.UsedCodeObject;
import org.netbeans.modules.form.codestructure.UsingCodeObject;

public class CodeStructure {
    public static final CodeExpression[] EMPTY_PARAMS = new CodeExpression[0];
    private static final int VARIABLE_CREATE = 1;
    private static final int VARIABLE_RENAME = 2;
    private static final int VARIABLE_RELEASE = 3;
    private static final int VARIABLE_ATTACH = 4;
    private static final int VARIABLE_DETACH = 5;
    private static UsingCodeObject globalUsingObject;
    private Map namesToVariables = new HashMap(50);
    private Map expressionsToVariables = new HashMap(50);
    private Set externalVariables = null;
    private static int globalDefaultVariableType;
    private int defaultVariableType = -1;
    private boolean undoRedoRecording = false;
    private int undoRedoMark = 0;
    private int oldestMark = 0;
    private int lastUndone = -1;
    private int undoRedoHardLimit = 10000;
    private Map undoMap;
    private Map redoMap;
    private FormJavaSource javaSource;
    private static int traceCount;
    private static final boolean TRACE = false;

    public CodeStructure(boolean bl) {
        if (bl) {
            this.setUndoRedoRecording(true);
        }
    }

    public void setFormJavaSource(FormJavaSource formJavaSource) {
        this.javaSource = formJavaSource;
    }

    public CodeExpression createExpression(Constructor constructor, CodeExpression[] codeExpressionArray) {
        CodeSupport.ConstructorOrigin constructorOrigin = new CodeSupport.ConstructorOrigin(constructor, codeExpressionArray);
        return new DefaultCodeExpression(this, constructorOrigin);
    }

    public CodeExpression createExpression(CodeExpression codeExpression, Method method, CodeExpression[] codeExpressionArray) {
        CodeSupport.MethodOrigin methodOrigin = new CodeSupport.MethodOrigin(codeExpression, method, codeExpressionArray);
        return new DefaultCodeExpression(this, methodOrigin);
    }

    public CodeExpression createExpression(CodeExpression codeExpression, Field field) {
        CodeSupport.FieldOrigin fieldOrigin = new CodeSupport.FieldOrigin(codeExpression, field);
        return new DefaultCodeExpression(this, fieldOrigin);
    }

    public CodeExpression createExpression(Class clazz, Object object, String string) {
        return new DefaultCodeExpression(this, new CodeSupport.ValueOrigin(clazz, object, string));
    }

    public CodeExpression createExpression(CodeExpressionOrigin codeExpressionOrigin) {
        return new DefaultCodeExpression(this, codeExpressionOrigin);
    }

    public CodeExpression createNullExpression(Class clazz) {
        return new DefaultCodeExpression(this, new CodeSupport.ValueOrigin(clazz, null, "null"));
    }

    public CodeExpression createDefaultExpression() {
        return new DefaultCodeExpression(this);
    }

    public void registerExpression(CodeExpression codeExpression) {
        if (globalUsingObject == null) {
            globalUsingObject = new GlobalUsingObject();
        }
        codeExpression.addUsingObject(globalUsingObject, 2, CodeStructure.class);
    }

    public static void removeExpression(CodeExpression codeExpression) {
        CodeStructure.unregisterUsedCodeObject(codeExpression);
        CodeStructure.unregisterUsingCodeObject(codeExpression);
        codeExpression.getCodeStructure().removeExpressionFromVariable(codeExpression);
    }

    public static CodeExpression[] filterExpressions(Iterator iterator, Object object) {
        ArrayList<CodeExpression> arrayList = new ArrayList<CodeExpression>();
        while (iterator.hasNext()) {
            CodeExpression codeExpression = (CodeExpression)iterator.next();
            if (!object.equals(codeExpression.getOrigin().getMetaObject())) continue;
            arrayList.add(codeExpression);
        }
        return arrayList.toArray(new CodeExpression[arrayList.size()]);
    }

    public static CodeStatement createStatement(CodeExpression codeExpression, Method method, CodeExpression[] codeExpressionArray) {
        CodeSupport.MethodStatement methodStatement = new CodeSupport.MethodStatement(codeExpression, method, codeExpressionArray);
        CodeStructure.registerUsingCodeObject(methodStatement);
        return methodStatement;
    }

    public static CodeStatement createStatement(CodeExpression codeExpression, Field field, CodeExpression codeExpression2) {
        CodeSupport.FieldStatement fieldStatement = new CodeSupport.FieldStatement(codeExpression, field, codeExpression2);
        CodeStructure.registerUsingCodeObject(fieldStatement);
        return fieldStatement;
    }

    public static void removeStatement(CodeStatement codeStatement) {
        CodeStructure.unregisterUsingCodeObject(codeStatement);
    }

    public static void removeStatements(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            CodeStructure.unregisterUsingCodeObject((CodeStatement)arrayList.get(i));
        }
    }

    public static CodeStatement[] filterStatements(Iterator iterator, Object object) {
        ArrayList<CodeStatement> arrayList = new ArrayList<CodeStatement>();
        while (iterator.hasNext()) {
            CodeStatement codeStatement = (CodeStatement)iterator.next();
            if (!object.equals(codeStatement.getMetaObject())) continue;
            arrayList.add(codeStatement);
        }
        return arrayList.toArray(new CodeStatement[arrayList.size()]);
    }

    public CodeGroup createCodeGroup() {
        return new CodeSupport.DefaultCodeGroup();
    }

    public static CodeExpressionOrigin createOrigin(Constructor constructor, CodeExpression[] codeExpressionArray) {
        return new CodeSupport.ConstructorOrigin(constructor, codeExpressionArray);
    }

    public static CodeExpressionOrigin createOrigin(CodeExpression codeExpression, Method method, CodeExpression[] codeExpressionArray) {
        return new CodeSupport.MethodOrigin(codeExpression, method, codeExpressionArray);
    }

    public static CodeExpressionOrigin createOrigin(CodeExpression codeExpression, Field field) {
        return new CodeSupport.FieldOrigin(codeExpression, field);
    }

    public static CodeExpressionOrigin createOrigin(Class clazz, Object object, String string) {
        return new CodeSupport.ValueOrigin(clazz, object, string);
    }

    public static Iterator getDefinedExpressionsIterator(CodeExpression codeExpression) {
        return codeExpression.getUsingObjectsIterator(1, CodeExpression.class);
    }

    public static Iterator getUsingExpressionsIterator(CodeExpression codeExpression) {
        return codeExpression.getUsingObjectsIterator(2, CodeExpression.class);
    }

    public static Iterator getDefinedStatementsIterator(CodeExpression codeExpression) {
        return codeExpression.getUsingObjectsIterator(1, CodeStatement.class);
    }

    public static Iterator getUsingStatementsIterator(CodeExpression codeExpression) {
        return codeExpression.getUsingObjectsIterator(2, CodeStatement.class);
    }

    static void registerUsingCodeObject(CodeStatement codeStatement) {
        CodeExpression[] codeExpressionArray;
        CodeExpression codeExpression = codeStatement.getParentExpression();
        if (codeExpression != null) {
            codeExpression.addUsingObject(codeStatement, 1, CodeStatement.class);
        }
        if ((codeExpressionArray = codeStatement.getStatementParameters()) != null) {
            for (int i = 0; i < codeExpressionArray.length; ++i) {
                codeExpressionArray[i].addUsingObject(codeStatement, 2, CodeStatement.class);
            }
        }
    }

    static void registerUsingCodeObject(CodeExpression codeExpression) {
        CodeExpression[] codeExpressionArray;
        CodeExpressionOrigin codeExpressionOrigin = codeExpression.getOrigin();
        CodeExpression codeExpression2 = codeExpressionOrigin.getParentExpression();
        if (codeExpression2 != null) {
            codeExpression2.addUsingObject(codeExpression, 1, CodeExpression.class);
        }
        if ((codeExpressionArray = codeExpressionOrigin.getCreationParameters()) != null) {
            for (int i = 0; i < codeExpressionArray.length; ++i) {
                codeExpressionArray[i].addUsingObject(codeExpression, 2, CodeExpression.class);
            }
        }
    }

    static void unregisterUsingCodeObject(UsingCodeObject usingCodeObject) {
        Iterator iterator = usingCodeObject.getUsedObjectsIterator();
        while (iterator.hasNext()) {
            UsedCodeObject usedCodeObject = (UsedCodeObject)iterator.next();
            if (usedCodeObject.removeUsingObject(usingCodeObject) || !(usedCodeObject instanceof UsingCodeObject)) continue;
            CodeStructure.unregisterUsingCodeObject((UsingCodeObject)((Object)usedCodeObject));
        }
    }

    static void unregisterObjectUsage(UsingCodeObject usingCodeObject, UsedCodeObject usedCodeObject) {
        if (!usedCodeObject.removeUsingObject(usingCodeObject) && usedCodeObject instanceof UsingCodeObject) {
            CodeStructure.unregisterUsingCodeObject((UsingCodeObject)((Object)usedCodeObject));
        }
    }

    static void unregisterUsedCodeObject(UsedCodeObject usedCodeObject) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = usedCodeObject.getUsingObjectsIterator(0, null);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        for (UsingCodeObject usingCodeObject : arrayList) {
            if (usingCodeObject.usedObjectRemoved(usedCodeObject)) continue;
            if (usingCodeObject instanceof UsedCodeObject) {
                CodeStructure.unregisterUsedCodeObject((UsedCodeObject)((Object)usingCodeObject));
            }
            CodeStructure.unregisterUsingCodeObject(usingCodeObject);
        }
    }

    public CodeVariable createVariable(int n, Class clazz, String string) {
        if (this.getVariable(string) != null) {
            return null;
        }
        if (n < 0 || string == null) {
            throw new IllegalArgumentException();
        }
        Variable variable = new Variable(n, clazz, string);
        this.namesToVariables.put(string, variable);
        if (this.undoRedoRecording) {
            this.logUndoableChange(new VariableChange(1, variable));
        }
        return variable;
    }

    public boolean renameVariable(String string, String string2) {
        Variable variable = (Variable)this.namesToVariables.get(string);
        if (variable == null || string2 == null || string2.equals(variable.getName()) || this.namesToVariables.get(string2) != null) {
            return false;
        }
        this.namesToVariables.remove(string);
        variable.name = string2;
        this.namesToVariables.put(string2, variable);
        if (this.undoRedoRecording) {
            VariableChange variableChange = new VariableChange(2, variable);
            variableChange.oldName = string;
            variableChange.newName = string2;
            this.logUndoableChange(variableChange);
        }
        return true;
    }

    public CodeVariable releaseVariable(String string) {
        Variable variable = (Variable)this.namesToVariables.remove(string);
        if (variable == null) {
            return null;
        }
        Map map = variable.expressionsMap;
        if (map == null) {
            return variable;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            this.expressionsToVariables.remove(iterator.next());
        }
        if (this.undoRedoRecording) {
            this.logUndoableChange(new VariableChange(3, variable));
        }
        return variable;
    }

    public boolean isVariableNameReserved(String string) {
        return this.namesToVariables.get(string) != null || this.javaSource.containsField(string, true);
    }

    public CodeVariable createVariableForExpression(CodeExpression codeExpression, int n, String string) {
        if (codeExpression == null) {
            throw new IllegalArgumentException();
        }
        if (this.getVariable(codeExpression) != null) {
            return null;
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.expressionsToVariables.get(codeExpression) != null) {
            this.removeExpressionFromVariable(codeExpression);
        }
        string = this.getFreeVariableName(string, codeExpression.getOrigin().getType());
        Variable variable = new Variable(n, codeExpression.getOrigin().getType(), string);
        CodeStatement codeStatement = this.createVariableAssignment(variable, codeExpression);
        variable.addCodeExpression(codeExpression, codeStatement);
        this.namesToVariables.put(string, variable);
        this.expressionsToVariables.put(codeExpression, variable);
        if (this.undoRedoRecording) {
            this.logUndoableChange(new VariableChange(1, variable));
            VariableChange variableChange = new VariableChange(4, variable);
            variableChange.expression = codeExpression;
            variableChange.statement = codeStatement;
            this.logUndoableChange(variableChange);
        }
        return variable;
    }

    private String getFreeVariableName(String string, Class clazz) {
        if (string == null || this.namesToVariables.get(string) != null) {
            String string2;
            int n;
            int n2 = 0;
            if (string != null) {
                char c;
                int n3 = string.length();
                n = 1;
                while (--n3 >= 0 && (c = string.charAt(n3)) >= '0' && c <= '9') {
                    n2 += (c - 48) * n;
                    n *= 10;
                }
                string2 = n3 >= 0 ? string.substring(0, n3 + 1) : string;
            } else {
                String string3 = clazz.getName();
                n = string3.lastIndexOf(36);
                if (n < 0 && (n = string3.lastIndexOf(43)) < 0) {
                    n = string3.lastIndexOf(46);
                }
                string2 = Character.toLowerCase(string3.charAt(n + 1)) + string3.substring(n + 2);
            }
            this.javaSource.refresh();
            while (this.namesToVariables.get(string = string2 + ++n2) != null || this.javaSource.containsField(string, false)) {
            }
        }
        return string;
    }

    public String getExternalVariableName(Class clazz, String string, boolean bl) {
        String string2 = this.getFreeVariableName(string, clazz);
        if (bl) {
            this.createVariable(4096, clazz, string2);
            if (this.externalVariables == null) {
                this.externalVariables = new HashSet();
            }
            this.externalVariables.add(string2);
        }
        return string2;
    }

    public void clearExternalVariableNames() {
        if (this.externalVariables != null) {
            Iterator iterator = this.externalVariables.iterator();
            while (iterator.hasNext()) {
                this.releaseVariable((String)iterator.next());
            }
            this.externalVariables.clear();
        }
    }

    public void attachExpressionToVariable(CodeExpression codeExpression, CodeVariable codeVariable) {
        if (codeExpression == null) {
            return;
        }
        if (codeVariable.getAssignment(codeExpression) != null) {
            return;
        }
        int n = 20480;
        if ((codeVariable.getType() & n) == 4096 && codeVariable.getAttachedExpressions().size() > 0) {
            throw new IllegalStateException("Standalone local variable declaration required for: " + codeVariable.getName());
        }
        Variable variable = (Variable)this.expressionsToVariables.get(codeExpression);
        if (variable != null && variable != codeVariable) {
            this.removeExpressionFromVariable(codeExpression);
        }
        Variable variable2 = (Variable)codeVariable;
        CodeStatement codeStatement = this.createVariableAssignment(variable2, codeExpression);
        variable2.addCodeExpression(codeExpression, codeStatement);
        this.expressionsToVariables.put(codeExpression, variable2);
        if (this.undoRedoRecording) {
            VariableChange variableChange = new VariableChange(4, variable2);
            variableChange.expression = codeExpression;
            variableChange.statement = codeStatement;
            this.logUndoableChange(variableChange);
        }
    }

    public void removeExpressionFromVariable(CodeExpression codeExpression) {
        if (codeExpression == null) {
            return;
        }
        Variable variable = (Variable)this.expressionsToVariables.remove(codeExpression);
        if (variable == null) {
            return;
        }
        CodeStatement codeStatement = variable.removeCodeExpression(codeExpression);
        if (this.undoRedoRecording) {
            VariableChange variableChange = new VariableChange(5, variable);
            variableChange.expression = codeExpression;
            variableChange.statement = codeStatement;
            this.logUndoableChange(variableChange);
        }
        if (variable.expressionsMap.isEmpty() && (variable.getType() & 0x8000) == 0) {
            this.releaseVariable(variable.getName());
        }
    }

    public CodeVariable getVariable(String string) {
        return (Variable)this.namesToVariables.get(string);
    }

    public CodeVariable getVariable(CodeExpression codeExpression) {
        return (Variable)this.expressionsToVariables.get(codeExpression);
    }

    public Iterator getVariablesIterator(int n, int n2, Class clazz) {
        return new VariablesIterator(this.namesToVariables.values().iterator(), n, n2, clazz);
    }

    public Collection getAllVariables() {
        return Collections.unmodifiableCollection(this.namesToVariables.values());
    }

    public static void setGlobalDefaultVariableType(int n) {
        if (n < 0) {
            globalDefaultVariableType = 8194;
        } else {
            int n2;
            if (((n &= 0xF0DF) & 0x3000) == 0) {
                n |= 0x2000;
            }
            if ((n & (n2 = 16400)) == n2) {
                n &= 0xFFFFBFFF;
            }
            globalDefaultVariableType = n;
        }
    }

    public void setDefaultVariableType(int n) {
        if (n < 0) {
            this.defaultVariableType = -1;
        } else {
            int n2;
            if (((n &= 0xF0DF) & 0x3000) == 0) {
                n |= 0x2000;
            }
            if ((n & (n2 = 16400)) == n2) {
                n &= 0xFFFFBFFF;
            }
            this.defaultVariableType = n;
        }
    }

    static int getGlobalDefaultVariableType() {
        return globalDefaultVariableType;
    }

    int getDefaultVariableType() {
        return this.defaultVariableType > -1 ? this.defaultVariableType : globalDefaultVariableType;
    }

    protected Map getNamesToVariablesMap() {
        return this.namesToVariables;
    }

    protected Map getExpressionsToVariables() {
        return this.expressionsToVariables;
    }

    private CodeStatement createVariableAssignment(CodeVariable codeVariable, CodeExpression codeExpression) {
        CodeSupport.AssignVariableStatement assignVariableStatement = new CodeSupport.AssignVariableStatement(codeVariable, codeExpression);
        return assignVariableStatement;
    }

    public void setUndoRedoRecording(boolean bl) {
        this.undoRedoRecording = bl;
        if (bl && this.undoMap == null) {
            this.undoMap = new HashMap(500);
            this.redoMap = new HashMap(100);
        }
    }

    public boolean isUndoRedoRecording() {
        return this.undoRedoRecording;
    }

    void logUndoableChange(CodeStructureChange codeStructureChange) {
        this.redoMap.clear();
        this.lastUndone = -1;
        if (this.undoMap.size() == 0) {
            this.oldestMark = this.undoRedoMark;
        }
        CodeStructure.t("adding undoable change " + this.undoRedoMark);
        this.undoMap.put(new Integer(this.undoRedoMark++), codeStructureChange);
        if (this.undoMap.size() > this.undoRedoHardLimit) {
            CodeStructure.t("undo/redo hard limit reached: " + this.undoMap.size() + " > " + this.undoRedoHardLimit);
        }
        while (this.undoMap.size() > this.undoRedoHardLimit) {
            Integer n = new Integer(this.oldestMark++);
            this.undoMap.remove(n);
        }
    }

    public Object markForUndo() {
        this.redoMap.clear();
        CodeStructure.t("mark for undo: " + this.undoRedoMark);
        Integer n = new Integer(this.undoRedoMark);
        return n;
    }

    public void releaseUndoableChanges(Object object, Object object2) {
        int n;
        int n2 = (Integer)object2;
        CodeStructure.t("release marks from " + n + " to " + n2);
        for (n = ((Integer)object).intValue(); n < n2; ++n) {
            Integer n3 = new Integer(n);
            this.undoMap.remove(n3);
            this.redoMap.remove(n3);
        }
    }

    public boolean undoToMark(Object object) {
        int n = this.undoRedoMark;
        int n2 = (Integer)object;
        if (n <= n2) {
            return false;
        }
        CodeStructure.t("undo to mark " + object);
        if (this.undoMap.get(object) == null) {
            CodeStructure.t("mark already dropped from the queue");
            return false;
        }
        boolean bl = this.undoRedoRecording;
        this.undoRedoRecording = false;
        while (n > n2) {
            Integer n3;
            CodeStructureChange codeStructureChange;
            if ((codeStructureChange = (CodeStructureChange)this.undoMap.remove(n3 = new Integer(--n))) == null) continue;
            codeStructureChange.undo();
            this.redoMap.put(n3, codeStructureChange);
            this.lastUndone = n;
            CodeStructure.t("undone: " + n3);
        }
        if (bl) {
            this.undoRedoRecording = true;
        }
        return true;
    }

    public boolean redoToMark(Object object) {
        if (this.lastUndone < 0) {
            return false;
        }
        int n = (Integer)object;
        if (this.lastUndone >= n || n > this.undoRedoMark) {
            return false;
        }
        CodeStructure.t("redo to mark " + object);
        boolean bl = this.undoRedoRecording;
        this.undoRedoRecording = false;
        while (this.lastUndone < n) {
            Integer n2;
            CodeStructureChange codeStructureChange;
            if ((codeStructureChange = (CodeStructureChange)this.redoMap.remove(n2 = new Integer(this.lastUndone++))) == null) continue;
            codeStructureChange.redo();
            this.undoMap.put(n2, codeStructureChange);
            CodeStructure.t("redone: " + n2);
        }
        if (bl) {
            this.undoRedoRecording = true;
        }
        return true;
    }

    static void t(String string) {
    }

    static {
        globalDefaultVariableType = 8194;
        traceCount = 0;
    }

    private static class GlobalUsingObject
    implements UsingCodeObject {
        private GlobalUsingObject() {
        }

        public void usageRegistered(UsedCodeObject usedCodeObject) {
        }

        public boolean usedObjectRemoved(UsedCodeObject usedCodeObject) {
            return true;
        }

        public UsedCodeObject getDefiningObject() {
            return null;
        }

        public Iterator getUsedObjectsIterator() {
            return null;
        }
    }

    final class Variable
    implements CodeVariable {
        private int type;
        private Class declaredType;
        private String name;
        private Map expressionsMap;
        private CodeStatement declarationStatement;

        Variable(int n, Class clazz, String string) {
            if ((n & 0x10) != 0) {
                n &= 0xFFFFBFFF;
            }
            this.type = n;
            this.declaredType = clazz;
            this.name = string;
        }

        public int getType() {
            return (this.type & 0x30DF) != 12511 ? this.type : CodeStructure.this.getDefaultVariableType();
        }

        public String getName() {
            return this.name;
        }

        public Class getDeclaredType() {
            return this.declaredType;
        }

        public Collection getAttachedExpressions() {
            return this.expressionsMap != null ? Collections.unmodifiableCollection(this.expressionsMap.keySet()) : Collections.EMPTY_LIST;
        }

        public CodeStatement getDeclaration() {
            if (this.declarationStatement == null) {
                this.declarationStatement = new CodeSupport.DeclareVariableStatement(this);
            }
            return this.declarationStatement;
        }

        public CodeStatement getAssignment(CodeExpression codeExpression) {
            return this.expressionsMap != null ? (CodeStatement)this.expressionsMap.get(codeExpression) : null;
        }

        void addCodeExpression(CodeExpression codeExpression, CodeStatement codeStatement) {
            if (this.expressionsMap == null) {
                this.expressionsMap = new HashMap();
            }
            this.expressionsMap.put(codeExpression, codeStatement);
        }

        CodeStatement removeCodeExpression(CodeExpression codeExpression) {
            if (this.expressionsMap != null) {
                return (CodeStatement)this.expressionsMap.remove(codeExpression);
            }
            return null;
        }
    }

    private class VariableChange
    implements CodeStructureChange {
        private int changeType;
        private Variable variable;
        private CodeExpression expression;
        private CodeStatement statement;
        private String oldName;
        private String newName;

        VariableChange(int n, Variable variable) {
            this.changeType = n;
            this.variable = variable;
        }

        public void undo() {
            switch (this.changeType) {
                case 1: {
                    CodeStructure.this.namesToVariables.remove(this.variable.name);
                    break;
                }
                case 2: {
                    CodeStructure.this.namesToVariables.remove(this.newName);
                    this.variable.name = this.oldName;
                    CodeStructure.this.namesToVariables.put(this.oldName, this.variable);
                    break;
                }
                case 3: {
                    Iterator iterator = this.variable.expressionsMap.values().iterator();
                    while (iterator.hasNext()) {
                        CodeStructure.this.expressionsToVariables.put(iterator.next(), this.variable);
                    }
                    CodeStructure.this.namesToVariables.put(this.variable.name, this.variable);
                    break;
                }
                case 4: {
                    CodeStructure.this.expressionsToVariables.remove(this.expression);
                    this.variable.expressionsMap.remove(this.expression);
                    break;
                }
                case 5: {
                    this.variable.expressionsMap.put(this.expression, this.statement);
                    CodeStructure.this.expressionsToVariables.put(this.expression, this.variable);
                }
            }
        }

        public void redo() {
            switch (this.changeType) {
                case 1: {
                    CodeStructure.this.namesToVariables.put(this.variable.name, this.variable);
                    break;
                }
                case 2: {
                    CodeStructure.this.namesToVariables.remove(this.oldName);
                    this.variable.name = this.newName;
                    CodeStructure.this.namesToVariables.put(this.newName, this.variable);
                    break;
                }
                case 3: {
                    CodeStructure.this.namesToVariables.remove(this.variable.name);
                    Iterator iterator = this.variable.expressionsMap.values().iterator();
                    while (iterator.hasNext()) {
                        CodeStructure.this.expressionsToVariables.remove(iterator.next());
                    }
                    break;
                }
                case 4: {
                    this.variable.expressionsMap.put(this.expression, this.statement);
                    CodeStructure.this.expressionsToVariables.put(this.expression, this.variable);
                    break;
                }
                case 5: {
                    CodeStructure.this.expressionsToVariables.remove(this.expression);
                    this.variable.expressionsMap.remove(this.expression);
                }
            }
        }
    }

    private static final class VariablesIterator
    implements Iterator {
        private int type;
        private int typeMask;
        private Class declaredType;
        private Iterator subIterator;
        private CodeVariable currentVar;

        public VariablesIterator(Iterator iterator, int n, int n2, Class clazz) {
            this.type = n;
            this.typeMask = n2;
            this.declaredType = clazz;
            this.subIterator = iterator;
        }

        public boolean hasNext() {
            if (this.currentVar != null) {
                return true;
            }
            while (this.subIterator.hasNext()) {
                CodeVariable codeVariable = (CodeVariable)this.subIterator.next();
                if (this.type >= 0 && (this.type & this.typeMask) != (codeVariable.getType() & this.typeMask) || this.declaredType != null && !this.declaredType.equals(codeVariable.getDeclaredType())) continue;
                this.currentVar = codeVariable;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            CodeVariable codeVariable = this.currentVar;
            this.currentVar = null;
            return codeVariable;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

