/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.editors.StringArrayCustomizable;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StringArrayCustomEditor
extends JPanel {
    private ResourceBundle bundle = NbBundle.getBundle(StringArrayCustomEditor.class);
    private Vector itemsVector;
    private StringArrayCustomizable editor;
    private static final int DEFAULT_WIDTH = 400;
    static final long serialVersionUID = -4347656479280614636L;
    private JPanel editPanel;
    private JScrollPane itemListScroll;
    private JList itemList;
    private JLabel itemLabel;
    private JTextField itemField;
    private JLabel itemListLabel;
    private JPanel buttonsPanel;
    private JButton addButton;
    private JButton changeButton;
    private JButton removeButton;
    private JSeparator jSeparator1;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JPanel paddingPanel;

    public StringArrayCustomEditor(StringArrayCustomizable stringArrayCustomizable) {
        this.editor = stringArrayCustomizable;
        this.itemsVector = new Vector();
        String[] stringArray = this.editor.getStringArray();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.itemsVector.addElement(stringArray[i]);
            }
        }
        this.initComponents();
        this.itemList.setCellRenderer(new EmptyStringListCellRenderer());
        this.itemList.setListData(this.itemsVector);
        this.itemList.setSelectionMode(0);
        this.setBorder(new EmptyBorder(new Insets(16, 8, 8, 0)));
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        Mnemonics.setLocalizedText((JLabel)this.itemLabel, (String)this.bundle.getString("CTL_Item"));
        Mnemonics.setLocalizedText((JLabel)this.itemListLabel, (String)this.bundle.getString("CTL_ItemList"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)this.bundle.getString("CTL_Add_StringArrayCustomEditor"));
        Mnemonics.setLocalizedText((AbstractButton)this.changeButton, (String)this.bundle.getString("CTL_Change_StringArrayCustomEditor"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)this.bundle.getString("CTL_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)this.bundle.getString("CTL_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)this.bundle.getString("CTL_MoveDown"));
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_StringArrayCustomEditor"));
        this.itemField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_Item"));
        this.itemList.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_ItemList"));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_Add_StringArrayCustomEditor"));
        this.changeButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_Change_StringArrayCustomEditor"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_Remove"));
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_MoveUp"));
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_MoveDown"));
        this.updateButtons();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(dimension.width, 400), dimension.height);
    }

    private void initComponents() {
        this.editPanel = new JPanel();
        this.itemListScroll = new JScrollPane();
        this.itemList = new JList();
        this.itemLabel = new JLabel();
        this.itemField = new JTextField();
        this.itemListLabel = new JLabel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.changeButton = new JButton();
        this.removeButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.paddingPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.editPanel.setLayout(new GridBagLayout());
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StringArrayCustomEditor.this.itemListValueChanged(listSelectionEvent);
            }
        });
        this.itemListScroll.setViewportView(this.itemList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editPanel.add((Component)this.itemListScroll, gridBagConstraints);
        this.itemLabel.setText("item");
        this.itemLabel.setLabelFor(this.itemField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 11, 12);
        gridBagConstraints.anchor = 17;
        this.editPanel.add((Component)this.itemLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.editPanel.add((Component)this.itemField, gridBagConstraints);
        this.itemListLabel.setText("jLabel1");
        this.itemListLabel.setLabelFor(this.itemList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.editPanel.add((Component)this.itemListLabel, gridBagConstraints);
        this.add((Component)this.editPanel, "Center");
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringArrayCustomEditor.this.addButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 8, 0, 8);
        gridBagConstraints2.weightx = 1.0;
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints2);
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringArrayCustomEditor.this.changeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(8, 8, 0, 8);
        gridBagConstraints2.weightx = 1.0;
        this.buttonsPanel.add((Component)this.changeButton, gridBagConstraints2);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringArrayCustomEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints2.weightx = 1.0;
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 4, 0, 4);
        this.buttonsPanel.add((Component)this.jSeparator1, gridBagConstraints2);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringArrayCustomEditor.this.moveUpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(8, 8, 0, 8);
        gridBagConstraints2.weightx = 1.0;
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints2);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringArrayCustomEditor.this.moveDownButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(8, 8, 0, 8);
        gridBagConstraints2.weightx = 1.0;
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weighty = 1.0;
        this.buttonsPanel.add((Component)this.paddingPanel, gridBagConstraints2);
        this.add((Component)this.buttonsPanel, "East");
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.itemList.getSelectedIndex();
        this.itemsVector.removeElementAt(n);
        this.itemsVector.insertElementAt(this.itemField.getText(), n);
        this.itemList.setListData(this.itemsVector);
        this.itemList.setSelectedIndex(n);
        this.itemList.repaint();
        this.updateValue();
    }

    private void moveDownButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.itemList.getSelectedIndex();
        String string = (String)this.itemsVector.elementAt(n);
        this.itemsVector.removeElementAt(n);
        this.itemsVector.insertElementAt(string, n + 1);
        this.itemList.setListData(this.itemsVector);
        this.itemList.setSelectedIndex(n + 1);
        this.itemList.repaint();
        this.updateValue();
    }

    private void moveUpButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.itemList.getSelectedIndex();
        String string = (String)this.itemsVector.elementAt(n);
        this.itemsVector.removeElementAt(n);
        this.itemsVector.insertElementAt(string, n - 1);
        this.itemList.setListData(this.itemsVector);
        this.itemList.setSelectedIndex(n - 1);
        this.itemList.repaint();
        this.updateValue();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.itemList.getSelectedIndex();
        this.itemsVector.removeElementAt(n);
        this.itemList.setListData(this.itemsVector);
        if (this.itemsVector.size() != 0) {
            if (n >= this.itemsVector.size()) {
                n = this.itemsVector.size() - 1;
            }
            this.itemList.setSelectedIndex(n);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void itemListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
        int n = this.itemList.getSelectedIndex();
        if (n != -1) {
            this.itemField.setText((String)this.itemsVector.elementAt(n));
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.itemsVector.addElement(this.itemField.getText());
        this.itemList.setListData(this.itemsVector);
        this.itemList.setSelectedIndex(this.itemsVector.size() - 1);
        this.itemList.repaint();
        this.updateValue();
    }

    private void updateButtons() {
        int n = this.itemList.getSelectedIndex();
        if (n == -1) {
            this.removeButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.moveUpButton.setEnabled(n != 0);
            this.moveDownButton.setEnabled(n != this.itemsVector.size() - 1);
            this.changeButton.setEnabled(true);
        }
    }

    private void updateValue() {
        Object[] objectArray = new String[this.itemsVector.size()];
        this.itemsVector.copyInto(objectArray);
        this.editor.setStringArray((String[])objectArray);
    }

    static class EmptyStringListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected static Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        static final long serialVersionUID = 487512296465844339L;

        public EmptyStringListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof String)) {
                return this;
            }
            String string = (String)object;
            if ("".equals(string)) {
                string = NbBundle.getMessage(EmptyStringListCellRenderer.class, (String)"CTL_Empty");
            }
            this.setText(string);
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }
}

