/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FontEditor
implements ExPropertyEditor,
XMLPropertyEditor,
FormAwareEditor,
PropertyChangeListener {
    private PropertyEditor delegate;
    private NbFont propertyValue = new NbFont();
    private RADProperty property;
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private boolean ignoreUpdates = true;
    private WeakReference lastSwitchBox;
    public static final String XML_FONT_ROOT = "FontInfo";
    public static final String XML_FONT = "Font";
    public static final String ATTR_RELATIVE = "relative";
    public static final String ATTR_RELATIVE_SIZE = "relativeSize";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_ITALIC_CHANGE = "italic";
    public static final String ATTR_BOLD_CHANGE = "bold";
    public static final String ATTR_COMP_NAME = "component";
    public static final String ATTR_PROP_NAME = "property";
    private FormModel formModel;

    public FontEditor() {
        this.delegate = PropertyEditorManager.findEditor(Font.class);
        if (this.delegate == null) {
            throw new IllegalStateException("FontEditor delegate not found.");
        }
        if (!(this.delegate instanceof XMLPropertyEditor)) {
            throw new IllegalStateException("FontEditor delegate doesn't implement XMLPropertyEditor.");
        }
        this.delegate.addPropertyChangeListener(this);
    }

    public void setValue(Object object) {
        if (object instanceof Font || object == null) {
            this.propertyValue = new NbFont();
            this.propertyValue.absolute = true;
            this.propertyValue.font = (Font)object;
        } else if (object instanceof NbFont) {
            this.propertyValue = ((NbFont)object).copy();
        } else {
            throw new IllegalArgumentException();
        }
        if (this.property != null) {
            this.propertyValue.property = this.property;
        }
        this.delegate.setValue(this.propertyValue.getDesignValue());
    }

    public Object getValue() {
        return this.propertyValue.absolute ? this.propertyValue.font : this.propertyValue;
    }

    public boolean isPaintable() {
        return this.delegate.isPaintable();
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        this.delegate.paintValue(graphics, rectangle);
    }

    public String getJavaInitializationString() {
        String string;
        if (this.propertyValue.absolute) {
            string = this.delegate.getJavaInitializationString();
        } else {
            boolean bl;
            RADComponent rADComponent = this.property.getRADComponent();
            CodeVariable codeVariable = rADComponent.getCodeExpression().getVariable();
            String string2 = codeVariable == null ? null : codeVariable.getName();
            String string3 = this.property.getPropertyDescriptor().getReadMethod().getName();
            String string4 = string3 + "()";
            if (string2 != null) {
                string4 = string2 + '.' + string4;
            }
            string = string4 + ".deriveFont(";
            boolean bl2 = bl = this.propertyValue.italic != null || this.propertyValue.bold != null;
            if (bl) {
                String string5 = null;
                if (this.propertyValue.italic != null) {
                    string5 = string4 + ".getStyle()";
                    string5 = Boolean.TRUE.equals(this.propertyValue.italic) ? string5 + " | " : string5 + " & ~";
                    string5 = string5 + "java.awt.Font.ITALIC";
                }
                string5 = string5 == null ? string4 + ".getStyle()" : "(" + string5 + ")";
                if (this.propertyValue.bold != null) {
                    string5 = Boolean.TRUE.equals(this.propertyValue.bold) ? string5 + " | " : string5 + " & ~";
                    string5 = string5 + "java.awt.Font.BOLD";
                }
                string = string + string5;
            }
            if (this.propertyValue.absoluteSize) {
                string = string + (bl ? ", " : "(float)");
                string = string + this.propertyValue.size + ")";
            } else if (this.propertyValue.size == 0) {
                string = bl ? string + ')' : string4;
            } else {
                if (bl) {
                    string = string + ", ";
                }
                string = string + string4 + ".getSize()";
                if (this.propertyValue.size > 0) {
                    string = string + '+';
                }
                string = string + this.propertyValue.size;
                if (!bl) {
                    string = string + "f";
                }
                string = string + ")";
            }
        }
        return string;
    }

    public String getAsText() {
        return this.propertyValue.absolute ? this.delegate.getAsText() : this.propertyValue.getDescription();
    }

    public void setAsText(String string) {
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        Component component;
        this.propertyValue = this.propertyValue.copy();
        final Component component2 = this.propertyValue.absolute ? this.delegate.getCustomEditor() : null;
        String string = NbBundle.getMessage(FontEditor.class, (String)"CTL_DeriveFont");
        final JCheckBox jCheckBox = new JCheckBox();
        this.lastSwitchBox = new WeakReference<JCheckBox>(jCheckBox);
        if (this.property == null) {
            jCheckBox.setVisible(false);
        } else {
            Mnemonics.setLocalizedText((AbstractButton)jCheckBox, (String)string);
            jCheckBox.setSelected(!this.propertyValue.absolute);
        }
        final RelativeFontPanel relativeFontPanel = new RelativeFontPanel();
        Component component3 = component = this.propertyValue.absolute ? component2 : relativeFontPanel;
        if (!this.propertyValue.absolute) {
            relativeFontPanel.updateFromPropertyValue();
        }
        final JPanel jPanel = new JPanel();
        final GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup().add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jCheckBox)).add(component));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jCheckBox).addPreferredGap(0).add(component).addContainerGap());
        jCheckBox.addItemListener(new ItemListener(){
            private Component absoluteInLayout;
            {
                this.absoluteInLayout = component2;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (jCheckBox.isSelected()) {
                    groupLayout.replace(this.absoluteInLayout, (Component)relativeFontPanel);
                    ((FontEditor)FontEditor.this).propertyValue.absolute = false;
                    FontEditor.this.convertToRelative();
                    relativeFontPanel.updateFromPropertyValue();
                } else {
                    this.absoluteInLayout = FontEditor.this.delegate.getCustomEditor();
                    groupLayout.replace((Component)relativeFontPanel, this.absoluteInLayout);
                    ((FontEditor)FontEditor.this).propertyValue.absolute = true;
                }
                FontEditor.this.firePropertyChange();
                jPanel.revalidate();
                jPanel.repaint();
            }
        });
        return jPanel;
    }

    private void convertToRelative() {
        boolean bl;
        boolean bl2;
        if (this.propertyValue.font == null) {
            return;
        }
        Font font = (Font)this.property.getDefaultValue();
        if (this.propertyValue.absoluteSize) {
            this.propertyValue.size = this.propertyValue.font.getSize();
        } else {
            if (font == null) {
                return;
            }
            this.propertyValue.size = this.propertyValue.font.getSize() - font.getSize();
        }
        if (font == null) {
            return;
        }
        int n = this.propertyValue.font.getStyle();
        int n2 = font.getStyle();
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = bl2 = (n2 & 2) != 0;
        if (bl3 && !bl2) {
            this.propertyValue.italic = Boolean.TRUE;
        }
        if (!bl3 && bl2) {
            this.propertyValue.italic = Boolean.FALSE;
        }
        if (this.propertyValue.italic != null && bl3 == bl2 && bl3 != this.propertyValue.italic) {
            this.propertyValue.italic = null;
        }
        boolean bl5 = (n & 1) != 0;
        boolean bl6 = bl = (n2 & 1) != 0;
        if (bl5 && !bl) {
            this.propertyValue.bold = Boolean.TRUE;
        }
        if (!bl5 && bl) {
            this.propertyValue.bold = Boolean.FALSE;
        }
        if (this.propertyValue.bold != null && bl5 == bl && bl5 != this.propertyValue.bold) {
            this.propertyValue.bold = null;
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Font font;
        this.propertyValue.font = font = (Font)this.delegate.getValue();
        if (!this.ignoreUpdates) {
            this.firePropertyChange();
        }
    }

    private void updateDelegate() {
        this.ignoreUpdates = true;
        this.delegate.setValue(this.propertyValue.getDesignValue());
        this.ignoreUpdates = false;
        this.firePropertyChange();
    }

    private void firePropertyChange() {
        this.propChangeSupport.firePropertyChange("", null, null);
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (featureDescriptor instanceof RADProperty && propertyEnv.getBeans().length == 1) {
            this.property = (RADProperty)((Object)featureDescriptor);
            if (this.propertyValue != null) {
                this.propertyValue.property = this.property;
            }
        } else {
            Object t;
            if (this.lastSwitchBox != null && (t = this.lastSwitchBox.get()) != null) {
                AbstractButton abstractButton = (AbstractButton)t;
                abstractButton.setVisible(false);
                if (abstractButton.isSelected()) {
                    abstractButton.setSelected(false);
                }
            }
            this.property = null;
        }
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_FONT_ROOT.equals(node.getNodeName())) {
            ((XMLPropertyEditor)this.delegate).readFromXML(node);
            this.setValue(this.delegate.getValue());
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        boolean bl = Boolean.valueOf(namedNodeMap.getNamedItem(ATTR_RELATIVE).getNodeValue());
        this.propertyValue = new NbFont();
        this.propertyValue.absolute = !bl;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (bl) {
                Node node3;
                if (!XML_FONT.equals(node2.getNodeName())) {
                    throw new IOException();
                }
                namedNodeMap = node2.getAttributes();
                this.propertyValue.absoluteSize = Boolean.valueOf(namedNodeMap.getNamedItem(ATTR_RELATIVE_SIZE).getNodeValue()) == false;
                this.propertyValue.size = Integer.parseInt(namedNodeMap.getNamedItem(ATTR_SIZE).getNodeValue());
                Node node4 = namedNodeMap.getNamedItem(ATTR_ITALIC_CHANGE);
                if (node4 != null) {
                    this.propertyValue.italic = Boolean.valueOf(node4.getNodeValue());
                }
                if ((node3 = namedNodeMap.getNamedItem(ATTR_BOLD_CHANGE)) != null) {
                    this.propertyValue.bold = Boolean.valueOf(node3.getNodeValue());
                }
                String string = namedNodeMap.getNamedItem(ATTR_COMP_NAME).getNodeValue();
                RADComponent rADComponent = this.formModel.findRADComponent(string);
                String string2 = namedNodeMap.getNamedItem(ATTR_PROP_NAME).getNodeValue();
                this.property = (RADProperty)rADComponent.getPropertyByName(string2);
                this.propertyValue.property = this.property;
                this.delegate.setValue(this.propertyValue.getDesignValue());
                break;
            }
            ((XMLPropertyEditor)this.delegate).readFromXML(node2);
            this.propertyValue.font = (Font)this.delegate.getValue();
            break;
        }
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_FONT_ROOT);
        element.setAttribute(ATTR_RELATIVE, Boolean.toString(!this.propertyValue.absolute));
        if (this.propertyValue.absolute) {
            Node node = ((XMLPropertyEditor)this.delegate).storeToXML(document);
            element.appendChild(node);
        } else {
            Element element2 = document.createElement(XML_FONT);
            element.appendChild(element2);
            element2.setAttribute(ATTR_RELATIVE_SIZE, Boolean.toString(!this.propertyValue.absoluteSize));
            element2.setAttribute(ATTR_SIZE, Integer.toString(this.propertyValue.size));
            if (this.propertyValue.italic != null) {
                element2.setAttribute(ATTR_ITALIC_CHANGE, this.propertyValue.italic.toString());
            }
            if (this.propertyValue.bold != null) {
                element2.setAttribute(ATTR_BOLD_CHANGE, this.propertyValue.bold.toString());
            }
            element2.setAttribute(ATTR_COMP_NAME, this.property.getRADComponent().getName());
            element2.setAttribute(ATTR_PROP_NAME, this.property.getName());
        }
        return element;
    }

    public void setFormModel(FormModel formModel) {
        this.formModel = formModel;
    }

    static class NbFont
    implements FormDesignValue {
        boolean absolute = false;
        Font font;
        Boolean italic;
        Boolean bold;
        boolean absoluteSize;
        int size;
        FormProperty property;

        NbFont() {
        }

        public Object getDesignValue() {
            Font font;
            if (this.absolute) {
                font = this.font;
            } else {
                font = this.defaultValue(this.property);
                if (font != null) {
                    int n;
                    int n2;
                    int n3 = n2 = font.getStyle();
                    if (this.italic != null) {
                        n3 = this.italic.booleanValue() ? (n3 |= 2) : (n3 &= 0xFFFFFFFD);
                    }
                    if (this.bold != null) {
                        n3 = this.bold.booleanValue() ? (n3 |= 1) : (n3 &= 0xFFFFFFFE);
                    }
                    int n4 = font.getSize();
                    int n5 = n = this.absoluteSize ? this.size : this.size + n4;
                    if (n3 != n2 || n4 != n) {
                        font = font.deriveFont(n3, n);
                    }
                }
            }
            return font;
        }

        private Font defaultValue(FormProperty formProperty) {
            RADProperty rADProperty;
            PropertyDescriptor propertyDescriptor;
            Method method;
            if (formProperty instanceof RADProperty && FormLAF.getUsePreviewDefaults() && (method = (propertyDescriptor = (rADProperty = (RADProperty)formProperty).getPropertyDescriptor()).getReadMethod()) != null) {
                try {
                    Class clazz = rADProperty.getRADComponent().getBeanClass();
                    Object object = BeanSupport.createBeanInstance(clazz);
                    return (Font)method.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (Font)formProperty.getDefaultValue();
        }

        public String getDescription() {
            String string;
            ResourceBundle resourceBundle = NbBundle.getBundle(FontEditor.class);
            if (this.absolute) {
                String string2 = null;
                switch (this.font.getStyle()) {
                    case 0: {
                        string2 = resourceBundle.getString("CTL_FontStylePlain");
                        break;
                    }
                    case 1: {
                        string2 = resourceBundle.getString("CTL_FontStyleBold");
                        break;
                    }
                    case 2: {
                        string2 = resourceBundle.getString("CTL_FontStyleItalic");
                        break;
                    }
                    case 3: {
                        string2 = resourceBundle.getString("CTL_FontStyleBoldItalic");
                        break;
                    }
                    default: {
                        string2 = Integer.toString(this.font.getStyle());
                    }
                }
                string = this.font.getName() + ' ' + this.font.getSize() + ' ' + string2;
            } else {
                string = Integer.toString(this.size);
                if (!this.absoluteSize && this.size > 0) {
                    string = '+' + string;
                }
                if (this.italic != null) {
                    string = string + " " + (this.italic != false ? (char)'+' : '-') + resourceBundle.getString("CTL_FontStyleItalic");
                }
                if (this.bold != null) {
                    string = string + " " + (this.bold != false ? (char)'+' : '-') + resourceBundle.getString("CTL_FontStyleBold");
                }
                if (string.charAt(0) == '0') {
                    string = string.substring(Math.min(2, string.length()));
                }
            }
            return string;
        }

        public FormDesignValue copy(FormProperty formProperty) {
            NbFont nbFont = this.copy();
            nbFont.property = formProperty;
            return nbFont;
        }

        NbFont copy() {
            NbFont nbFont = new NbFont();
            nbFont.absolute = this.absolute;
            nbFont.font = this.font;
            nbFont.italic = this.italic;
            nbFont.bold = this.bold;
            nbFont.absoluteSize = this.absoluteSize;
            nbFont.size = this.size;
            nbFont.property = this.property;
            return nbFont;
        }
    }

    private class RelativeFontPanel
    extends JPanel {
        private JRadioButton absoluteChoice;
        private JSpinner absoluteSize;
        private JRadioButton addBoldChoice;
        private JRadioButton addItalicChoice;
        private JCheckBox italicCheckBox;
        private JRadioButton relativeChoice;
        private JSpinner relativeSize;
        private JRadioButton removeBoldChoice;
        private JRadioButton removeItalicChoice;
        private JCheckBox thicknessCheckBox;

        RelativeFontPanel() {
            this.initComponents();
        }

        void updateFromPropertyValue() {
            FontEditor.this.ignoreUpdates = true;
            boolean bl = ((FontEditor)FontEditor.this).propertyValue.italic != null;
            this.italicCheckBox.setSelected(bl);
            this.addItalicChoice.setEnabled(bl);
            this.removeItalicChoice.setEnabled(bl);
            if (!bl) {
                this.addItalicChoice.setSelected(true);
            } else if (Boolean.TRUE.equals(((FontEditor)FontEditor.this).propertyValue.italic)) {
                this.addItalicChoice.setSelected(true);
            } else if (Boolean.FALSE.equals(((FontEditor)FontEditor.this).propertyValue.italic)) {
                this.removeItalicChoice.setSelected(true);
            }
            boolean bl2 = ((FontEditor)FontEditor.this).propertyValue.bold != null;
            this.thicknessCheckBox.setSelected(bl2);
            this.addBoldChoice.setEnabled(bl2);
            this.removeBoldChoice.setEnabled(bl2);
            if (!bl2) {
                this.addBoldChoice.setSelected(true);
            } else if (Boolean.TRUE.equals(((FontEditor)FontEditor.this).propertyValue.bold)) {
                this.addBoldChoice.setSelected(true);
            } else if (Boolean.FALSE.equals(((FontEditor)FontEditor.this).propertyValue.bold)) {
                this.removeBoldChoice.setSelected(true);
            }
            this.absoluteSize.setEnabled(((FontEditor)FontEditor.this).propertyValue.absoluteSize);
            this.relativeSize.setEnabled(!((FontEditor)FontEditor.this).propertyValue.absoluteSize);
            if (((FontEditor)FontEditor.this).propertyValue.absoluteSize) {
                this.absoluteSize.setValue(new Integer(((FontEditor)FontEditor.this).propertyValue.size));
                this.absoluteChoice.setSelected(true);
                this.synchronizeSizeControls();
            } else {
                this.relativeSize.setValue(new Integer(((FontEditor)FontEditor.this).propertyValue.size));
                this.relativeChoice.setSelected(true);
                this.synchronizeSizeControls();
            }
            FontEditor.this.ignoreUpdates = false;
        }

        private void synchronizeSizeControls() {
            if (((FontEditor)FontEditor.this).propertyValue.absoluteSize) {
                Font font = (Font)FontEditor.this.property.getDefaultValue();
                if (font != null) {
                    this.relativeSize.setValue(new Integer(((FontEditor)FontEditor.this).propertyValue.size - font.getSize()));
                }
            } else {
                Font font = (Font)FontEditor.this.propertyValue.getDesignValue();
                this.absoluteSize.setValue(new Integer(font == null ? 12 : font.getSize()));
            }
        }

        private void initComponents() {
            this.relativeSize = new JSpinner(new SpinnerNumberModel(0, Short.MIN_VALUE, Short.MAX_VALUE, 1));
            this.relativeSize.setEditor(new JSpinner.NumberEditor(this.relativeSize, "+#;-#"));
            this.absoluteSize = new JSpinner(new SpinnerNumberModel(12, 1, Short.MAX_VALUE, 1));
            ResourceBundle resourceBundle = NbBundle.getBundle(FontEditor.class);
            JLabel jLabel = new JLabel(resourceBundle.getString("CTL_FontSize"));
            JLabel jLabel2 = new JLabel(resourceBundle.getString("CTL_FontStyle"));
            this.absoluteChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.absoluteChoice, (String)resourceBundle.getString("CTL_AbsoluteFontSize"));
            this.relativeChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.relativeChoice, (String)resourceBundle.getString("CTL_RelativeFontSize"));
            this.italicCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.italicCheckBox, (String)resourceBundle.getString("CTL_ChangeItalic"));
            this.addItalicChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.addItalicChoice, (String)resourceBundle.getString("CTL_AddItalic"));
            this.removeItalicChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.removeItalicChoice, (String)resourceBundle.getString("CTL_RemoveItalic"));
            this.thicknessCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.thicknessCheckBox, (String)resourceBundle.getString("CTL_ChangeBold"));
            this.addBoldChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.addBoldChoice, (String)resourceBundle.getString("CTL_AddBold"));
            this.removeBoldChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.removeBoldChoice, (String)resourceBundle.getString("CTL_RemoveBold"));
            Listener listener = new Listener();
            this.relativeChoice.addItemListener(listener);
            this.thicknessCheckBox.addItemListener(listener);
            this.italicCheckBox.addItemListener(listener);
            this.relativeSize.addChangeListener(listener);
            this.absoluteSize.addChangeListener(listener);
            this.addItalicChoice.addItemListener(listener);
            this.addBoldChoice.addItemListener(listener);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.addItalicChoice);
            buttonGroup.add(this.removeItalicChoice);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.addBoldChoice);
            buttonGroup2.add(this.removeBoldChoice);
            ButtonGroup buttonGroup3 = new ButtonGroup();
            buttonGroup3.add(this.absoluteChoice);
            buttonGroup3.add(this.relativeChoice);
            Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            Insets insets = new Insets(0, 0, 0, 0);
            this.absoluteChoice.setBorder(border);
            this.absoluteChoice.setMargin(insets);
            this.relativeChoice.setBorder(border);
            this.relativeChoice.setMargin(insets);
            this.italicCheckBox.setBorder(border);
            this.italicCheckBox.setMargin(insets);
            this.addItalicChoice.setBorder(border);
            this.addItalicChoice.setMargin(insets);
            this.removeItalicChoice.setBorder(border);
            this.removeItalicChoice.setMargin(insets);
            this.thicknessCheckBox.setBorder(border);
            this.thicknessCheckBox.setMargin(insets);
            this.addBoldChoice.setBorder(border);
            this.addBoldChoice.setMargin(insets);
            this.removeBoldChoice.setBorder(border);
            this.removeBoldChoice.setMargin(insets);
            GroupLayout groupLayout = new GroupLayout((Container)this);
            this.setLayout((LayoutManager)groupLayout);
            groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)jLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.relativeChoice).add((Component)this.absoluteChoice)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.relativeSize, -2, 50, -2).add((Component)this.absoluteSize, -2, 50, -2)))).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)jLabel2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.italicCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.addItalicChoice).add((Component)this.removeItalicChoice)))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.thicknessCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.removeBoldChoice).add((Component)this.addBoldChoice)))))).addContainerGap());
            groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.relativeChoice).add((Component)this.relativeSize, -2, -1, -2).add((Component)this.italicCheckBox).add((Component)this.thicknessCheckBox)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.absoluteChoice).add((Component)this.absoluteSize, -2, -1, -2).add((Component)this.addItalicChoice).add((Component)this.addBoldChoice)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.removeItalicChoice).add((Component)this.removeBoldChoice)).addContainerGap());
        }

        private class Listener
        implements ItemListener,
        ChangeListener {
            private Listener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (FontEditor.this.ignoreUpdates) {
                    return;
                }
                FontEditor.this.ignoreUpdates = true;
                Object object = itemEvent.getSource();
                if (object == RelativeFontPanel.this.relativeChoice) {
                    boolean bl = RelativeFontPanel.this.relativeChoice.isSelected();
                    RelativeFontPanel.this.relativeSize.setEnabled(bl);
                    RelativeFontPanel.this.absoluteSize.setEnabled(!bl);
                    ((FontEditor)FontEditor.this).propertyValue.absoluteSize = !bl;
                    ((FontEditor)FontEditor.this).propertyValue.size = ((Number)(bl ? RelativeFontPanel.this.relativeSize : RelativeFontPanel.this.absoluteSize).getValue()).intValue();
                } else if (object == RelativeFontPanel.this.italicCheckBox) {
                    boolean bl = RelativeFontPanel.this.italicCheckBox.isSelected();
                    RelativeFontPanel.this.addItalicChoice.setEnabled(bl);
                    RelativeFontPanel.this.removeItalicChoice.setEnabled(bl);
                    ((FontEditor)FontEditor.this).propertyValue.italic = bl ? Boolean.valueOf(RelativeFontPanel.this.addItalicChoice.isSelected()) : null;
                } else if (object == RelativeFontPanel.this.thicknessCheckBox) {
                    boolean bl = RelativeFontPanel.this.thicknessCheckBox.isSelected();
                    RelativeFontPanel.this.addBoldChoice.setEnabled(bl);
                    RelativeFontPanel.this.removeBoldChoice.setEnabled(bl);
                    ((FontEditor)FontEditor.this).propertyValue.bold = bl ? Boolean.valueOf(RelativeFontPanel.this.addBoldChoice.isSelected()) : null;
                } else if (object == RelativeFontPanel.this.addBoldChoice) {
                    ((FontEditor)FontEditor.this).propertyValue.bold = RelativeFontPanel.this.addBoldChoice.isSelected();
                } else if (object == RelativeFontPanel.this.addItalicChoice) {
                    ((FontEditor)FontEditor.this).propertyValue.italic = RelativeFontPanel.this.addItalicChoice.isSelected();
                }
                FontEditor.this.ignoreUpdates = false;
                FontEditor.this.updateDelegate();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                if (FontEditor.this.ignoreUpdates) {
                    return;
                }
                FontEditor.this.ignoreUpdates = true;
                Object object = changeEvent.getSource();
                if (object == RelativeFontPanel.this.relativeSize) {
                    ((FontEditor)FontEditor.this).propertyValue.size = ((Number)RelativeFontPanel.this.relativeSize.getValue()).intValue();
                    RelativeFontPanel.this.synchronizeSizeControls();
                } else if (object == RelativeFontPanel.this.absoluteSize) {
                    ((FontEditor)FontEditor.this).propertyValue.size = ((Number)RelativeFontPanel.this.absoluteSize.getValue()).intValue();
                    RelativeFontPanel.this.synchronizeSizeControls();
                }
                FontEditor.this.ignoreUpdates = false;
                FontEditor.this.updateDelegate();
            }
        }
    }
}

