/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class IconEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
FormAwareEditor,
NamedPropertyEditor {
    public static final int TYPE_URL = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_CLASSPATH = 3;
    private static final String URL_PREFIX = "URL";
    private static final String FILE_PREFIX = "File";
    private static final String CLASSPATH_PREFIX = "Classpath";
    private FormModel formModel;
    public static final String XML_IMAGE = "Image";
    public static final String ATTR_TYPE = "iconType";
    public static final String ATTR_NAME = "name";

    private static String getString(String string) {
        return NbBundle.getBundle(IconEditor.class).getString(string);
    }

    public static boolean isImage(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).endsWith(".jpg") || string.endsWith(".gif") || string.endsWith(".jpeg") || string.endsWith(".jpe") || string.endsWith(".png");
    }

    private static String convert(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        StringBuffer stringBuffer = new StringBuffer();
        if (stringTokenizer.hasMoreElements()) {
            stringBuffer.append(stringTokenizer.nextElement());
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append("\\\\").append(stringTokenizer.nextElement());
            }
        }
        return stringBuffer.toString();
    }

    public int getSourceType() {
        if (this.getValue() instanceof NbImageIcon) {
            return ((NbImageIcon)this.getValue()).type;
        }
        return 2;
    }

    public String getSourceName() {
        if (this.getValue() instanceof NbImageIcon) {
            return ((NbImageIcon)this.getValue()).name;
        }
        return null;
    }

    public Object getValue() {
        return super.getValue();
    }

    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return "null";
        }
        if (object instanceof NbImageIcon) {
            NbImageIcon nbImageIcon = (NbImageIcon)object;
            switch (nbImageIcon.type) {
                case 1: {
                    return "URL: " + nbImageIcon.name;
                }
                case 2: {
                    return "File: " + nbImageIcon.name;
                }
                case 3: {
                    return "Classpath: " + nbImageIcon.name;
                }
            }
        }
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(this.iconFromText(string));
    }

    public String getJavaInitializationString() {
        if (this.getValue() instanceof NbImageIcon) {
            NbImageIcon nbImageIcon = (NbImageIcon)this.getValue();
            switch (nbImageIcon.type) {
                case 1: {
                    return "new javax.swing.JLabel() {\n  public javax.swing.Icon getIcon() {\n    try {\n      return new javax.swing.ImageIcon(\n        new java.net.URL(\"" + IconEditor.convert(nbImageIcon.name) + "\")\n" + "      );\n" + "    } catch (java.net.MalformedURLException e) {\n" + "    }\n" + "    return null;\n" + "  }\n" + "}.getIcon()";
                }
                case 2: {
                    return "new javax.swing.ImageIcon(\"" + IconEditor.convert(nbImageIcon.name) + "\")";
                }
                case 3: {
                    return "new javax.swing.ImageIcon(getClass().getResource(\"" + IconEditor.convert(nbImageIcon.name) + "\"))";
                }
            }
        }
        return "null";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new IconPanel();
    }

    private URL findResource(String string) {
        FileObject fileObject;
        ClassPath classPath;
        FileObject fileObject2;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((fileObject2 = (classPath = ClassPath.getClassPath((FileObject)(fileObject = FormEditor.getFormDataObject(this.formModel).getFormFile()), (String)"classpath/source")).findResource(string)) == null) {
            classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            fileObject2 = classPath.findResource(string);
        }
        if (fileObject2 == null) {
            return null;
        }
        try {
            return fileObject2.getURL();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            return null;
        }
    }

    public void setFormModel(FormModel formModel) {
        this.formModel = formModel;
    }

    private NbImageIcon iconFromText(String string) throws IllegalArgumentException {
        NbImageIcon nbImageIcon;
        block10: {
            try {
                if (string.startsWith(FILE_PREFIX)) {
                    String string2 = string.substring(FILE_PREFIX.length() + 1).trim();
                    nbImageIcon = new NbImageIcon(string2);
                    nbImageIcon.type = 2;
                    nbImageIcon.name = string2;
                    break block10;
                }
                if (string.startsWith(CLASSPATH_PREFIX)) {
                    String string3 = string.substring(CLASSPATH_PREFIX.length() + 1).trim();
                    if ("".equals(string3) || "/".equals(string3) || "///".equals(string3) || string3.endsWith("#")) {
                        return null;
                    }
                    URL uRL = this.findResource(string3);
                    nbImageIcon = uRL == null ? new NbImageIcon() : new NbImageIcon(uRL);
                    nbImageIcon.type = 3;
                    nbImageIcon.name = string3;
                    break block10;
                }
                if (string.startsWith(URL_PREFIX)) {
                    String string4 = string.substring(URL_PREFIX.length() + 1).trim();
                    try {
                        URL uRL = new URL(string4);
                        nbImageIcon = new NbImageIcon(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        nbImageIcon = new NbImageIcon();
                    }
                    nbImageIcon.type = 1;
                    nbImageIcon.name = string4;
                    break block10;
                }
                if (string.equals("null")) {
                    nbImageIcon = null;
                } else {
                    nbImageIcon = new NbImageIcon(string.trim());
                    nbImageIcon.type = 2;
                    nbImageIcon.name = string;
                }
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                throw illegalArgumentException;
            }
        }
        return nbImageIcon;
    }

    public String getDisplayName() {
        return NbBundle.getBundle(this.getClass()).getString("CTL_IconEditor_DisplayName");
    }

    public void readFromXML(org.w3c.dom.Node node) throws IOException {
        if (!XML_IMAGE.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            int n = Integer.parseInt(namedNodeMap.getNamedItem(ATTR_TYPE).getNodeValue());
            String string = namedNodeMap.getNamedItem(ATTR_NAME).getNodeValue();
            switch (n) {
                case 0: {
                    this.setValue(null);
                    break;
                }
                case 1: {
                    this.setAsText("URL: " + string);
                    break;
                }
                case 2: {
                    this.setAsText("File: " + string);
                    break;
                }
                case 3: {
                    this.setAsText("Classpath: " + string);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)nullPointerException);
            throw iOException;
        }
    }

    public org.w3c.dom.Node storeToXML(Document document) {
        Element element = document.createElement(XML_IMAGE);
        if (this.getValue() instanceof NbImageIcon) {
            NbImageIcon nbImageIcon = (NbImageIcon)this.getValue();
            element.setAttribute(ATTR_TYPE, Integer.toString(nbImageIcon.type));
            element.setAttribute(ATTR_NAME, nbImageIcon.name);
        } else {
            element.setAttribute(ATTR_TYPE, "0");
            element.setAttribute(ATTR_NAME, "null");
        }
        return element;
    }

    private class IconPanel
    extends JPanel
    implements EnhancedCustomPropertyEditor,
    ActionListener {
        static final long serialVersionUID = -6904264999063788703L;
        private JPanel jPanel1;
        private JLabel jLabel1;
        private JRadioButton rbUrl;
        private JRadioButton rbFile;
        private JRadioButton rbClasspath;
        private JRadioButton rbNoPicture;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JLabel jLabel4;
        private JLabel jLabel5;
        private JPanel jPanel2;
        private JLabel lName;
        private JTextField tfName;
        private JButton bSelect;
        private JPanel jPanel3;
        private JLabel jLabel7;
        private JScrollPane spImage;
        private JLabel iconLabel;
        private NbImageIcon localIcon;

        public IconPanel() {
            this.iconLabel = new JLabel(){

                public boolean isFocusTraversable() {
                    return true;
                }
            };
            this.iconLabel.setPreferredSize(new Dimension(32, 32));
            this.iconLabel.setHorizontalAlignment(0);
            this.iconLabel.setVerticalAlignment(0);
            this.initComponents();
            this.spImage.setViewportView(this.iconLabel);
            this.jLabel1.setText(IconEditor.getString("CTL_ImageSourceType"));
            this.jLabel2.setText(IconEditor.getString("CTL_URLExample"));
            this.jLabel3.setText(IconEditor.getString("CTL_FileExample"));
            this.jLabel4.setText(IconEditor.getString("CTL_ClasspathExample"));
            this.jLabel5.setText(IconEditor.getString("CTL_Null"));
            this.lName.setLabelFor(this.tfName);
            this.jLabel1.setLabelFor(this.jPanel1);
            this.jLabel2.setLabelFor(this.rbUrl);
            this.jLabel3.setLabelFor(this.rbFile);
            this.jLabel4.setLabelFor(this.rbClasspath);
            this.jLabel5.setLabelFor(this.rbNoPicture);
            this.jLabel7.setLabelFor(this.iconLabel);
            Mnemonics.setLocalizedText((AbstractButton)this.rbUrl, (String)IconEditor.getString("CTL_URL"));
            Mnemonics.setLocalizedText((AbstractButton)this.rbFile, (String)IconEditor.getString("CTL_File"));
            Mnemonics.setLocalizedText((AbstractButton)this.rbClasspath, (String)IconEditor.getString("CTL_Classpath"));
            Mnemonics.setLocalizedText((AbstractButton)this.rbNoPicture, (String)IconEditor.getString("CTL_NoPicture"));
            Mnemonics.setLocalizedText((JLabel)this.lName, (String)IconEditor.getString("CTL_ImageSourceName"));
            Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)IconEditor.getString("CTL_Preview"));
            Mnemonics.setLocalizedText((AbstractButton)this.bSelect, (String)IconEditor.getString("CTL_ButtonSelect"));
            this.tfName.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_ImageSourceName"));
            this.bSelect.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_ButtonSelect"));
            this.iconLabel.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_Preview"));
            this.rbUrl.getAccessibleContext().setAccessibleDescription(this.jLabel2.getText());
            this.rbFile.getAccessibleContext().setAccessibleDescription(this.jLabel3.getText());
            this.rbClasspath.getAccessibleContext().setAccessibleDescription(this.jLabel4.getText());
            this.rbNoPicture.getAccessibleContext().setAccessibleDescription(this.jLabel5.getText());
            this.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_IconCustomEditor"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbUrl);
            buttonGroup.add(this.rbFile);
            buttonGroup.add(this.rbClasspath);
            buttonGroup.add(this.rbNoPicture);
            Object object = IconEditor.this.getValue();
            if (!(object instanceof NbImageIcon)) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            this.localIcon = (NbImageIcon)object;
            switch (this.localIcon.type) {
                case 1: {
                    this.rbUrl.setSelected(true);
                    this.bSelect.setEnabled(false);
                    break;
                }
                case 2: {
                    this.rbFile.setSelected(true);
                    this.bSelect.setEnabled(true);
                    break;
                }
                case 3: {
                    this.rbClasspath.setSelected(true);
                    this.bSelect.setEnabled(true);
                }
            }
            this.tfName.setText(this.localIcon.name);
            this.updateIcon();
        }

        private void initComponents() {
            this.jPanel1 = new JPanel();
            this.jLabel1 = new JLabel();
            this.rbUrl = new JRadioButton();
            this.rbFile = new JRadioButton();
            this.rbClasspath = new JRadioButton();
            this.rbNoPicture = new JRadioButton();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.jLabel4 = new JLabel();
            this.jLabel5 = new JLabel();
            this.jPanel2 = new JPanel();
            this.lName = new JLabel();
            this.tfName = new JTextField();
            this.bSelect = new JButton();
            this.jPanel3 = new JPanel();
            this.jLabel7 = new JLabel();
            this.spImage = new JScrollPane();
            this.setLayout(new GridBagLayout());
            this.jPanel1.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(12, 24, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.rbUrl, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.rbFile, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.rbClasspath, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.rbNoPicture, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(12, 5, 0, 12);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            this.add((Component)this.jPanel1, gridBagConstraints2);
            this.jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints3.anchor = 17;
            this.jPanel2.add((Component)this.lName, gridBagConstraints3);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(12, 5, 0, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.weightx = 1.0;
            this.jPanel2.add((Component)this.tfName, gridBagConstraints3);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(12, 5, 0, 17);
            gridBagConstraints3.anchor = 17;
            this.jPanel2.add((Component)this.bSelect, gridBagConstraints3);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 1;
            this.add((Component)this.jPanel2, gridBagConstraints2);
            this.jPanel3.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints4.anchor = 17;
            this.jPanel3.add((Component)this.jLabel7, gridBagConstraints4);
            gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.insets = new Insets(5, 12, 0, 12);
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            this.jPanel3.add((Component)this.spImage, gridBagConstraints4);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            this.add((Component)this.jPanel3, gridBagConstraints2);
            this.tfName.addActionListener(this);
            this.rbFile.addActionListener(this);
            this.rbUrl.addActionListener(this);
            this.rbClasspath.addActionListener(this);
            this.rbNoPicture.addActionListener(this);
            this.bSelect.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.tfName) {
                this.setValue();
            } else if (object == this.rbFile) {
                this.bSelect.setEnabled(true);
                this.tfName.setEnabled(true);
                this.setValue();
                this.updateIcon();
            } else if (object == this.rbUrl) {
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(true);
                this.setValue();
            } else if (object == this.rbClasspath) {
                this.bSelect.setEnabled(true);
                this.tfName.setEnabled(true);
                this.setValue();
            } else if (object == this.rbNoPicture) {
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                this.localIcon = null;
                this.updateIcon();
            } else if (object == this.bSelect) {
                String string;
                if (this.rbFile.isSelected()) {
                    File file = this.selectFile();
                    if (file != null) {
                        this.tfName.setText(file.getAbsolutePath());
                        this.setValue();
                    }
                } else if (this.rbClasspath.isSelected() && (string = this.selectResource()) != null) {
                    this.tfName.setText("/" + string);
                    this.setValue();
                }
            }
        }

        private File selectFile() {
            final File[] fileArray = new File[1];
            final FeatureDescriptor featureDescriptor = new FeatureDescriptor();
            ExPropertyModel exPropertyModel = new ExPropertyModel(){

                public void setValue(Object object) {
                    fileArray[0] = (File)object;
                }

                public Object getValue() {
                    return fileArray[0];
                }

                public Class getPropertyType() {
                    return File.class;
                }

                public Class getPropertyEditorClass() {
                    return null;
                }

                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                public Object[] getBeans() {
                    return new Object[0];
                }

                public FeatureDescriptor getFeatureDescriptor() {
                    return featureDescriptor;
                }
            };
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    return IconEditor.isImage(file.getName()) || file.isDirectory();
                }

                public String getDescription() {
                    return IconEditor.getString("CTL_ImagesExtensionName");
                }
            };
            featureDescriptor.setValue("directories", Boolean.FALSE);
            featureDescriptor.setValue("files", Boolean.TRUE);
            featureDescriptor.setValue("filter", fileFilter);
            PropertyPanel propertyPanel = new PropertyPanel((PropertyModel)exPropertyModel, 2);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyPanel, IconEditor.getString("CTL_OpenDialogName"), true, null);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == DialogDescriptor.OK_OPTION) {
                return fileArray[0];
            }
            return null;
        }

        private List getRoots(ClassPath classPath) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(classPath.entries().size());
            for (ClassPath.Entry entry : classPath.entries()) {
                URL uRL = entry.getURL();
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)uRL);
                FileObject[] fileObjectArray = result.getRoots();
                if (fileObjectArray.length > 0) {
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        arrayList.add(fileObjectArray[i]);
                    }
                    continue;
                }
                if (entry.getRoot() == null) continue;
                arrayList.add(entry.getRoot());
            }
            return arrayList;
        }

        private String selectResource() {
            FileObject fileObject;
            DataObject dataObject;
            Object object;
            Project project;
            Object object2;
            FileObject fileObject2;
            Children.Array array;
            FileObject fileObject3 = FormEditor.getFormDataObject(IconEditor.this.formModel).getFormFile();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject3, (String)"classpath/execute");
            List list = classPath == null ? Collections.EMPTY_LIST : this.getRoots(classPath);
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject3);
            Node[] nodeArray = new Node[list.size()];
            int n = -1;
            try {
                array = list.listIterator();
                while (array.hasNext()) {
                    fileObject2 = (FileObject)array.next();
                    object2 = DataObject.find((FileObject)fileObject2);
                    object = this.rootDisplayName(fileObject2, project, (project = FileOwnerQuery.getOwner((FileObject)fileObject2)) != project2);
                    nodeArray[array.previousIndex()] = new RootNode(object2.getNodeDelegate(), (String)object);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(4096, (Throwable)dataObjectNotFoundException);
                return null;
            }
            array = new Children.Array();
            array.add(nodeArray);
            fileObject2 = new AbstractNode((Children)array);
            fileObject2.setIconBase("org/netbeans/modules/form/editors2/iconResourceRoot");
            fileObject2.setDisplayName(IconEditor.getString("CTL_ClassPathName"));
            object2 = new ResourceSelector((Node)fileObject2);
            project = new DialogDescriptor(object2, IconEditor.getString("CTL_OpenDialogName"));
            object = DialogDisplayer.getDefault().notify((NotifyDescriptor)project);
            nodeArray = object == DialogDescriptor.OK_OPTION ? ((ResourceSelector)object2).getNodes() : null;
            String string = null;
            if (nodeArray != null && nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class)) != null && (fileObject = dataObject.getPrimaryFile()) != null) {
                if (classPath.contains(fileObject)) {
                    string = classPath.getResourceName(fileObject);
                } else {
                    ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                    string = classPath2.getResourceName(fileObject);
                }
            }
            return string;
        }

        private String rootDisplayName(FileObject fileObject, Project project, boolean bl) {
            if (project != null) {
                String string;
                SourceGroup sourceGroup = this.sourceGroup(fileObject, project);
                String string2 = string = sourceGroup != null ? sourceGroup.getDisplayName() : FileUtil.getFileDisplayName((FileObject)fileObject);
                if (bl) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    string = string + " [" + projectInformation.getDisplayName() + "]";
                }
                return string;
            }
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }

        private SourceGroup sourceGroup(FileObject fileObject, Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                if (fileObject != sourceGroupArray[i].getRootFolder()) continue;
                return sourceGroupArray[i];
            }
            return null;
        }

        public Object getPropertyValue() throws IllegalStateException {
            NbImageIcon nbImageIcon = null;
            String string = this.tfName.getText().trim();
            if ("".equals(string) || "/".equals(string) || "///".equals(string) || string.endsWith("#")) {
                return null;
            }
            if (this.rbFile.isSelected()) {
                nbImageIcon = new NbImageIcon(string);
                nbImageIcon.type = 2;
                nbImageIcon.name = string;
            } else if (this.rbClasspath.isSelected()) {
                URL uRL = IconEditor.this.findResource(string);
                nbImageIcon = new NbImageIcon(uRL);
                nbImageIcon.type = 3;
                nbImageIcon.name = string;
            } else if (this.rbUrl.isSelected()) {
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                nbImageIcon = new NbImageIcon(uRL);
                nbImageIcon.type = 1;
                nbImageIcon.name = string;
            }
            return nbImageIcon;
        }

        void updateIcon() {
            IconEditor.this.setValue(this.localIcon);
            this.iconLabel.setIcon(this.localIcon == null ? null : this.localIcon.icon);
            this.iconLabel.setEnabled(this.localIcon != null);
            this.validate();
        }

        void setValue() {
            String string = this.tfName.getText();
            if ("".equals(string)) {
                this.localIcon = null;
                this.updateIcon();
                return;
            }
            String string2 = "";
            if (this.rbUrl.isSelected()) {
                string2 = "URL: ";
            } else if (this.rbFile.isSelected()) {
                string2 = "File: ";
            } else if (this.rbClasspath.isSelected()) {
                string2 = "Classpath: ";
            }
            try {
                this.localIcon = IconEditor.this.iconFromText(string2 + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.localIcon = null;
            }
            this.updateIcon();
        }
    }

    public static class NbImageIcon
    implements FormDesignValue,
    Serializable {
        static final long serialVersionUID = 7018807466471349466L;
        private ImageIcon icon = new ImageIcon("");
        private int type;
        private String name;

        public NbImageIcon() {
        }

        NbImageIcon(URL uRL) {
            this.type = 1;
            try {
                this.icon = new ImageIcon(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        NbImageIcon(String string) {
            this.type = 2;
            try {
                this.icon = new ImageIcon(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public NbImageIcon(NbImageIcon nbImageIcon) {
            this.icon = nbImageIcon.icon;
            this.type = nbImageIcon.type;
            this.name = nbImageIcon.name;
        }

        String getName() {
            return this.name;
        }

        public Object getDesignValue() {
            return this.icon;
        }

        public String getDescription() {
            return this.name;
        }

        public FormDesignValue copy(FormProperty formProperty) {
            return new NbImageIcon(this);
        }
    }

    private static class ResourceSelector
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();

        public ResourceSelector(Node node) {
            ResourceBundle resourceBundle = NbBundle.getBundle(ResourceSelector.class);
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ResourceSelector"));
            this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ResourceSelector"));
            this.manager.setRootContext(node);
            BeanTreeView beanTreeView = new BeanTreeView();
            beanTreeView.setPopupAllowed(false);
            beanTreeView.setDefaultActionAllowed(false);
            beanTreeView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
            beanTreeView.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ResourceSelectorView"));
            beanTreeView.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ResourceSelectorView"));
            this.add((Component)beanTreeView, "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height = Math.max(dimension.height, Utilities.getUsableScreenBounds().height / 2);
            return dimension;
        }

        public Node[] getNodes() {
            return this.manager.getSelectedNodes();
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }

    private static class RootNode
    extends FilterNode {
        RootNode(Node node, String string) {
            super(node);
            if (string != null) {
                this.disableDelegation(12);
                this.setDisplayName(string);
            }
        }
    }
}

