/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.editors2.CustomTableModelEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableModelEditor
implements PropertyEditor,
XMLPropertyEditor,
NamedPropertyEditor {
    private static final String XML_TABLE = "Table";
    private static final String XML_COLUMN = "Column";
    private static final String XML_DATA = "Data";
    private static final String ATTR_COLUMN_COUNT = "columnCount";
    private static final String ATTR_ROW_COUNT = "rowCount";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_EDITABLE = "editable";
    private static final String ATTR_VALUE = "value";
    private NbTableModel table;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Object getValue() {
        return this.table;
    }

    public void setValue(Object object) {
        this.table = new NbTableModel((TableModel)object);
        this.support.firePropertyChange("", null, null);
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
    }

    public String getJavaInitializationString() {
        TableModel tableModel = (TableModel)this.getValue();
        StringBuffer stringBuffer = new StringBuffer();
        int n = tableModel.getColumnCount();
        int n2 = tableModel.getRowCount();
        stringBuffer.append("{\n\t\t");
        if (n > 0) {
            String string = tableModel.getColumnName(0);
            stringBuffer.append("\"").append(string != null ? string : "").append('\"');
            for (int i = 1; i < n; ++i) {
                String string2 = tableModel.getColumnName(i);
                stringBuffer.append(", \"").append(string2 != null ? string2 : "").append('\"');
            }
        }
        stringBuffer.append("\n\t}");
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("{\n\t\t");
        if (n > 0) {
            stringBuffer2.append(tableModel.getColumnClass(0).getName()).append(".class");
            if (tableModel.getColumnClass(0) != Object.class) {
                bl = true;
            }
            for (int i = 1; i < n; ++i) {
                if (tableModel.getColumnClass(i) != Object.class) {
                    bl = true;
                }
                stringBuffer2.append(", ").append(tableModel.getColumnClass(i).getName()).append(".class");
            }
        }
        stringBuffer2.append("\n\t}");
        boolean bl2 = false;
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("{\n\t\t");
        if (n > 0) {
            stringBuffer3.append(tableModel.isCellEditable(0, 0));
            if (!tableModel.isCellEditable(0, 0)) {
                bl2 = true;
            }
            for (int i = 1; i < n; ++i) {
                if (!tableModel.isCellEditable(0, i)) {
                    bl2 = true;
                }
                stringBuffer3.append(", ").append(tableModel.isCellEditable(0, i));
            }
        }
        stringBuffer3.append("\n\t}");
        StringBuffer stringBuffer4 = new StringBuffer();
        stringBuffer4.append("{\n\t\t");
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (i != 0) {
                    stringBuffer4.append(",\n\t\t");
                }
                if (n == 0) {
                    stringBuffer4.append("{}");
                    continue;
                }
                Object object = tableModel.getValueAt(i, 0);
                stringBuffer4.append('{').append(TableModelEditor.getAsString(object));
                for (int j = 1; j < n; ++j) {
                    object = tableModel.getValueAt(i, j);
                    stringBuffer4.append(", ").append(TableModelEditor.getAsString(object));
                }
                stringBuffer4.append('}');
            }
        }
        stringBuffer4.append("\n\t}");
        if (bl2 || bl) {
            return "new javax.swing.table.DefaultTableModel(\n\tnew Object [][] " + stringBuffer4.toString() + ",\n" + "\tnew String [] " + stringBuffer.toString() + "\n" + ") {\n" + (bl ? "\tClass[] types = new Class [] " + stringBuffer2.toString() + ";\n" : "") + (bl2 ? "\tboolean[] canEdit = new boolean [] " + stringBuffer3.toString() + ";\n" : "") + (bl ? "\n\tpublic Class getColumnClass(int columnIndex) {\n\t\treturn types [columnIndex];\n\t}\n" : "") + (bl2 ? "\n\tpublic boolean isCellEditable(int rowIndex, int columnIndex) {\n\t\treturn canEdit [columnIndex];\n\t}\n" : "") + "}";
        }
        return "new javax.swing.table.DefaultTableModel(\n\tnew Object [][] " + stringBuffer4.toString() + ",\n" + "\tnew String [] " + stringBuffer.toString() + "\n" + ")";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new CustomTableModelEditor(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_TABLE);
        int n = this.table.getColumnCount();
        int n2 = this.table.getRowCount();
        element.setAttribute(ATTR_COLUMN_COUNT, Integer.toString(n));
        element.setAttribute(ATTR_ROW_COUNT, Integer.toString(n2));
        for (int i = 0; i < n; ++i) {
            int n3;
            NbTableModel.ColumnItem columnItem = this.table.getColumnItem(i);
            Element element2 = document.createElement(XML_COLUMN);
            element2.setAttribute(ATTR_TITLE, columnItem.title);
            element2.setAttribute(ATTR_TYPE, columnItem.type.getName());
            element2.setAttribute(ATTR_EDITABLE, columnItem.editable ? "true" : "false");
            boolean bl = false;
            for (n3 = 0; n3 < n2; ++n3) {
                if (columnItem.rows.get(n3) == null) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n3 = 0; n3 < n2; ++n3) {
                    Element element3 = document.createElement(XML_DATA);
                    element3.setAttribute(ATTR_VALUE, TableModelEditor.valueToString(columnItem.rows.get(n3)));
                    element2.appendChild(element3);
                }
            }
            element.appendChild(element2);
        }
        return element;
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_TABLE.equals(node.getNodeName())) {
            throw new IOException(TableModelEditor.getReadingErrorMessage());
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        IOException iOException = null;
        int n = -1;
        int n2 = -1;
        Node node2 = namedNodeMap.getNamedItem(ATTR_COLUMN_COUNT);
        if (node2 != null) {
            try {
                n = Integer.parseInt(node2.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                iOException = new IOException(TableModelEditor.getReadingErrorMessage());
                ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)numberFormatException);
            }
        }
        if ((node2 = namedNodeMap.getNamedItem(ATTR_ROW_COUNT)) != null) {
            try {
                n2 = Integer.parseInt(node2.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                if (iOException == null) {
                    iOException = new IOException(TableModelEditor.getReadingErrorMessage());
                }
                ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)numberFormatException);
            }
        }
        if (n < 0 || n2 < 0) {
            if (iOException == null) {
                iOException = new IOException(TableModelEditor.getReadingErrorMessage());
            }
            throw iOException;
        }
        ArrayList<NbTableModel.ColumnItem> arrayList = new ArrayList<NbTableModel.ColumnItem>(n);
        NodeList nodeList = node.getChildNodes();
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            int n4;
            NamedNodeMap namedNodeMap2;
            Node node3 = nodeList.item(i);
            if (!XML_COLUMN.equals(node3.getNodeName()) || (namedNodeMap2 = node3.getAttributes()) == null) continue;
            String string = null;
            Class<?> clazz = null;
            Boolean bl = null;
            node2 = namedNodeMap2.getNamedItem(ATTR_TITLE);
            if (node2 != null) {
                string = node2.getNodeValue();
            }
            if ((node2 = namedNodeMap2.getNamedItem(ATTR_TYPE)) != null) {
                try {
                    clazz = Class.forName(node2.getNodeValue());
                }
                catch (Exception exception) {
                    iOException = new IOException(TableModelEditor.getReadingErrorMessage());
                    ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
                }
            }
            if ((node2 = namedNodeMap2.getNamedItem(ATTR_EDITABLE)) != null) {
                bl = Boolean.valueOf(node2.getNodeValue());
            }
            if (string == null || clazz == null || bl == null) {
                if (iOException == null) {
                    iOException = new IOException(TableModelEditor.getReadingErrorMessage());
                }
                throw iOException;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>(n2);
            NodeList nodeList2 = node3.getChildNodes();
            int n5 = nodeList2.getLength();
            for (n4 = 0; n4 < n5; ++n4) {
                NamedNodeMap namedNodeMap3;
                Node node4 = nodeList2.item(n4);
                if (!XML_DATA.equals(node4.getNodeName()) || (namedNodeMap3 = node4.getAttributes()) == null) continue;
                Object object = null;
                node2 = namedNodeMap3.getNamedItem(ATTR_VALUE);
                if (node2 != null) {
                    try {
                        object = TableModelEditor.stringToValue(node2.getNodeValue(), clazz);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        iOException = new IOException(TableModelEditor.getReadingErrorMessage());
                        ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)illegalArgumentException);
                        throw iOException;
                    }
                }
                arrayList2.add(object);
            }
            if (arrayList2.size() != n2) {
                if (arrayList2.size() == 0) {
                    for (n4 = 0; n4 < n2; ++n4) {
                        arrayList2.add(null);
                    }
                } else {
                    throw new IOException(TableModelEditor.getReadingErrorMessage());
                }
            }
            arrayList.add(new NbTableModel.ColumnItem(string, clazz, (boolean)bl, arrayList2));
        }
        if (arrayList.size() != n) {
            throw new IOException(TableModelEditor.getReadingErrorMessage());
        }
        this.table = new NbTableModel(arrayList, n2);
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle(TableModelEditor.class);
    }

    private static String getReadingErrorMessage() {
        return TableModelEditor.getBundle().getString("ERR_InvalidXMLFormat");
    }

    private static String valueToString(Object object) {
        if (object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean || object instanceof Character) {
            return object.toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object == null) {
            return "null";
        }
        return null;
    }

    private static Object stringToValue(String string, Class clazz) {
        if ("null".equals(string)) {
            return null;
        }
        if (clazz == Object.class) {
            return string;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.equals(clazz)) {
            return Integer.valueOf(string);
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.equals(clazz)) {
            return Short.valueOf(string);
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.equals(clazz)) {
            return Byte.valueOf(string);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.equals(clazz)) {
            return Long.valueOf(string);
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.equals(clazz)) {
            return Float.valueOf(string);
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.equals(clazz)) {
            return Double.valueOf(string);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.valueOf(string);
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.equals(clazz)) {
            return new Character(string.charAt(0));
        }
        if (String.class.isAssignableFrom(clazz)) {
            return string;
        }
        throw new IllegalArgumentException();
    }

    static String getAsString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
        }
        String string2 = "";
        if (object instanceof Byte) {
            string2 = "(byte) ";
        } else if (object instanceof Short) {
            string2 = "(short) ";
        }
        return "new " + string + "(" + string2 + object + ")";
    }

    static Object getDefaultValue(Class clazz) {
        return null;
    }

    public String getDisplayName() {
        return NbBundle.getBundle(this.getClass()).getString("CTL_TableModelEditor_DisplayName");
    }

    public static class NbTableModel
    extends AbstractTableModel
    implements Externalizable {
        static final long serialVersionUID = -6843008677521167210L;
        List columns;
        int rowCount;
        transient boolean alwaysEditable = false;

        public NbTableModel() {
        }

        public NbTableModel(String[] stringArray, Class[] classArray, boolean[] blArray) {
            this(stringArray, classArray, blArray, 4);
        }

        public NbTableModel(String[] stringArray, Class[] classArray, boolean[] blArray, int n) {
            this.rowCount = n;
            this.columns = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.columns.add(new ColumnItem(stringArray[i], classArray[i], blArray[i], n));
            }
        }

        public NbTableModel(TableModel tableModel) {
            ResourceBundle resourceBundle = TableModelEditor.getBundle();
            if (tableModel == null) {
                this.rowCount = 4;
                this.columns = new ArrayList(20);
                for (int i = 0; i < 4; ++i) {
                    this.columns.add(new ColumnItem(resourceBundle.getString("CTL_Title") + " " + Integer.toString(i + 1), Object.class, true, this.rowCount));
                }
            } else {
                this.rowCount = tableModel.getRowCount();
                int n = tableModel.getColumnCount();
                this.columns = new ArrayList(n);
                if (tableModel instanceof NbTableModel) {
                    NbTableModel nbTableModel = (NbTableModel)tableModel;
                    for (int i = 0; i < n; ++i) {
                        ColumnItem columnItem = (ColumnItem)nbTableModel.columns.get(i);
                        this.columns.add(new ColumnItem(columnItem));
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        ColumnItem columnItem = new ColumnItem(tableModel.getColumnName(i), tableModel.getColumnClass(i), true, this.rowCount);
                        for (int j = 0; j < this.rowCount; ++j) {
                            columnItem.rows.set(j, tableModel.getValueAt(j, i));
                        }
                        this.columns.add(columnItem);
                    }
                }
            }
        }

        NbTableModel(List list, int n) {
            this.columns = list;
            this.rowCount = n;
        }

        public Class getColumnClass(int n) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            return columnItem.type;
        }

        public void setColumnClass(int n, Class clazz) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            columnItem.type = clazz;
        }

        public String getColumnName(int n) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            return columnItem.title;
        }

        public void setColumnName(int n, String string) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            columnItem.title = string;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public boolean isColumnEditable(int n) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            return columnItem.editable;
        }

        public boolean isCellEditable(int n, int n2) {
            if (this.alwaysEditable) {
                return true;
            }
            ColumnItem columnItem = (ColumnItem)this.columns.get(n2);
            return columnItem.editable;
        }

        public void setColumnEditable(int n, boolean bl) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n);
            columnItem.editable = bl;
        }

        public Object getValueAt(int n, int n2) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n2);
            return columnItem.rows.get(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            ColumnItem columnItem = (ColumnItem)this.columns.get(n2);
            columnItem.rows.set(n, object);
            this.fireTableCellUpdated(n, n2);
        }

        private ColumnItem getColumnItem(int n) {
            return (ColumnItem)this.columns.get(n);
        }

        void setRowCount(int n) {
            int n2;
            if (n == this.rowCount) {
                return;
            }
            int n3 = this.columns.size();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                List list = ((ColumnItem)this.columns.get((int)n2)).rows;
                if (n > this.rowCount) {
                    for (n4 = n - this.rowCount; n4 > 0; --n4) {
                        list.add(null);
                    }
                    continue;
                }
                for (n4 = this.rowCount - n; n4 > 0; --n4) {
                    list.remove(n + n4 - 1);
                }
            }
            n2 = this.rowCount;
            this.rowCount = n;
            if (n > n2) {
                this.fireTableRowsInserted(n2, n - 1);
            } else {
                this.fireTableRowsDeleted(n, n2 - 1);
            }
        }

        void addRow(int n) {
            if (n >= 0 && n <= this.rowCount) {
                int n2 = this.columns.size();
                for (int i = 0; i < n2; ++i) {
                    ((ColumnItem)this.columns.get((int)i)).rows.add(n, null);
                }
                ++this.rowCount;
                this.fireTableRowsInserted(n, n);
            }
        }

        void removeRow(int n) {
            if (n >= 0 && n < this.rowCount) {
                int n2 = this.columns.size();
                for (int i = 0; i < n2; ++i) {
                    ((ColumnItem)this.columns.get((int)i)).rows.remove(n);
                }
                --this.rowCount;
                this.fireTableRowsDeleted(n, n);
            }
        }

        void moveRow(int n, int n2) {
            if (this.columns.size() > 0 && n >= 0 && n < this.rowCount && n2 >= 0 && n2 < this.rowCount && n != n2) {
                int n3 = this.columns.size();
                for (int i = 0; i < n3; ++i) {
                    List list = ((ColumnItem)this.columns.get((int)i)).rows;
                    Object e = list.get(n2);
                    list.set(n2, list.get(n));
                    list.set(n, e);
                }
                this.fireTableStructureChanged();
            }
        }

        void setColumnCount(int n) {
            ResourceBundle resourceBundle = TableModelEditor.getBundle();
            int n2 = this.columns.size();
            if (n == n2) {
                return;
            }
            if (n > n2) {
                for (int i = n - n2; i > 0; --i) {
                    this.columns.add(new ColumnItem(resourceBundle.getString("CTL_Title") + " " + Integer.toString(n - i + 1), Object.class, true, this.rowCount));
                }
            } else {
                for (int i = n2 - n; i > 0; --i) {
                    this.columns.remove(n + i - 1);
                }
            }
            this.fireTableStructureChanged();
        }

        void addColumn(int n) {
            if (n >= 0 && n <= this.columns.size()) {
                this.columns.add(n, new ColumnItem(TableModelEditor.getBundle().getString("CTL_Title") + " " + Integer.toString(n + 1), Object.class, true, this.rowCount));
                int n2 = this.columns.size();
                for (int i = n + 1; i < n2; ++i) {
                    ColumnItem columnItem = (ColumnItem)this.columns.get(i);
                    NbTableModel.renameDefaultColumnTitle(columnItem, i, i + 1);
                }
                this.fireTableStructureChanged();
            }
        }

        void removeColumn(int n) {
            if (n >= 0 && n < this.columns.size()) {
                this.columns.remove(n);
                int n2 = this.columns.size();
                for (int i = n; i < n2; ++i) {
                    ColumnItem columnItem = (ColumnItem)this.columns.get(i);
                    NbTableModel.renameDefaultColumnTitle(columnItem, i + 2, i + 1);
                }
                this.fireTableStructureChanged();
            }
        }

        void moveColumn(int n, int n2) {
            if (n >= 0 && n < this.columns.size() && n2 >= 0 && n2 < this.columns.size() && n != n2) {
                ColumnItem columnItem = (ColumnItem)this.columns.get(n);
                ColumnItem columnItem2 = (ColumnItem)this.columns.get(n2);
                NbTableModel.renameDefaultColumnTitle(columnItem, n + 1, n2 + 1);
                NbTableModel.renameDefaultColumnTitle(columnItem2, n2 + 1, n + 1);
                this.columns.set(n2, columnItem);
                this.columns.set(n, columnItem2);
                this.fireTableStructureChanged();
            }
        }

        private static void renameDefaultColumnTitle(ColumnItem columnItem, int n, int n2) {
            String string = TableModelEditor.getBundle().getString("CTL_Title") + " " + Integer.toString(n);
            if (string.equals(columnItem.title)) {
                columnItem.title = TableModelEditor.getBundle().getString("CTL_Title") + " " + Integer.toString(n2);
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            ColumnItem columnItem;
            int n;
            objectOutput.writeInt(this.rowCount);
            int n2 = this.columns.size();
            objectOutput.writeInt(n2);
            String[] stringArray = new String[n2];
            boolean[] blArray = new boolean[n2];
            for (n = 0; n < n2; ++n) {
                columnItem = (ColumnItem)this.columns.get(n);
                stringArray[n] = columnItem.title;
                blArray[n] = columnItem.editable;
            }
            objectOutput.writeObject(stringArray);
            objectOutput.writeObject(blArray);
            for (n = 0; n < n2; ++n) {
                columnItem = (ColumnItem)this.columns.get(n);
                objectOutput.writeObject(columnItem.type.getName());
            }
            for (n = 0; n < this.rowCount; ++n) {
                for (int i = 0; i < n2; ++i) {
                    ColumnItem columnItem2 = (ColumnItem)this.columns.get(i);
                    if (columnItem2.rows.get(n) instanceof Serializable) {
                        objectOutput.writeObject(columnItem2.rows.get(n));
                        continue;
                    }
                    objectOutput.writeObject(null);
                }
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            int n;
            this.rowCount = objectInput.readInt();
            int n2 = objectInput.readInt();
            this.columns = new ArrayList(n2);
            String[] stringArray = (String[])objectInput.readObject();
            boolean[] blArray = (boolean[])objectInput.readObject();
            for (n = 0; n < n2; ++n) {
                this.columns.add(new ColumnItem(stringArray[n], Class.forName((String)objectInput.readObject()), blArray[n], this.rowCount));
            }
            for (n = 0; n < this.rowCount; ++n) {
                for (int i = 0; i < n2; ++i) {
                    ColumnItem columnItem = (ColumnItem)this.columns.get(i);
                    columnItem.rows.set(n, objectInput.readObject());
                }
            }
        }

        private static class ColumnItem {
            String title;
            Class type;
            boolean editable;
            List rows;

            ColumnItem(String string, Class clazz, boolean bl, int n) {
                this.title = string;
                this.type = clazz;
                this.editable = bl;
                this.rows = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    this.rows.add(null);
                }
            }

            ColumnItem(String string, Class clazz, boolean bl, List list) {
                this.title = string;
                this.type = clazz;
                this.editable = bl;
                this.rows = list;
            }

            ColumnItem(ColumnItem columnItem) {
                this.title = columnItem.title;
                this.type = columnItem.type;
                this.editable = columnItem.editable;
                int n = columnItem.rows.size();
                this.rows = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    this.rows.add(columnItem.rows.get(i));
                }
            }
        }
    }
}

