/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

class LayoutDragger
implements LayoutConstants {
    private VisualMapper visualMapper;
    private int operation;
    private static final int ADDING = 0;
    private static final int MOVING = 1;
    private static final int RESIZING = 2;
    private LayoutComponent[] movingComponents;
    private int[] movingEdges;
    private LayoutRegion[] movingFormation;
    private int[] startCursorPosition;
    private SizeDef[] sizing;
    private int[] lastCursorPosition = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
    private int[] moveDirection = new int[]{0, 0};
    private int lockedDimension = -1;
    private LayoutComponent targetContainer;
    private LayoutRegion[] movingBounds;
    private PositionDef[] bestPositions = new PositionDef[2];
    private boolean canSnapToBaseline;
    private LayoutRegion movingSpace;
    private int dimension;
    private boolean snapping;
    private PositionDef[][] findingsNextTo;
    private PositionDef[][] findingsAligned;
    static final int[] ALL_EDGES = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
    private static final int GL_TIP = 8;
    private static final int SNAP_DISTANCE = 8;
    private static final int ORT_DISTANCE = 8;
    private static BasicStroke dashedStroke = new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{5.0f, 2.0f}, 0.0f);

    LayoutDragger(LayoutComponent[] layoutComponentArray, LayoutRegion[] layoutRegionArray, int[] nArray, int[] nArray2, VisualMapper visualMapper) {
        int n;
        int n2;
        for (n2 = 0; n2 < 2; ++n2) {
            if (nArray2[n2] != 0 && nArray2[n2] != 1) continue;
            this.operation = 2;
            break;
        }
        if (this.operation != 2) {
            this.operation = layoutComponentArray[0].getParent() == null ? 0 : 1;
        }
        this.movingComponents = layoutComponentArray;
        this.movingFormation = layoutRegionArray;
        this.startCursorPosition = nArray;
        this.movingEdges = nArray2;
        this.visualMapper = visualMapper;
        this.movingBounds = new LayoutRegion[layoutRegionArray.length];
        this.movingSpace = new LayoutRegion();
        for (n2 = 0; n2 < layoutRegionArray.length; ++n2) {
            this.movingBounds[n2] = new LayoutRegion();
            this.movingSpace.expand(layoutRegionArray[n2]);
        }
        LayoutInterval layoutInterval = layoutComponentArray[0].getLayoutInterval(1).getParent();
        for (n = 0; n < layoutComponentArray.length; ++n) {
            if (layoutComponentArray[n].getLayoutInterval(1).getParent() == layoutInterval) continue;
            layoutInterval = null;
            break;
        }
        this.canSnapToBaseline = layoutComponentArray.length == 1 || layoutInterval != null && layoutInterval.getGroupAlignment() == 3;
        this.findingsNextTo = new PositionDef[2][];
        this.findingsAligned = new PositionDef[2][];
        for (n = 0; n < 2; ++n) {
            int n3 = LayoutRegion.POINT_COUNT[n];
            this.findingsNextTo[n] = new PositionDef[n3];
            this.findingsAligned[n] = new PositionDef[n3];
            for (int i = 0; i < n3; ++i) {
                this.findingsNextTo[n][i] = new PositionDef();
                this.findingsAligned[n][i] = new PositionDef();
            }
        }
        if (this.operation == 2) {
            this.prepareResizing();
        }
    }

    private void prepareResizing() {
        this.sizing = new SizeDef[2];
        LayoutComponent layoutComponent = this.movingComponents[0];
        LayoutRegion layoutRegion = this.movingFormation[0];
        Dimension dimension = null;
        for (int i = 0; i < 2; ++i) {
            SizeDef sizeDef;
            if (!this.isResizing(i)) continue;
            this.sizing[i] = sizeDef = new SizeDef();
            sizeDef.originalSize = layoutRegion.size(i);
            if (layoutComponent.isLayoutContainer()) {
                LayoutInterval layoutInterval = this.findResizingGap(layoutComponent.getLayoutRoot(i));
                if (layoutInterval != null) {
                    sizeDef.resizingGap = layoutInterval;
                    sizeDef.originalGapSize = LayoutInterval.getIntervalCurrentSize(layoutInterval, i);
                    sizeDef.preferredGapSize = LayoutUtils.getSizeOfDefaultGap(layoutInterval, this.visualMapper);
                    sizeDef.preferredSize = sizeDef.originalSize - sizeDef.originalGapSize + sizeDef.preferredGapSize;
                    sizeDef.zeroPreferredSize = LayoutDragger.isZeroResizingGap(layoutInterval) ? sizeDef.originalSize - sizeDef.originalGapSize : Short.MIN_VALUE;
                    continue;
                }
                if (dimension == null) {
                    dimension = this.visualMapper.getComponentMinimumSize(layoutComponent.getId());
                }
                sizeDef.preferredSize = i == 0 ? dimension.width : dimension.height;
                continue;
            }
            if (dimension == null) {
                dimension = this.visualMapper.getComponentPreferredSize(layoutComponent.getId());
            }
            sizeDef.preferredSize = i == 0 ? dimension.width : dimension.height;
        }
    }

    private LayoutInterval findResizingGap(LayoutInterval layoutInterval) {
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval2;
            LayoutInterval layoutInterval3 = (LayoutInterval)iterator.next();
            if (layoutInterval3.isEmptySpace() && layoutInterval3.hasAttribute(4)) {
                return layoutInterval3;
            }
            if (!layoutInterval3.isGroup() || (layoutInterval2 = this.findResizingGap(layoutInterval3)) == null) continue;
            return layoutInterval2;
        }
        return null;
    }

    private static boolean isZeroResizingGap(LayoutInterval layoutInterval) {
        return LayoutInterval.getNeighbor(layoutInterval, 0, false, true, false) == null || LayoutInterval.getNeighbor(layoutInterval, 1, false, true, false) == null;
    }

    void setTargetContainer(LayoutComponent layoutComponent) {
        this.targetContainer = layoutComponent;
    }

    LayoutComponent getTargetContainer() {
        return this.targetContainer;
    }

    boolean isResizing() {
        return this.operation == 2;
    }

    boolean isResizing(int n) {
        return this.movingEdges[n] == 0 || this.movingEdges[n] == 1;
    }

    int getResizingEdge(int n) {
        return this.movingEdges[n];
    }

    LayoutComponent[] getMovingComponents() {
        return this.movingComponents;
    }

    VisualMapper getVisualMapper() {
        return this.visualMapper;
    }

    LayoutRegion[] getMovingBounds() {
        return this.movingBounds;
    }

    LayoutRegion getMovingSpace() {
        return this.movingSpace;
    }

    PositionDef[] getPositions() {
        return this.bestPositions;
    }

    SizeDef[] getSizes() {
        return this.sizing;
    }

    boolean snappedToDefaultSize(int n) {
        if (this.isResizing(n) && this.bestPositions[n] == null) {
            int n2 = this.movingSpace.size(n);
            return n2 == this.sizing[n].preferredSize || n2 == this.sizing[n].zeroPreferredSize;
        }
        return false;
    }

    void move(int[] nArray, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3 = -1;
        int n4 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < 2; ++n2) {
            PositionDef positionDef;
            int n5 = n2;
            nArray[n5] = nArray[n5] - this.startCursorPosition[n2];
            n = nArray[n2];
            int n6 = this.lastCursorPosition[n2];
            this.lastCursorPosition[n2] = n;
            if (n6 == Integer.MIN_VALUE) {
                bl2 = false;
                continue;
            }
            int n7 = n - n6;
            if (n7 != 0) {
                int n8 = this.moveDirection[n2] = n7 > 0 ? 1 : 0;
            }
            if (this.movingEdges[n2] != Integer.MAX_VALUE) {
                bl2 = false;
                continue;
            }
            if (this.lockedDimension >= 0 || (positionDef = this.bestPositions[n2]) == null || positionDef.nextTo || n7 >= n4) continue;
            n3 = n2;
            n4 = n7;
        }
        if (bl2) {
            if (this.lockedDimension < 0) {
                this.lockedDimension = n3;
            }
        } else {
            this.lockedDimension = -1;
        }
        for (n2 = 0; n2 < this.movingBounds.length; ++n2) {
            for (n = 0; n < 2; ++n) {
                if (n == this.lockedDimension) continue;
                this.movingBounds[n2].set(n, this.movingFormation[n2]);
                this.movingBounds[n2].reshape(n, this.movingEdges[n], nArray[n]);
            }
        }
        this.movingSpace = new LayoutRegion();
        for (n2 = 0; n2 < this.movingBounds.length; ++n2) {
            this.movingSpace.expand(this.movingBounds[n2]);
        }
        if (this.canSnapToBaseline) {
            this.movingSpace.positions[1][3] = this.movingBounds[0].positions[1][3];
        }
        for (n2 = 0; n2 < 2; ++n2) {
            if (n2 == this.lockedDimension) continue;
            this.bestPositions[n2] = null;
            for (n = 0; n < LayoutRegion.POINT_COUNT[n2]; ++n) {
                this.findingsNextTo[n2][n].reset();
                this.findingsAligned[n2][n].reset();
            }
        }
        this.snapping = bl;
        if (bl) {
            this.dimension = 1;
            while (this.dimension >= 0) {
                if (this.dimension != this.lockedDimension && this.movingEdges[this.dimension] != Integer.MIN_VALUE && (n2 = this.findBestPosition()) != Integer.MIN_VALUE) {
                    int n9 = this.dimension;
                    nArray[n9] = nArray[n9] - n2;
                    for (n = 0; n < this.movingBounds.length; ++n) {
                        this.movingBounds[n].reshape(this.dimension, this.movingEdges[this.dimension], -n2);
                    }
                    this.movingSpace.reshape(this.dimension, this.movingEdges[this.dimension], -n2);
                }
                --this.dimension;
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            int n10 = n2;
            nArray[n10] = nArray[n10] + this.startCursorPosition[n2];
        }
    }

    void paintMoveFeedback(Graphics2D graphics2D) {
        for (int i = 0; i < 2; ++i) {
            Object object;
            int n;
            int n2;
            int n3;
            PositionDef positionDef = this.bestPositions[i];
            if (positionDef != null) {
                LayoutRegion layoutRegion;
                boolean bl;
                n3 = positionDef.interval.getParent() == null ? 1 : 0;
                n2 = 1 - i;
                n = positionDef.alignment;
                LayoutInterval layoutInterval = positionDef.interval;
                object = layoutInterval.getParent();
                do {
                    bl = false;
                    if (object != null && ((LayoutInterval)object).isParallel()) {
                        if (n == 0 || n == 1) {
                            layoutRegion = ((LayoutInterval)object).getCurrentSpace();
                            if (!positionDef.nextTo && LayoutRegion.distance(layoutRegion, this.movingSpace, i, n, n) == 0) {
                                bl = true;
                            }
                        } else if (n == ((LayoutInterval)object).getGroupAlignment()) {
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    layoutInterval = object;
                    object = LayoutInterval.getFirstParent((LayoutInterval)object, 103);
                } while (bl);
                layoutRegion = layoutInterval.getCurrentSpace();
                LayoutRegion layoutRegion2 = this.targetContainer.getLayoutRoot(0).getCurrentSpace();
                int n4 = layoutRegion2.positions[n2][0];
                int n5 = layoutRegion2.positions[n2][1];
                int n6 = layoutRegion.positions[i][n3 != 0 || !positionDef.nextTo ? n : 1 - n];
                int n7 = layoutRegion.positions[n2][0] - 10;
                n7 = Math.max(n7, n4);
                int n8 = layoutRegion.positions[n2][1] + 10;
                n8 = Math.min(n8, n5);
                int n9 = this.movingSpace.positions[i][n];
                int n10 = this.movingSpace.positions[n2][0] - 10;
                n10 = Math.max(n10, n4);
                int n11 = this.movingSpace.positions[n2][1] + 10;
                n11 = Math.min(n11, n5);
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(dashedStroke);
                if (positionDef.nextTo) {
                    if (i == 0) {
                        graphics2D.drawLine(n9, Math.min(n10, n7), n9, Math.max(n11, n8));
                    } else {
                        graphics2D.drawLine(Math.min(n10, n7), n9, Math.max(n11, n8), n9);
                    }
                } else if (n9 == n6) {
                    if (i == 0) {
                        graphics2D.drawLine(n6, Math.min(n10, n7), n6, Math.max(n11, n8));
                    } else {
                        graphics2D.drawLine(Math.min(n10, n7), n6, Math.max(n11, n8), n6);
                    }
                } else if (i == 0) {
                    graphics2D.drawLine(n6, n7, n6, n8);
                    graphics2D.drawLine(n9, n10, n9, n11);
                } else {
                    graphics2D.drawLine(n7, n6, n8, n6);
                    graphics2D.drawLine(n10, n9, n11, n9);
                }
                graphics2D.setStroke(stroke);
                continue;
            }
            if (!this.snappedToDefaultSize(i)) continue;
            n3 = this.movingEdges[i];
            n2 = this.movingSpace.positions[i][n3];
            n = this.movingSpace.positions[i][n3 ^ 1];
            int n12 = this.movingSpace.positions[i ^ 1][2];
            object = graphics2D.getStroke();
            graphics2D.setStroke(dashedStroke);
            if (i == 0) {
                graphics2D.drawLine(n2, n12, n, n12);
            } else {
                graphics2D.drawLine(n12, n2, n12, n);
            }
            graphics2D.setStroke((Stroke)object);
        }
    }

    String[] positionCode() {
        String[] stringArray = new String[2];
        for (int i = 0; i < 2; ++i) {
            PositionDef positionDef = this.bestPositions[i];
            if (positionDef != null) {
                int n = positionDef.alignment;
                if (positionDef.nextTo) {
                    stringArray[i] = "nextTo" + LayoutDragger.dimensionCode(i) + LayoutDragger.alignmentCode(n);
                    continue;
                }
                int n2 = this.movingSpace.positions[i][n];
                int n3 = positionDef.interval.getCurrentSpace().positions[i][n];
                if (n2 == n3) {
                    stringArray[i] = "align" + LayoutDragger.dimensionCode(i) + LayoutDragger.alignmentCode(n);
                    continue;
                }
                stringArray[i] = "indent";
                continue;
            }
            if (!this.snappedToDefaultSize(i)) continue;
            stringArray[i] = "snappedToDefault" + LayoutDragger.dimensionCode(i);
        }
        if (stringArray[0] == null) {
            stringArray[0] = stringArray[1];
            stringArray[1] = null;
        }
        if (stringArray[0] == null) {
            stringArray[0] = this.isResizing() ? "generalResizing" : "generalPosition";
        }
        return stringArray;
    }

    private static String dimensionCode(int n) {
        return n == 0 ? "Horizontal" : "Vertical";
    }

    private static String alignmentCode(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Leading";
                break;
            }
            case 1: {
                string = "Trailing";
                break;
            }
            case 3: {
                string = "Baseline";
            }
        }
        return string;
    }

    private int findBestPosition() {
        PositionDef positionDef;
        int n;
        int n2 = Integer.MIN_VALUE;
        if (this.targetContainer != null) {
            PositionDef positionDef2;
            LayoutInterval layoutInterval = this.targetContainer.getLayoutRoot(this.dimension);
            n = this.movingEdges[this.dimension];
            this.checkRootForNextTo(layoutInterval, n);
            this.scanLayoutForNextTo(layoutInterval, n);
            PositionDef positionDef3 = this.chooseBestNextTo();
            if (this.snapping) {
                this.checkRootForAligned(layoutInterval, n);
                this.scanLayoutForAligned(layoutInterval, n);
                positionDef2 = this.chooseBestAligned();
            } else {
                positionDef2 = null;
            }
            if (positionDef2 == null) {
                positionDef = positionDef3;
            } else if (positionDef3 == null) {
                positionDef = positionDef2;
            } else {
                PositionDef positionDef4;
                boolean bl = this.isPreferredNextTo(positionDef3, positionDef2);
                int n3 = LayoutDragger.smallestDistance(this.findingsNextTo[this.dimension]);
                int n4 = LayoutDragger.smallestDistance(this.findingsAligned[this.dimension]);
                if (!LayoutDragger.relatedPositions(positionDef3, positionDef2)) {
                    int n5 = Math.abs(LayoutRegion.nonOverlapDistance(positionDef2.interval.getCurrentSpace(), this.movingSpace, this.dimension ^ 1));
                    n4 = LayoutDragger.getDistanceScore(n4, n5);
                }
                if (bl) {
                    positionDef = n4 * 2 <= n3 && n3 - n4 >= 4 ? positionDef2 : positionDef3;
                } else {
                    PositionDef positionDef5 = positionDef = n3 * 2 <= n4 && n4 - n3 >= 4 ? positionDef3 : positionDef2;
                }
                if (positionDef == positionDef3 && (positionDef4 = this.getAlignedEqualToNextTo(positionDef3)) != null) {
                    positionDef = positionDef4;
                }
            }
        } else {
            positionDef = null;
        }
        if (this.snapping) {
            if (this.isResizing(this.dimension)) {
                int n6 = this.movingSpace.size(this.dimension) - this.sizing[this.dimension].preferredSize;
                int n7 = this.movingSpace.size(this.dimension) - this.sizing[this.dimension].zeroPreferredSize;
                int n8 = Math.abs(n6) <= Math.abs(n7) ? n6 : n7;
                n = Math.abs(n8);
                if (n < 8 && (positionDef == null || n < Math.abs(positionDef.distance))) {
                    positionDef = null;
                    int n9 = n2 = this.movingEdges[this.dimension] == 0 ? -n8 : n8;
                }
            }
            if (positionDef != null) {
                n2 = positionDef.distance;
            }
        }
        this.bestPositions[this.dimension] = positionDef;
        return n2;
    }

    private void checkRootForNextTo(LayoutInterval layoutInterval, int n) {
        assert (n == Integer.MAX_VALUE || n == 0 || n == 1);
        if (this.operation == 2 && this.isValidNextToResizing(layoutInterval, n) != 1) {
            return;
        }
        LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
        for (int i = 0; i <= 1; ++i) {
            if (n != Integer.MAX_VALUE && n != i) continue;
            int n2 = LayoutRegion.distance(layoutRegion, this.movingSpace, this.dimension, i, i);
            assert (n2 != Integer.MIN_VALUE);
            if (this.snapping) {
                int n3 = this.findPadding(null, this.movingComponents[0].getLayoutInterval(this.dimension), this.dimension, i);
                n2 += i == 0 ? -n3 : n3;
            }
            if (this.snapping && Math.abs(n2) >= 8) continue;
            PositionDef positionDef = this.findingsNextTo[this.dimension][i];
            assert (!positionDef.isSet());
            positionDef.interval = layoutInterval;
            positionDef.alignment = i;
            positionDef.distance = n2;
            positionDef.nextTo = true;
            positionDef.snapped = this.snapping && Math.abs(n2) < 8;
        }
    }

    private int scanLayoutForNextTo(LayoutInterval layoutInterval, int n) {
        assert (n == Integer.MAX_VALUE || n == 0 || n == 1);
        int n2 = -1;
        int n3 = layoutInterval.getSubIntervalCount();
        for (int i = 0; i < n3; ++i) {
            LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(i);
            if (layoutInterval2.isEmptySpace() || !this.orthogonalOverlap(layoutInterval, i)) continue;
            int n4 = -1;
            if (layoutInterval2.isComponent()) {
                if (this.isValidInterval(layoutInterval2) && (this.operation != 2 || this.isValidNextToResizing(layoutInterval2, n) == 1)) {
                    n4 = this.checkNextToPosition(layoutInterval2, n);
                }
            } else if (layoutInterval2.isSequential()) {
                n4 = this.scanLayoutForNextTo(layoutInterval2, n);
            } else {
                int n5;
                int n6;
                boolean bl = this.isValidInterval(layoutInterval2);
                int n7 = n6 = bl && this.operation == 2 ? this.isValidNextToResizing(layoutInterval2, n) : 1;
                if (n6 != -1 && LayoutDragger.canGoInsideForNextTo(layoutInterval2, bl)) {
                    int n8 = n;
                    for (int j = 0; j <= 1; ++j) {
                        if (n != Integer.MAX_VALUE && j != n) continue;
                        int n9 = LayoutRegion.distance(layoutInterval2.getCurrentSpace(), this.movingSpace, this.dimension, j, j) * (j == 0 ? 1 : -1);
                        if (n9 >= -8) continue;
                        n8 = n8 == Integer.MAX_VALUE ? j ^ 1 : Integer.MIN_VALUE;
                    }
                    n5 = n8 != Integer.MIN_VALUE ? this.scanLayoutForNextTo(layoutInterval2, n8) : -1;
                } else {
                    n5 = n;
                }
                if (bl && n6 == 1 && n5 != -1) {
                    n4 = this.checkNextToPosition(layoutInterval2, n5);
                }
            }
            if (n4 == -1) continue;
            if (layoutInterval.isSequential()) {
                if (n2 != -1 || i != 0 && i + 1 != n3) continue;
                if (i != 0) {
                    n4 = n4 == 1 ? -1 : 0;
                } else if (i + 1 != n3) {
                    n4 = n4 == 0 ? -1 : 1;
                }
                n2 = n4;
                continue;
            }
            if (LayoutInterval.wantResize(layoutInterval2)) {
                if (n4 == Integer.MAX_VALUE) {
                    n2 = Integer.MAX_VALUE;
                    continue;
                }
                if (n2 != -1) continue;
                n2 = n4;
                continue;
            }
            if (n4 != Integer.MAX_VALUE && (n4 ^ 1) != layoutInterval2.getAlignment() || n2 != -1) continue;
            n2 = layoutInterval2.getAlignment() ^ 1;
        }
        return n2;
    }

    private boolean orthogonalOverlap(LayoutInterval layoutInterval, int n) {
        LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(n);
        LayoutRegion layoutRegion = layoutInterval2.getCurrentSpace();
        if (LayoutRegion.overlap(this.movingSpace, layoutRegion, this.dimension ^ 1, 0)) {
            return true;
        }
        if (this.dimension == 1) {
            if (layoutInterval2.isSequential()) {
                return true;
            }
            if (layoutInterval.getParent() != null && layoutInterval.getParent().getSubIntervalCount() > 1) {
                return false;
            }
            if (!LayoutRegion.overlap(this.movingSpace, layoutInterval.getCurrentSpace(), this.dimension, 0)) {
                return true;
            }
            if (layoutInterval.isSequential()) {
                if (LayoutRegion.distance(this.movingSpace, layoutRegion, this.dimension, 1, 0) > 0) {
                    LayoutInterval layoutInterval3;
                    while (--n >= 0 && ((layoutInterval3 = layoutInterval.getSubInterval(n)).isEmptySpace() || !this.isValidInterval(layoutInterval3))) {
                    }
                    if (n < 0) {
                        return true;
                    }
                } else if (LayoutRegion.distance(layoutRegion, this.movingSpace, this.dimension, 1, 0) > 0) {
                    LayoutInterval layoutInterval4;
                    while (++n < layoutInterval.getSubIntervalCount() && ((layoutInterval4 = layoutInterval.getSubInterval(n)).isEmptySpace() || !this.isValidInterval(layoutInterval4))) {
                    }
                    if (n == layoutInterval.getSubIntervalCount()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private int checkNextToPosition(LayoutInterval layoutInterval, int n) {
        int n2 = -1;
        LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
        for (int i = 0; i <= 1; ++i) {
            boolean bl;
            if (n != Integer.MAX_VALUE && i != n) continue;
            int n3 = LayoutRegion.distance(layoutRegion, this.movingSpace, this.dimension, i ^ 1, i);
            if (this.snapping) {
                int n4 = this.findPadding(layoutInterval, this.movingComponents[0].getLayoutInterval(this.dimension), this.dimension, i);
                bl = Math.abs(n3 += i == 0 ? -n4 : n4) < 8;
            } else {
                boolean bl2 = i == 0 ? n3 > 0 : (bl = n3 < 0);
            }
            if (!bl) continue;
            n2 = n2 == -1 ? i : Integer.MAX_VALUE;
            PositionDef positionDef = this.findingsNextTo[this.dimension][i];
            if (positionDef.isSet() && this.compareNextToPosition(layoutInterval, n3, positionDef) <= 0) continue;
            positionDef.interval = layoutInterval;
            positionDef.alignment = i;
            positionDef.distance = n3;
            positionDef.nextTo = true;
            positionDef.snapped = this.snapping;
        }
        return n2;
    }

    private int compareNextToPosition(LayoutInterval layoutInterval, int n, PositionDef positionDef) {
        int n2;
        if (!positionDef.isSet()) {
            return 1;
        }
        LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
        LayoutRegion layoutRegion2 = positionDef.interval.getCurrentSpace();
        int n3 = Math.abs(positionDef.distance);
        if (n < 0) {
            n = -n;
        }
        if (n != n3) {
            return n < n3 ? 1 : -1;
        }
        if (layoutInterval.isParentOf(positionDef.interval)) {
            return 1;
        }
        int n4 = Math.abs(LayoutRegion.minDistance(layoutRegion, this.movingSpace, this.dimension ^ 1));
        if (n4 != (n2 = Math.abs(LayoutRegion.minDistance(layoutRegion2, this.movingSpace, this.dimension ^ 1)))) {
            return n4 < n2 ? 1 : -1;
        }
        return 0;
    }

    private static boolean canGoInsideForNextTo(LayoutInterval layoutInterval, boolean bl) {
        return layoutInterval.isSequential() || layoutInterval.isParallel() && (!bl || layoutInterval.getGroupAlignment() != 2 && layoutInterval.getGroupAlignment() != 3);
    }

    private void checkRootForAligned(LayoutInterval layoutInterval, int n) {
        assert (n == Integer.MAX_VALUE || n == 0 || n == 1);
        if (this.operation == 2 && !this.isValidAlignedResizing(layoutInterval, n)) {
            return;
        }
        LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
        for (int i = 0; i <= 1; ++i) {
            int n2;
            if (n != Integer.MAX_VALUE && n != i || (n2 = LayoutRegion.distance(layoutRegion, this.movingSpace, this.dimension, i, i)) == Integer.MIN_VALUE || Math.abs(n2) >= 8) continue;
            PositionDef positionDef = this.findingsAligned[this.dimension][i];
            assert (!positionDef.isSet());
            positionDef.interval = layoutInterval;
            positionDef.alignment = i;
            positionDef.distance = n2;
            positionDef.nextTo = false;
            positionDef.snapped = true;
        }
    }

    private void scanLayoutForAligned(LayoutInterval layoutInterval, int n) {
        assert (n == Integer.MAX_VALUE || n == 0 || n == 1);
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
            if (layoutInterval2.isEmptySpace()) continue;
            if (layoutInterval2.isComponent() && this.isValidInterval(layoutInterval2) && (this.operation != 2 || this.isValidAlignedResizing(layoutInterval2, n))) {
                for (int i = 0; i < LayoutRegion.POINT_COUNT[this.dimension]; ++i) {
                    PositionDef positionDef;
                    int n2;
                    if (n != Integer.MAX_VALUE && i != n) continue;
                    int n3 = this.getIndentedDistance(layoutInterval2, i);
                    int n4 = this.getDirectDistance(layoutInterval2, i);
                    int n5 = n2 = Math.abs(n3) < Math.abs(n4) ? n3 : n4;
                    if (!this.checkAlignedDistance(n2, layoutInterval2.getCurrentSpace(), i) || this.compareAlignedPosition(layoutInterval2, n2, positionDef = this.findingsAligned[this.dimension][i]) < 0) continue;
                    positionDef.interval = layoutInterval2;
                    positionDef.alignment = i;
                    positionDef.distance = n2;
                    positionDef.nextTo = false;
                    positionDef.snapped = true;
                }
            }
            if (layoutInterval2.getSubIntervalCount() <= 0 || !LayoutRegion.overlap(layoutInterval2.getCurrentSpace(), this.movingSpace, this.dimension, 4)) continue;
            this.scanLayoutForAligned(layoutInterval2, n);
        }
    }

    private int getIndentedDistance(LayoutInterval layoutInterval, int n) {
        int n2;
        LayoutRegion layoutRegion;
        int n3;
        if (this.dimension == 0 && n == 0 && (n3 = LayoutRegion.distance(layoutRegion = layoutInterval.getCurrentSpace(), this.movingSpace, 1, 1, 0)) >= 0 && n3 < 16 && (n2 = this.findIndent(layoutInterval.getComponent(), this.movingComponents[0], this.dimension, n)) > 0) {
            return LayoutRegion.distance(layoutRegion, this.movingSpace, this.dimension, n, n) - n2;
        }
        return Integer.MAX_VALUE;
    }

    private int getDirectDistance(LayoutInterval layoutInterval, int n) {
        return this.checkValidAlignment(layoutInterval, n) ? LayoutRegion.distance(layoutInterval.getCurrentSpace(), this.movingSpace, this.dimension, n, n) : Integer.MAX_VALUE;
    }

    private boolean checkValidAlignment(LayoutInterval layoutInterval, int n) {
        int n2 = layoutInterval.getAlignment();
        if (n2 != -1) {
            boolean bl = true;
            Iterator iterator = layoutInterval.getParent().getSubIntervals();
            while (iterator.hasNext()) {
                LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
                if (layoutInterval2 == layoutInterval || !this.isValidInterval(layoutInterval2)) continue;
                bl = false;
                break;
            }
            if (bl) {
                n2 = -1;
            }
        }
        return !(n == 0 || n == 1 ? n2 == 2 || n2 == 3 : (n == 2 ? n2 != 2 : n == 3 && n2 == 2));
    }

    private boolean checkAlignedDistance(int n, LayoutRegion layoutRegion, int n2) {
        if (n != Integer.MIN_VALUE && Math.abs(n) < 8) {
            int n3;
            int n4;
            int n5;
            int n6 = this.movingSpace.positions[this.dimension][n2] - layoutRegion.positions[this.dimension][n2] - n;
            if (n6 == 0) {
                n5 = layoutRegion.positions[this.dimension][n2] - 4;
                n4 = layoutRegion.positions[this.dimension][n2] + 4;
                n3 = this.movingSpace.positions[this.dimension ^ 1][0];
            } else {
                n5 = layoutRegion.positions[this.dimension][n2];
                n4 = n5 + n6 + 4;
                n3 = this.movingSpace.positions[this.dimension ^ 1][1];
            }
            int n7 = layoutRegion.positions[this.dimension ^ 1][1];
            if (n7 > n3 && (n7 = this.movingSpace.positions[this.dimension ^ 1][1]) > (n3 = layoutRegion.positions[this.dimension ^ 1][0])) {
                return true;
            }
            return !this.contentOverlap(this.targetContainer.getLayoutRoot(this.dimension), n5, n4, n7, n3, this.dimension);
        }
        return false;
    }

    private boolean contentOverlap(LayoutInterval layoutInterval, int n, int n2, int n3, int n4, int n5) {
        int[][] nArray = layoutInterval.getCurrentSpace().positions;
        int n6 = layoutInterval.getSubIntervalCount();
        for (int i = 0; i < n6; ++i) {
            Object object;
            int n7;
            int n8;
            int n9;
            int n10;
            LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(i);
            if (layoutInterval2.isEmptySpace()) {
                if (layoutInterval.isParallel()) continue;
                n10 = i == 0 ? nArray[n5][0] : layoutInterval.getSubInterval((int)(i - 1)).getCurrentSpace().positions[n5][1];
                n9 = i + 1 == n6 ? nArray[n5][1] : layoutInterval.getSubInterval((int)(i + 1)).getCurrentSpace().positions[n5][0];
                n8 = nArray[n5 ^ 1][0];
                n7 = nArray[n5 ^ 1][1];
                if (n8 < n3) {
                    n7 = n8;
                } else if (n7 > n4) {
                    n8 = n7;
                }
            } else {
                object = layoutInterval2.getCurrentSpace().positions;
                n10 = object[n5][0];
                n9 = object[n5][1];
                n8 = object[n5 ^ 1][0];
                n7 = object[n5 ^ 1][1];
            }
            if (n10 >= n2 || n9 <= n || n8 >= n4 || n7 <= n3) continue;
            if (layoutInterval2.isComponent()) {
                if (!this.isValidInterval(layoutInterval2)) continue;
                return true;
            }
            if (layoutInterval2.isEmptySpace()) {
                if (!(i <= 0 || i + 1 >= n6 || layoutInterval2.getMinimumSize() != -1 && layoutInterval2.getMinimumSize() != -2 || layoutInterval2.getPreferredSize() != -1 || layoutInterval2.getMaximumSize() != -1 && layoutInterval2.getMaximumSize() != -2)) {
                    object = layoutInterval.getSubInterval(i - 1);
                    LayoutInterval layoutInterval3 = layoutInterval.getSubInterval(i + 1);
                    if (!(((LayoutInterval)object).isComponent() && !this.isValidInterval((LayoutInterval)object) || layoutInterval3.isComponent() && !this.isValidInterval(layoutInterval3))) {
                        return true;
                    }
                }
                if (n10 < n || n9 > n2) continue;
                return false;
            }
            if (!layoutInterval2.isGroup() || !this.contentOverlap(layoutInterval2, n, n2, n3, n4, n5)) continue;
            return true;
        }
        return false;
    }

    private int compareAlignedPosition(LayoutInterval layoutInterval, int n, PositionDef positionDef) {
        int n2;
        if (!positionDef.isSet()) {
            return 1;
        }
        if (n < 0) {
            n = -n;
        }
        int n3 = Math.abs(positionDef.distance);
        if (layoutInterval.getParent() == null) {
            return n < n3 ? 1 : -1;
        }
        if (positionDef.interval.getParent() == null) {
            return n3 < n ? -1 : 1;
        }
        LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
        LayoutRegion layoutRegion2 = positionDef.interval.getCurrentSpace();
        int n4 = Math.abs(LayoutRegion.nonOverlapDistance(layoutRegion, this.movingSpace, this.dimension ^ 1));
        int n5 = Math.abs(LayoutRegion.nonOverlapDistance(layoutRegion2, this.movingSpace, this.dimension ^ 1));
        int n6 = LayoutDragger.getDistanceScore(n, n4);
        if (n6 != (n2 = LayoutDragger.getDistanceScore(n3, n5))) {
            return n6 < n2 ? 1 : -1;
        }
        return 0;
    }

    private static int getDistanceScore(int n, int n2) {
        return n + n2 / 8;
    }

    private PositionDef chooseBestNextTo() {
        PositionDef[] positionDefArray = this.findingsNextTo[this.dimension];
        PositionDef positionDef = null;
        int n = 0;
        for (int i = 0; i < positionDefArray.length; ++i) {
            PositionDef positionDef2 = positionDefArray[i];
            if (!positionDef2.isSet()) continue;
            int n2 = Math.abs(positionDef2.distance);
            if (positionDef != null && n2 >= n && (n2 != n || this.moveDirection[this.dimension] != i)) continue;
            positionDef = positionDef2;
            n = n2;
        }
        return positionDef;
    }

    private PositionDef chooseBestAligned() {
        PositionDef[] positionDefArray = this.findingsAligned[this.dimension];
        PositionDef positionDef = null;
        for (int i = positionDefArray.length - 1; i >= 0; --i) {
            PositionDef positionDef2 = positionDefArray[i];
            if (!positionDef2.isSet()) continue;
            if (i == 3 || i == 2) {
                return positionDef2;
            }
            if (positionDef == null) {
                positionDef = positionDef2;
                continue;
            }
            int n = this.compareAlignedPosition(positionDef2.interval, positionDef2.distance, positionDef);
            if (n == 0) {
                n = this.compareAlignedDirection(positionDef2, positionDef);
            }
            if (n <= 0) continue;
            positionDef = positionDef2;
        }
        return positionDef;
    }

    private int compareAlignedDirection(PositionDef positionDef, PositionDef positionDef2) {
        boolean bl;
        boolean bl2 = LayoutDragger.isSuitableAlignment(positionDef);
        if (bl2 == (bl = LayoutDragger.isSuitableAlignment(positionDef2))) {
            bl2 = positionDef.alignment == this.moveDirection[this.dimension];
            boolean bl3 = bl = positionDef2.alignment == this.moveDirection[this.dimension];
            if (bl2 == bl) {
                return 0;
            }
        }
        return bl2 ? 1 : -1;
    }

    private static boolean isSuitableAlignment(PositionDef positionDef) {
        assert (positionDef.alignment == 0 || positionDef.alignment == 1);
        LayoutInterval layoutInterval = LayoutInterval.getFirstParent(positionDef.interval, 103);
        return LayoutInterval.isAlignedAtBorder(positionDef.interval, layoutInterval, positionDef.alignment) || !LayoutInterval.isAlignedAtBorder(positionDef.interval, layoutInterval, positionDef.alignment ^ 1);
    }

    private static int smallestDistance(PositionDef[] positionDefArray) {
        int n = -1;
        for (int i = 0; i < positionDefArray.length; ++i) {
            PositionDef positionDef = positionDefArray[i];
            if (!positionDef.isSet()) continue;
            int n2 = Math.abs(positionDef.distance);
            if (n >= 0 && n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    private boolean isPreferredNextTo(PositionDef positionDef, PositionDef positionDef2) {
        if (positionDef != null && positionDef2 != null && this.operation == 2) {
            LayoutInterval layoutInterval;
            LayoutInterval layoutInterval2 = this.movingComponents[0].getLayoutInterval(this.dimension);
            int n = this.movingEdges[this.dimension] ^ 1;
            return !(positionDef2.interval.isParentOf(layoutInterval2) ? LayoutInterval.isAlignedAtBorder(layoutInterval2, positionDef2.interval, n) : LayoutInterval.isAlignedAtBorder(layoutInterval2, layoutInterval = LayoutInterval.getCommonParent(layoutInterval2, positionDef2.interval), n) && LayoutInterval.isAlignedAtBorder(positionDef2.interval, layoutInterval, n));
        }
        return this.dimension == 0;
    }

    private static boolean relatedPositions(PositionDef positionDef, PositionDef positionDef2) {
        if (positionDef.interval == null || positionDef2.interval == null) {
            return false;
        }
        LayoutInterval layoutInterval = LayoutInterval.getNeighbor(positionDef2.interval, positionDef.alignment, true, true, false);
        return layoutInterval == positionDef.interval || layoutInterval == null && positionDef.interval.getParent() == null;
    }

    private PositionDef getAlignedEqualToNextTo(PositionDef positionDef) {
        LayoutInterval layoutInterval;
        if (this.operation == 2 || !positionDef.snapped) {
            return null;
        }
        int n = positionDef.alignment;
        PositionDef positionDef2 = this.findingsAligned[this.dimension][n];
        if (positionDef2 != null && positionDef2.distance == positionDef.distance && (layoutInterval = LayoutInterval.getNeighbor(positionDef2.interval, n, true, true, false)) != null && (layoutInterval == positionDef.interval || layoutInterval.isParentOf(positionDef.interval))) {
            return positionDef2;
        }
        return null;
    }

    private boolean isValidInterval(LayoutInterval layoutInterval) {
        if (this.operation == 0) {
            return true;
        }
        if (layoutInterval.isGroup()) {
            int n = 0;
            Iterator iterator = layoutInterval.getSubIntervals();
            while (iterator.hasNext()) {
                LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
                if (layoutInterval2.isEmptySpace() && !layoutInterval.isSequential() || !this.isValidInterval(layoutInterval2) || ++n <= 1) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.movingComponents.length; ++i) {
            if (this.movingComponents[i].getLayoutInterval(this.dimension) != layoutInterval) continue;
            return false;
        }
        return true;
    }

    private int isValidNextToResizing(LayoutInterval layoutInterval, int n) {
        assert (n == 0 || n == 1);
        LayoutInterval layoutInterval2 = this.movingComponents[0].getLayoutInterval(this.dimension);
        if (layoutInterval.isParentOf(layoutInterval2)) {
            return layoutInterval.getParent() == null && LayoutDragger.clearWayToParent(layoutInterval2, layoutInterval, this.dimension, n) && (!LayoutDragger.toDeepToMerge(layoutInterval2, layoutInterval, n) || LayoutInterval.getNeighbor(layoutInterval2, n, true, true, false) == null) ? 1 : 0;
        }
        LayoutInterval layoutInterval3 = LayoutInterval.getCommonParent(layoutInterval, layoutInterval2);
        if (layoutInterval3.isSequential()) {
            if (LayoutDragger.toDeepToMerge(layoutInterval2, layoutInterval3, n) && LayoutInterval.getNeighbor(layoutInterval2, n, true, true, false) != layoutInterval) {
                return -1;
            }
            if ((layoutInterval2 = LayoutDragger.getClearWayToParent(layoutInterval2, layoutInterval3, this.dimension, n)) == null) {
                return -1;
            }
            while (layoutInterval.getParent() != layoutInterval3) {
                layoutInterval = layoutInterval.getParent();
            }
            int n2 = layoutInterval3.indexOf(n == 0 ? layoutInterval : layoutInterval2) + 1;
            int n3 = layoutInterval3.indexOf(n == 0 ? layoutInterval2 : layoutInterval) - 1;
            return n2 <= n3 && !LayoutUtils.contentOverlap(this.movingSpace, layoutInterval3, n2, n3, this.dimension ^ 1) ? 1 : -1;
        }
        return -1;
    }

    private boolean isValidAlignedResizing(LayoutInterval layoutInterval, int n) {
        int n2 = LayoutRegion.distance(this.movingSpace, layoutInterval.getCurrentSpace(), this.dimension, n ^ 1, n);
        if (n == 0 && n2 <= 0 || n == 1 && n2 >= 0) {
            int n3;
            int n4;
            LayoutInterval layoutInterval2 = this.movingComponents[0].getLayoutInterval(this.dimension);
            if (layoutInterval.isParentOf(layoutInterval2)) {
                LayoutInterval layoutInterval3;
                if (!LayoutDragger.clearWayToParent(layoutInterval2, layoutInterval, this.dimension, n)) {
                    return false;
                }
                return !LayoutDragger.toDeepToMerge(layoutInterval2, layoutInterval, n) || (layoutInterval3 = LayoutInterval.getNeighbor(layoutInterval2, n, true, true, false)) == null || !layoutInterval.isParentOf(layoutInterval3);
            }
            LayoutInterval layoutInterval4 = LayoutInterval.getCommonParent(layoutInterval, layoutInterval2);
            if (layoutInterval4.isParallel()) {
                return true;
            }
            if (LayoutDragger.toDeepToMerge(layoutInterval2, layoutInterval4, n)) {
                return false;
            }
            if ((layoutInterval2 = LayoutDragger.getClearWayToParent(layoutInterval2, layoutInterval4, this.dimension, n)) == null) {
                return false;
            }
            while (layoutInterval.getParent() != layoutInterval4) {
                layoutInterval = layoutInterval.getParent();
            }
            if (n == 0) {
                n4 = layoutInterval4.indexOf(layoutInterval);
                n3 = layoutInterval4.indexOf(layoutInterval2) - 1;
            } else {
                n4 = layoutInterval4.indexOf(layoutInterval2) + 1;
                n3 = layoutInterval4.indexOf(layoutInterval);
            }
            return n4 <= n3 && !LayoutUtils.contentOverlap(this.movingSpace, layoutInterval4, n4, n3, this.dimension ^ 1);
        }
        return false;
    }

    private static boolean clearWayToParent(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2) {
        return LayoutDragger.getClearWayToParent(layoutInterval, layoutInterval2, n, n2) != null;
    }

    private static LayoutInterval getClearWayToParent(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2) {
        LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        while (layoutInterval3 != layoutInterval2) {
            if (layoutInterval3.isSequential()) {
                int n3;
                int n4;
                if (n2 == 0) {
                    n4 = 0;
                    n3 = layoutInterval3.indexOf(layoutInterval) - 1;
                } else {
                    n4 = layoutInterval3.indexOf(layoutInterval) + 1;
                    n3 = layoutInterval3.getSubIntervalCount() - 1;
                }
                if (n4 <= n3 && LayoutUtils.contentOverlap(layoutRegion, layoutInterval3, n4, n3, n ^ 1)) {
                    return null;
                }
            }
            layoutInterval = layoutInterval3;
            layoutInterval3 = layoutInterval.getParent();
        }
        return layoutInterval;
    }

    private static boolean toDeepToMerge(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        int n2 = 0;
        int n3 = -1;
        LayoutInterval layoutInterval3 = null;
        LayoutInterval layoutInterval4 = layoutInterval.getParent();
        while (layoutInterval4 != layoutInterval2) {
            if (layoutInterval4.isParallel()) {
                if (n3 == -1) {
                    n3 = layoutInterval.getAlignment();
                    if (n3 != n) {
                        ++n2;
                    }
                } else if (!LayoutInterval.isAlignedAtBorder(layoutInterval3, layoutInterval4, n3) && ++n2 > 1) {
                    return true;
                }
                layoutInterval3 = layoutInterval4;
            }
            layoutInterval = layoutInterval4;
            layoutInterval4 = layoutInterval.getParent();
        }
        return n2 >= 2;
    }

    int findPadding(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2) {
        int n3 = n2 == 0 ? 1 : 0;
        List list = LayoutUtils.edgeSubComponents(layoutInterval2, n2);
        List list2 = LayoutUtils.edgeSubComponents(layoutInterval, n3);
        List list3 = n2 == 0 ? list2 : list;
        List list4 = n2 == 0 ? list : list2;
        HashMap<String, LayoutRegion> hashMap = new HashMap<String, LayoutRegion>();
        for (int i = 0; i < this.movingComponents.length; ++i) {
            hashMap.put(this.movingComponents[i].getId(), this.movingBounds[i]);
        }
        return LayoutUtils.getSizeOfDefaultGap(list3, list4, this.visualMapper, this.targetContainer.getId(), hashMap);
    }

    int findIndent(LayoutComponent layoutComponent, LayoutComponent layoutComponent2, int n, int n2) {
        return this.visualMapper.getPreferredPadding(layoutComponent.getId(), layoutComponent2.getId(), n, n2, 2);
    }

    static class PositionDef {
        private int distance = Integer.MIN_VALUE;
        LayoutInterval interval;
        int alignment = Integer.MIN_VALUE;
        boolean nextTo;
        boolean snapped;

        PositionDef() {
        }

        private void reset() {
            this.distance = Integer.MIN_VALUE;
            this.interval = null;
            this.alignment = Integer.MIN_VALUE;
        }

        private boolean isSet() {
            return this.interval != null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("distance=").append(this.distance);
            stringBuffer.append(",alignment=").append(this.alignment);
            stringBuffer.append(",nextTo=").append(this.nextTo);
            stringBuffer.append(",snapped=").append(this.snapped);
            return stringBuffer.toString();
        }
    }

    static class SizeDef {
        private int originalSize;
        private int preferredSize;
        private int zeroPreferredSize;
        private LayoutInterval resizingGap;
        private int originalGapSize;
        private int preferredGapSize;

        SizeDef() {
        }

        LayoutInterval getResizingGap() {
            return this.resizingGap;
        }

        int getResizingGapSize(int n) {
            if (this.resizingGap == null) {
                return Integer.MIN_VALUE;
            }
            if (n == this.zeroPreferredSize) {
                return 0;
            }
            int n2 = this.originalGapSize - this.originalSize + n;
            return n == this.preferredSize || n2 < 0 ? -1 : n2;
        }
    }
}

