/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDragger;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutOperations;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;

class LayoutFeeder
implements LayoutConstants {
    boolean imposeSize;
    boolean optimizeStructure;
    private LayoutModel layoutModel;
    private LayoutOperations operations;
    private LayoutDragger dragger;
    private IncludeDesc[] originalPositions1 = new IncludeDesc[2];
    private IncludeDesc[] originalPositions2 = new IncludeDesc[2];
    private boolean[] originalLPositionsFixed = new boolean[2];
    private boolean[] originalTPositionsFixed = new boolean[2];
    private LayoutDragger.PositionDef[] newPositions = new LayoutDragger.PositionDef[2];
    private LayoutInterval[] addingIntervals;
    private boolean[] becomeResizing = new boolean[2];
    private int dimension;
    private LayoutInterval addingInterval;
    private LayoutRegion addingSpace;
    private boolean solveOverlap;
    private boolean originalLPosFixed;
    private boolean originalTPosFixed;
    private int aEdge;
    private LayoutInterval aSnappedParallel;
    private LayoutInterval aSnappedNextTo;

    LayoutFeeder(LayoutOperations layoutOperations, LayoutDragger layoutDragger, LayoutInterval[] layoutIntervalArray) {
        this.layoutModel = layoutOperations.getModel();
        this.operations = layoutOperations;
        this.dragger = layoutDragger;
        this.addingIntervals = layoutIntervalArray;
        for (int i = 0; i < 2; ++i) {
            this.dimension = i;
            if (layoutDragger.isResizing()) {
                Object object;
                LayoutInterval layoutInterval = layoutIntervalArray[i];
                if (layoutDragger.isResizing(i)) {
                    IncludeDesc includeDesc = LayoutFeeder.findOutCurrentPosition(layoutInterval, i, layoutDragger.getResizingEdge(i) ^ 1);
                    object = layoutDragger.getPositions()[i];
                    if (!(object != null && ((LayoutDragger.PositionDef)object).snapped || includeDesc.snapped())) {
                        includeDesc.alignment = LayoutInterval.getEffectiveAlignment(layoutInterval);
                    }
                    this.originalPositions1[i] = includeDesc;
                    this.newPositions[i] = object;
                    this.becomeResizing[i] = this.checkResizing();
                } else {
                    IncludeDesc includeDesc;
                    int n = -1;
                    object = LayoutFeeder.findOutCurrentPosition(layoutInterval, i, n);
                    this.originalPositions1[i] = object;
                    n = ((IncludeDesc)object).alignment;
                    if ((n == 0 || n == 1) && (includeDesc = LayoutFeeder.findOutCurrentPosition(layoutInterval, i, n ^ 1)).snapped()) {
                        this.originalPositions2[i] = includeDesc;
                    }
                }
                this.originalLPositionsFixed[i] = LayoutFeeder.isFixedRelativePosition(layoutInterval, 0);
                this.originalTPositionsFixed[i] = LayoutFeeder.isFixedRelativePosition(layoutInterval, 1);
                continue;
            }
            this.newPositions[i] = layoutDragger.getPositions()[i];
        }
    }

    void add() {
        int n;
        int n2 = n = this.getDimensionSolvingOverlap(this.newPositions);
        for (int i = 0; i < 2; ++i) {
            LayoutDragger.PositionDef positionDef;
            this.dimension = n2;
            this.addingInterval = this.addingIntervals[n2];
            this.addingSpace = this.dragger.getMovingSpace();
            this.addingInterval.setCurrentSpace(this.addingSpace);
            this.solveOverlap = n == n2;
            IncludeDesc includeDesc = this.originalPositions1[n2];
            IncludeDesc includeDesc2 = this.originalPositions2[n2];
            LayoutFeeder.correctNeighborInSequence(includeDesc);
            LayoutFeeder.correctNeighborInSequence(includeDesc2);
            if (this.dragger.isResizing()) {
                this.originalLPosFixed = this.originalLPositionsFixed[n2];
                this.originalTPosFixed = this.originalTPositionsFixed[n2];
                if (this.dragger.isResizing(n2)) {
                    this.layoutModel.setIntervalSize(this.addingInterval, this.becomeResizing[n2] ? -1 : -2, this.addingSpace.size(n2), this.becomeResizing[n2] ? Short.MAX_VALUE : -2);
                }
            }
            if ((positionDef = this.newPositions[n2]) != null && (positionDef.alignment == 2 || positionDef.alignment == 3)) {
                this.aEdge = positionDef.alignment;
                this.aSnappedParallel = positionDef.interval;
                this.addSimplyAligned();
            } else if (this.dragger.isResizing() && (includeDesc.alignment == 2 || includeDesc.alignment == 3)) {
                this.aEdge = includeDesc.alignment;
                this.aSnappedParallel = includeDesc.snappedParallel;
                this.addSimplyAligned();
            } else {
                IncludeDesc includeDesc3;
                IncludeDesc includeDesc4 = null;
                IncludeDesc includeDesc5 = null;
                LinkedList<IncludeDesc> linkedList = new LinkedList<IncludeDesc>();
                boolean bl = false;
                if (this.dragger.isResizing(n2 ^ 1)) {
                    this.aEdge = includeDesc.alignment;
                    this.aSnappedParallel = includeDesc.snappedParallel;
                    this.aSnappedNextTo = includeDesc.snappedNextTo;
                } else if (positionDef != null) {
                    this.aEdge = positionDef.alignment;
                    this.aSnappedParallel = !positionDef.nextTo ? positionDef.interval : null;
                    this.aSnappedNextTo = positionDef.snapped && positionDef.nextTo ? positionDef.interval : null;
                    bl = this.dragger.isResizing(n2);
                } else if (this.dragger.isResizing(n2)) {
                    this.aEdge = includeDesc.alignment;
                    this.aSnappedParallel = includeDesc.snappedParallel;
                    this.aSnappedNextTo = includeDesc.snappedNextTo;
                    bl = true;
                } else {
                    this.aEdge = -1;
                    this.aSnappedNextTo = null;
                    this.aSnappedParallel = null;
                }
                LayoutInterval layoutInterval = this.dragger.getTargetContainer().getLayoutRoot(n2);
                this.analyzeParallel(layoutInterval, linkedList);
                if (linkedList.isEmpty()) {
                    assert (this.aSnappedParallel != null);
                    if (includeDesc != null && includeDesc.alignment == this.aEdge) {
                        linkedList.add(includeDesc);
                    } else {
                        this.addAligningInclusion(linkedList);
                    }
                } else {
                    includeDesc3 = this.addAligningInclusion(linkedList);
                    if (linkedList.size() > 1) {
                        if (includeDesc3 == null || bl && includeDesc.alignment == this.aEdge) {
                            includeDesc3 = includeDesc;
                        }
                        this.mergeParallelInclusions(linkedList, includeDesc3, bl);
                        assert (linkedList.size() == 1);
                    }
                }
                includeDesc3 = (IncludeDesc)linkedList.get(0);
                linkedList.clear();
                if (bl) {
                    includeDesc4 = includeDesc;
                    if (includeDesc3 != includeDesc) {
                        if (positionDef != null) {
                            includeDesc5 = includeDesc3;
                        }
                        if (includeDesc3.parent == includeDesc.parent && includeDesc3.newSubGroup) {
                            includeDesc.newSubGroup = true;
                        }
                    }
                } else {
                    includeDesc4 = includeDesc3;
                    if (this.dragger.isResizing(n2 ^ 1) && (positionDef != null || includeDesc2 != null)) {
                        if (positionDef != null) {
                            assert (this.dragger.isResizing(n2));
                            this.aEdge = positionDef.alignment;
                            this.aSnappedParallel = !positionDef.nextTo ? positionDef.interval : null;
                            this.aSnappedNextTo = positionDef.snapped && positionDef.nextTo ? positionDef.interval : null;
                        } else {
                            assert (!this.dragger.isResizing(n2));
                            this.aEdge = includeDesc2.alignment;
                            this.aSnappedParallel = includeDesc2.snappedParallel;
                            this.aSnappedNextTo = includeDesc2.snappedNextTo;
                        }
                        this.analyzeParallel(layoutInterval, linkedList);
                        if (linkedList.isEmpty()) {
                            assert (this.aSnappedParallel != null);
                            if (includeDesc2 != null && includeDesc2.alignment == this.aEdge) {
                                linkedList.add(includeDesc2);
                            } else {
                                this.addAligningInclusion(linkedList);
                            }
                        } else {
                            IncludeDesc includeDesc6 = this.addAligningInclusion(linkedList);
                            if (linkedList.size() > 1) {
                                if (includeDesc6 == null) {
                                    includeDesc6 = includeDesc2 != null ? includeDesc2 : includeDesc;
                                }
                                this.mergeParallelInclusions(linkedList, includeDesc6, false);
                                assert (linkedList.size() == 1);
                            }
                        }
                        includeDesc5 = (IncludeDesc)linkedList.get(0);
                        linkedList.clear();
                    }
                }
                if (!this.mergeSequentialInclusions(includeDesc4, includeDesc5)) {
                    includeDesc5 = null;
                }
                this.addInterval(includeDesc4, includeDesc5);
            }
            n2 ^= 1;
        }
    }

    private static IncludeDesc findOutCurrentPosition(LayoutInterval layoutInterval, int n, int n2) {
        LayoutInterval layoutInterval2;
        LayoutInterval layoutInterval3;
        Object object;
        int n3;
        LayoutInterval layoutInterval4 = layoutInterval.getParent();
        int n4 = LayoutInterval.getCount(layoutInterval4, Integer.MAX_VALUE, true);
        IncludeDesc includeDesc = new IncludeDesc();
        if (layoutInterval4.isSequential() && n4 > 1) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n4 == 2) {
                includeDesc.parent = layoutInterval4.getParent();
                int n5 = 0;
                for (n3 = layoutInterval4.getSubIntervalCount() - 1; n3 >= 0; --n3) {
                    object = layoutInterval4.getSubInterval(n3);
                    if (object == layoutInterval) {
                        n5 = n3;
                        continue;
                    }
                    if (((LayoutInterval)object).isEmptySpace()) continue;
                    includeDesc.neighbor = object;
                    includeDesc.index = n5;
                    break;
                }
            } else {
                includeDesc.parent = layoutInterval4;
                includeDesc.index = layoutInterval4.indexOf(layoutInterval);
            }
        } else {
            if (layoutInterval4.isSequential()) {
                layoutInterval4 = layoutInterval4.getParent();
                n4 = LayoutInterval.getCount(layoutInterval4, Integer.MAX_VALUE, true);
                if (n2 < 0) {
                    n2 = 0;
                }
            } else {
                int n6 = layoutInterval.getAlignment();
                if (n2 < 0 || n6 != 0 && n6 != 1) {
                    n2 = n6;
                }
            }
            if (n4 <= 2 && layoutInterval4.getParent() != null) {
                LayoutInterval layoutInterval5 = layoutInterval4;
                if ((layoutInterval4 = layoutInterval4.getParent()).isSequential()) {
                    n3 = 0;
                    object = layoutInterval4.getSubIntervals();
                    while (object.hasNext()) {
                        LayoutInterval layoutInterval6 = (LayoutInterval)object.next();
                        if (layoutInterval6.isEmptySpace() || layoutInterval6.isParentOf(layoutInterval) || !LayoutRegion.overlap(layoutInterval.getCurrentSpace(), layoutInterval6.getCurrentSpace(), n ^ 1, 0)) continue;
                        n3 = 1;
                        break;
                    }
                    if (n3 != 0) {
                        includeDesc.newSubGroup = true;
                        includeDesc.index = layoutInterval4.indexOf(layoutInterval5);
                    } else {
                        layoutInterval4 = layoutInterval4.getParent();
                    }
                }
                includeDesc.parent = layoutInterval4;
            } else {
                includeDesc.parent = layoutInterval4;
            }
        }
        if (n2 == 0 || n2 == 1) {
            includeDesc.fixedPosition = LayoutFeeder.isFixedRelativePosition(layoutInterval, n2);
        }
        includeDesc.snappedParallel = LayoutFeeder.findAlignedInterval(layoutInterval, n, n2);
        if (includeDesc.snappedParallel == null && (n2 == 0 || n2 == 1) && (layoutInterval3 = LayoutInterval.getNeighbor(layoutInterval, n2, false, true, false)) != null && LayoutInterval.isFixedDefaultPadding(layoutInterval3) && ((layoutInterval2 = LayoutInterval.getDirectNeighbor(layoutInterval3, n2 ^ 1, true)) == layoutInterval || LayoutInterval.isPlacedAtBorder(layoutInterval, layoutInterval2, n, n2))) {
            object = LayoutInterval.getNeighbor(layoutInterval3, n2, true, true, false);
            if (object != null) {
                if (((LayoutInterval)object).getParent() == layoutInterval3.getParent() || ((LayoutInterval)object).getCurrentSpace().positions[n][n2 ^ 1] == layoutInterval3.getParent().getCurrentSpace().positions[n][n2]) {
                    includeDesc.snappedNextTo = object;
                }
            } else {
                object = LayoutInterval.getRoot(layoutInterval);
                if (LayoutInterval.isPlacedAtBorder(layoutInterval3.getParent(), (LayoutInterval)object, n, n2)) {
                    includeDesc.snappedNextTo = object;
                }
            }
        }
        includeDesc.alignment = n2;
        return includeDesc;
    }

    private static boolean isFixedRelativePosition(LayoutInterval layoutInterval, int n) {
        assert (n == 0 || n == 1);
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2 == null) {
            return true;
        }
        if (layoutInterval2.isSequential()) {
            LayoutInterval layoutInterval3 = LayoutInterval.getDirectNeighbor(layoutInterval, n, false);
            if (layoutInterval3 != null) {
                return !LayoutInterval.wantResize(layoutInterval3);
            }
            layoutInterval = layoutInterval2;
            layoutInterval2 = layoutInterval.getParent();
        }
        if (!LayoutInterval.isAlignedAtBorder(layoutInterval, layoutInterval2, n) && LayoutInterval.contentWantResize(layoutInterval2)) {
            return false;
        }
        return LayoutFeeder.isFixedRelativePosition(layoutInterval2, n);
    }

    private static LayoutInterval findAlignedInterval(LayoutInterval layoutInterval, int n, int n2) {
        Object object;
        LayoutInterval layoutInterval2 = null;
        boolean bl = false;
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        if ((n2 == 0 || n2 == 1) && layoutInterval3.isSequential() && LayoutInterval.getCount(layoutInterval3, -1, true) == 1 && (object = LayoutInterval.getDirectNeighbor(layoutInterval, n2, false)) != null && ((LayoutInterval)object).isEmptySpace() && !LayoutInterval.canResize((LayoutInterval)object) && LayoutInterval.getCount(layoutInterval3.getParent(), Integer.MAX_VALUE, true) == 2) {
            bl = true;
        }
        do {
            layoutInterval3 = LayoutInterval.getFirstParent(layoutInterval, 103);
            if (!bl) {
                boolean bl2;
                boolean bl3 = n2 == 0 || n2 == 1 ? LayoutInterval.isAlignedAtBorder(layoutInterval, layoutInterval3, n2) : (bl2 = layoutInterval.getParent() == layoutInterval3 && layoutInterval.getAlignment() == n2);
                if (!bl2) {
                    return null;
                }
                if (layoutInterval3.getParent() == null) {
                    return layoutInterval3;
                }
            }
            object = layoutInterval3.getSubIntervals();
            while (object.hasNext()) {
                LayoutInterval layoutInterval4 = (LayoutInterval)object.next();
                if (layoutInterval4.isEmptySpace() || layoutInterval4 == layoutInterval || layoutInterval4.isParentOf(layoutInterval)) continue;
                if (n2 == 0 || n2 == 1) {
                    LayoutInterval layoutInterval5 = LayoutUtils.getOutermostComponent(layoutInterval4, n, n2);
                    if (!LayoutInterval.isAlignedAtBorder(layoutInterval5, layoutInterval3, n2) && !LayoutInterval.isPlacedAtBorder(layoutInterval5, layoutInterval3, n, n2)) continue;
                    LayoutInterval layoutInterval6 = LayoutInterval.getFirstParent(layoutInterval5, 103);
                    while (layoutInterval6 != layoutInterval3) {
                        layoutInterval5 = layoutInterval6;
                        layoutInterval6 = LayoutInterval.getFirstParent(layoutInterval5, 103);
                    }
                    layoutInterval2 = layoutInterval5;
                    break;
                }
                layoutInterval2 = layoutInterval4;
                break;
            }
            if (bl) {
                return layoutInterval2;
            }
            layoutInterval = layoutInterval3;
        } while (layoutInterval2 == null);
        return layoutInterval3.getSubIntervalCount() > 2 ? layoutInterval3 : layoutInterval2;
    }

    private static void correctNeighborInSequence(IncludeDesc includeDesc) {
        if (includeDesc != null && includeDesc.neighbor != null && includeDesc.neighbor.getParent().isSequential()) {
            assert (includeDesc.parent == includeDesc.neighbor.getParent().getParent());
            includeDesc.parent = includeDesc.neighbor.getParent();
            includeDesc.neighbor = null;
        }
    }

    private int getDimensionSolvingOverlap(LayoutDragger.PositionDef[] positionDefArray) {
        boolean[] blArray;
        if (this.dragger.isResizing(0) && !this.dragger.isResizing(1)) {
            return 0;
        }
        if (this.dragger.isResizing(1) && !this.dragger.isResizing(0) || positionDefArray[0] != null && positionDefArray[0].snapped && (positionDefArray[1] == null || !positionDefArray[1].snapped) || positionDefArray[1] != null && !positionDefArray[1].nextTo && positionDefArray[1].snapped && positionDefArray[1].interval.getParent() == null && !LayoutFeeder.existsComponentPlacedAtBorder(positionDefArray[1].interval, 1, positionDefArray[1].alignment)) {
            return 1;
        }
        if (positionDefArray[1] != null && positionDefArray[1].nextTo && positionDefArray[1].snapped && positionDefArray[1].interval.getParent() == null) {
            int n = positionDefArray[1].alignment;
            int[][] nArray = LayoutFeeder.overlappingGapSides(this.dragger.getTargetContainer().getLayoutRoot(0), this.dragger.getMovingSpace());
            if ((n == 0 || n == 1) && nArray[1][1 - n] != 0 && nArray[1][n] == 0) {
                return 1;
            }
        }
        if (!(positionDefArray[0] != null && positionDefArray[0].snapped || positionDefArray[1] != null && positionDefArray[1].snapped || !(blArray = LayoutFeeder.overlappingGapDimensions(this.dragger.getTargetContainer().getLayoutRoot(0), this.dragger.getMovingSpace()))[1] || blArray[0])) {
            return 1;
        }
        return 0;
    }

    private static boolean existsComponentPlacedAtBorder(LayoutInterval layoutInterval, int n, int n2) {
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
            if (!LayoutInterval.isPlacedAtBorder(layoutInterval, n, n2)) continue;
            if (layoutInterval2.isComponent()) {
                return true;
            }
            if (!layoutInterval2.isGroup() || !LayoutFeeder.existsComponentPlacedAtBorder(layoutInterval2, n, n2)) continue;
            return true;
        }
        return false;
    }

    private static void fillOverlappingComponents(List list, LayoutInterval layoutInterval, LayoutRegion layoutRegion) {
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
            if (layoutInterval2.isGroup()) {
                LayoutFeeder.fillOverlappingComponents(list, layoutInterval2, layoutRegion);
                continue;
            }
            if (!layoutInterval2.isComponent()) continue;
            LayoutComponent layoutComponent = layoutInterval2.getComponent();
            LayoutRegion layoutRegion2 = layoutInterval2.getCurrentSpace();
            if (!LayoutRegion.overlap(layoutRegion2, layoutRegion, 0, 0) || !LayoutRegion.overlap(layoutRegion2, layoutRegion, 1, 0)) continue;
            list.add(layoutComponent);
        }
    }

    private static boolean[] overlappingGapDimensions(LayoutInterval layoutInterval, LayoutRegion layoutRegion) {
        boolean[] blArray = new boolean[2];
        int[][] nArray = LayoutFeeder.overlappingGapSides(layoutInterval, layoutRegion);
        for (int i = 0; i < 2; ++i) {
            blArray[i] = nArray[i][0] == 1 && nArray[i][1] == 1;
        }
        return blArray;
    }

    private static int[][] overlappingGapSides(LayoutInterval layoutInterval, LayoutRegion layoutRegion) {
        int[][] nArrayArray = new int[][]{{0, 0}, {0, 0}};
        LinkedList linkedList = new LinkedList();
        LayoutFeeder.fillOverlappingComponents(linkedList, layoutInterval, layoutRegion);
        for (LayoutComponent layoutComponent : linkedList) {
            LayoutRegion layoutRegion2 = layoutComponent.getLayoutInterval(0).getCurrentSpace();
            for (int i = 0; i < 2; ++i) {
                int[] nArray = LayoutFeeder.overlappingSides(layoutRegion2, layoutRegion, i);
                for (int j = 0; j < 2; ++j) {
                    if (nArray[j] == 1) {
                        nArrayArray[i][j] = 1;
                        continue;
                    }
                    if (nArray[j] != -1) continue;
                    if (nArrayArray[i][j] == -1) {
                        nArrayArray[i][j] = 1;
                        continue;
                    }
                    if (nArrayArray[i][j] != 0) continue;
                    nArrayArray[i][j] = -1;
                }
            }
        }
        return nArrayArray;
    }

    private static int[] overlappingSides(LayoutRegion layoutRegion, LayoutRegion layoutRegion2, int n) {
        int[] nArray = new int[2];
        int n2 = layoutRegion.positions[n][0];
        int n3 = layoutRegion.positions[n][1];
        int n4 = layoutRegion2.positions[n][0];
        int n5 = layoutRegion2.positions[n][1];
        if (n4 < n3 && n3 < n5) {
            nArray[0] = 1;
        }
        if (n4 < n2 && n2 < n5) {
            nArray[1] = 1;
        }
        if (nArray[0] == 1 && nArray[1] == 1) {
            nArray[1] = -1;
            nArray[0] = -1;
        }
        return nArray;
    }

    private boolean checkResizing() {
        LayoutInterval layoutInterval = this.addingIntervals[this.dimension];
        int n = this.dragger.getResizingEdge(this.dimension);
        int n2 = n ^ 1;
        LayoutDragger.PositionDef positionDef = this.newPositions[this.dimension];
        boolean bl = false;
        if (positionDef != null && positionDef.snapped && positionDef.interval != null) {
            int n3;
            int n4;
            if (positionDef.interval.isParentOf(layoutInterval)) {
                LayoutInterval layoutInterval2 = LayoutInterval.getFirstParent(layoutInterval, 103);
                if (!LayoutRegion.pointInside(this.dragger.getMovingSpace(), n, layoutInterval2.getCurrentSpace(), this.dimension)) {
                    layoutInterval2 = positionDef.interval;
                }
                n4 = LayoutInterval.getEffectiveAlignmentInParent(layoutInterval, layoutInterval2, n2);
                n3 = n;
            } else {
                LayoutInterval layoutInterval3 = LayoutInterval.getCommonParent(layoutInterval, positionDef.interval);
                n4 = LayoutInterval.getEffectiveAlignmentInParent(layoutInterval, layoutInterval3, n2);
                int n5 = n3 = positionDef.nextTo ? LayoutInterval.getEffectiveAlignmentInParent(positionDef.interval, layoutInterval3, positionDef.alignment ^ 1) : n;
            }
            if (!(n4 == n3 || n4 != 0 && n4 != 1 || n3 != 0 && n3 != 1)) {
                bl = true;
            }
        }
        return bl;
    }

    private void addSimplyAligned() {
        int n = this.aEdge;
        assert (n == 2 || n == 3);
        this.layoutModel.setIntervalAlignment(this.addingInterval, n);
        if (this.aSnappedParallel.isParallel() && this.aSnappedParallel.getGroupAlignment() == n) {
            this.layoutModel.addInterval(this.addingInterval, this.aSnappedParallel, -1);
            return;
        }
        LayoutInterval layoutInterval = this.aSnappedParallel.getParent();
        if (layoutInterval.isParallel() && layoutInterval.getGroupAlignment() == n) {
            this.layoutModel.addInterval(this.addingInterval, layoutInterval, -1);
            return;
        }
        int n2 = this.layoutModel.removeInterval(this.aSnappedParallel);
        LayoutInterval layoutInterval2 = new LayoutInterval(103);
        layoutInterval2.setGroupAlignment(n);
        if (layoutInterval.isParallel()) {
            layoutInterval2.setAlignment(this.aSnappedParallel.getAlignment());
        }
        this.layoutModel.setIntervalAlignment(this.aSnappedParallel, n);
        this.layoutModel.addInterval(this.aSnappedParallel, layoutInterval2, -1);
        this.layoutModel.addInterval(this.addingInterval, layoutInterval2, -1);
        this.layoutModel.addInterval(layoutInterval2, layoutInterval, n2);
    }

    void addInterval(IncludeDesc includeDesc, IncludeDesc includeDesc2) {
        int n;
        this.addToGroup(includeDesc, includeDesc2, true);
        if (includeDesc.snappedParallel != null || includeDesc2 != null && includeDesc2.snappedParallel != null) {
            if (includeDesc2 != null && includeDesc2.snappedParallel != null) {
                this.alignInParallel(this.addingInterval, includeDesc2.snappedParallel, includeDesc2.alignment);
            }
            if (includeDesc.snappedParallel != null) {
                this.alignInParallel(this.addingInterval, includeDesc.snappedParallel, includeDesc.alignment);
            }
        }
        this.checkParallelResizing(this.addingInterval, includeDesc, includeDesc2);
        LayoutInterval layoutInterval = this.addingInterval.getParent();
        int n2 = -1;
        if (layoutInterval.isSequential()) {
            int n3 = n = layoutInterval.getAlignment() != 1 ? 1 : 0;
            if (LayoutInterval.getDirectNeighbor(this.addingInterval, n, true) == null) {
                n2 = n;
            } else if (LayoutInterval.getDirectNeighbor(this.addingInterval, n ^= 1, true) == null) {
                n2 = n;
            }
        } else {
            n2 = this.addingInterval.getAlignment() ^ 1;
        }
        if (n2 != -1) {
            this.accommodateOutPosition(this.addingInterval, n2);
        }
        if (this.dragger.isResizing(this.dimension) && LayoutInterval.wantResize(this.addingInterval)) {
            this.operations.suppressResizingOfSurroundingGaps(this.addingInterval);
        }
        this.operations.optimizeGaps(LayoutInterval.getFirstParent(this.addingInterval, 103), this.dimension);
        layoutInterval = this.addingInterval.getParent();
        if (layoutInterval.isSequential() && (n = LayoutInterval.getCount(layoutInterval, Integer.MAX_VALUE, true)) > 1 && this.dimension == 0) {
            this.operations.moveInsideSequential(layoutInterval, this.dimension);
        }
        this.operations.mergeParallelGroups(LayoutInterval.getFirstParent(this.addingInterval, 103));
    }

    private void addToGroup(IncludeDesc includeDesc, IncludeDesc includeDesc2, boolean bl) {
        Object object;
        int n;
        int n2;
        LayoutConstants layoutConstants;
        LayoutInterval[] layoutIntervalArray;
        assert (includeDesc2 == null || includeDesc.parent == includeDesc2.parent && includeDesc.newSubGroup == includeDesc2.newSubGroup && includeDesc.neighbor == includeDesc2.neighbor);
        Object object2 = includeDesc.parent;
        LayoutInterval[] layoutIntervalArray2 = null;
        int n3 = 0;
        if (object2.isSequential()) {
            if (includeDesc.newSubGroup && (layoutIntervalArray = this.extractParallelSequence((LayoutInterval)object2, (LayoutRegion)(layoutConstants = this.addingSpace), false, includeDesc.alignment)) != null) {
                layoutIntervalArray2 = new LayoutInterval(102);
                object2 = layoutIntervalArray;
            }
            if (layoutIntervalArray2 == null) {
                layoutIntervalArray2 = object2;
                object2 = layoutIntervalArray2.getParent();
                n3 = includeDesc.index;
            }
        } else {
            layoutConstants = includeDesc.neighbor;
            if (layoutConstants != null) {
                assert (((LayoutInterval)layoutConstants).getParent() == object2);
                layoutIntervalArray2 = new LayoutInterval(102);
                this.layoutModel.addInterval((LayoutInterval)layoutIntervalArray2, (LayoutInterval)object2, this.layoutModel.removeInterval((LayoutInterval)layoutConstants));
                layoutIntervalArray2.setAlignment(((LayoutInterval)layoutConstants).getAlignment());
                this.layoutModel.setIntervalAlignment((LayoutInterval)layoutConstants, -1);
                this.layoutModel.addInterval((LayoutInterval)layoutConstants, (LayoutInterval)layoutIntervalArray2, 0);
                n3 = includeDesc.index;
            } else {
                layoutIntervalArray2 = new LayoutInterval(102);
                layoutIntervalArray2.setAlignment(includeDesc.alignment);
            }
        }
        assert (includeDesc.alignment >= 0 || includeDesc2 == null);
        assert (includeDesc2 == null || includeDesc2.alignment == (includeDesc.alignment ^ 1));
        assert (object2.isParallel());
        layoutConstants = new LayoutInterval[2];
        layoutIntervalArray = new LayoutInterval[2];
        Object object3 = null;
        int[] nArray = new int[2];
        int n4 = layoutIntervalArray2.getSubIntervalCount();
        if (n3 > n4) {
            n3 = n4;
        }
        for (n2 = 0; n2 <= 1; ++n2) {
            int n5;
            n = n2 == 0 ? n3 - 1 : n3;
            int n6 = n5 = n2 == 0 ? n3 - 2 : n3 + 1;
            if (n >= 0 && n < n4) {
                object = layoutIntervalArray2.getSubInterval(n);
                if (((LayoutInterval)object).isEmptySpace()) {
                    object3 = object;
                    if (n5 >= 0 && n5 < n4) {
                        layoutConstants[n2] = layoutIntervalArray2.getSubInterval(n5);
                    }
                } else {
                    layoutConstants[n2] = object;
                }
            }
            if (includeDesc.alignment >= 0) continue;
            nArray[n2] = this.addingSpace.positions[this.dimension][2] - (layoutConstants[n2] != null ? LayoutFeeder.getPerceivedNeighborPosition((LayoutInterval)layoutConstants[n2], this.addingSpace, this.dimension, n2 ^ 1) : LayoutFeeder.getPerceivedParentPosition((LayoutInterval)layoutIntervalArray2, (LayoutInterval)object2, this.addingSpace, this.dimension, n2));
            if (n2 != 1) continue;
            int n7 = n2;
            nArray[n7] = nArray[n7] * -1;
        }
        n = 0;
        for (n2 = 2; n2 > 0; --n2) {
            block43: {
                Object object4;
                boolean bl2;
                Object object5;
                boolean bl3;
                boolean bl4;
                block44: {
                    layoutIntervalArray[n] = null;
                    LayoutInterval layoutInterval = layoutConstants[n] == null ? LayoutInterval.getNeighbor((LayoutInterval)object2, n, false, true, false) : null;
                    Object object6 = object = includeDesc.alignment < 0 || includeDesc.alignment == n ? includeDesc : includeDesc2;
                    if (layoutConstants[n] == null && object != null && (((IncludeDesc)object).snappedNextTo != null && layoutInterval != null && LayoutInterval.isDefaultPadding(layoutInterval) || ((IncludeDesc)object).snappedParallel != null && (!layoutIntervalArray2.isParentOf(((IncludeDesc)object).snappedParallel) || object3 == null))) break block43;
                    bl4 = includeDesc.alignment < 0 ? nArray[n] < nArray[n ^ 1] || nArray[n] == nArray[n ^ 1] && n == 0 : (includeDesc2 != null ? ((IncludeDesc)object).fixedPosition || n == 0 && this.originalLPosFixed || n == 1 && this.originalTPosFixed : (includeDesc.snappedParallel == null || !layoutIntervalArray2.isParentOf(includeDesc.snappedParallel) ? n == includeDesc.alignment : n == (includeDesc.alignment ^ 1)));
                    bl3 = false;
                    if (bl4 || layoutConstants[n] != null || object3 != null) break block44;
                    IncludeDesc includeDesc3 = object == includeDesc ? includeDesc2 : includeDesc;
                    Object object7 = object5 = includeDesc3 != null ? includeDesc3.snappedParallel : null;
                    if (object5 == null && layoutIntervalArray2.getSubIntervalCount() == 0 && layoutIntervalArray2.getAlignment() != (n ^ 1)) {
                        this.layoutModel.setIntervalAlignment((LayoutInterval)layoutIntervalArray2, n ^ 1);
                    }
                    if (layoutInterval != null && layoutInterval.isEmptySpace()) break block43;
                    boolean bl5 = bl3 = object5 != null && ((LayoutInterval)object5).getParent() != null || object2.getParent() != null && LayoutInterval.getCount((LayoutInterval)object2, n ^ 1, true) > 0;
                }
                if (!(bl2 = bl4)) {
                    if (bl3 || LayoutInterval.wantResize(this.addingInterval)) {
                        bl2 = true;
                    } else if (object3 != null && !LayoutInterval.canResize((LayoutInterval)object3)) {
                        Object object8 = object5 = object == includeDesc ? includeDesc2 : includeDesc;
                        if (object5 == null || ((IncludeDesc)object5).snappedParallel == null || layoutConstants[n] == null || LayoutInterval.getEffectiveAlignment((LayoutInterval)layoutConstants[n], n ^ 1) == (n ^ 1)) {
                            bl2 = true;
                        }
                    } else if (object3 == null && (layoutConstants[n] != null && LayoutInterval.getEffectiveAlignment((LayoutInterval)layoutConstants[n], n ^ 1) == (n ^ 1) || LayoutInterval.wantResize((LayoutInterval)layoutIntervalArray2))) {
                        bl2 = true;
                    }
                }
                object5 = new LayoutInterval(101);
                if (!(bl3 || object != null && ((IncludeDesc)object).snappedNextTo != null)) {
                    int n8;
                    object4 = object != null && ((IncludeDesc)object).snappedParallel != null ? ((IncludeDesc)object).snappedParallel.getCurrentSpace() : this.addingSpace;
                    int n9 = n8 = layoutConstants[n] != null ? LayoutRegion.distance(((LayoutInterval)layoutConstants[n]).getCurrentSpace(), (LayoutRegion)object4, this.dimension, n ^ 1, n) : LayoutRegion.distance(object2.getCurrentSpace(), (LayoutRegion)object4, this.dimension, n, n);
                    if (n == 1) {
                        n8 *= -1;
                    }
                    if (n8 > 0) {
                        int n10;
                        int n11 = n10 = layoutConstants[n] != null || LayoutInterval.getNeighbor((LayoutInterval)object2, n, false, true, false) == null ? this.determineExpectingPadding(this.addingInterval, (LayoutInterval)layoutConstants[n], (LayoutInterval)layoutIntervalArray2, n) : Short.MIN_VALUE;
                        if (n8 > n10 || bl2 && n8 != n10) {
                            ((LayoutInterval)object5).setPreferredSize(n8);
                            if (bl2) {
                                ((LayoutInterval)object5).setMinimumSize(-2);
                                ((LayoutInterval)object5).setMaximumSize(-2);
                            }
                        }
                    }
                }
                if (!bl2) {
                    ((LayoutInterval)object5).setMaximumSize(Short.MAX_VALUE);
                    Object object9 = object4 = object == includeDesc ? includeDesc2 : includeDesc;
                    if (bl && layoutConstants[n] != null && object2.getParent() != null && (object4 == null || ((IncludeDesc)object4).alignment == -1) && !LayoutFeeder.isSignificantGroupEdge((LayoutInterval)layoutIntervalArray2, n ^ 1)) {
                        object2 = this.separateSequence((LayoutInterval)layoutIntervalArray2, n ^ 1);
                        if (n == 1) {
                            ++n2;
                        }
                    }
                }
                layoutIntervalArray[n] = object5;
            }
            n ^= 1;
        }
        if (layoutIntervalArray2.getParent() == null) {
            assert (layoutIntervalArray2.getSubIntervalCount() == 0);
            if (layoutIntervalArray[0] == null && layoutIntervalArray[1] == null) {
                this.layoutModel.setIntervalAlignment(this.addingInterval, layoutIntervalArray2.getAlignment());
                this.layoutModel.addInterval(this.addingInterval, (LayoutInterval)object2, -1);
                return;
            }
            this.layoutModel.addInterval((LayoutInterval)layoutIntervalArray2, (LayoutInterval)object2, -1);
        }
        if (includeDesc.snappedParallel != null && layoutIntervalArray2.isParentOf(includeDesc.snappedParallel)) {
            includeDesc.snappedParallel = null;
        }
        n3 = object3 != null ? this.layoutModel.removeInterval((LayoutInterval)object3) : (layoutConstants[1] != null ? layoutIntervalArray2.indexOf((LayoutInterval)layoutConstants[1]) : (layoutConstants[0] != null ? layoutIntervalArray2.getSubIntervalCount() : 0));
        if (layoutIntervalArray[0] != null) {
            this.layoutModel.addInterval(layoutIntervalArray[0], (LayoutInterval)layoutIntervalArray2, n3++);
        }
        this.layoutModel.setIntervalAlignment(this.addingInterval, -1);
        this.layoutModel.addInterval(this.addingInterval, (LayoutInterval)layoutIntervalArray2, n3++);
        if (layoutIntervalArray[1] != null) {
            this.layoutModel.addInterval(layoutIntervalArray[1], (LayoutInterval)layoutIntervalArray2, n3);
        }
    }

    private LayoutInterval extractParallelSequence(LayoutInterval layoutInterval, LayoutRegion layoutRegion, boolean bl, int n) {
        LayoutInterval layoutInterval2;
        int n2 = layoutInterval.getSubIntervalCount();
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = layoutInterval.getCurrentSpace().positions[this.dimension][0];
        int n6 = layoutInterval.getCurrentSpace().positions[this.dimension][1];
        int n7 = n < 0 ? 2 : n;
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            layoutInterval2 = layoutInterval.getSubInterval(i);
            if (layoutInterval2.isEmptySpace()) continue;
            LayoutRegion layoutRegion2 = layoutInterval2.getCurrentSpace();
            boolean bl3 = bl2 = !this.solveOverlap && LayoutUtils.contentOverlap(layoutRegion, layoutInterval2, this.dimension);
            if (!bl2 && LayoutUtils.contentOverlap(layoutRegion, layoutInterval2, this.dimension ^ 1)) {
                if (LayoutFeeder.getAddDirection(layoutRegion, layoutRegion2, this.dimension, n7) == 0) {
                    n4 = i - 1;
                    n6 = layoutRegion2.positions[this.dimension][0];
                    break;
                }
                n3 = i + 1;
                n5 = layoutRegion2.positions[this.dimension][1];
                continue;
            }
            if (!bl) continue;
            int[] nArray = layoutRegion.positions[this.dimension];
            int[] nArray2 = layoutRegion2.positions[this.dimension];
            if (nArray[0] >= nArray2[1]) {
                n3 = i + 1;
                n5 = nArray2[1];
                continue;
            }
            if (nArray[0] >= nArray2[0]) {
                n3 = i;
                n5 = nArray2[0];
                continue;
            }
            if (nArray[1] > nArray2[1]) continue;
            if (nArray[1] > nArray2[0]) {
                n4 = i;
                n6 = nArray2[1];
                break;
            }
            n4 = i - 1;
            n6 = nArray2[0];
            break;
        }
        if (n3 > n4) {
            return null;
        }
        if (n3 == 0 && n4 == n2 - 1) {
            return layoutInterval.getParent();
        }
        LayoutInterval layoutInterval3 = new LayoutInterval(103);
        if (n != -1) {
            layoutInterval3.setGroupAlignment(n);
        }
        if (n3 == n4) {
            layoutInterval2 = this.layoutModel.removeInterval(layoutInterval, n3);
            this.layoutModel.addInterval(layoutInterval2, layoutInterval3, 0);
        } else {
            layoutInterval2 = new LayoutInterval(102);
            layoutInterval3.add(layoutInterval2, 0);
            int n8 = n3;
            while (n8 <= n4) {
                LayoutInterval layoutInterval4 = this.layoutModel.removeInterval(layoutInterval, n8);
                --n4;
                this.layoutModel.addInterval(layoutInterval4, layoutInterval2, -1);
            }
        }
        this.layoutModel.addInterval(layoutInterval3, layoutInterval, n3);
        layoutInterval3.getCurrentSpace().set(this.dimension, n5, n6);
        return layoutInterval3;
    }

    private static int getPerceivedParentPosition(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, LayoutRegion layoutRegion, int n, int n2) {
        int n3 = Integer.MIN_VALUE;
        do {
            if (layoutInterval2.isSequential()) {
                layoutInterval = layoutInterval2;
                layoutInterval2 = layoutInterval.getParent();
            }
            LayoutInterval layoutInterval3 = null;
            while (layoutInterval3 == null && layoutInterval2.getParent() != null) {
                boolean bl;
                boolean bl2 = bl = layoutInterval.getParent() != null ? LayoutFeeder.isSignificantGroupEdge(layoutInterval, n2) : LayoutInterval.isClosedGroup(layoutInterval2, n2);
                if (bl) break;
                layoutInterval3 = LayoutInterval.getDirectNeighbor(layoutInterval2, n2, true);
                if (layoutInterval3 != null || !(layoutInterval2 = (layoutInterval = layoutInterval2).getParent()).isSequential()) continue;
                layoutInterval = layoutInterval2;
                layoutInterval2 = layoutInterval.getParent();
            }
            if (layoutInterval3 == null) {
                n3 = layoutInterval2.getCurrentSpace().positions[n][n2];
                continue;
            }
            while ((n3 = LayoutFeeder.getPerceivedNeighborPosition(layoutInterval3, layoutRegion, n, n2 ^ 1)) == Integer.MIN_VALUE && (layoutInterval3 = LayoutInterval.getDirectNeighbor(layoutInterval3, n2, true)) != null) {
            }
            if (layoutInterval3 != null) continue;
            layoutInterval = layoutInterval2;
            layoutInterval2 = layoutInterval.getParent();
        } while (n3 == Integer.MIN_VALUE);
        return n3;
    }

    private static boolean isSignificantGroupEdge(LayoutInterval layoutInterval, int n) {
        LayoutInterval layoutInterval2;
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        assert (layoutInterval3.isParallel());
        if (layoutInterval.getAlignment() == n || LayoutInterval.wantResize(layoutInterval)) {
            return true;
        }
        if (!LayoutInterval.isClosedGroup(layoutInterval3, n)) {
            return false;
        }
        return LayoutInterval.isExplicitlyClosedGroup(layoutInterval3) || (layoutInterval2 = LayoutInterval.getNeighbor(layoutInterval3, n, false, true, true)) == null || !LayoutInterval.isDefaultPadding(layoutInterval2);
    }

    private static int getPerceivedNeighborPosition(LayoutInterval layoutInterval, LayoutRegion layoutRegion, int n, int n2) {
        int n3;
        int n4;
        assert (!layoutInterval.isEmptySpace());
        if (layoutInterval.isComponent()) {
            return layoutInterval.getCurrentSpace().positions[n][n2];
        }
        int n5 = Integer.MIN_VALUE;
        int n6 = layoutInterval.getSubIntervalCount();
        if (layoutInterval.isParallel() || n2 == 0) {
            n4 = 1;
            n3 = 0;
        } else {
            n4 = -1;
            n3 = n6 - 1;
        }
        while (n3 >= 0 && n3 < n6) {
            int n7;
            LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(n3);
            n3 += n4;
            if (layoutInterval2.isEmptySpace() || layoutInterval2.isComponent() && !LayoutRegion.overlap(layoutRegion, layoutInterval2.getCurrentSpace(), n ^ 1, 0) || (n7 = LayoutFeeder.getPerceivedNeighborPosition(layoutInterval2, layoutRegion, n, n2)) == Integer.MIN_VALUE) continue;
            if (layoutInterval.isSequential()) {
                n5 = n7;
                break;
            }
            if (n5 != Integer.MIN_VALUE && n7 * n4 >= n5 * n4) continue;
            n5 = n7;
        }
        return n5;
    }

    private LayoutInterval separateSequence(LayoutInterval layoutInterval, int n) {
        LayoutInterval layoutInterval2;
        int n2;
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        assert (layoutInterval3.isParallel());
        while (!layoutInterval3.getParent().isSequential()) {
            layoutInterval3 = layoutInterval3.getParent();
        }
        LayoutInterval layoutInterval4 = layoutInterval3.getParent();
        int n3 = n == 0 ? -1 : 1;
        int n4 = layoutInterval4.getSubIntervalCount();
        for (n2 = layoutInterval4.indexOf(layoutInterval3) + n3; n2 >= 0 && n2 < n4 && ((layoutInterval2 = layoutInterval4.getSubInterval(n2)).isEmptySpace() || !LayoutUtils.contentOverlap(this.addingSpace, layoutInterval2, this.dimension ^ 1)); n2 += n3) {
        }
        int n5 = n2 >= 0 && n2 < n4 ? layoutInterval4.getSubInterval((int)n2).getCurrentSpace().positions[this.dimension][n ^ 1] : layoutInterval4.getParent().getCurrentSpace().positions[this.dimension][n];
        this.operations.parallelizeWithParentSequence(layoutInterval, n2 -= n3, this.dimension);
        layoutInterval3 = layoutInterval.getParent();
        layoutInterval3.getCurrentSpace().positions[this.dimension][n] = n5;
        return layoutInterval3;
    }

    private void accommodateOutPosition(LayoutInterval layoutInterval, int n) {
        if (n == 2 || n == 3) {
            return;
        }
        int n2 = layoutInterval.getCurrentSpace().positions[this.dimension][n];
        assert (n2 != Integer.MIN_VALUE);
        int n3 = Integer.MIN_VALUE;
        int n4 = n == 0 ? -1 : 1;
        int[] nArray = null;
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        LayoutInterval layoutInterval3 = null;
        do {
            Object object;
            if (layoutInterval2.isSequential()) {
                if (n3 > 0) {
                    int n5 = this.accommodateSizeInSequence(layoutInterval, layoutInterval3, n3, n);
                    n3 -= n5;
                    if (nArray != null) {
                        int n6 = n;
                        nArray[n6] = nArray[n6] + n5 * n4;
                    }
                }
                if ((object = LayoutInterval.getDirectNeighbor(layoutInterval, n, false)) != null && (!((LayoutInterval)object).isEmptySpace() || LayoutInterval.canResize((LayoutInterval)object))) {
                    return;
                }
                layoutInterval3 = layoutInterval;
            } else {
                nArray = layoutInterval2.getCurrentSpace().positions[this.dimension];
                if (nArray[n] != Integer.MIN_VALUE) {
                    n3 = (n2 - nArray[n]) * n4;
                    if (n3 > 0) {
                        object = layoutInterval.getCurrentSpace().positions[this.dimension];
                        if (!layoutInterval.getCurrentSpace().isSet(this.dimension) || object[n] * n4 < nArray[n] * n4) {
                            object[n] = nArray[n];
                        }
                    }
                } else {
                    nArray = null;
                }
                if (!layoutInterval.isSequential()) {
                    layoutInterval3 = layoutInterval;
                }
            }
            layoutInterval = layoutInterval2;
            layoutInterval2 = layoutInterval.getParent();
        } while ((n3 > 0 || n3 == Integer.MIN_VALUE) && layoutInterval2 != null && (!layoutInterval2.isParallel() || layoutInterval.getAlignment() != n));
    }

    private int accommodateSizeInSequence(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2) {
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        assert (layoutInterval3.isSequential());
        LayoutRegion layoutRegion = layoutInterval2.getCurrentSpace();
        int n3 = n;
        int n4 = layoutInterval.getCurrentSpace().positions[this.dimension][n2];
        int n5 = layoutInterval3.getParent().getCurrentSpace().positions[this.dimension][n2];
        boolean bl = false;
        int n6 = n2 == 0 ? -1 : 1;
        int n7 = layoutInterval3.indexOf(layoutInterval);
        int n8 = layoutInterval2.isComponent() ? n7 : -1;
        int n9 = layoutInterval3.getSubIntervalCount();
        for (int i = n7 + n6; i >= 0 && i < n9; i += n6) {
            int n10;
            LayoutInterval layoutInterval4 = layoutInterval3.getSubInterval(i);
            if (n8 != -1) {
                n10 = Integer.MIN_VALUE;
                if (!layoutInterval4.isEmptySpace()) {
                    if (LayoutUtils.contentOverlap(layoutRegion, layoutInterval4, this.dimension ^ 1)) {
                        if (n8 != n7) {
                            n8 = i - n6;
                            n10 = layoutInterval4.getCurrentSpace().positions[this.dimension][n2 ^ 1];
                        } else {
                            n8 = -1;
                        }
                    } else {
                        n8 = i;
                        if (!bl && LayoutUtils.contentOverlap(layoutRegion, layoutInterval4, this.dimension)) {
                            bl = true;
                        }
                    }
                }
                if ((i == 0 || i + n6 == n9) && n10 == Integer.MIN_VALUE && n8 != -1) {
                    if (n8 != n7 && (bl || this.dimension == 0)) {
                        n8 = i;
                        n10 = n5;
                    } else {
                        n8 = -1;
                    }
                }
                if (n10 != Integer.MIN_VALUE) {
                    LayoutInterval layoutInterval5 = layoutInterval2.getParent().isSequential() ? layoutInterval2.getParent() : layoutInterval2;
                    LayoutInterval layoutInterval6 = LayoutInterval.getDirectNeighbor(layoutInterval2, n2, false);
                    if (layoutInterval6 == null && !LayoutInterval.isAlignedAtBorder(layoutInterval5, n2)) {
                        layoutInterval6 = new LayoutInterval(101);
                        if (!layoutInterval5.isSequential()) {
                            layoutInterval5 = new LayoutInterval(102);
                            this.layoutModel.addInterval(layoutInterval5, layoutInterval2.getParent(), this.layoutModel.removeInterval(layoutInterval2));
                            this.layoutModel.setIntervalAlignment(layoutInterval5, layoutInterval2.getRawAlignment());
                            this.layoutModel.setIntervalAlignment(layoutInterval2, -1);
                            this.layoutModel.addInterval(layoutInterval2, layoutInterval5, 0);
                        }
                        this.layoutModel.addInterval(layoutInterval6, layoutInterval5, n2 == 0 ? 0 : -1);
                    } else assert (layoutInterval6 == null || layoutInterval6.isEmptySpace());
                    this.operations.parallelizeWithParentSequence(layoutInterval5, n8, this.dimension);
                    if (n2 == 1) {
                        i -= n9 - layoutInterval3.getSubIntervalCount();
                    }
                    n9 = layoutInterval3.getSubIntervalCount();
                    n8 = -1;
                    if ((n3 -= Math.abs(n10 - n4)) >= 0) continue;
                    n3 = 0;
                    continue;
                }
                if (n8 != -1) continue;
                i = n7;
                continue;
            }
            if (layoutInterval4.isEmptySpace() && layoutInterval4.getPreferredSize() != -1) {
                n10 = this.determinePadding(layoutInterval, this.dimension, n2);
                int n11 = LayoutInterval.getIntervalCurrentSize(layoutInterval4, this.dimension);
                int n12 = n11 - n3;
                if (n12 <= n10) {
                    n12 = -1;
                    n3 -= n11 - n10;
                } else {
                    n3 = 0;
                }
                this.operations.resizeInterval(layoutInterval4, n12);
                if (!LayoutInterval.wantResize(layoutInterval4) || !LayoutInterval.wantResize(layoutInterval)) break;
                this.layoutModel.setIntervalSize(layoutInterval4, layoutInterval4.getMinimumSize(), layoutInterval4.getPreferredSize(), -2);
                break;
            }
            layoutInterval = layoutInterval4;
        }
        return n - n3;
    }

    private LayoutInterval alignInParallel(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        LayoutInterval layoutInterval3;
        int n2;
        LayoutInterval layoutInterval4;
        LayoutInterval layoutInterval5;
        LayoutInterval layoutInterval6;
        int n3;
        LayoutInterval layoutInterval7;
        assert (n == 0 || n == 1);
        if (layoutInterval2.isParentOf(layoutInterval) || layoutInterval.isParentOf(layoutInterval2)) {
            return null;
        }
        LayoutInterval layoutInterval8 = LayoutInterval.getCommonParent(layoutInterval, layoutInterval2);
        if (layoutInterval8 == null || layoutInterval8.isSequential()) {
            return null;
        }
        boolean bl = LayoutInterval.wantResize(layoutInterval);
        LayoutInterval layoutInterval9 = layoutInterval;
        LayoutInterval layoutInterval10 = LayoutInterval.getFirstParent(layoutInterval, 103);
        while (!layoutInterval10.isParentOf(layoutInterval2)) {
            if (LayoutInterval.isAlignedAtBorder(layoutInterval9, layoutInterval10, n)) {
                if (bl && !LayoutInterval.canResize(layoutInterval10)) {
                    this.operations.enableGroupResizing(layoutInterval10);
                }
                layoutInterval9 = layoutInterval10;
                layoutInterval10 = LayoutInterval.getFirstParent(layoutInterval9, 103);
            } else {
                layoutInterval10 = null;
            }
            if (layoutInterval10 != null) continue;
            return null;
        }
        boolean bl2 = this.dragger.isResizing(this.dimension);
        LayoutInterval layoutInterval11 = layoutInterval9;
        while (layoutInterval11.getParent() != layoutInterval10) {
            layoutInterval11 = layoutInterval11.getParent();
        }
        int n4 = layoutInterval10.remove(layoutInterval11);
        boolean bl3 = false;
        do {
            if ((layoutInterval7 = LayoutInterval.getFirstParent(layoutInterval2, 103)) == null) {
                return null;
            }
            if (!LayoutFeeder.canSubstAlignWithParent(layoutInterval2, this.dimension, n, bl2)) continue;
            if (layoutInterval7 == layoutInterval10) {
                bl3 = true;
                continue;
            }
            layoutInterval2 = layoutInterval7;
        } while (layoutInterval2 == layoutInterval7);
        layoutInterval10.add(layoutInterval11, n4);
        if (layoutInterval7 != layoutInterval10) {
            return null;
        }
        if (layoutInterval9 != layoutInterval) {
            if (!LayoutInterval.isAlignedAtBorder(layoutInterval2, n) && (n3 = LayoutRegion.distance(layoutInterval9.getCurrentSpace(), layoutInterval2.getCurrentSpace(), this.dimension, n, n) * (n == 1 ? -1 : 1)) > 0) {
                layoutInterval11 = layoutInterval;
                while (layoutInterval11.getParent() != layoutInterval9) {
                    layoutInterval11 = layoutInterval11.getParent();
                }
                n4 = layoutInterval9.remove(layoutInterval11);
                this.operations.cutStartingGap(layoutInterval9, n3, this.dimension, n);
                layoutInterval9.add(layoutInterval11, n4);
            }
            this.optimizeStructure = true;
        }
        n3 = LayoutInterval.getEffectiveAlignment(layoutInterval2, n);
        ArrayList<LayoutInterval> arrayList = new ArrayList<LayoutInterval>(2);
        ArrayList arrayList2 = new ArrayList(2);
        int n5 = layoutInterval10.getSubIntervalCount();
        int n6 = this.extract(layoutInterval2, arrayList, arrayList2, n);
        this.extract(layoutInterval9, arrayList, arrayList2, n);
        assert (!bl3 || arrayList2.isEmpty());
        int n7 = LayoutRegion.distance(layoutInterval2.getCurrentSpace(), layoutInterval.getCurrentSpace(), this.dimension, n, n);
        assert (n7 == 0 || n == 0);
        if (n7 != 0) {
            layoutInterval6 = new LayoutInterval(101);
            layoutInterval6.setSize(Math.abs(n7));
            layoutInterval5 = layoutInterval.getParent();
            if (layoutInterval5 == null || !layoutInterval5.isSequential()) {
                layoutInterval4 = new LayoutInterval(102);
                if (layoutInterval5 != null) {
                    this.layoutModel.addInterval(layoutInterval4, layoutInterval5, this.layoutModel.removeInterval(layoutInterval));
                }
                this.layoutModel.setIntervalAlignment(layoutInterval, -1);
                this.layoutModel.addInterval(layoutInterval, layoutInterval4, 0);
                layoutInterval5 = layoutInterval4;
            }
            this.layoutModel.addInterval(layoutInterval6, layoutInterval5, n == 0 ? 0 : -1);
            if (layoutInterval == layoutInterval9) {
                arrayList.set(arrayList.size() - 1, layoutInterval5);
            }
        }
        if (bl3 || n5 == 2 && layoutInterval10.getParent() != null) {
            layoutInterval6 = layoutInterval10;
            if (!arrayList2.isEmpty()) {
                layoutInterval4 = layoutInterval6.getParent();
                if (layoutInterval4.isSequential()) {
                    layoutInterval5 = layoutInterval4;
                } else {
                    n2 = this.layoutModel.removeInterval(layoutInterval6);
                    layoutInterval5 = new LayoutInterval(102);
                    layoutInterval5.setAlignment(layoutInterval6.getAlignment());
                    this.layoutModel.addInterval(layoutInterval5, layoutInterval4, n2);
                    this.layoutModel.setIntervalAlignment(layoutInterval6, -1);
                    this.layoutModel.addInterval(layoutInterval6, layoutInterval5, -1);
                }
            } else {
                layoutInterval5 = null;
            }
        } else {
            layoutInterval6 = new LayoutInterval(103);
            layoutInterval6.setGroupAlignment(n);
            if (!arrayList2.isEmpty()) {
                layoutInterval5 = new LayoutInterval(102);
                layoutInterval5.add(layoutInterval6, 0);
                if (n3 == 0 || n3 == 1) {
                    layoutInterval5.setAlignment(n3);
                }
                this.layoutModel.addInterval(layoutInterval5, layoutInterval10, -1);
            } else {
                layoutInterval5 = null;
                if (n3 == 0 || n3 == 1) {
                    layoutInterval6.setAlignment(n3);
                }
                this.layoutModel.addInterval(layoutInterval6, layoutInterval10, -1);
            }
            if (n == 0 || n == 1) {
                int n8 = layoutInterval2.getCurrentSpace().positions[this.dimension][n];
                n2 = layoutInterval10.getCurrentSpace().positions[this.dimension][n ^ 1];
                layoutInterval6.getCurrentSpace().set(this.dimension, n == 0 ? n8 : n2, n == 0 ? n2 : n8);
            }
        }
        LayoutInterval layoutInterval12 = (LayoutInterval)arrayList.get(1);
        if (layoutInterval12.getParent() != layoutInterval6) {
            if (layoutInterval12.getParent() != null) {
                this.layoutModel.removeInterval(layoutInterval12);
            }
            this.layoutModel.addInterval(layoutInterval12, layoutInterval6, -1);
        }
        if (!LayoutInterval.isAlignedAtBorder(layoutInterval12, n)) {
            this.layoutModel.setIntervalAlignment(layoutInterval12, n);
        }
        if ((layoutInterval3 = (LayoutInterval)arrayList.get(0)).getParent() != layoutInterval6) {
            if (layoutInterval3.getParent() != null) {
                this.layoutModel.setIntervalAlignment(layoutInterval3, n6);
                this.layoutModel.removeInterval(layoutInterval3);
            }
            this.layoutModel.addInterval(layoutInterval3, layoutInterval6, -1);
        }
        if (!(bl2 || layoutInterval6.getSubIntervalCount() != 2 || LayoutInterval.isAlignedAtBorder(layoutInterval3, n) || LayoutInterval.isAlignedAtBorder(layoutInterval12, n ^ 1))) {
            this.layoutModel.setIntervalAlignment(layoutInterval3, n);
        }
        if (!arrayList2.isEmpty()) {
            LayoutInterval layoutInterval13;
            int n9 = layoutInterval5.indexOf(layoutInterval6);
            if (n == 1) {
                ++n9;
            }
            if ((layoutInterval13 = this.operations.addGroupContent(arrayList2, layoutInterval5, n9, this.dimension, n)) != null) {
                int n10 = layoutInterval10.getCurrentSpace().positions[this.dimension][n];
                int n11 = layoutInterval2.getCurrentSpace().positions[this.dimension][n];
                layoutInterval13.getCurrentSpace().set(this.dimension, n == 0 ? n10 : n11, n == 0 ? n11 : n10);
                this.operations.optimizeGaps(layoutInterval13, this.dimension);
                this.operations.mergeParallelGroups(layoutInterval13);
            }
        }
        return layoutInterval6;
    }

    private int extract(LayoutInterval layoutInterval, List list, List list2, int n) {
        int n2 = LayoutInterval.getEffectiveAlignment(layoutInterval, n);
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        if (layoutInterval2.isSequential()) {
            int n3 = this.operations.extract(layoutInterval, n, false, n == 0 ? list2 : null, n == 0 ? null : list2);
            if (n3 == 1) {
                if (n2 == 0 || n2 == 1) {
                    this.layoutModel.setIntervalAlignment(layoutInterval, n2);
                }
                this.layoutModel.removeInterval(layoutInterval2);
                list.add(layoutInterval);
            } else {
                list.add(layoutInterval2);
            }
        } else {
            list.add(layoutInterval);
        }
        return n2;
    }

    private void checkParallelResizing(LayoutInterval layoutInterval, IncludeDesc includeDesc, IncludeDesc includeDesc2) {
        LayoutConstants layoutConstants;
        Object object;
        LayoutInterval layoutInterval2;
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        if (layoutInterval3.isSequential()) {
            layoutInterval2 = layoutInterval3;
            layoutInterval3 = layoutInterval3.getParent();
        } else {
            layoutInterval2 = layoutInterval;
        }
        if (layoutInterval3.getParent() == null) {
            return;
        }
        int n = -1;
        if (includeDesc.snappedNextTo != null && includeDesc.snappedNextTo.getParent() == null) {
            n = includeDesc.alignment;
        }
        if (includeDesc2 != null && includeDesc2.snappedNextTo != null && includeDesc2.snappedNextTo.getParent() == null) {
            int n2 = n = n == -1 ? includeDesc2.alignment : Integer.MAX_VALUE;
        }
        if (n == 0 || n == 1) {
            int n3 = layoutInterval3.remove(layoutInterval2);
            object = LayoutInterval.getNeighbor(layoutInterval3, n ^ 1, false, true, true);
            if (object != null && ((LayoutInterval)object).getPreferredSize() == -1 && LayoutInterval.isAlignedAtBorder(((LayoutInterval)object).getParent(), LayoutInterval.getRoot((LayoutInterval)object), n ^ 1) || object == null && LayoutInterval.isAlignedAtBorder(layoutInterval3, LayoutInterval.getRoot(layoutInterval3), n ^ 1)) {
                n = Integer.MAX_VALUE;
            }
            layoutInterval3.add(layoutInterval2, n3);
        }
        if (n == Integer.MAX_VALUE) {
            return;
        }
        LayoutInterval layoutInterval4 = null;
        if (layoutInterval != layoutInterval2) {
            assert (layoutInterval2.isSequential());
            for (int i = 0; i <= 1; ++i) {
                layoutConstants = LayoutInterval.getDirectNeighbor(layoutInterval, i, false);
                if (layoutConstants == null || !((LayoutInterval)layoutConstants).isEmptySpace() || !LayoutInterval.canResize((LayoutInterval)layoutConstants)) continue;
                layoutInterval4 = layoutConstants;
                break;
            }
        }
        if (LayoutInterval.wantResize(layoutInterval) ? !this.dragger.isResizing(this.dimension) : layoutInterval4 == null) {
            return;
        }
        if (!LayoutInterval.canResize(layoutInterval3) && (includeDesc.snappedNextTo != null && !layoutInterval3.isParentOf(includeDesc.snappedNextTo) || includeDesc2 != null && includeDesc2.snappedNextTo != null && !layoutInterval3.isParentOf(includeDesc2.snappedNextTo))) {
            this.operations.enableGroupResizing(layoutInterval3);
        }
        if (LayoutInterval.canResize(layoutInterval3) && layoutInterval3.getParent() != null) {
            boolean bl = false;
            boolean bl2 = false;
            Iterator iterator = layoutInterval3.getSubIntervals();
            while (iterator.hasNext()) {
                int n4;
                LayoutInterval layoutInterval5 = (LayoutInterval)iterator.next();
                if (layoutInterval5 == layoutInterval2) continue;
                if (LayoutInterval.wantResize(layoutInterval5)) {
                    bl = true;
                    break;
                }
                if (bl2 || (n4 = layoutInterval5.getAlignment()) != 0 && n4 != 1) continue;
                bl2 = this.getExpectedBorderPosition(layoutInterval2, this.dimension, n4 ^ 1) == this.getExpectedBorderPosition(layoutInterval5, this.dimension, n4 ^ 1);
            }
            if (!bl && bl2) {
                this.operations.suppressGroupResizing(layoutInterval3);
            }
        }
        if (!LayoutInterval.canResize(layoutInterval3)) {
            this.layoutModel.changeIntervalAttribute(layoutInterval2, 1, true);
            if (layoutInterval4 != null) {
                this.layoutModel.setIntervalSize(layoutInterval4, -1, -1, Short.MAX_VALUE);
            } else if (layoutInterval.isComponent()) {
                int n5;
                layoutConstants = layoutInterval.getComponent();
                object = ((LayoutComponent)layoutConstants).isLayoutContainer() ? this.operations.getMapper().getComponentMinimumSize(((LayoutComponent)layoutConstants).getId()) : this.operations.getMapper().getComponentPreferredSize(((LayoutComponent)layoutConstants).getId());
                int n6 = n5 = this.dimension == 0 ? ((Dimension)object).width : ((Dimension)object).height;
                if (layoutInterval.getPreferredSize() < n5) {
                    this.layoutModel.setIntervalSize(layoutInterval, 0, 0, layoutInterval.getMaximumSize());
                } else {
                    this.layoutModel.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize() != -2 ? layoutInterval.getMinimumSize() : -1, -1, layoutInterval.getMaximumSize());
                }
            }
        }
        if (layoutInterval.isComponent() && layoutInterval4 == null && (layoutInterval2 == layoutInterval || LayoutInterval.getCount(layoutInterval2, -1, true) == 1)) {
            this.setParallelSameSize(layoutInterval3, layoutInterval2, this.dimension);
        }
    }

    private void setParallelSameSize(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        LayoutInterval layoutInterval3 = LayoutFeeder.getOneNonEmpty(layoutInterval2);
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval4 = (LayoutInterval)iterator.next();
            if (layoutInterval4 == layoutInterval2) continue;
            if (layoutInterval4.isParallel()) {
                this.setParallelSameSize(layoutInterval4, layoutInterval3, n);
                continue;
            }
            LayoutInterval layoutInterval5 = LayoutFeeder.getOneNonEmpty(layoutInterval4);
            if (layoutInterval5 == null || !LayoutRegion.sameSpace(layoutInterval3.getCurrentSpace(), layoutInterval5.getCurrentSpace(), n) || LayoutInterval.wantResize(layoutInterval4)) continue;
            if (layoutInterval5.isParallel()) {
                this.setParallelSameSize(layoutInterval5, layoutInterval3, n);
                continue;
            }
            this.layoutModel.setIntervalAlignment(layoutInterval4, layoutInterval2.getAlignment());
            int n2 = layoutInterval5.getMinimumSize();
            this.layoutModel.setIntervalSize(layoutInterval5, n2 != -2 ? n2 : -1, layoutInterval5.getPreferredSize(), Short.MAX_VALUE);
            this.layoutModel.changeIntervalAttribute(layoutInterval5, 1, true);
        }
    }

    private static LayoutInterval getOneNonEmpty(LayoutInterval layoutInterval) {
        if (!layoutInterval.isSequential()) {
            return layoutInterval;
        }
        LayoutInterval layoutInterval2 = null;
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval3 = (LayoutInterval)iterator.next();
            if (layoutInterval3.isEmptySpace()) continue;
            if (layoutInterval2 == null) {
                layoutInterval2 = layoutInterval3;
                continue;
            }
            return null;
        }
        return layoutInterval2;
    }

    private int getExpectedBorderPosition(LayoutInterval layoutInterval, int n, int n2) {
        LayoutInterval layoutInterval2 = LayoutUtils.getOutermostComponent(layoutInterval, n, n2);
        int n3 = layoutInterval2.getCurrentSpace().positions[n][n2];
        LayoutInterval layoutInterval3 = LayoutInterval.getNeighbor(layoutInterval2, n2, false, true, false);
        if (layoutInterval3 != null && layoutInterval3.isEmptySpace() && layoutInterval.isParentOf(layoutInterval3)) {
            int n4 = layoutInterval3.getPreferredSize();
            if (n4 == -1) {
                n4 = LayoutUtils.getSizeOfDefaultGap(layoutInterval3, this.operations.getMapper());
            }
            if (n2 == 0) {
                n4 *= -1;
            }
            n3 += n4;
        }
        return n3;
    }

    private int determinePadding(LayoutInterval layoutInterval, int n, int n2) {
        LayoutInterval layoutInterval2 = LayoutInterval.getNeighbor(layoutInterval, n2, true, true, false);
        return this.dragger.findPadding(layoutInterval2, layoutInterval, n, n2);
    }

    private int determineExpectingPadding(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, LayoutInterval layoutInterval3, int n) {
        if (layoutInterval2 == null) {
            layoutInterval2 = LayoutInterval.getNeighbor(layoutInterval3, 102, n);
        }
        return this.dragger.findPadding(layoutInterval2, layoutInterval, this.dimension, n);
    }

    private void analyzeParallel(LayoutInterval layoutInterval, List list) {
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            int n;
            Object object;
            IncludeDesc includeDesc;
            boolean bl;
            LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
            if (layoutInterval2.isEmptySpace()) continue;
            LayoutRegion layoutRegion = layoutInterval2.getCurrentSpace();
            if (layoutInterval2.isParallel() && LayoutFeeder.pointInside(this.addingSpace, this.aEdge, layoutInterval2, this.dimension) && this.shouldEnterGroup(layoutInterval2)) {
                this.analyzeParallel(layoutInterval2, list);
                continue;
            }
            if (layoutInterval2.isSequential()) {
                this.analyzeSequential(layoutInterval2, list);
                continue;
            }
            if (!this.orthogonalOverlap(layoutInterval2) || (bl = LayoutRegion.overlap(this.addingSpace, layoutRegion, this.dimension, 0)) && !this.solveOverlap && ((includeDesc = this.originalPositions1[this.dimension]) == null || (this.aEdge ^ 1) != includeDesc.alignment || includeDesc.parent != layoutInterval2 && !layoutInterval2.isParentOf(includeDesc.parent))) continue;
            if (bl) {
                this.imposeSize = true;
            }
            int n2 = Integer.MIN_VALUE;
            if (this.aSnappedNextTo != null && (layoutInterval2 == this.aSnappedNextTo || layoutInterval2.isParentOf(this.aSnappedNextTo) || this.aSnappedNextTo.getParent() == null || (object = LayoutInterval.getNeighbor(layoutInterval2, this.aEdge, true, true, false)) == this.aSnappedNextTo || object != null && ((LayoutInterval)object).isParentOf(this.aSnappedNextTo))) {
                n2 = -1;
            }
            if (n2 != -1) {
                if (!bl) {
                    int n3 = LayoutRegion.distance(layoutRegion, this.addingSpace, this.dimension, 1, 0);
                    n = LayoutRegion.distance(this.addingSpace, layoutRegion, this.dimension, 1, 0);
                    n2 = n3 >= 0 ? n3 : n;
                } else {
                    n2 = 0;
                }
            }
            if ((object = this.addInclusion(layoutInterval, false, n2, 0, list)) == null) continue;
            ((IncludeDesc)object).neighbor = layoutInterval2;
            n = this.aEdge < 0 ? 2 : this.aEdge;
            ((IncludeDesc)object).index = LayoutFeeder.getAddDirection(this.addingSpace, layoutRegion, this.dimension, n) == 0 ? 0 : 1;
        }
        if (list.isEmpty() && layoutInterval.getParent() == null && (this.aSnappedParallel == null || this.canAlignWith(this.aSnappedParallel, layoutInterval, this.aEdge))) {
            int n = this.aSnappedNextTo == layoutInterval ? -1 : Integer.MAX_VALUE;
            this.addInclusion(layoutInterval, false, n, Integer.MAX_VALUE, list);
        }
    }

    private void analyzeSequential(LayoutInterval layoutInterval, List list) {
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = layoutInterval.getSubIntervalCount();
        for (int i = 0; i < n4; ++i) {
            int n5;
            LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(i);
            if (layoutInterval2.isEmptySpace()) {
                if (n != i) continue;
                ++n;
                continue;
            }
            LayoutRegion layoutRegion = layoutInterval2.getCurrentSpace();
            if (layoutInterval2.isParallel() && LayoutFeeder.pointInside(this.addingSpace, this.aEdge, layoutInterval2, this.dimension) && this.shouldEnterGroup(layoutInterval2)) {
                n5 = list.size();
                this.analyzeParallel(layoutInterval2, list);
                if (list.size() > n5) {
                    return;
                }
            }
            n5 = this.orthogonalOverlap(layoutInterval2);
            int n6 = this.dimension == 1 && n5 == 0 ? 4 : 0;
            boolean bl3 = LayoutRegion.overlap(this.addingSpace, layoutRegion, this.dimension, n6);
            if (n5 != 0 || this.dimension == 1 && !bl3 && !bl2) {
                int n7;
                if (bl3) {
                    IncludeDesc includeDesc;
                    if (!this.solveOverlap && ((includeDesc = this.originalPositions1[this.dimension]) == null || (this.aEdge ^ 1) != includeDesc.alignment || includeDesc.parent != layoutInterval2 && !layoutInterval2.isParentOf(includeDesc.parent))) {
                        return;
                    }
                    if (n5 != 0) {
                        this.imposeSize = true;
                    }
                    bl = true;
                    n3 = 0;
                    n2 = 0;
                } else {
                    n7 = LayoutRegion.distance(layoutRegion, this.addingSpace, this.dimension, 1, 0);
                    int n8 = LayoutRegion.distance(this.addingSpace, layoutRegion, this.dimension, 1, 0);
                    if (n7 >= 0 && n7 < n2) {
                        n2 = n7;
                    }
                    if (n8 >= 0 && n8 < n2) {
                        n2 = n8;
                    }
                    if (n5 != 0) {
                        n3 = 0;
                        bl = true;
                    } else {
                        n7 = LayoutRegion.distance(layoutRegion, this.addingSpace, this.dimension ^ 1, 1, 0);
                        n8 = LayoutRegion.distance(this.addingSpace, layoutRegion, this.dimension ^ 1, 1, 0);
                        if (n7 > 0 && n7 < n3) {
                            n3 = n7;
                        }
                        if (n8 > 0 && n8 < n3) {
                            n3 = n8;
                        }
                    }
                }
                int n9 = n7 = this.aEdge < 0 ? 2 : this.aEdge;
                if (LayoutFeeder.getAddDirection(this.addingSpace, layoutRegion, this.dimension, n7) == 0) {
                    if (this.aEdge == 0) break;
                    n = i;
                    break;
                }
                bl2 = false;
                if (this.aEdge != 0) continue;
                n = i + 1;
                continue;
            }
            bl2 = true;
        }
        if (bl || this.dimension == 1 && !bl2) {
            IncludeDesc includeDesc;
            if (this.aSnappedNextTo != null && (layoutInterval.isParentOf(this.aSnappedNextTo) || this.aSnappedNextTo.getParent() == null)) {
                n2 = -1;
            }
            if ((includeDesc = this.addInclusion(layoutInterval, bl2, n2, n3, list)) != null) {
                if (n == -1) {
                    n = this.aEdge == 0 ? 0 : layoutInterval.getSubIntervalCount();
                }
                includeDesc.index = n;
            }
        }
    }

    private static boolean pointInside(LayoutRegion layoutRegion, int n, LayoutInterval layoutInterval, int n2) {
        LayoutRegion layoutRegion2 = layoutInterval.getCurrentSpace();
        if (n != -1) {
            return LayoutRegion.pointInside(layoutRegion, n, layoutRegion2, n2);
        }
        boolean bl = LayoutRegion.pointInside(layoutRegion, 0, layoutRegion2, n2);
        boolean bl2 = LayoutRegion.pointInside(layoutRegion, 1, layoutRegion2, n2);
        return bl && bl2 || bl && !LayoutInterval.isClosedGroup(layoutInterval, 1) || bl2 && !LayoutInterval.isClosedGroup(layoutInterval, 0);
    }

    private boolean orthogonalOverlap(LayoutInterval layoutInterval) {
        boolean bl;
        if (this.solveOverlap || !LayoutUtils.isOverlapPreventedInOtherDimension(this.addingInterval, layoutInterval, this.dimension)) {
            bl = LayoutUtils.contentOverlap(this.addingSpace, layoutInterval, this.dimension ^ 1);
            if (bl && this.dragger.isResizing(this.dimension) && !this.dragger.isResizing(this.dimension ^ 1) && this.originalPositions1[this.dimension] != null) {
                IncludeDesc includeDesc = this.originalPositions1[this.dimension];
                LayoutInterval layoutInterval2 = includeDesc.parent;
                if (layoutInterval2.isParentOf(layoutInterval)) {
                    if (layoutInterval2.isParallel() && (includeDesc.neighbor == null || includeDesc.neighbor != layoutInterval && !includeDesc.neighbor.isParentOf(layoutInterval))) {
                        bl = false;
                    }
                } else if (layoutInterval2 == layoutInterval) {
                    if (layoutInterval2.isParallel() && includeDesc.neighbor == null) {
                        bl = false;
                    }
                } else if (!layoutInterval.isParentOf(layoutInterval2) && (layoutInterval2 = LayoutInterval.getCommonParent(layoutInterval2, layoutInterval)) != null && layoutInterval2.isParallel()) {
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private IncludeDesc addInclusion(LayoutInterval layoutInterval, boolean bl, int n, int n2, List list) {
        if (!list.isEmpty()) {
            boolean bl2;
            int n3 = list.size() - 1;
            IncludeDesc includeDesc = (IncludeDesc)list.get(n3);
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = includeDesc.ortDistance == 0;
            boolean bl6 = bl2 = n2 == 0;
            if (bl5 != bl2) {
                bl3 = bl5;
                bl4 = bl2;
            } else if (bl5) {
                bl4 = true;
                bl3 = true;
            } else if (includeDesc.ortDistance != n2) {
                bl3 = includeDesc.ortDistance < n2;
                bl4 = n2 < includeDesc.ortDistance;
            } else if (includeDesc.distance != n) {
                bl3 = includeDesc.distance < n;
                boolean bl7 = bl4 = n < includeDesc.distance;
            }
            if (!bl3 && !bl4) {
                LayoutInterval layoutInterval2 = includeDesc.parent.isParallel() ? includeDesc.parent : includeDesc.parent.getParent();
                bl4 = layoutInterval2.isParentOf(layoutInterval);
                boolean bl8 = bl3 = !bl4;
            }
            if (!bl3) {
                list.remove(n3);
            }
            if (!bl4) {
                return null;
            }
        }
        IncludeDesc includeDesc = new IncludeDesc();
        includeDesc.parent = layoutInterval;
        includeDesc.newSubGroup = bl;
        includeDesc.alignment = this.aEdge;
        includeDesc.snappedParallel = this.aSnappedParallel;
        if (n == -1) {
            includeDesc.snappedNextTo = this.aSnappedNextTo;
            includeDesc.fixedPosition = true;
        }
        includeDesc.distance = n;
        includeDesc.ortDistance = n2;
        list.add(includeDesc);
        return includeDesc;
    }

    private IncludeDesc addAligningInclusion(List list) {
        if (this.aSnappedParallel == null) {
            return null;
        }
        boolean bl = false;
        for (IncludeDesc includeDesc : list) {
            if (!this.canAlignWith(this.aSnappedParallel, includeDesc.parent, this.aEdge)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            IncludeDesc includeDesc = new IncludeDesc();
            includeDesc.parent = this.aSnappedParallel.getParent() != null ? LayoutInterval.getFirstParent(this.aSnappedParallel, 103) : this.aSnappedParallel;
            includeDesc.snappedParallel = this.aSnappedParallel;
            includeDesc.alignment = this.aEdge;
            list.add(0, includeDesc);
            return includeDesc;
        }
        return null;
    }

    private void mergeParallelInclusions(List list, IncludeDesc includeDesc, boolean bl) {
        LayoutInterval layoutInterval;
        int n;
        int n2;
        LayoutInterval layoutInterval2;
        LayoutInterval layoutInterval3;
        Object object;
        Object object2;
        Object object32;
        Object object4;
        Object object5;
        Object object62;
        Object object7 = null;
        boolean bl2 = false;
        for (Object object62 : list) {
            if (includeDesc != null && bl && !this.canCombine((IncludeDesc)object62, includeDesc)) continue;
            if (object7 != null) {
                boolean bl3;
                boolean bl4 = bl3 = includeDesc != null && !bl && ((IncludeDesc)object62).parent == includeDesc.parent;
                if (!bl2 && bl3) {
                    object7 = object62;
                    bl2 = true;
                    continue;
                }
                if (bl2 != bl3) continue;
                object5 = ((IncludeDesc)object7).parent.isSequential() ? ((IncludeDesc)object7).parent.getParent() : ((IncludeDesc)object7).parent;
                Object object8 = object4 = ((IncludeDesc)object62).parent.isSequential() ? ((IncludeDesc)object62).parent.getParent() : ((IncludeDesc)object62).parent;
                if (((LayoutInterval)object5).isParentOf((LayoutInterval)object4)) {
                    object7 = object62;
                    continue;
                }
                if (((LayoutInterval)object4).isParentOf((LayoutInterval)object5) || ((IncludeDesc)object62).distance >= ((IncludeDesc)object7).distance) continue;
                object7 = object62;
                continue;
            }
            object7 = object62;
            bl2 = includeDesc != null && !bl && ((IncludeDesc)object62).parent == includeDesc.parent;
        }
        if (object7 == null) {
            assert (bl);
            list.clear();
            list.add(includeDesc);
            return;
        }
        Object object9 = ((IncludeDesc)object7).parent.isSequential() ? ((IncludeDesc)object7).parent.getParent() : ((IncludeDesc)object7).parent;
        object62 = list.iterator();
        while (object62.hasNext()) {
            IncludeDesc includeDesc2 = (IncludeDesc)object62.next();
            if (includeDesc2 == object7) continue;
            if (!LayoutFeeder.compatibleInclusions(includeDesc2, (IncludeDesc)object7, this.dimension)) {
                object62.remove();
                continue;
            }
            object5 = includeDesc2.parent.isSequential() ? includeDesc2.parent.getParent() : includeDesc2.parent;
            if (!((LayoutInterval)object5).isParentOf((LayoutInterval)object9)) continue;
            object4 = includeDesc2.parent.isSequential() ? includeDesc2.parent : includeDesc2.neighbor;
            this.layoutModel.removeInterval((LayoutInterval)object4);
            this.layoutModel.addInterval((LayoutInterval)object4, (LayoutInterval)object9, -1);
            if (((LayoutInterval)object5).getSubIntervalCount() == 1) {
                LayoutInterval layoutInterval4 = ((LayoutInterval)object5).getParent();
                object32 = this.layoutModel.removeInterval((LayoutInterval)object5, 0);
                this.operations.addContent((LayoutInterval)object32, layoutInterval4, this.layoutModel.removeInterval((LayoutInterval)object5));
                if (object9 == object32 && ((LayoutInterval)object9).getParent() == null) {
                    object9 = layoutInterval4;
                }
                this.updateReplacedOriginalGroup((LayoutInterval)object9, null);
            }
            if (includeDesc2.parent != object5) continue;
            includeDesc2.parent = object9;
        }
        if (((IncludeDesc)object7).parent.isParallel() && ((IncludeDesc)object7).snappedParallel != null && ((IncludeDesc)object7).ortDistance != 0 && list.size() > 1) {
            list.remove(object7);
        }
        if (list.size() == 1) {
            return;
        }
        object62 = null;
        LayoutInterval layoutInterval5 = null;
        object5 = new LinkedList();
        object4 = new LinkedList();
        for (Object object32 : list) {
            if (!((IncludeDesc)object32).parent.isSequential() || !((IncludeDesc)object32).newSubGroup) continue;
            object2 = this.extractParallelSequence(((IncludeDesc)object32).parent, this.addingSpace, false, ((IncludeDesc)object32).alignment);
            assert (((LayoutInterval)object2).isParallel());
            if (object62 == null) {
                object62 = object2;
            } else {
                object = this.layoutModel.removeInterval((LayoutInterval)object2, 0);
                this.layoutModel.addInterval((LayoutInterval)object, (LayoutInterval)object62, -1);
            }
            this.operations.extract((LayoutInterval)object2, -1, true, (List)object5, (List)object4);
            this.layoutModel.removeInterval((LayoutInterval)object2);
            this.layoutModel.removeInterval(((IncludeDesc)object32).parent);
        }
        int n3 = -1;
        if (object62 != null) {
            if (object5.isEmpty()) {
                n3 = 1;
            }
            if (object4.isEmpty()) {
                n3 = 0;
            }
        }
        object32 = null;
        object2 = list.iterator();
        while (object2.hasNext()) {
            object = (IncludeDesc)object2.next();
            if (((IncludeDesc)object).parent.isParallel() || !((IncludeDesc)object).newSubGroup) {
                this.addToGroup((IncludeDesc)object, null, false);
                this.operations.extract(this.addingInterval, n3, n3 == -1, (List)object5, (List)object4);
                layoutInterval3 = this.addingInterval.getParent();
                this.layoutModel.removeInterval(this.addingInterval);
                this.layoutModel.removeInterval(layoutInterval3);
                if (n3 != -1 && LayoutInterval.getCount(layoutInterval3, -1, true) >= 1) {
                    if (object32 == null) {
                        object32 = new LayoutInterval(103);
                        ((LayoutInterval)object32).setGroupAlignment(n3);
                    }
                    this.operations.addContent(layoutInterval3, (LayoutInterval)object32, -1);
                }
            }
            if (((IncludeDesc)object).snappedNextTo != null) {
                layoutInterval5 = ((IncludeDesc)object).snappedNextTo;
            }
            if (object == object7) continue;
            object2.remove();
        }
        object2 = ((LayoutInterval)object9).getCurrentSpace().positions[this.dimension];
        object = ((LayoutInterval)(object62 != null ? object62 : this.addingInterval)).getCurrentSpace().positions[this.dimension];
        if (((LayoutInterval)object9).getSubIntervalCount() == 0 && ((LayoutInterval)object9).getParent() != null) {
            layoutInterval2 = ((LayoutInterval)object9).getParent();
            n2 = this.layoutModel.removeInterval((LayoutInterval)object9);
            if (layoutInterval2.isSequential()) {
                layoutInterval3 = layoutInterval2;
                object9 = layoutInterval2.getParent();
            } else {
                layoutInterval3 = new LayoutInterval(102);
                layoutInterval3.setAlignment(((LayoutInterval)object9).getAlignment());
                this.layoutModel.addInterval(layoutInterval3, layoutInterval2, n2);
                object9 = layoutInterval2;
                n2 = 0;
            }
        } else {
            layoutInterval3 = new LayoutInterval(102);
            this.layoutModel.addInterval(layoutInterval3, (LayoutInterval)object9, -1);
            n2 = 0;
        }
        if (layoutInterval3.getSubIntervalCount() == 0) {
            layoutInterval3.getCurrentSpace().set(this.dimension, ((LayoutInterval)object9).getCurrentSpace());
        }
        this.updateReplacedOriginalGroup((LayoutInterval)object9, layoutInterval3);
        layoutInterval2 = null;
        LayoutInterval layoutInterval6 = null;
        if (!object5.isEmpty()) {
            n = layoutInterval3.getSubIntervalCount();
            layoutInterval2 = this.operations.addGroupContent((List)object5, layoutInterval3, n2, this.dimension, 0);
            n2 += layoutInterval3.getSubIntervalCount() - n;
        }
        if (!object4.isEmpty()) {
            layoutInterval6 = this.operations.addGroupContent((List)object4, layoutInterval3, n2, this.dimension, 1);
        }
        if (layoutInterval2 != null) {
            n = layoutInterval3.getSubIntervalCount();
            layoutInterval2.getCurrentSpace().set(this.dimension, (int)object2[0], (int)object[0]);
            this.operations.optimizeGaps(layoutInterval2, this.dimension);
            n2 += layoutInterval3.getSubIntervalCount() - n;
        }
        if (layoutInterval6 != null) {
            layoutInterval6.getCurrentSpace().set(this.dimension, (int)object[1], (int)object2[1]);
            this.operations.optimizeGaps(layoutInterval6, this.dimension);
        }
        ((IncludeDesc)object7).parent = layoutInterval3;
        ((IncludeDesc)object7).newSubGroup = false;
        ((IncludeDesc)object7).neighbor = null;
        int n4 = n2;
        if (n4 == layoutInterval3.getSubIntervalCount()) {
            layoutInterval = layoutInterval3.getSubInterval(--n4);
        } else {
            layoutInterval = layoutInterval3.getSubInterval(n4);
            if (!layoutInterval.isEmptySpace() && --n4 > 0) {
                layoutInterval = layoutInterval3.getSubInterval(n4);
            }
        }
        if (!layoutInterval.isEmptySpace()) {
            layoutInterval = null;
        } else if (object62 == null) {
            n2 = n4;
            if (n2 == 0 && !LayoutInterval.isAlignedAtBorder(layoutInterval3, 0)) {
                this.layoutModel.removeInterval(layoutInterval);
                layoutInterval = null;
            } else if (n2 == layoutInterval3.getSubIntervalCount() - 1 && !LayoutInterval.isAlignedAtBorder(layoutInterval3, 1)) {
                this.layoutModel.removeInterval(layoutInterval);
                layoutInterval = null;
            }
        }
        ((IncludeDesc)object7).snappedNextTo = layoutInterval5;
        if (layoutInterval5 != null) {
            ((IncludeDesc)object7).fixedPosition = true;
        }
        if (object62 != null) {
            if (layoutInterval != null && (n3 == -1 || n3 == 0 && n2 > n4 || n3 == 1 && n2 <= n4)) {
                this.layoutModel.removeInterval(layoutInterval);
                if (n2 >= n4 && n2 > 0) {
                    --n2;
                }
            }
            int n5 = n2;
            if (object32 != null && ((LayoutInterval)object32).getSubIntervalCount() > 0) {
                LayoutInterval layoutInterval7 = new LayoutInterval(102);
                layoutInterval7.setAlignment(((IncludeDesc)object7).alignment);
                this.operations.addContent((LayoutInterval)object32, layoutInterval7, 0);
                this.layoutModel.addInterval(layoutInterval7, (LayoutInterval)object62, -1);
                ((IncludeDesc)object7).parent = layoutInterval7;
                n2 = n3 == 0 ? 0 : layoutInterval7.getSubIntervalCount();
            } else {
                ((IncludeDesc)object7).newSubGroup = true;
            }
            this.operations.addContent((LayoutInterval)object62, layoutInterval3, n5);
            this.updateMovedOriginalNeighbor();
        }
        ((IncludeDesc)object7).index = n2;
    }

    private static boolean compatibleInclusions(IncludeDesc includeDesc, IncludeDesc includeDesc2, int n) {
        LayoutRegion layoutRegion;
        Object object;
        LayoutInterval layoutInterval;
        LayoutInterval layoutInterval2;
        LayoutInterval layoutInterval3 = includeDesc.parent.isSequential() ? includeDesc.parent.getParent() : includeDesc.parent;
        LayoutInterval layoutInterval4 = layoutInterval2 = includeDesc2.parent.isSequential() ? includeDesc2.parent.getParent() : includeDesc2.parent;
        if (layoutInterval3 == layoutInterval2) {
            return true;
        }
        if (layoutInterval3.isParentOf(layoutInterval2)) {
            layoutInterval = layoutInterval3;
            layoutInterval3 = layoutInterval2;
            object = includeDesc;
            includeDesc2 = object;
        } else if (!layoutInterval2.isParentOf(layoutInterval3)) {
            return false;
        }
        LayoutInterval layoutInterval5 = layoutInterval = includeDesc2.parent.isSequential() ? includeDesc2.parent : includeDesc2.neighbor;
        if (layoutInterval == null) {
            return false;
        }
        object = layoutInterval.getCurrentSpace();
        return LayoutRegion.pointInside((LayoutRegion)object, 0, layoutRegion = layoutInterval3.getCurrentSpace(), n) && LayoutRegion.pointInside((LayoutRegion)object, 1, layoutRegion, n);
    }

    private void updateReplacedOriginalGroup(LayoutInterval layoutInterval, LayoutInterval layoutInterval2) {
        LayoutFeeder.updateReplacedOriginalGroup(this.originalPositions1[this.dimension], layoutInterval, layoutInterval2);
        LayoutFeeder.updateReplacedOriginalGroup(this.originalPositions2[this.dimension], layoutInterval, layoutInterval2);
    }

    private static void updateReplacedOriginalGroup(IncludeDesc includeDesc, LayoutInterval layoutInterval, LayoutInterval layoutInterval2) {
        if (includeDesc != null && LayoutInterval.getRoot(layoutInterval) != LayoutInterval.getRoot(includeDesc.parent)) {
            if (includeDesc.parent.isParallel()) {
                includeDesc.parent = layoutInterval;
            } else if (layoutInterval2 != null) {
                includeDesc.parent = layoutInterval2;
            }
        }
    }

    private void updateMovedOriginalNeighbor() {
        LayoutFeeder.updateMovedOriginalNeighbor(this.originalPositions1[this.dimension]);
        LayoutFeeder.updateMovedOriginalNeighbor(this.originalPositions2[this.dimension]);
    }

    private static void updateMovedOriginalNeighbor(IncludeDesc includeDesc) {
        if (includeDesc != null && includeDesc.neighbor != null) {
            includeDesc.parent = LayoutInterval.getFirstParent(includeDesc.neighbor, 103);
            LayoutFeeder.correctNeighborInSequence(includeDesc);
        }
    }

    private boolean mergeSequentialInclusions(IncludeDesc includeDesc, IncludeDesc includeDesc2) {
        boolean bl;
        LayoutInterval layoutInterval;
        if (includeDesc2 == null || !this.canCombine(includeDesc, includeDesc2)) {
            return false;
        }
        assert (!(includeDesc.alignment != 0 && includeDesc.alignment != 1 || includeDesc2.alignment != 0 && includeDesc2.alignment != 1 || includeDesc.alignment != (includeDesc2.alignment ^ 1)));
        if (includeDesc.parent == includeDesc2.parent) {
            return true;
        }
        if (includeDesc.parent.isParentOf(includeDesc2.parent)) {
            layoutInterval = includeDesc.parent;
            bl = includeDesc.neighbor != null || includeDesc2.snappedNextTo != null;
        } else if (includeDesc2.parent.isParentOf(includeDesc.parent)) {
            layoutInterval = includeDesc2.parent;
            bl = includeDesc2.neighbor != null || includeDesc.snappedNextTo != null;
        } else {
            layoutInterval = LayoutInterval.getFirstParent(includeDesc.parent, 102);
            bl = false;
        }
        if (layoutInterval.isSequential() || bl) {
            LayoutInterval layoutInterval2;
            if (includeDesc.alignment == 1) {
                IncludeDesc includeDesc3 = includeDesc;
                includeDesc = includeDesc2;
                includeDesc2 = includeDesc3;
            }
            int n = 0;
            LayoutInterval layoutInterval3 = null;
            boolean bl2 = false;
            int n2 = 0;
            LayoutInterval layoutInterval4 = null;
            boolean bl3 = false;
            if (layoutInterval.isSequential()) {
                if (layoutInterval.isParentOf(includeDesc.parent)) {
                    LayoutInterval layoutInterval5 = layoutInterval3 = includeDesc.parent.isSequential() ? includeDesc.parent : includeDesc.neighbor;
                    if (layoutInterval3 != null) {
                        while (layoutInterval3.getParent().getParent() != layoutInterval) {
                            layoutInterval3 = layoutInterval3.getParent();
                        }
                        n = layoutInterval.indexOf(layoutInterval3.getParent());
                    } else {
                        layoutInterval2 = includeDesc.parent;
                        while (layoutInterval2.getParent() != layoutInterval) {
                            layoutInterval2 = layoutInterval2.getParent();
                        }
                        n = layoutInterval.indexOf(layoutInterval2);
                    }
                } else {
                    n = includeDesc.index;
                    if (n == layoutInterval.getSubIntervalCount()) {
                        --n;
                    }
                    bl2 = layoutInterval.getSubInterval(n).isEmptySpace();
                }
                if (layoutInterval.isParentOf(includeDesc2.parent)) {
                    LayoutInterval layoutInterval6 = layoutInterval4 = includeDesc2.parent.isSequential() ? includeDesc2.parent : includeDesc2.neighbor;
                    if (layoutInterval4 != null) {
                        while (layoutInterval4.getParent().getParent() != layoutInterval) {
                            layoutInterval4 = layoutInterval4.getParent();
                        }
                        n2 = layoutInterval.indexOf(layoutInterval4.getParent());
                    } else {
                        layoutInterval2 = includeDesc2.parent;
                        while (layoutInterval2.getParent() != layoutInterval) {
                            layoutInterval2 = layoutInterval2.getParent();
                        }
                        n2 = layoutInterval.indexOf(layoutInterval2);
                    }
                } else {
                    n2 = includeDesc2.index;
                    if (includeDesc2.snappedParallel == null || !layoutInterval.isParentOf(includeDesc2.snappedParallel)) {
                        bl3 = layoutInterval.getSubInterval(--n2).isEmptySpace();
                    }
                }
            }
            if ((n2 > n + 1 || n2 == n + 1 && !bl2 && !bl3) && (layoutInterval3 != null && !includeDesc.newSubGroup || layoutInterval4 != null && !includeDesc2.newSubGroup)) {
                LayoutInterval layoutInterval7;
                LayoutInterval layoutInterval8;
                if (n == 0 && n2 == layoutInterval.getSubIntervalCount() - 1) {
                    layoutInterval2 = layoutInterval.getParent();
                } else {
                    layoutInterval2 = new LayoutInterval(103);
                    layoutInterval8 = new LayoutInterval(102);
                    this.layoutModel.addInterval(layoutInterval8, layoutInterval2, 0);
                    layoutInterval2.getCurrentSpace().set(this.dimension, LayoutUtils.getVisualPosition(layoutInterval.getSubInterval(n), this.dimension, 0), LayoutUtils.getVisualPosition(layoutInterval.getSubInterval(n2), this.dimension, 1));
                    int n3 = n;
                    while (n3 <= n2) {
                        layoutInterval7 = this.layoutModel.removeInterval(layoutInterval, n3);
                        --n2;
                        this.layoutModel.addInterval(layoutInterval7, layoutInterval8, -1);
                    }
                    this.layoutModel.addInterval(layoutInterval2, layoutInterval, n);
                }
                layoutInterval8 = new LayoutInterval(102);
                this.layoutModel.addInterval(layoutInterval8, layoutInterval2, -1);
                if (layoutInterval3 != null) {
                    LayoutInterval layoutInterval9 = layoutInterval3.getParent();
                    this.layoutModel.removeInterval(layoutInterval3);
                    if (layoutInterval9.getSubIntervalCount() == 1) {
                        layoutInterval7 = this.layoutModel.removeInterval(layoutInterval9, 0);
                        this.operations.addContent(layoutInterval7, layoutInterval9.getParent(), this.layoutModel.removeInterval(layoutInterval9));
                    }
                    this.operations.addContent(layoutInterval3, layoutInterval8, 0);
                    if (layoutInterval4 != null) {
                        layoutInterval7 = new LayoutInterval(101);
                        int n4 = LayoutRegion.distance(layoutInterval3.getCurrentSpace(), layoutInterval4.getCurrentSpace(), this.dimension, 0, 1);
                        layoutInterval7.setSize(n4);
                        this.layoutModel.addInterval(layoutInterval7, layoutInterval8, -1);
                        includeDesc.index = includeDesc2.index = layoutInterval8.indexOf(layoutInterval7);
                    } else {
                        includeDesc2.index = includeDesc.index;
                    }
                } else {
                    includeDesc.index = includeDesc2.index;
                }
                if (layoutInterval4 != null) {
                    LayoutInterval layoutInterval10 = layoutInterval4.getParent();
                    this.layoutModel.removeInterval(layoutInterval4);
                    if (layoutInterval10.getSubIntervalCount() == 1) {
                        layoutInterval7 = this.layoutModel.removeInterval(layoutInterval10, 0);
                        this.operations.addContent(layoutInterval7, layoutInterval10.getParent(), this.layoutModel.removeInterval(layoutInterval10));
                    }
                    this.operations.addContent(layoutInterval4, layoutInterval8, -1);
                }
                includeDesc.parent = includeDesc2.parent = layoutInterval8;
                includeDesc2.newSubGroup = false;
                includeDesc.newSubGroup = false;
                includeDesc2.neighbor = null;
                includeDesc.neighbor = null;
            } else if (includeDesc2.parent.isParentOf(includeDesc.parent)) {
                includeDesc2.parent = includeDesc.parent;
                includeDesc2.index = includeDesc.index;
                includeDesc2.newSubGroup = includeDesc.newSubGroup;
                includeDesc2.neighbor = includeDesc.neighbor;
                if (bl3) {
                    includeDesc2.fixedPosition = false;
                }
            } else if (includeDesc.parent.isParentOf(includeDesc2.parent)) {
                includeDesc.parent = includeDesc2.parent;
                includeDesc.index = includeDesc2.index;
                includeDesc.newSubGroup = includeDesc2.newSubGroup;
                includeDesc.neighbor = includeDesc2.neighbor;
                if (bl2) {
                    includeDesc.fixedPosition = false;
                }
            }
        } else {
            Object object;
            assert (includeDesc.parent.isParallel() && includeDesc2.parent.isParallel() && (layoutInterval == includeDesc.parent || layoutInterval == includeDesc2.parent) && includeDesc.neighbor == null && includeDesc2.neighbor == null);
            if (includeDesc2.snappedNextTo == null && includeDesc2.snappedParallel == null || includeDesc2.snappedParallel != null && this.canAlignWith(includeDesc2.snappedParallel, includeDesc.parent, includeDesc2.alignment)) {
                includeDesc2.parent = includeDesc.parent;
                return true;
            }
            if (includeDesc2.parent == layoutInterval) {
                object = includeDesc;
                includeDesc = includeDesc2;
                includeDesc2 = object;
            }
            assert (includeDesc2.snappedNextTo == null);
            if (includeDesc2.snappedParallel == includeDesc2.parent) {
                includeDesc2.parent = LayoutInterval.getFirstParent(includeDesc2.parent, 103);
                if (includeDesc2.parent == includeDesc.parent) {
                    return true;
                }
            }
            if (includeDesc2.snappedParallel == null || this.canAlignWith(includeDesc2.snappedParallel, includeDesc.parent, includeDesc2.alignment)) {
                includeDesc2.parent = includeDesc.parent;
                return true;
            }
            if (LayoutInterval.isAlignedAtBorder(includeDesc2.parent, includeDesc.parent, includeDesc.alignment)) {
                includeDesc.parent = includeDesc2.parent;
                return true;
            }
            object = includeDesc2.parent.getParent();
            if (((LayoutInterval)object).isSequential() && ((LayoutInterval)object).getParent() == includeDesc.parent) {
                LayoutInterval layoutInterval11;
                int n = ((LayoutInterval)object).indexOf(includeDesc2.parent) + (includeDesc.alignment == 0 ? -1 : 1);
                LayoutInterval layoutInterval12 = layoutInterval11 = n == 0 || n == ((LayoutInterval)object).getSubIntervalCount() - 1 ? ((LayoutInterval)object).getSubInterval(n) : null;
                if (layoutInterval11 != null && LayoutInterval.isFixedDefaultPadding(layoutInterval11) && includeDesc.snappedNextTo == includeDesc.parent && LayoutInterval.wantResize((LayoutInterval)object)) {
                    includeDesc.parent = includeDesc2.parent;
                    includeDesc.snappedNextTo = null;
                    includeDesc.snappedParallel = includeDesc2.parent;
                    return true;
                }
                if (layoutInterval11 != null && layoutInterval11.isEmptySpace() && includeDesc.snappedParallel == includeDesc.parent) {
                    int n5 = LayoutInterval.getIntervalCurrentSize(layoutInterval11, this.dimension);
                    this.copyGapInsideGroup(layoutInterval11, n5, includeDesc2.parent, includeDesc.alignment);
                    this.layoutModel.removeInterval(layoutInterval11);
                    includeDesc.parent = includeDesc2.parent;
                    return true;
                }
            }
            includeDesc2.parent = includeDesc.parent;
        }
        return true;
    }

    private void copyGapInsideGroup(LayoutInterval layoutInterval, int n, LayoutInterval layoutInterval2, int n2) {
        assert (layoutInterval.isEmptySpace() && (n2 == 0 || n2 == 1));
        if (n2 == 0) {
            n = -n;
        }
        int[] nArray = layoutInterval2.getCurrentSpace().positions[this.dimension];
        int n3 = n2;
        nArray[n3] = nArray[n3] + n;
        Iterator iterator = layoutInterval2.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval3 = (LayoutInterval)iterator.next();
            LayoutInterval layoutInterval4 = LayoutInterval.cloneInterval(layoutInterval, null);
            if (layoutInterval3.isSequential()) {
                int[] nArray2 = layoutInterval3.getCurrentSpace().positions[this.dimension];
                int n4 = n2;
                nArray2[n4] = nArray2[n4] + n;
                int n5 = n2 == 0 ? 0 : layoutInterval3.getSubIntervalCount();
                this.operations.insertGapIntoSequence(layoutInterval4, layoutInterval3, n5, this.dimension);
                continue;
            }
            LayoutInterval layoutInterval5 = new LayoutInterval(102);
            layoutInterval5.getCurrentSpace().set(this.dimension, layoutInterval3.getCurrentSpace());
            int[] nArray3 = layoutInterval5.getCurrentSpace().positions[this.dimension];
            int n6 = n2;
            nArray3[n6] = nArray3[n6] + n;
            layoutInterval5.setAlignment(layoutInterval3.getRawAlignment());
            this.layoutModel.addInterval(layoutInterval5, layoutInterval2, this.layoutModel.removeInterval(layoutInterval3));
            this.layoutModel.setIntervalAlignment(layoutInterval3, -1);
            this.layoutModel.addInterval(layoutInterval3, layoutInterval5, 0);
            this.layoutModel.addInterval(layoutInterval4, layoutInterval5, n2 == 0 ? 0 : 1);
        }
    }

    private boolean shouldEnterGroup(LayoutInterval layoutInterval) {
        assert (layoutInterval.isParallel());
        int n = this.aEdge;
        int n2 = layoutInterval.getGroupAlignment();
        if (n2 != n && (n2 != 0 && n2 != 1 || n != 0 && n != 1 && n != -1)) {
            return false;
        }
        return this.aSnappedParallel == null || this.allowsSubAlignWith(this.aSnappedParallel, layoutInterval, n);
    }

    private boolean allowsSubAlignWith(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        if (layoutInterval2 == layoutInterval || layoutInterval2.isParentOf(layoutInterval)) {
            return true;
        }
        LayoutInterval layoutInterval3 = LayoutInterval.getFirstParent(layoutInterval, 103);
        while (layoutInterval3 != null) {
            if (LayoutInterval.isAlignedAtBorder(layoutInterval, layoutInterval3, n)) {
                if (layoutInterval3.isParentOf(layoutInterval2) && LayoutInterval.isAlignedAtBorder(layoutInterval2, layoutInterval3, n)) {
                    return true;
                }
                layoutInterval = layoutInterval3;
                layoutInterval3 = LayoutInterval.getFirstParent(layoutInterval, 103);
                continue;
            }
            layoutInterval3 = null;
        }
        return false;
    }

    private boolean canAlignWith(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        if (layoutInterval2.isSequential()) {
            layoutInterval2 = layoutInterval2.getParent();
        }
        if (layoutInterval == layoutInterval2) {
            return true;
        }
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        if (layoutInterval3 == null) {
            layoutInterval3 = layoutInterval;
        } else if (layoutInterval3.isSequential()) {
            layoutInterval3 = layoutInterval3.getParent();
        }
        while (layoutInterval3 != null && layoutInterval3 != layoutInterval2 && !layoutInterval3.isParentOf(layoutInterval2)) {
            if (LayoutFeeder.canSubstAlignWithParent(layoutInterval, this.dimension, n, this.dragger.isResizing(this.dimension))) {
                layoutInterval = layoutInterval3;
                layoutInterval3 = LayoutInterval.getFirstParent(layoutInterval, 103);
                continue;
            }
            layoutInterval3 = null;
        }
        if (layoutInterval3 == null) {
            return false;
        }
        if (layoutInterval3 == layoutInterval2) {
            return true;
        }
        return LayoutInterval.isAlignedAtBorder(layoutInterval2, layoutInterval3, n);
    }

    private static boolean canSubstAlignWithParent(LayoutInterval layoutInterval, int n, int n2, boolean bl) {
        LayoutInterval layoutInterval2 = LayoutInterval.getFirstParent(layoutInterval, 103);
        boolean bl2 = LayoutInterval.isAlignedAtBorder(layoutInterval, layoutInterval2, n2);
        if (!bl2 && LayoutInterval.getDirectNeighbor(layoutInterval, n2, false) == null && LayoutInterval.isPlacedAtBorder(layoutInterval, layoutInterval2, n, n2)) {
            boolean bl3 = bl2 = bl || LayoutInterval.getDirectNeighbor(layoutInterval2, n2, true) != null || LayoutInterval.isClosedGroup(layoutInterval2, n2);
            if (!bl2) {
                boolean bl4 = true;
                Iterator iterator = layoutInterval2.getSubIntervals();
                while (iterator.hasNext()) {
                    LayoutInterval layoutInterval3 = (LayoutInterval)iterator.next();
                    if (layoutInterval3.getAlignment() == n2 || LayoutInterval.wantResize(layoutInterval3)) {
                        bl2 = true;
                        break;
                    }
                    if (!bl4 || LayoutInterval.isPlacedAtBorder(layoutInterval3, n, n2)) continue;
                    bl4 = false;
                }
                if (bl4) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private boolean canCombine(IncludeDesc includeDesc, IncludeDesc includeDesc2) {
        if (includeDesc.parent == includeDesc2.parent) {
            return true;
        }
        if (includeDesc.parent.isParentOf(includeDesc2.parent)) {
            return this.isBorderInclusion(includeDesc2);
        }
        if (includeDesc2.parent.isParentOf(includeDesc.parent)) {
            return this.isBorderInclusion(includeDesc);
        }
        LayoutInterval layoutInterval = includeDesc.parent.isParallel() ? includeDesc.parent : includeDesc.parent.getParent();
        LayoutInterval layoutInterval2 = includeDesc2.parent.isParallel() ? includeDesc2.parent : includeDesc2.parent.getParent();
        return layoutInterval.getParent() == layoutInterval2.getParent() && this.isBorderInclusion(includeDesc) && this.isBorderInclusion(includeDesc2) && LayoutInterval.getDirectNeighbor(layoutInterval, includeDesc.alignment ^ 1, true) == layoutInterval2;
    }

    private boolean isBorderInclusion(IncludeDesc includeDesc) {
        if (includeDesc.alignment != 0 && includeDesc.alignment != 1) {
            return false;
        }
        if (includeDesc.parent.isSequential()) {
            int n = includeDesc.alignment == 0 ? includeDesc.index : 0;
            int n2 = includeDesc.alignment == 0 ? includeDesc.parent.getSubIntervalCount() - 1 : includeDesc.index - 1;
            return n > n2 || !LayoutUtils.contentOverlap(this.addingSpace, includeDesc.parent, n, n2, this.dimension ^ 1);
        }
        return includeDesc.neighbor == null || includeDesc.alignment == 0 && includeDesc.index >= 1 || includeDesc.alignment == 1 && includeDesc.index == 0;
    }

    private static int getAddDirection(LayoutRegion layoutRegion, LayoutRegion layoutRegion2, int n, int n2) {
        return LayoutRegion.distance(layoutRegion, layoutRegion2, n, n2, 2) > 0 ? 0 : 1;
    }

    private static class IncludeDesc {
        LayoutInterval parent;
        int index = -1;
        boolean newSubGroup;
        LayoutInterval neighbor;
        LayoutInterval snappedParallel;
        LayoutInterval snappedNextTo;
        int alignment;
        boolean fixedPosition;
        int distance = Integer.MAX_VALUE;
        int ortDistance = Integer.MAX_VALUE;

        private IncludeDesc() {
        }

        boolean snapped() {
            return this.snappedNextTo != null || this.snappedParallel != null;
        }
    }
}

