/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutEvent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutPersistenceManager;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.w3c.dom.NodeList;

public class LayoutModel
implements LayoutConstants {
    private Map idToComponents = new HashMap();
    private ArrayList listeners;
    private boolean recordingChanges = true;
    private boolean undoRedoInProgress;
    private int changeMark;
    private int oldestMark;
    private int changeCountHardLimit = 10000;
    private Map undoMap = new HashMap(500);
    private Map redoMap = new HashMap(100);
    private LayoutUndoableEdit lastUndoableEdit;
    private boolean corrected;
    private Map linkSizeGroupsH = new HashMap();
    private Map linkSizeGroupsV = new HashMap();
    private int maxLinkGroupId = 0;

    public LayoutComponent getLayoutComponent(String string) {
        return (LayoutComponent)this.idToComponents.get(string);
    }

    public void addRootComponent(LayoutComponent layoutComponent) {
        this.addComponent(layoutComponent, null, -1);
    }

    public void removeComponent(String string, boolean bl) {
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        if (layoutComponent != null) {
            this.removeComponentAndIntervals(layoutComponent, bl);
        }
    }

    public boolean changeComponentToContainer(String string) {
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        if (layoutComponent != null) {
            this.setLayoutContainer(layoutComponent, true);
            return true;
        }
        return false;
    }

    public boolean changeContainerToComponent(String string) {
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        if (layoutComponent == null) {
            return false;
        }
        for (int i = layoutComponent.getSubComponentCount() - 1; i >= 0; --i) {
            LayoutComponent layoutComponent2;
            this.removeComponentAndIntervals(layoutComponent2, !(layoutComponent2 = layoutComponent.getSubComponent(i)).isLayoutContainer());
        }
        if (layoutComponent.getParent() == null) {
            this.removeComponent(layoutComponent, true);
        }
        this.setLayoutContainer(layoutComponent, false);
        return true;
    }

    void registerComponent(LayoutComponent layoutComponent, boolean bl) {
        this.registerComponentImpl(layoutComponent);
        if (bl && layoutComponent.isLayoutContainer()) {
            Iterator iterator = layoutComponent.getSubcomponents();
            while (iterator.hasNext()) {
                this.registerComponent((LayoutComponent)iterator.next(), bl);
            }
        }
    }

    void registerComponentImpl(LayoutComponent layoutComponent) {
        LayoutComponent layoutComponent2 = this.idToComponents.put(layoutComponent.getId(), layoutComponent);
        if (layoutComponent2 != layoutComponent) {
            LayoutEvent layoutEvent = new LayoutEvent(this, 11);
            layoutEvent.setComponent(layoutComponent);
            this.addChange(layoutEvent);
            this.fireEvent(layoutEvent);
        }
    }

    void unregisterComponent(LayoutComponent layoutComponent, boolean bl) {
        if (bl && layoutComponent.isLayoutContainer()) {
            Iterator iterator = layoutComponent.getSubcomponents();
            while (iterator.hasNext()) {
                this.unregisterComponent((LayoutComponent)iterator.next(), bl);
            }
        }
        this.removeComponentFromLinkSizedGroup(layoutComponent, 0);
        this.removeComponentFromLinkSizedGroup(layoutComponent, 1);
        this.unregisterComponentImpl(layoutComponent);
    }

    void unregisterComponentImpl(LayoutComponent layoutComponent) {
        Object v = this.idToComponents.remove(layoutComponent.getId());
        if (v != null) {
            LayoutEvent layoutEvent = new LayoutEvent(this, 12);
            layoutEvent.setComponent(layoutComponent);
            this.addChange(layoutEvent);
            this.fireEvent(layoutEvent);
        }
    }

    void changeComponentId(LayoutComponent layoutComponent, String string) {
        this.unregisterComponentImpl(layoutComponent);
        layoutComponent.setId(string);
        this.registerComponentImpl(layoutComponent);
    }

    void replaceComponent(LayoutComponent layoutComponent, LayoutComponent layoutComponent2) {
        assert (layoutComponent2.getParent() == null);
        for (int i = 0; i < 2; ++i) {
            LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(i);
            LayoutInterval layoutInterval2 = layoutComponent2.getLayoutInterval(i);
            assert (layoutInterval2.getParent() == null);
            this.setIntervalAlignment(layoutInterval2, layoutInterval.getRawAlignment());
            this.setIntervalSize(layoutInterval2, layoutInterval.getMinimumSize(), layoutInterval.getPreferredSize(), layoutInterval.getMaximumSize());
            LayoutInterval layoutInterval3 = layoutInterval.getParent();
            if (layoutInterval3 == null) continue;
            int n = this.removeInterval(layoutInterval);
            this.addInterval(layoutInterval2, layoutInterval3, n);
        }
        LayoutComponent layoutComponent3 = layoutComponent.getParent();
        if (layoutComponent3 != null) {
            int n = this.removeComponentImpl(layoutComponent);
            this.addComponentImpl(layoutComponent2, layoutComponent3, n);
        }
        this.unregisterComponentImpl(layoutComponent);
        this.registerComponentImpl(layoutComponent2);
    }

    Iterator getAllComponents() {
        return this.idToComponents.values().iterator();
    }

    public void addNewComponent(LayoutComponent layoutComponent, LayoutComponent layoutComponent2, LayoutComponent layoutComponent3) {
        for (int i = 0; i < 2; ++i) {
            LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(i);
            if (layoutComponent2 != null) {
                this.addInterval(layoutInterval, layoutComponent2.getLayoutRoot(i), -1);
            }
            this.setIntervalAlignment(layoutInterval, -1);
            if (layoutComponent3 == null) continue;
            LayoutInterval layoutInterval2 = layoutComponent3.getLayoutInterval(i);
            this.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize(), layoutInterval2.getPreferredSize(), layoutInterval.getMaximumSize());
        }
        this.addComponent(layoutComponent, layoutComponent2, -1);
    }

    void addComponent(LayoutComponent layoutComponent, LayoutComponent layoutComponent2, int n) {
        this.addComponentImpl(layoutComponent, layoutComponent2, n);
        this.registerComponent(layoutComponent, true);
    }

    void addComponentImpl(LayoutComponent layoutComponent, LayoutComponent layoutComponent2, int n) {
        assert (layoutComponent.getParent() == null);
        if (layoutComponent2 != null) {
            assert (this.getLayoutComponent(layoutComponent2.getId()) == layoutComponent2);
            n = layoutComponent2.add(layoutComponent, n);
        } else assert (layoutComponent.isLayoutContainer());
        LayoutEvent layoutEvent = new LayoutEvent(this, 1);
        layoutEvent.setComponent(layoutComponent, layoutComponent2, n);
        this.addChange(layoutEvent);
        this.fireEvent(layoutEvent);
    }

    void removeComponent(LayoutComponent layoutComponent) {
        this.removeComponent(layoutComponent, true);
    }

    void removeComponent(LayoutComponent layoutComponent, boolean bl) {
        this.removeComponentImpl(layoutComponent);
        if (bl && this.getLayoutComponent(layoutComponent.getId()) != null) {
            this.unregisterComponent(layoutComponent, true);
        }
    }

    int removeComponentImpl(LayoutComponent layoutComponent) {
        LayoutComponent layoutComponent2 = layoutComponent.getParent();
        if (layoutComponent2 == null) {
            return -1;
        }
        int n = layoutComponent2.remove(layoutComponent);
        LayoutEvent layoutEvent = new LayoutEvent(this, 2);
        layoutEvent.setComponent(layoutComponent, layoutComponent2, n);
        this.addChange(layoutEvent);
        this.fireEvent(layoutEvent);
        return n;
    }

    void removeComponentAndIntervals(LayoutComponent layoutComponent, boolean bl) {
        boolean bl2 = layoutComponent.getParent() == null;
        this.removeComponent(layoutComponent, bl);
        if (!bl2) {
            for (int i = 0; i < 2; ++i) {
                LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(i);
                if (layoutInterval.getParent() == null) continue;
                this.removeInterval(layoutInterval);
            }
        }
    }

    void addInterval(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n) {
        assert (layoutInterval.getParent() == null);
        n = layoutInterval2.add(layoutInterval, n);
        LayoutEvent layoutEvent = new LayoutEvent(this, 3);
        layoutEvent.setInterval(layoutInterval, layoutInterval2, n);
        this.addChange(layoutEvent);
        this.fireEvent(layoutEvent);
    }

    int removeInterval(LayoutInterval layoutInterval) {
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        int n = layoutInterval2.remove(layoutInterval);
        LayoutEvent layoutEvent = new LayoutEvent(this, 4);
        layoutEvent.setInterval(layoutInterval, layoutInterval2, n);
        this.addChange(layoutEvent);
        this.fireEvent(layoutEvent);
        return n;
    }

    LayoutInterval removeInterval(LayoutInterval layoutInterval, int n) {
        LayoutInterval layoutInterval2 = layoutInterval.remove(n);
        LayoutEvent layoutEvent = new LayoutEvent(this, 4);
        layoutEvent.setInterval(layoutInterval2, layoutInterval, n);
        this.addChange(layoutEvent);
        this.fireEvent(layoutEvent);
        return layoutInterval2;
    }

    void changeIntervalAttribute(LayoutInterval layoutInterval, int n, boolean bl) {
        int n2 = layoutInterval.getAttributes();
        if (bl) {
            layoutInterval.setAttribute(n);
        } else {
            layoutInterval.unsetAttribute(n);
        }
        int n3 = layoutInterval.getAttributes();
        LayoutEvent layoutEvent = new LayoutEvent(this, 8);
        layoutEvent.setAttributes(layoutInterval, n2, n3);
        this.addChange(layoutEvent);
    }

    void setIntervalAlignment(LayoutInterval layoutInterval, int n) {
        int n2 = layoutInterval.getRawAlignment();
        layoutInterval.setAlignment(n);
        LayoutEvent layoutEvent = new LayoutEvent(this, 5);
        layoutEvent.setAlignment(layoutInterval, n2, n);
        this.addChange(layoutEvent);
    }

    void setGroupAlignment(LayoutInterval layoutInterval, int n) {
        int n2 = layoutInterval.getGroupAlignment();
        if (n == n2) {
            return;
        }
        layoutInterval.setGroupAlignment(n);
        LayoutEvent layoutEvent = new LayoutEvent(this, 6);
        layoutEvent.setAlignment(layoutInterval, n2, n);
        this.addChange(layoutEvent);
    }

    void setLayoutContainer(LayoutComponent layoutComponent, boolean bl) {
        boolean bl2 = layoutComponent.isLayoutContainer();
        if (bl2 != bl) {
            LayoutInterval[] layoutIntervalArray = layoutComponent.getLayoutRoots();
            layoutComponent.setLayoutContainer(bl, null);
            LayoutEvent layoutEvent = new LayoutEvent(this, 10);
            layoutEvent.setContainer(layoutComponent, layoutIntervalArray);
            this.addChange(layoutEvent);
        }
    }

    public void setIntervalSize(LayoutInterval layoutInterval, int n, int n2, int n3) {
        Object object;
        int n4 = layoutInterval.getMinimumSize();
        int n5 = layoutInterval.getPreferredSize();
        int n6 = layoutInterval.getMaximumSize();
        if (n == n4 && n2 == n5 && n3 == n6) {
            return;
        }
        layoutInterval.setSizes(n, n2, n3);
        if (layoutInterval.isComponent()) {
            boolean bl;
            object = layoutInterval.getComponent();
            boolean bl2 = bl = layoutInterval == ((LayoutComponent)object).getLayoutInterval(0);
            if (n4 != n) {
                ((LayoutComponent)object).firePropertyChange(bl ? "horizontalMinSize" : "verticalMinSize", new Integer(n4), new Integer(n));
            }
            if (n5 != n2) {
                ((LayoutComponent)object).firePropertyChange(bl ? "horizontalPrefSize" : "verticalPrefSize", new Integer(n5), new Integer(n2));
            }
            if (n6 != n3) {
                ((LayoutComponent)object).firePropertyChange(bl ? "horizontalMaxSize" : "verticalMaxSize", new Integer(n6), new Integer(n3));
            }
        }
        object = new LayoutEvent(this, 7);
        ((LayoutEvent)object).setSize(layoutInterval, n4, n5, n6, n, n2, n3);
        this.addChange((LayoutEvent)object);
    }

    public void copyModelFrom(LayoutModel layoutModel, Map map, String string, String string2) {
        LayoutConstants layoutConstants;
        Object object;
        LayoutComponent layoutComponent = layoutModel.getLayoutComponent(string);
        LayoutComponent layoutComponent2 = this.getLayoutComponent(string2);
        if (layoutComponent2 == null) {
            layoutComponent2 = new LayoutComponent(string2, true);
            this.addRootComponent(layoutComponent2);
        } else if (!layoutComponent2.isLayoutContainer()) {
            this.changeComponentToContainer(string2);
        }
        for (Map.Entry entry : map.entrySet()) {
            object = (String)entry.getValue();
            layoutConstants = this.getLayoutComponent((String)object);
            if (layoutConstants == null) {
                String string3 = (String)entry.getKey();
                LayoutComponent layoutComponent3 = layoutModel.getLayoutComponent(string3);
                layoutConstants = new LayoutComponent((String)object, layoutComponent3.isLayoutContainer());
            }
            if (((LayoutComponent)layoutConstants).getParent() != null) continue;
            this.addComponent((LayoutComponent)layoutConstants, layoutComponent2, -1);
        }
        for (int i = 0; i < 2; ++i) {
            object = layoutComponent.getLayoutRoot(i);
            layoutConstants = layoutComponent2.getLayoutRoot(i);
            this.copyInterval((LayoutInterval)object, (LayoutInterval)layoutConstants, map);
        }
    }

    private void copyInterval(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, Map map) {
        Iterator iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            Object object;
            LayoutInterval layoutInterval3 = (LayoutInterval)iterator.next();
            LayoutInterval layoutInterval4 = null;
            if (layoutInterval3.isComponent()) {
                object = (String)map.get(layoutInterval3.getComponent().getId());
                LayoutComponent layoutComponent = this.getLayoutComponent((String)object);
                int n = layoutInterval3 == layoutInterval3.getComponent().getLayoutInterval(0) ? 0 : 1;
                layoutInterval4 = layoutComponent.getLayoutInterval(n);
            }
            object = LayoutInterval.cloneInterval(layoutInterval3, layoutInterval4);
            if (layoutInterval3.isGroup()) {
                this.copyInterval(layoutInterval3, (LayoutInterval)object, map);
            }
            this.addInterval((LayoutInterval)object, layoutInterval2, -1);
        }
    }

    public void createModel(String string, Container container, Map map) {
        Object object;
        Object object2;
        if (map.isEmpty()) {
            return;
        }
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        assert (layoutComponent != null);
        Insets insets = new Insets(0, 0, 0, 0);
        if (container instanceof JComponent && (object2 = ((JComponent)container).getBorder()) != null) {
            insets = object2.getBorderInsets(container);
        }
        object2 = new HashMap();
        Iterator iterator = map.entrySet().iterator();
        Rectangle rectangle = new Rectangle();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval;
            object = iterator.next();
            String string2 = (String)object.getKey();
            Component component = (Component)object.getValue();
            LayoutComponent layoutComponent2 = this.getLayoutComponent(string2);
            if (layoutComponent2 == null) {
                layoutComponent2 = new LayoutComponent(string2, false);
            }
            this.addComponent(layoutComponent2, layoutComponent, -1);
            Rectangle rectangle2 = component.getBounds();
            Dimension dimension = component.getPreferredSize();
            if (rectangle2.equals(rectangle)) {
                rectangle2.setSize(dimension);
            }
            rectangle2 = new Rectangle(rectangle2.x - insets.left, rectangle2.y - insets.top, rectangle2.width, rectangle2.height);
            object2.put(string2, rectangle2);
            if (dimension.width != rectangle2.width) {
                layoutInterval = layoutComponent2.getLayoutInterval(0);
                this.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize(), rectangle2.width, layoutInterval.getMaximumSize());
            }
            if (dimension.height == rectangle2.height) continue;
            layoutInterval = layoutComponent2.getLayoutInterval(1);
            this.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize(), rectangle2.height, layoutInterval.getMaximumSize());
        }
        object = new RegionInfo((Map)object2);
        ((RegionInfo)object).calculateIntervals();
        this.addInterval(((RegionInfo)object).getInterval(0), layoutComponent.getLayoutRoot(0), -1);
        this.addInterval(((RegionInfo)object).getInterval(1), layoutComponent.getLayoutRoot(1), -1);
    }

    public LayoutInterval[] createIntervalsFromBounds(LayoutRegion layoutRegion, LayoutComponent[] layoutComponentArray, LayoutRegion[] layoutRegionArray) {
        Object object;
        HashMap<String, LayoutInterval[]> hashMap = new HashMap<String, LayoutInterval[]>();
        for (int i = 0; i < layoutComponentArray.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                LayoutInterval layoutInterval = layoutComponentArray[i].getLayoutInterval(j);
                this.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize(), layoutRegionArray[i].size(j), layoutInterval.getMaximumSize());
            }
            object = new Rectangle(layoutRegionArray[i].positions[0][0] - layoutRegion.positions[0][0], layoutRegionArray[i].positions[1][0] - layoutRegion.positions[1][0], layoutRegionArray[i].size(0), layoutRegionArray[i].size(1));
            hashMap.put(layoutComponentArray[i].getId(), (LayoutInterval[])object);
        }
        RegionInfo regionInfo = new RegionInfo(hashMap);
        regionInfo.calculateIntervals();
        object = new LayoutInterval[2];
        for (int i = 0; i < 2; ++i) {
            object[i] = regionInfo.getInterval(i);
        }
        return object;
    }

    void addListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        } else {
            this.listeners.remove(listener);
        }
        this.listeners.add(listener);
    }

    void removeListener(Listener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireEvent(LayoutEvent layoutEvent) {
        if (this.listeners != null && this.listeners.size() > 0) {
            Iterator iterator = ((List)this.listeners.clone()).iterator();
            while (iterator.hasNext()) {
                ((Listener)iterator.next()).layoutChanged(layoutEvent);
            }
        }
    }

    public boolean isChangeRecording() {
        return this.recordingChanges;
    }

    public void setChangeRecording(boolean bl) {
        this.recordingChanges = bl;
    }

    boolean isUndoRedoInProgress() {
        return this.undoRedoInProgress;
    }

    public Object getChangeMark() {
        return new Integer(this.changeMark);
    }

    public void endUndoableEdit() {
        if (this.lastUndoableEdit != null) {
            this.lastUndoableEdit.endMark = this.getChangeMark();
            this.lastUndoableEdit = null;
        }
    }

    public boolean isUndoableEditInProgress() {
        return this.lastUndoableEdit != null;
    }

    public UndoableEdit getUndoableEdit() {
        if (this.recordingChanges && !this.undoRedoInProgress) {
            LayoutUndoableEdit layoutUndoableEdit = new LayoutUndoableEdit();
            layoutUndoableEdit.startMark = this.getChangeMark();
            this.endUndoableEdit();
            this.lastUndoableEdit = layoutUndoableEdit;
            return layoutUndoableEdit;
        }
        return null;
    }

    private void addChange(LayoutEvent layoutEvent) {
        if (this.recordingChanges && !this.undoRedoInProgress) {
            this.redoMap.clear();
            if (this.undoMap.size() == 0) {
                this.oldestMark = this.changeMark;
            }
            this.undoMap.put(new Integer(this.changeMark++), layoutEvent);
            while (this.undoMap.size() > this.changeCountHardLimit) {
                this.undoMap.remove(new Integer(this.oldestMark++));
            }
        }
    }

    boolean undo(Object object, Object object2) {
        assert (!this.undoRedoInProgress);
        if (!this.undoMap.containsKey(object)) {
            return false;
        }
        int n = (Integer)object;
        int n2 = (Integer)object2;
        this.undoRedoInProgress = true;
        while (n2 > n) {
            Integer n3;
            LayoutEvent layoutEvent;
            if ((layoutEvent = (LayoutEvent)this.undoMap.remove(n3 = new Integer(--n2))) == null) continue;
            layoutEvent.undo();
            this.redoMap.put(n3, layoutEvent);
        }
        this.undoRedoInProgress = false;
        return true;
    }

    boolean redo(Object object, Object object2) {
        assert (!this.undoRedoInProgress);
        if (!this.redoMap.containsKey(object)) {
            return false;
        }
        int n = (Integer)object;
        int n2 = (Integer)object2;
        this.undoRedoInProgress = true;
        while (n < n2) {
            Integer n3;
            LayoutEvent layoutEvent;
            if ((layoutEvent = (LayoutEvent)this.redoMap.remove(n3 = new Integer(n++))) == null) continue;
            layoutEvent.redo();
            this.undoMap.put(n3, layoutEvent);
        }
        this.undoRedoInProgress = false;
        return true;
    }

    void releaseChanges(Object object, Object object2) {
        int n = (Integer)object2;
        for (int i = ((Integer)object).intValue(); i < n; ++i) {
            Integer n2 = new Integer(i);
            this.undoMap.remove(n2);
            this.redoMap.remove(n2);
        }
    }

    public String dump(final Map map) {
        Map.Entry entry22;
        TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == object2) {
                    return 0;
                }
                LayoutComponent layoutComponent = (LayoutComponent)object;
                LayoutComponent layoutComponent2 = (LayoutComponent)object2;
                if (layoutComponent.isParentOf(layoutComponent2)) {
                    return -1;
                }
                if (layoutComponent2.isParentOf(layoutComponent)) {
                    return 1;
                }
                LayoutComponent layoutComponent3 = LayoutComponent.getCommonParent(layoutComponent, layoutComponent2);
                while (layoutComponent.getParent() != layoutComponent3) {
                    layoutComponent = layoutComponent.getParent();
                }
                while (layoutComponent2.getParent() != layoutComponent3) {
                    layoutComponent2 = layoutComponent2.getParent();
                }
                if (layoutComponent3 != null) {
                    return layoutComponent3.indexOf(layoutComponent) < layoutComponent3.indexOf(layoutComponent2) ? -1 : 1;
                }
                String string = layoutComponent.getId();
                String string2 = layoutComponent2.getId();
                if (map != null) {
                    string = (String)map.get(string);
                    string2 = (String)map.get(string2);
                    if (string == null) {
                        return -1;
                    }
                    if (string2 == null) {
                        return 1;
                    }
                }
                return string.compareTo(string2);
            }
        });
        for (Map.Entry entry22 : this.idToComponents.entrySet()) {
            LayoutComponent layoutComponent = (LayoutComponent)entry22.getValue();
            if (!layoutComponent.isLayoutContainer()) continue;
            treeSet.add(layoutComponent);
        }
        entry22 = new StringBuffer();
        ((StringBuffer)((Object)entry22)).append("<LayoutModel>\n");
        for (LayoutComponent layoutComponent : treeSet) {
            String string = layoutComponent.getId();
            if (map != null) {
                string = (String)map.get(string);
            }
            if (string != null) {
                ((StringBuffer)((Object)entry22)).append("  <Root id=\"" + string + "\">\n");
            } else {
                ((StringBuffer)((Object)entry22)).append("  <Root>\n");
            }
            ((StringBuffer)((Object)entry22)).append(this.dumpLayout(2, layoutComponent, map, true));
            ((StringBuffer)((Object)entry22)).append("  </Root>\n");
        }
        ((StringBuffer)((Object)entry22)).append("</LayoutModel>\n");
        return ((StringBuffer)((Object)entry22)).toString();
    }

    public String dump(LayoutInterval layoutInterval, int n) {
        return new LayoutPersistenceManager(this).saveIntervalLayout(2, layoutInterval, n);
    }

    public String dumpLayout(int n, LayoutComponent layoutComponent, Map map, boolean bl) {
        return new LayoutPersistenceManager(this).saveLayout(n, layoutComponent, map, bl);
    }

    public void loadModel(String string, NodeList nodeList, Map map) throws IOException {
        new LayoutPersistenceManager(this).loadModel(string, nodeList, map);
    }

    public boolean wasCorrected() {
        return this.corrected;
    }

    void setCorrected() {
        this.corrected = true;
    }

    void addComponentToLinkSizedGroup(int n, String string, int n2) {
        Integer n3;
        Map map;
        List list;
        if (-1 == n) {
            return;
        }
        if (this.maxLinkGroupId < n) {
            this.maxLinkGroupId = n;
        }
        if ((list = (List)(map = n2 == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV).get(n3 = new Integer(n))) != null && (list.contains(string) || !this.sameContainer(string, (String)list.get(0)))) {
            return;
        }
        this.addComponentToLinkSizedGroupImpl(n, string, n2);
    }

    void addComponentToLinkSizedGroupImpl(int n, String string, int n2) {
        Integer n3;
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        Map map = n2 == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV;
        ArrayList<String> arrayList = (ArrayList<String>)map.get(n3 = new Integer(n));
        if (arrayList != null) {
            arrayList.add(layoutComponent.getId());
        } else {
            arrayList = new ArrayList<String>();
            arrayList.add(layoutComponent.getId());
            map.put(n3, arrayList);
        }
        int n4 = layoutComponent.getLinkSizeId(n2);
        layoutComponent.setLinkSizeId(n, n2);
        LayoutEvent layoutEvent = new LayoutEvent(this, 9);
        layoutEvent.setLinkSizeGroup(layoutComponent, n4, n, n2);
        this.addChange(layoutEvent);
        this.fireEvent(layoutEvent);
    }

    private boolean sameContainer(String string, String string2) {
        LayoutComponent layoutComponent = this.getLayoutComponent(string);
        LayoutComponent layoutComponent2 = this.getLayoutComponent(string2);
        return layoutComponent.getParent().equals(layoutComponent2.getParent());
    }

    void removeComponentFromLinkSizedGroup(LayoutComponent layoutComponent, int n) {
        if (layoutComponent == null) {
            return;
        }
        int n2 = layoutComponent.getLinkSizeId(n);
        if (n2 != -1) {
            Object object;
            Map map = n == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV;
            Integer n3 = new Integer(n2);
            List list = null;
            list = (List)map.get(n3);
            list.remove(layoutComponent.getId());
            layoutComponent.setLinkSizeId(-1, n);
            if (list.size() == 1) {
                object = this.getLayoutComponent((String)list.get(0));
                int n4 = ((LayoutComponent)object).getLinkSizeId(n);
                ((LayoutComponent)object).setLinkSizeId(-1, n);
                map.remove(n3);
                LayoutEvent layoutEvent = new LayoutEvent(this, 9);
                layoutEvent.setLinkSizeGroup((LayoutComponent)object, n4, -1, n);
                this.addChange(layoutEvent);
                this.fireEvent(layoutEvent);
            }
            if (list.size() == 0) {
                map.remove(n3);
            }
            object = new LayoutEvent(this, 9);
            ((LayoutEvent)object).setLinkSizeGroup(layoutComponent, n2, -1, n);
            this.addChange((LayoutEvent)object);
            this.fireEvent((LayoutEvent)object);
        }
    }

    public int areComponentsLinkSized(List list, int n) {
        if (list.size() == 1) {
            String string = (String)list.get(0);
            boolean bl = this.getLayoutComponent(string).isLinkSized(n);
            return bl ? 1 : 0;
        }
        Iterator iterator = list.iterator();
        boolean bl = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LayoutComponent layoutComponent = this.getLayoutComponent(string);
            Integer n2 = new Integer(layoutComponent.getLinkSizeId(n));
            if (!arrayList.contains(n2)) {
                arrayList.add(n2);
            }
            if (arrayList.size() <= 2) continue;
            return -1;
        }
        if (arrayList.size() == 1) {
            if (arrayList.contains(new Integer(-1))) {
                return 0;
            }
            return 1;
        }
        if (arrayList.contains(new Integer(-1))) {
            return 0;
        }
        return -1;
    }

    Map getLinkSizeGroups(int n) {
        if (0 == n) {
            return this.linkSizeGroupsH;
        }
        if (1 == n) {
            return this.linkSizeGroupsV;
        }
        return null;
    }

    public void unsetSameSize(List list, int n) {
        for (String string : list) {
            LayoutComponent layoutComponent = this.getLayoutComponent(string);
            this.removeComponentFromLinkSizedGroup(layoutComponent, n);
        }
    }

    public void setSameSize(List list, int n) {
        Iterator iterator = list.iterator();
        int n2 = this.findGroupId(list, n);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LayoutComponent layoutComponent = this.getLayoutComponent(string);
            this.addComponentToLinkSizedGroup(n2, layoutComponent.getId(), n);
        }
    }

    private int findGroupId(List list, int n) {
        for (String string : list) {
            LayoutComponent layoutComponent = this.getLayoutComponent(string);
            if (!layoutComponent.isLinkSized(n)) continue;
            return layoutComponent.getLinkSizeId(n);
        }
        return ++this.maxLinkGroupId;
    }

    private class LayoutUndoableEdit
    extends AbstractUndoableEdit {
        private Object startMark;
        private Object endMark;

        private LayoutUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.endMark == null) {
                assert (LayoutModel.this.lastUndoableEdit == this);
                this.endMark = LayoutModel.this.getChangeMark();
                LayoutModel.this.lastUndoableEdit = null;
            }
            LayoutModel.this.undo(this.startMark, this.endMark);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            LayoutModel.this.redo(this.startMark, this.endMark);
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }

        public void die() {
            LayoutModel.this.releaseChanges(this.startMark, this.endMark != null ? this.endMark : LayoutModel.this.getChangeMark());
        }
    }

    static interface Listener {
        public void layoutChanged(LayoutEvent var1);
    }

    private class RegionInfo {
        private LayoutInterval horizontal = null;
        private LayoutInterval vertical = null;
        private Map idToBounds;
        private int minx;
        private int maxx;
        private int miny;
        private int maxy;
        private int dimension;

        public RegionInfo(Map map) {
            this.idToBounds = map;
            this.dimension = -1;
            this.miny = 0;
            this.minx = 0;
            this.updateRegionBounds();
        }

        private RegionInfo(Map map, int n) {
            this.idToBounds = map;
            this.dimension = n;
            this.miny = Short.MAX_VALUE;
            this.minx = Short.MAX_VALUE;
            this.updateRegionBounds();
        }

        private void updateRegionBounds() {
            this.maxx = Short.MIN_VALUE;
            this.maxy = Short.MIN_VALUE;
            for (Rectangle rectangle : this.idToBounds.values()) {
                this.minx = Math.min(this.minx, rectangle.x);
                this.miny = Math.min(this.miny, rectangle.y);
                this.maxx = Math.max(this.maxx, rectangle.x + rectangle.width);
                this.maxy = Math.max(this.maxy, rectangle.y + rectangle.height);
            }
        }

        public void calculateIntervals() {
            Object object;
            Iterator<Object> iterator;
            if (this.idToBounds.size() == 1) {
                String string = (String)this.idToBounds.keySet().iterator().next();
                Rectangle rectangle = (Rectangle)this.idToBounds.get(string);
                LayoutComponent layoutComponent = LayoutModel.this.getLayoutComponent(string);
                this.horizontal = layoutComponent.getLayoutInterval(0);
                this.horizontal = this.prefixByGap(this.horizontal, rectangle.x - this.minx);
                this.vertical = layoutComponent.getLayoutInterval(1);
                this.vertical = this.prefixByGap(this.vertical, rectangle.y - this.miny);
                return;
            }
            int n = -1;
            List list = null;
            HashMap hashMap = null;
            do {
                boolean bl;
                boolean bl2 = bl = this.dimension == -1 && n == 0 || this.dimension != -1 && n != -1;
                if (bl) {
                    n = -1;
                }
                if (this.dimension == -1) {
                    switch (n) {
                        case -1: {
                            n = 1;
                            break;
                        }
                        case 1: {
                            n = 0;
                            break;
                        }
                        case 0: {
                            bl = true;
                        }
                    }
                } else {
                    n = this.dimension;
                }
                if (bl) {
                    iterator = (String)this.idToBounds.keySet().iterator().next();
                    Object object2 = (Rectangle)this.idToBounds.remove(iterator);
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    hashMap.put(iterator, (Rectangle)object2);
                }
                iterator = this.createPossibleCuts(n);
                list = this.cutIntoParts((Set)((Object)iterator), n);
            } while (!this.idToBounds.isEmpty() && list.isEmpty());
            this.dimension = n;
            LinkedList<RegionInfo> linkedList = new LinkedList<RegionInfo>();
            for (Object object2 : list) {
                object = new RegionInfo((Map)object2, this.dimension == 0 ? 1 : 0);
                ((RegionInfo)object).calculateIntervals();
                linkedList.add((RegionInfo)object);
            }
            this.mergeSubRegions(linkedList, this.dimension);
            if (hashMap != null) {
                for (int i = 0; i <= 1; ++i) {
                    Object object3;
                    iterator = hashMap.entrySet().iterator();
                    Object object4 = object = i == 0 ? this.horizontal : this.vertical;
                    if (!((LayoutInterval)object).isParallel()) {
                        object3 = new LayoutInterval(103);
                        LayoutModel.this.addInterval((LayoutInterval)object, (LayoutInterval)object3, -1);
                        if (i == 0) {
                            this.horizontal = object3;
                        } else {
                            this.vertical = object3;
                        }
                        object = object3;
                    }
                    while (iterator.hasNext()) {
                        object3 = (Map.Entry)iterator.next();
                        String string = (String)object3.getKey();
                        Rectangle rectangle = (Rectangle)object3.getValue();
                        LayoutComponent layoutComponent = LayoutModel.this.getLayoutComponent(string);
                        LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(i);
                        int n2 = i == 0 ? rectangle.x - this.minx : rectangle.y - this.miny;
                        layoutInterval = this.prefixByGap(layoutInterval, n2);
                        LayoutModel.this.addInterval(layoutInterval, (LayoutInterval)object, -1);
                    }
                }
            }
        }

        private SortedSet createPossibleCuts(int n) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (String string : this.idToBounds.keySet()) {
                Rectangle rectangle = (Rectangle)this.idToBounds.get(string);
                int n2 = n == 0 ? rectangle.x : rectangle.y;
                treeSet.add(new Integer(n2));
            }
            treeSet.add(new Integer(n == 0 ? this.maxx : this.maxy));
            return treeSet;
        }

        private List cutIntoParts(Set set, int n) {
            LinkedList linkedList = new LinkedList();
            for (Integer n2 : set) {
                int n3 = n2;
                boolean bl = true;
                HashMap<String, Rectangle> hashMap = new HashMap<String, Rectangle>();
                HashMap<String, Rectangle> hashMap2 = new HashMap<String, Rectangle>();
                Iterator iterator = this.idToBounds.entrySet().iterator();
                while (bl && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    Rectangle rectangle = (Rectangle)entry.getValue();
                    int n4 = n == 0 ? rectangle.x : rectangle.y;
                    int n5 = n4 + (n == 0 ? rectangle.width : rectangle.height);
                    if (n4 >= n3) {
                        hashMap2.put(string, rectangle);
                        continue;
                    }
                    if (n5 <= n3) {
                        hashMap.put(string, rectangle);
                        continue;
                    }
                    bl = false;
                }
                if (!bl || hashMap.isEmpty() || linkedList.isEmpty() && hashMap.size() == this.idToBounds.size()) continue;
                this.idToBounds.keySet().removeAll(hashMap.keySet());
                linkedList.add(hashMap);
            }
            return linkedList;
        }

        private void mergeSubRegions(List list, int n) {
            if (list.size() == 0) {
                this.horizontal = new LayoutInterval(103);
                this.vertical = new LayoutInterval(103);
                return;
            }
            LayoutInterval layoutInterval = new LayoutInterval(102);
            LayoutInterval layoutInterval2 = new LayoutInterval(103);
            int n2 = n == 0 ? this.minx : this.miny;
            for (RegionInfo regionInfo : list) {
                int n3;
                int n4;
                LayoutInterval layoutInterval3;
                LayoutInterval layoutInterval4;
                if (n == 0) {
                    layoutInterval4 = regionInfo.horizontal;
                    layoutInterval3 = regionInfo.vertical;
                    n4 = regionInfo.miny - this.miny;
                    n3 = regionInfo.minx - n2;
                    n2 = regionInfo.maxx;
                } else {
                    layoutInterval4 = regionInfo.vertical;
                    layoutInterval3 = regionInfo.horizontal;
                    n4 = regionInfo.minx - this.minx;
                    n3 = regionInfo.miny - n2;
                    n2 = regionInfo.maxy;
                }
                if (n3 > 0) {
                    LayoutInterval layoutInterval5 = new LayoutInterval(101);
                    layoutInterval5.setSize(n3);
                    LayoutModel.this.addInterval(layoutInterval5, layoutInterval, -1);
                }
                LayoutModel.this.addInterval(layoutInterval4, layoutInterval, -1);
                layoutInterval3 = this.prefixByGap(layoutInterval3, n4);
                LayoutModel.this.addInterval(layoutInterval3, layoutInterval2, -1);
            }
            if (n == 0) {
                this.horizontal = layoutInterval;
                this.vertical = layoutInterval2;
            } else {
                this.horizontal = layoutInterval2;
                this.vertical = layoutInterval;
            }
        }

        private LayoutInterval prefixByGap(LayoutInterval layoutInterval, int n) {
            if (n > 0) {
                LayoutInterval layoutInterval2 = new LayoutInterval(101);
                layoutInterval2.setSize(n);
                if (layoutInterval.isSequential()) {
                    LayoutModel.this.addInterval(layoutInterval2, layoutInterval, 0);
                } else {
                    LayoutInterval layoutInterval3 = new LayoutInterval(102);
                    LayoutModel.this.addInterval(layoutInterval2, layoutInterval3, -1);
                    LayoutModel.this.addInterval(layoutInterval, layoutInterval3, -1);
                    layoutInterval = layoutInterval3;
                }
            }
            return layoutInterval;
        }

        public LayoutInterval getInterval(int n) {
            return n == 0 ? this.horizontal : this.vertical;
        }
    }
}

