/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class LayoutPersistenceManager
implements LayoutConstants {
    private LayoutModel layoutModel;
    private LayoutComponent root;
    private int dimension;
    private Map<String, String> idNameMap;
    private boolean humanReadable;
    private int indent;
    private StringBuffer sb;
    static final String XML_DIMENSION_LAYOUT = "DimensionLayout";
    static final String XML_GROUP = "Group";
    static final String XML_COMPONENT = "Component";
    static final String XML_EMPTY_SPACE = "EmptySpace";
    static final String ATTR_DIMENSION_DIM = "dim";
    static final String ATTR_GROUP_TYPE = "type";
    static final String ATTR_SIZE_MIN = "min";
    static final String ATTR_SIZE_PREF = "pref";
    static final String ATTR_SIZE_MAX = "max";
    static final String ATTR_ALIGNMENT = "alignment";
    static final String ATTR_GROUP_ALIGNMENT = "groupAlignment";
    static final String ATTR_LINK_SIZE = "linkSize";
    static final String ATTR_COMPONENT_ID = "id";
    static final String ATTR_ATTRIBUTES = "attributes";
    static final String VALUE_DIMENSION_HORIZONTAL = "horizontal";
    static final String VALUE_DIMENSION_VERTICAL = "vertical";
    static final String VALUE_ALIGNMENT_LEADING = "leading";
    static final String VALUE_ALIGNMENT_TRAILING = "trailing";
    static final String VALUE_ALIGNMENT_CENTER = "center";
    static final String VALUE_ALIGNMENT_BASELINE = "baseline";
    static final String VALUE_SIZE_PREFERRED = "$pref";
    static final String VALUE_SIZE_MAX = "Short.MAX_VALUE";
    static final String VALUE_GROUP_PARALLEL = "parallel";
    static final String VALUE_GROUP_SEQUENTIAL = "sequential";
    private final String TEMPORARY_ID = "<temp_id>";
    private String missingNameH;
    private String missingNameV;

    LayoutPersistenceManager(LayoutModel layoutModel) {
        this.layoutModel = layoutModel;
    }

    String saveLayout(int n, LayoutComponent layoutComponent, Map map, boolean bl) {
        this.root = layoutComponent;
        this.indent = n;
        this.idNameMap = map;
        this.humanReadable = bl;
        this.sb = new StringBuffer();
        for (int i = 0; i < 2; ++i) {
            this.indent().append('<').append(XML_DIMENSION_LAYOUT);
            this.sb.append(' ').append(ATTR_DIMENSION_DIM).append("=\"");
            if (bl) {
                switch (i) {
                    case 0: {
                        this.sb.append(VALUE_DIMENSION_HORIZONTAL);
                        break;
                    }
                    case 1: {
                        this.sb.append(VALUE_DIMENSION_VERTICAL);
                        break;
                    }
                    default: {
                        this.sb.append(i);
                        break;
                    }
                }
            } else {
                this.sb.append(i);
            }
            this.sb.append("\">\n");
            LayoutInterval layoutInterval = layoutComponent.getLayoutRoot(i);
            this.saveInterval(layoutInterval, i);
            this.indent().append("</").append(XML_DIMENSION_LAYOUT).append(">\n");
        }
        return this.sb.toString();
    }

    String saveIntervalLayout(int n, LayoutInterval layoutInterval, int n2) {
        this.indent = n;
        this.humanReadable = true;
        this.sb = new StringBuffer();
        this.saveInterval(layoutInterval, n2);
        return this.sb.toString();
    }

    private void saveInterval(LayoutInterval layoutInterval, int n) {
        ++this.indent;
        this.indent();
        if (layoutInterval.isGroup()) {
            this.sb.append('<').append(XML_GROUP).append(' ');
            this.sb.append(ATTR_GROUP_TYPE).append("=\"");
            if (this.humanReadable) {
                this.sb.append(layoutInterval.isParallel() ? VALUE_GROUP_PARALLEL : VALUE_GROUP_SEQUENTIAL);
            } else {
                this.sb.append(layoutInterval.getType());
            }
            this.sb.append("\"");
            this.saveAlignment(layoutInterval.getRawAlignment(), false);
            if (layoutInterval.isParallel()) {
                this.saveAlignment(layoutInterval.getGroupAlignment(), true);
            }
            this.saveSize(layoutInterval.getMinimumSize(), ATTR_SIZE_MIN);
            this.saveSize(layoutInterval.getMaximumSize(), ATTR_SIZE_MAX);
            this.saveAttributes(layoutInterval.getAttributes());
            this.sb.append(">\n");
            ++this.indent;
            Iterator iterator = layoutInterval.getSubIntervals();
            while (iterator.hasNext()) {
                LayoutInterval layoutInterval2 = (LayoutInterval)iterator.next();
                this.saveInterval(layoutInterval2, n);
            }
            --this.indent;
            this.indent().append("</").append(XML_GROUP).append(">\n");
        } else {
            if (layoutInterval.isComponent()) {
                String string = layoutInterval.getComponent().getId();
                if (this.idNameMap != null) {
                    string = this.idNameMap.get(string);
                    assert (string != null);
                }
                this.sb.append('<').append(XML_COMPONENT).append(' ');
                this.sb.append(ATTR_COMPONENT_ID).append("=\"").append(string).append("\"");
                this.saveLinkSize(layoutInterval.getComponent().getLinkSizeId(n));
                this.saveAlignment(layoutInterval.getRawAlignment(), false);
            } else if (layoutInterval.isEmptySpace()) {
                this.sb.append('<').append(XML_EMPTY_SPACE);
            } else assert (false);
            this.saveSize(layoutInterval.getMinimumSize(), ATTR_SIZE_MIN);
            this.saveSize(layoutInterval.getPreferredSize(), ATTR_SIZE_PREF);
            this.saveSize(layoutInterval.getMaximumSize(), ATTR_SIZE_MAX);
            this.saveAttributes(layoutInterval.getAttributes());
            this.sb.append("/>\n");
        }
        --this.indent;
    }

    private void saveLinkSize(int n) {
        if (n != -1) {
            this.sb.append(" ").append(ATTR_LINK_SIZE).append("=\"").append(n).append("\"");
        }
    }

    private void saveAlignment(int n, boolean bl) {
        String string = " " + (bl ? ATTR_GROUP_ALIGNMENT : ATTR_ALIGNMENT) + "=\"";
        if (this.humanReadable) {
            if (n != -1) {
                this.sb.append(string);
                switch (n) {
                    case 0: {
                        this.sb.append(VALUE_ALIGNMENT_LEADING);
                        break;
                    }
                    case 1: {
                        this.sb.append(VALUE_ALIGNMENT_TRAILING);
                        break;
                    }
                    case 2: {
                        this.sb.append(VALUE_ALIGNMENT_CENTER);
                        break;
                    }
                    case 3: {
                        this.sb.append(VALUE_ALIGNMENT_BASELINE);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.sb.append("\"");
            }
        } else if (n != -1) {
            this.sb.append(string).append(n).append("\"");
        }
    }

    private void saveSize(int n, String string) {
        String string2 = " " + string + "=\"";
        if (this.humanReadable) {
            if (n != -1) {
                this.sb.append(string2);
                if (n == -2) {
                    this.sb.append(VALUE_SIZE_PREFERRED);
                } else if (n == Short.MAX_VALUE) {
                    this.sb.append(VALUE_SIZE_MAX);
                } else {
                    this.sb.append(n);
                }
                this.sb.append("\"");
            }
        } else if (n != -1) {
            this.sb.append(string2).append(n).append("\"");
        }
    }

    private void saveAttributes(int n) {
        if (!this.humanReadable) {
            n &= 0x23;
        }
        this.sb.append(' ').append(ATTR_ATTRIBUTES).append("=\"");
        this.sb.append(n).append("\"");
    }

    private StringBuffer indent() {
        char[] cArray = new char[2 * this.indent];
        Arrays.fill(cArray, ' ');
        return this.sb.append(cArray);
    }

    void loadModel(String string, NodeList nodeList, Map map) throws IOException {
        this.idNameMap = map;
        this.resetMissingName();
        LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string);
        if (layoutComponent == null) {
            layoutComponent = new LayoutComponent(string, true);
            this.layoutModel.addRootComponent(layoutComponent);
        }
        this.root = layoutComponent;
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Node node2 = node.getAttributes().getNamedItem(ATTR_DIMENSION_DIM);
            this.dimension = LayoutPersistenceManager.integerFromNode(node2);
            LayoutInterval layoutInterval = layoutComponent.getLayoutRoot(this.dimension);
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node3 = nodeList2.item(j);
                if (!(node3 instanceof Element)) continue;
                this.loadGroup(layoutInterval, node3, this.dimension);
                continue block0;
            }
        }
        this.correctMissingName();
    }

    private void loadGroup(LayoutInterval layoutInterval, Node node, int n) throws IOException {
        int n2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(ATTR_ALIGNMENT);
        Node node3 = namedNodeMap.getNamedItem(ATTR_GROUP_ALIGNMENT);
        Node node4 = namedNodeMap.getNamedItem(ATTR_SIZE_MIN);
        Node node5 = namedNodeMap.getNamedItem(ATTR_SIZE_MAX);
        int n3 = node2 == null ? -1 : LayoutPersistenceManager.integerFromNode(node2);
        layoutInterval.setAlignment(n3);
        if (layoutInterval.isParallel()) {
            int n4 = n2 = node3 == null ? -1 : LayoutPersistenceManager.integerFromNode(node3);
            if (n2 != -1) {
                layoutInterval.setGroupAlignment(n2);
            }
        }
        n2 = node4 == null ? -1 : LayoutPersistenceManager.integerFromNode(node4);
        int n5 = node5 == null ? -1 : LayoutPersistenceManager.integerFromNode(node5);
        layoutInterval.setMinimumSize(n2);
        layoutInterval.setMaximumSize(n5);
        this.loadAttributes(layoutInterval, namedNodeMap);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node6 = nodeList.item(i);
            if (!(node6 instanceof Element)) continue;
            String string = node6.getNodeName();
            if (XML_GROUP.equals(string)) {
                Node node7 = node6.getAttributes().getNamedItem(ATTR_GROUP_TYPE);
                int n6 = LayoutPersistenceManager.integerFromNode(node7);
                LayoutInterval layoutInterval2 = new LayoutInterval(n6);
                layoutInterval.add(layoutInterval2, -1);
                this.loadGroup(layoutInterval2, node6, n);
                continue;
            }
            if (XML_EMPTY_SPACE.equals(string)) {
                this.loadEmptySpace(layoutInterval, node6);
                continue;
            }
            assert (XML_COMPONENT.equals(string));
            this.loadComponent(layoutInterval, node6, n);
        }
        if (n == 1) {
            this.checkAndFixGroup(layoutInterval);
        }
    }

    private void loadEmptySpace(LayoutInterval layoutInterval, Node node) {
        LayoutInterval layoutInterval2 = new LayoutInterval(101);
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.loadSizes(layoutInterval2, namedNodeMap);
        this.loadAttributes(layoutInterval2, namedNodeMap);
        layoutInterval.add(layoutInterval2, -1);
    }

    private void loadComponent(LayoutInterval layoutInterval, Node node, int n) throws IOException {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem(ATTR_COMPONENT_ID).getNodeValue();
        Node node3 = namedNodeMap.getNamedItem(ATTR_LINK_SIZE);
        String string2 = this.idNameMap.get(string);
        if (string2 == null) {
            string2 = this.useTemporaryId(string);
        }
        int n2 = (node2 = namedNodeMap.getNamedItem(ATTR_ALIGNMENT)) == null ? -1 : LayoutPersistenceManager.integerFromNode(node2);
        LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string2);
        if (layoutComponent == null) {
            layoutComponent = new LayoutComponent(string2, false);
        }
        if (layoutComponent.getParent() == null) {
            this.layoutModel.addComponent(layoutComponent, this.root, -1);
        }
        LayoutInterval layoutInterval2 = layoutComponent.getLayoutInterval(n);
        layoutInterval2.setAlignment(n2);
        if (node3 != null) {
            this.layoutModel.addComponentToLinkSizedGroup(LayoutPersistenceManager.integerFromNode(node3), layoutComponent.getId(), n);
        }
        this.loadSizes(layoutInterval2, namedNodeMap);
        this.loadAttributes(layoutInterval2, namedNodeMap);
        layoutInterval.add(layoutInterval2, -1);
    }

    private void loadSizes(LayoutInterval layoutInterval, NamedNodeMap namedNodeMap) {
        Node node = namedNodeMap.getNamedItem(ATTR_SIZE_MIN);
        Node node2 = namedNodeMap.getNamedItem(ATTR_SIZE_PREF);
        Node node3 = namedNodeMap.getNamedItem(ATTR_SIZE_MAX);
        int n = node == null ? -1 : LayoutPersistenceManager.integerFromNode(node);
        int n2 = node2 == null ? -1 : LayoutPersistenceManager.integerFromNode(node2);
        int n3 = node3 == null ? -1 : LayoutPersistenceManager.integerFromNode(node3);
        layoutInterval.setSizes(n, n2, n3);
    }

    private void loadAttributes(LayoutInterval layoutInterval, NamedNodeMap namedNodeMap) {
        Node node = namedNodeMap.getNamedItem(ATTR_ATTRIBUTES);
        int n = 0;
        if (node != null) {
            n = LayoutPersistenceManager.integerFromNode(node);
            n &= 0x23;
        }
        layoutInterval.setAttributes(n);
    }

    private static int integerFromNode(Node node) {
        String string = node.getNodeValue();
        return Integer.parseInt(string);
    }

    void checkAndFixGroup(LayoutInterval layoutInterval) {
        if (layoutInterval.isParallel()) {
            LayoutInterval layoutInterval2;
            int n = layoutInterval.getGroupAlignment();
            int n2 = 0;
            Iterator iterator = layoutInterval.getSubIntervals();
            while (iterator.hasNext()) {
                layoutInterval2 = (LayoutInterval)iterator.next();
                if (layoutInterval2.getAlignment() != 3) continue;
                if (!layoutInterval2.isComponent()) {
                    layoutInterval2.setAlignment(n == 3 ? 0 : -1);
                    this.layoutModel.setCorrected();
                    System.err.println("WARNING: Invalid use of BASELINE [1], corrected automatically");
                    continue;
                }
                ++n2;
            }
            if (n2 > 0) {
                if (n2 < layoutInterval.getSubIntervalCount()) {
                    layoutInterval2 = new LayoutInterval(103);
                    layoutInterval2.setGroupAlignment(3);
                    int n3 = 0;
                    while (n3 < layoutInterval.getSubIntervalCount()) {
                        LayoutInterval layoutInterval3 = layoutInterval.getSubInterval(n3);
                        if (layoutInterval3.getAlignment() == 3) {
                            layoutInterval.remove(n3);
                            layoutInterval2.add(layoutInterval3, -1);
                            continue;
                        }
                        ++n3;
                    }
                    if (n == 3) {
                        layoutInterval.setGroupAlignment(0);
                    }
                    layoutInterval.add(layoutInterval2, -1);
                    this.layoutModel.setCorrected();
                    System.err.println("WARNING: Invalid use of BASELINE [2], corrected automatically");
                } else if (n != 3) {
                    layoutInterval.setGroupAlignment(3);
                    this.layoutModel.setCorrected();
                    System.err.println("WARNING: Invalid use of BASELINE [3], corrected automatically");
                }
            } else if (n == 3 && layoutInterval.getSubIntervalCount() > 0) {
                layoutInterval.setGroupAlignment(0);
                this.layoutModel.setCorrected();
                System.err.println("WARNING: Invalid use of BASELINE [4], corrected automatically");
            }
        }
    }

    private void resetMissingName() {
        this.missingNameV = null;
        this.missingNameH = null;
    }

    private String useTemporaryId(String string) throws IOException {
        if (this.dimension == 0) {
            if (this.missingNameH == null && (this.missingNameV == null || this.missingNameV.equals(string))) {
                this.missingNameH = string;
                return "<temp_id>";
            }
        } else if (this.dimension == 1 && this.missingNameV == null && (this.missingNameH == null || this.missingNameH.equals(string))) {
            this.missingNameV = string;
            return "<temp_id>";
        }
        throw new IOException("Undefined component referenced in layout: " + string);
    }

    private void correctMissingName() throws IOException {
        if (this.missingNameH == null && this.missingNameV == null) {
            return;
        }
        if (this.missingNameH != null && this.missingNameV != null && this.missingNameH.equals(this.missingNameV) && this.idNameMap.size() == this.root.getSubComponentCount()) {
            for (Map.Entry<String, String> entry : this.idNameMap.entrySet()) {
                String string = entry.getValue();
                LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string);
                if (layoutComponent == null) {
                    layoutComponent = this.layoutModel.getLayoutComponent("<temp_id>");
                    this.layoutModel.changeComponentId(layoutComponent, string);
                } else {
                    if (layoutComponent.getParent() != null) continue;
                    LayoutComponent layoutComponent2 = this.layoutModel.getLayoutComponent("<temp_id>");
                    this.layoutModel.replaceComponent(layoutComponent2, layoutComponent);
                }
                this.layoutModel.setCorrected();
                System.err.println("WARNING: Invalid component name in layout: " + this.missingNameH + ", corrected automatically to: " + entry.getKey());
                this.resetMissingName();
                return;
            }
        }
        this.layoutModel.removeComponent("<temp_id>", true);
        this.resetMissingName();
        throw new IOException("Undefined component referenced in layout: " + (this.missingNameH != null ? this.missingNameH : this.missingNameV));
    }
}

