/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Rectangle;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;

class LayoutRegion
implements LayoutConstants {
    static final int[] POINT_COUNT = new int[]{3, 4};
    static final int ALL_POINTS = Integer.MAX_VALUE;
    static final int NO_POINT = Integer.MIN_VALUE;
    static final int UNKNOWN = Integer.MIN_VALUE;
    int[][] positions = new int[2][];

    LayoutRegion() {
        this.positions[0] = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        this.positions[1] = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    }

    LayoutRegion(LayoutRegion layoutRegion) {
        this();
        this.set(layoutRegion);
    }

    boolean isSet() {
        return this.isSet(0) && this.isSet(1);
    }

    boolean isSet(int n) {
        return this.positions[n][0] != Integer.MIN_VALUE && this.positions[n][1] != Integer.MIN_VALUE;
    }

    int size(int n) {
        int n2 = this.positions[n][1];
        int n3 = this.positions[n][0];
        return n2 != Integer.MIN_VALUE && n3 != Integer.MIN_VALUE ? n2 - n3 : Integer.MIN_VALUE;
    }

    void set(Rectangle rectangle, int n) {
        int[] nArray = this.positions[0];
        nArray[0] = rectangle.x;
        nArray[1] = rectangle.x + rectangle.width;
        nArray[2] = rectangle.x + rectangle.width / 2;
        int[] nArray2 = this.positions[1];
        nArray2[0] = rectangle.y;
        nArray2[1] = rectangle.y + rectangle.height;
        nArray2[2] = rectangle.y + rectangle.height / 2;
        nArray2[3] = n;
    }

    Rectangle toRectangle(Rectangle rectangle) {
        int[] nArray = this.positions[0];
        rectangle.x = nArray[0];
        rectangle.width = nArray[1] - rectangle.x;
        int[] nArray2 = this.positions[1];
        rectangle.y = nArray2[0];
        rectangle.height = nArray2[1] - rectangle.y;
        return rectangle;
    }

    void set(LayoutRegion layoutRegion) {
        for (int i = 0; i < 2; ++i) {
            this.set(i, layoutRegion);
        }
    }

    void set(int n, LayoutRegion layoutRegion) {
        int[] nArray = this.positions[n];
        int[] nArray2 = layoutRegion.positions[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    void set(int n, int n2, int n3) {
        int[] nArray = this.positions[n];
        if (nArray[0] != n2 || nArray[1] != n3) {
            nArray[0] = n2;
            nArray[1] = n3;
            int n4 = nArray[2] = n2 != Integer.MIN_VALUE && n3 != Integer.MIN_VALUE ? (n2 + n3) / 2 : Integer.MIN_VALUE;
            if (n == 1) {
                nArray[3] = Integer.MIN_VALUE;
            }
        }
    }

    void reset() {
        for (int i = 0; i < 2; ++i) {
            int[] nArray = this.positions[i];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = Integer.MIN_VALUE;
            }
        }
    }

    void reshape(int[] nArray, int[] nArray2) {
        for (int i = 0; i < 2; ++i) {
            this.reshape(i, nArray != null ? nArray[i] : Integer.MAX_VALUE, nArray2[i]);
        }
    }

    void reshape(int n, int n2, int n3) {
        int[] nArray = this.positions[n];
        if (n2 == Integer.MAX_VALUE) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == Integer.MIN_VALUE) continue;
                int n4 = i;
                nArray[n4] = nArray[n4] + n3;
            }
        } else if (n2 != Integer.MIN_VALUE) {
            assert (n2 == 0 || n2 == 1);
            if (nArray[n2] != Integer.MIN_VALUE) {
                int n5 = n2;
                nArray[n5] = nArray[n5] + n3;
                if (nArray[0] != Integer.MIN_VALUE && nArray[1] != Integer.MIN_VALUE) {
                    if (nArray[0] > nArray[1]) {
                        nArray[n2] = nArray[n2 ^ 1];
                    }
                    nArray[2] = (nArray[0] + nArray[1]) / 2;
                }
                if (n == 1 && n3 != 0) {
                    nArray[3] = Integer.MIN_VALUE;
                }
            }
        }
    }

    void expand(LayoutRegion layoutRegion) {
        for (int i = 0; i < 2; ++i) {
            this.expand(layoutRegion, i);
        }
    }

    void expand(LayoutRegion layoutRegion, int n) {
        int[] nArray = this.positions[n];
        int[] nArray2 = layoutRegion.positions[n];
        if (nArray2[0] != Integer.MIN_VALUE && (nArray[0] == Integer.MIN_VALUE || nArray2[0] < nArray[0])) {
            nArray[0] = nArray2[0];
        }
        if (nArray2[1] != Integer.MIN_VALUE && (nArray[1] == Integer.MIN_VALUE || nArray2[1] > nArray[1])) {
            nArray[1] = nArray2[1];
        }
        if (nArray[0] != Integer.MIN_VALUE && nArray[1] != Integer.MIN_VALUE) {
            nArray[2] = (nArray[0] + nArray[1]) / 2;
        }
    }

    static boolean isValidCoordinate(int n) {
        return n > Short.MIN_VALUE && n < Short.MAX_VALUE;
    }

    static int distance(LayoutRegion layoutRegion, LayoutRegion layoutRegion2, int n, int n2, int n3) {
        int n4 = layoutRegion.positions[n][n2];
        int n5 = layoutRegion2.positions[n][n3];
        return n4 != Integer.MIN_VALUE && n5 != Integer.MIN_VALUE ? n5 - n4 : Integer.MIN_VALUE;
    }

    static int minDistance(LayoutRegion layoutRegion, LayoutRegion layoutRegion2, int n) {
        int[] nArray = layoutRegion.positions[n];
        int[] nArray2 = layoutRegion2.positions[n];
        int n2 = Integer.MIN_VALUE;
        int n3 = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n4;
            if (nArray[i] == Integer.MIN_VALUE || nArray2[i] == Integer.MIN_VALUE) continue;
            int n5 = nArray2[i] - nArray[i];
            if (n5 < 0) {
                n5 = -n5;
                n4 = -1;
            } else {
                n4 = 1;
            }
            if (n2 != Integer.MIN_VALUE && n5 >= n2) continue;
            n2 = n5;
            n3 = n4;
        }
        return n2 * n3;
    }

    static int nonOverlapDistance(LayoutRegion layoutRegion, LayoutRegion layoutRegion2, int n) {
        int[] nArray = layoutRegion2.positions[n];
        int[] nArray2 = layoutRegion.positions[n];
        int n2 = nArray[0] - nArray2[1];
        if (n2 >= 0) {
            return n2;
        }
        n2 = nArray[1] - nArray2[0];
        if (n2 <= 0) {
            return n2;
        }
        return 0;
    }

    static boolean pointInside(LayoutRegion layoutRegion, int n, LayoutRegion layoutRegion2, int n2) {
        int[] nArray = layoutRegion2.positions[n2];
        int n3 = layoutRegion.positions[n2][n];
        assert (n3 != Integer.MIN_VALUE && nArray[0] != Integer.MIN_VALUE && nArray[1] != Integer.MIN_VALUE);
        if (n == 0) {
            return n3 >= nArray[0] && n3 < nArray[1];
        }
        return n3 > nArray[0] && n3 <= nArray[1];
    }

    static boolean overlap(LayoutRegion layoutRegion, LayoutRegion layoutRegion2, int n, int n2) {
        int[] nArray = layoutRegion.positions[n];
        int[] nArray2 = layoutRegion2.positions[n];
        assert (nArray[0] != Integer.MIN_VALUE && nArray[1] != Integer.MIN_VALUE && nArray2[0] != Integer.MIN_VALUE && nArray2[1] != Integer.MIN_VALUE);
        return nArray[1] + n2 > nArray2[0] && nArray[0] - n2 < nArray2[1];
    }

    static boolean sameSpace(LayoutRegion layoutRegion, LayoutRegion layoutRegion2) {
        return LayoutRegion.sameSpace(layoutRegion, layoutRegion2, 0) && LayoutRegion.sameSpace(layoutRegion, layoutRegion2, 1);
    }

    static boolean sameSpace(LayoutRegion layoutRegion, LayoutRegion layoutRegion2, int n) {
        return layoutRegion.positions[n][0] == layoutRegion2.positions[n][0] && layoutRegion.positions[n][1] == layoutRegion2.positions[n][1];
    }
}

