/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.lang.reflect.Method;
import javax.swing.JScrollPane;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;

public class JScrollPaneSupport
extends AbstractLayoutSupport {
    private static Method setViewportViewMethod;
    private boolean assistantParams;

    public Class getSupportedClass() {
        return JScrollPane.class;
    }

    public boolean checkEmptyContainer(Container container) {
        return container instanceof JScrollPane && ((JScrollPane)container).getViewport().getView() == null;
    }

    public int getNewIndex(Container container, Container container2, Component component, int n, Point point, Point point2) {
        this.assistantParams = container instanceof JScrollPane && ((JScrollPane)container).getViewport().getView() == null;
        return this.assistantParams ? 0 : -1;
    }

    public String getAssistantContext() {
        return this.assistantParams ? "jscrollPaneLayout" : null;
    }

    public boolean paintDragFeedback(Container container, Container container2, Component component, LayoutConstraints layoutConstraints, int n, Graphics graphics) {
        if (container instanceof JScrollPane && ((JScrollPane)container).getViewport().getView() == null) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            graphics.drawRect(0, 0, dimension.width, dimension.height);
            return true;
        }
        return false;
    }

    public void addComponentsToContainer(Container container, Container container2, Component[] componentArray, int n) {
        if (componentArray.length == 0) {
            return;
        }
        if (container instanceof JScrollPane) {
            ((JScrollPane)container).setViewportView(componentArray[0]);
        }
    }

    public boolean removeComponentFromContainer(Container container, Container container2, Component component) {
        return false;
    }

    public boolean clearContainer(Container container, Container container2) {
        if (container instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            Component component = jScrollPane.getViewport().getView();
            if (component != null) {
                component.removeNotify();
                component.setBounds(0, 0, 0, 0);
            }
            jScrollPane.setViewportView(null);
            return true;
        }
        return super.clearContainer(container, container2);
    }

    protected CodeExpression getActiveContainerCodeExpression() {
        return this.getLayoutContext().getContainerCodeExpression();
    }

    protected CodeExpression readComponentCode(CodeStatement codeStatement, CodeGroup codeGroup) {
        if (JScrollPaneSupport.getSetViewportViewMethod().equals(codeStatement.getMetaObject()) || JScrollPaneSupport.getSimpleAddMethod().equals(codeStatement.getMetaObject())) {
            codeGroup.addStatement(codeStatement);
            this.getConstraintsList().add(null);
            return codeStatement.getStatementParameters()[0];
        }
        return null;
    }

    protected void createComponentCode(CodeGroup codeGroup, CodeExpression codeExpression, int n) {
        CodeStatement codeStatement = CodeStructure.createStatement(this.getLayoutContext().getContainerCodeExpression(), JScrollPaneSupport.getSetViewportViewMethod(), new CodeExpression[]{codeExpression});
        codeGroup.addStatement(codeStatement);
    }

    private static Method getSetViewportViewMethod() {
        if (setViewportViewMethod == null) {
            try {
                setViewportViewMethod = JScrollPane.class.getMethod("setViewportView", Component.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return setViewportViewMethod;
    }
}

