/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.CategorySelector;
import org.netbeans.modules.form.palette.PaletteItemDataObject;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public final class BeanInstaller {
    private static WeakReference wizardRef;

    private BeanInstaller() {
    }

    public static void installBeans(String string) {
        AddToPaletteWizard addToPaletteWizard = BeanInstaller.getAddWizard();
        if (addToPaletteWizard.show(string)) {
            BeanInstaller.createPaletteItems(string, addToPaletteWizard.getSelectedBeans(), addToPaletteWizard.getSelectedCategory());
        }
    }

    public static void installBeans(Node[] nodeArray) {
        Object object;
        Object object2;
        Object object3;
        final LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        for (int i = 0; i < nodeArray.length; ++i) {
            object3 = (DataObject)nodeArray[i].getCookie(DataObject.class);
            if (object3 == null) continue;
            object2 = object3.getPrimaryFile();
            object = new JavaClassHandler((FileObject)object2, linkedList2, linkedList){
                final /* synthetic */ FileObject val$fo;
                final /* synthetic */ List val$unableToInstall;
                final /* synthetic */ List val$beans;
                {
                    this.val$fo = fileObject;
                    this.val$unableToInstall = list;
                    this.val$beans = list2;
                }

                public void handle(String string) {
                    ClassSource classSource = ClassPathUtils.getProjectClassSource(this.val$fo, string);
                    if (classSource == null) {
                        this.val$unableToInstall.add(string);
                    } else {
                        this.val$beans.add(classSource);
                    }
                }
            };
            BeanInstaller.scanFileObject(object2.getParent(), object2, (JavaClassHandler)object);
        }
        if (linkedList2.size() > 0) {
            Iterator iterator = linkedList2.iterator();
            object3 = new StringBuffer();
            while (iterator.hasNext()) {
                ((StringBuffer)object3).append(iterator.next() + ", ");
            }
            ((StringBuffer)object3).delete(((StringBuffer)object3).length() - 2, ((StringBuffer)object3).length());
            object2 = PaletteUtils.getBundleString("MSG_cannotInstallBeans");
            object = MessageFormat.format((String)object2, ((StringBuffer)object3).toString());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message(object);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            if (linkedList.size() == 0) {
                return;
            }
        }
        if (linkedList.size() == 0) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)PaletteUtils.getBundleString("MSG_noBeansUnderNodes"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        String string = CategorySelector.selectCategory();
        if (string == null) {
            return;
        }
        object3 = PaletteUtils.getPaletteFolder().getFileObject(string);
        try {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction((FileObject)object3){
                final /* synthetic */ FileObject val$categoryFolder;
                {
                    this.val$categoryFolder = fileObject;
                }

                public void run() {
                    for (ClassSource classSource : linkedList) {
                        try {
                            PaletteItemDataObject.createFile(this.val$categoryFolder, classSource);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static List findJavaBeansInJar(File[] fileArray) {
        HashMap<String, ItemInfo> hashMap = null;
        for (int i = 0; i < fileArray.length; ++i) {
            Manifest manifest;
            try {
                manifest = new JarFile(fileArray[i]).getManifest();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                continue;
            }
            if (manifest == null) continue;
            String string = fileArray[i].getAbsolutePath();
            Map<String, Attributes> map = manifest.getEntries();
            for (Map.Entry<String, Attributes> entry : map.entrySet()) {
                String string2;
                String string3 = entry.getKey();
                if (!string3.endsWith(".class") || !"True".equalsIgnoreCase(string2 = entry.getValue().getValue("Java-Bean"))) continue;
                String string4 = string3.substring(0, string3.length() - 6).replace('\\', '/').replace('/', '.');
                if (string4.startsWith(".")) {
                    string4 = string4.substring(1);
                }
                ItemInfo itemInfo = new ItemInfo();
                itemInfo.classname = string4;
                itemInfo.source = string;
                if (hashMap == null) {
                    hashMap = new HashMap<String, ItemInfo>(100);
                }
                hashMap.put(itemInfo.classname, itemInfo);
            }
        }
        return hashMap != null ? new ArrayList(hashMap.values()) : null;
    }

    static List findJavaBeans(File[] fileArray) {
        HashMap hashMap = new HashMap(100);
        for (int i = 0; i < fileArray.length; ++i) {
            FileObject fileObject = FileUtil.toFileObject((File)fileArray[i]);
            if (fileObject == null) continue;
            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
            }
            if (fileObject == null || !fileObject.isFolder()) continue;
            BeanInstaller.scanFolderForBeans(fileObject, hashMap, fileArray[i].getAbsolutePath());
        }
        return new ArrayList(hashMap.values());
    }

    private static void createPaletteItems(final String string, final ItemInfo[] itemInfoArray, String string2) {
        if (itemInfoArray.length == 0) {
            return;
        }
        final FileObject fileObject = PaletteUtils.getPaletteFolder().getFileObject(string2);
        if (fileObject == null) {
            return;
        }
        try {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    String[] stringArray = new String[]{string};
                    for (int i = 0; i < itemInfoArray.length; ++i) {
                        try {
                            PaletteItemDataObject.createFile(fileObject, new ClassSource(itemInfoArray[i].classname, stringArray, new String[]{itemInfoArray[i].source}));
                            continue;
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void scanFolderForBeans(FileObject fileObject, final Map map, final String string) {
        JavaClassHandler javaClassHandler = new JavaClassHandler(){

            public void handle(String string2) {
                ItemInfo itemInfo = new ItemInfo();
                itemInfo.classname = string2;
                itemInfo.source = string;
                map.put(itemInfo.classname, itemInfo);
            }
        };
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            if (fileObject2.isFolder()) {
                BeanInstaller.scanFolderForBeans(fileObject2, map, string);
                continue;
            }
            try {
                if (!"class".equals(fileObject2.getExt()) || DataObject.find((FileObject)fileObject2) == null) continue;
                BeanInstaller.scanFileObject(fileObject, fileObject2, javaClassHandler);
                continue;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void scanFileObject(FileObject fileObject, FileObject fileObject2, JavaClassHandler javaClassHandler) {
        if ("class".equals(fileObject2.getExt())) {
            BeanInstaller.processClassFile(fileObject2, javaClassHandler);
        } else if ("java".equals(fileObject2.getExt())) {
            BeanInstaller.processJavaFile(fileObject2, javaClassHandler);
        }
    }

    public static String findJavaBeanName(FileObject fileObject) {
        final String[] stringArray = new String[1];
        BeanInstaller.scanFileObject(null, fileObject, new JavaClassHandler(){

            public void handle(String string) {
                stringArray[0] = string;
            }
        });
        return stringArray[0];
    }

    private static void processJavaFile(final FileObject fileObject, final JavaClassHandler javaClassHandler) {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = BeanInstaller.findClass(compilationController, fileObject.getName());
                    if (typeElement != null && BeanInstaller.isDeclaredAsJavaBean(typeElement)) {
                        javaClassHandler.handle(typeElement.getQualifiedName().toString());
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Logger.getLogger(BeanInstaller.class.getClass().getName()).log(Level.SEVERE, fileObject.toString(), iOException);
        }
    }

    private static TypeElement findClass(CompilationController compilationController, String string) {
        for (Tree tree : compilationController.getCompilationUnit().getTypeDecls()) {
            if (!string.equals(((ClassTree)tree).getSimpleName().toString())) continue;
            TreePath treePath = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), tree);
            TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath);
            return typeElement;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processClassFile(FileObject fileObject, JavaClassHandler javaClassHandler) {
        try {
            ClassFile classFile;
            InputStream inputStream = null;
            try {
                inputStream = fileObject.getInputStream();
                classFile = new ClassFile(inputStream, false);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (classFile != null && BeanInstaller.isDeclaredAsJavaBean(classFile)) {
                javaClassHandler.handle(classFile.getName().getExternalName());
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(BeanInstaller.class.getClass().getName()).log(Level.SEVERE, fileObject.toString(), iOException);
        }
    }

    public static boolean isDeclaredAsJavaBean(TypeElement typeElement) {
        Set<javax.lang.model.element.Modifier> set = typeElement.getModifiers();
        if (ElementKind.CLASS != typeElement.getKind() || !set.contains((Object)javax.lang.model.element.Modifier.PUBLIC) || set.contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            set = element.getModifiers();
            if (ElementKind.CONSTRUCTOR != element.getKind() || !set.contains((Object)javax.lang.model.element.Modifier.PUBLIC) || !((ExecutableElement)element).getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeclaredAsJavaBean(ClassFile classFile) {
        int n = classFile.getAccess();
        if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || Modifier.isInterface(n) || classFile.isAnnotation() || classFile.isEnum() || classFile.isSynthetic()) {
            return false;
        }
        for (Method method : classFile.getMethods()) {
            Method method2 = method;
            if (!method2.isPublic() || !method2.getParameters().isEmpty() || !"<init>".equals(method2.getName())) continue;
            return true;
        }
        return false;
    }

    private static AddToPaletteWizard getAddWizard() {
        AddToPaletteWizard addToPaletteWizard = null;
        if (wizardRef != null) {
            addToPaletteWizard = (AddToPaletteWizard)((Object)wizardRef.get());
        }
        if (addToPaletteWizard == null) {
            addToPaletteWizard = new AddToPaletteWizard();
            wizardRef = new WeakReference<AddToPaletteWizard>(addToPaletteWizard);
        }
        return addToPaletteWizard;
    }

    static class ItemInfo
    implements Comparable {
        String classname;
        String source;

        ItemInfo() {
        }

        public int compareTo(Object object) {
            ItemInfo itemInfo = (ItemInfo)object;
            int n = this.classname.lastIndexOf(46);
            String string = n >= 0 ? this.classname.substring(n + 1) : this.classname;
            n = itemInfo.classname.lastIndexOf(46);
            String string2 = n >= 0 ? itemInfo.classname.substring(n + 1) : itemInfo.classname;
            return string.compareTo(string2);
        }
    }

    private static interface JavaClassHandler {
        public void handle(String var1);
    }
}

