/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.BeanInstaller;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

class ChooseBeansWizardPanel
implements WizardDescriptor.Panel {
    private File[] currentFiles;
    private Map libraryNameMap;
    private List markedBeans;
    private List allBeans;
    private String sourceType;
    private BeanSelector beanSelector;
    private JLabel noBeansLabel;
    private EventListenerList listenerList;

    ChooseBeansWizardPanel() {
    }

    public Component getComponent() {
        if (this.markedBeans == null && (this.allBeans == null || this.allBeans.size() == 0)) {
            String string;
            if ("jar".equals(this.sourceType)) {
                string = "MSG_NoBeanInJAR";
            } else if ("library".equals(this.sourceType)) {
                string = "MSG_NoBeanInLibrary";
            } else if ("project".equals(this.sourceType)) {
                string = "MSG_NoBeanInProject";
            } else {
                throw new IllegalArgumentException();
            }
            this.noBeansLabel = new JLabel(PaletteUtils.getBundleString(string));
            this.noBeansLabel.setPreferredSize(new Dimension(400, 300));
            this.noBeansLabel.setVerticalAlignment(1);
            this.noBeansLabel.setName(PaletteUtils.getBundleString("CTL_NoBeans_Caption"));
            this.noBeansLabel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            return this.noBeansLabel;
        }
        if (this.beanSelector == null) {
            this.beanSelector = new BeanSelector();
            this.beanSelector.setName(PaletteUtils.getBundleString("CTL_SelectBeans_Caption"));
            this.beanSelector.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            if (this.markedBeans != null || this.allBeans != null) {
                this.beanSelector.setBeans(this.markedBeans, this.allBeans);
            }
            Listener listener = new Listener();
            this.beanSelector.list.addListSelectionListener(listener);
            this.beanSelector.radio1.addActionListener(listener);
            this.beanSelector.radio2.addActionListener(listener);
        }
        return this.beanSelector;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        return this.beanSelector != null && this.beanSelector.getSelectedBeans().size() > 0;
    }

    public void readSettings(Object object) {
        AddToPaletteWizard addToPaletteWizard = (AddToPaletteWizard)((Object)object);
        this.sourceType = addToPaletteWizard.getSourceType();
        File[] fileArray = addToPaletteWizard.getJARFiles();
        if (this.currentFiles != null && this.currentFiles.length == fileArray.length) {
            for (int i = 0; i < fileArray.length && fileArray[i].equals(this.currentFiles[i]); ++i) {
                if (i + 1 != fileArray.length) continue;
                return;
            }
        }
        this.currentFiles = fileArray;
        this.libraryNameMap = addToPaletteWizard.libraryNameMap;
        this.allBeans = null;
        this.markedBeans = BeanInstaller.findJavaBeansInJar(fileArray);
        if (this.markedBeans != null) {
            if (this.libraryNameMap != null) {
                ChooseBeansWizardPanel.remapLibraryNames(this.markedBeans, this.libraryNameMap);
            }
            Collections.sort(this.markedBeans);
        } else {
            this.allBeans = BeanInstaller.findJavaBeans(fileArray);
            if (this.libraryNameMap != null) {
                ChooseBeansWizardPanel.remapLibraryNames(this.allBeans, this.libraryNameMap);
            }
            Collections.sort(this.allBeans);
        }
        if (this.beanSelector != null) {
            this.beanSelector.setBeans(this.markedBeans, this.allBeans);
        }
    }

    public void storeSettings(Object object) {
        if (this.beanSelector != null) {
            List list = this.beanSelector.getSelectedBeans();
            BeanInstaller.ItemInfo[] itemInfoArray = new BeanInstaller.ItemInfo[list.size()];
            list.toArray(itemInfoArray);
            ((AddToPaletteWizard)((Object)object)).setSelectedBeans(itemInfoArray);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private static void remapLibraryNames(List list, Map map) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            BeanInstaller.ItemInfo itemInfo = (BeanInstaller.ItemInfo)list.get(i);
            itemInfo.source = (String)map.get(itemInfo.source);
        }
    }

    static class BeanSelector
    extends JPanel {
        JList list;
        JRadioButton radio1;
        JRadioButton radio2;

        BeanSelector() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)PaletteUtils.getBundleString("CTL_SelectBeans"));
            jLabel.setLabelFor(this.list);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            gridBagConstraints.anchor = 17;
            this.add((Component)jLabel, gridBagConstraints);
            this.list = new JList();
            this.list.setLayoutOrientation(1);
            this.list.setVisibleRowCount(0);
            this.list.setCellRenderer(new ItemInfoRenderer());
            this.list.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_CTL_SelectBeans"));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.list);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)jScrollPane, gridBagConstraints);
            this.radio1 = new JRadioButton();
            this.radio1.setActionCommand("SHOW MARKED");
            Mnemonics.setLocalizedText((AbstractButton)this.radio1, (String)PaletteUtils.getBundleString("CTL_ShowMarked"));
            this.radio1.setToolTipText(PaletteUtils.getBundleString("HINT_ShowMarked"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)this.radio1, gridBagConstraints);
            this.radio2 = new JRadioButton();
            this.radio2.setActionCommand("SHOW ALL");
            Mnemonics.setLocalizedText((AbstractButton)this.radio2, (String)PaletteUtils.getBundleString("CTL_ShowAllClasses"));
            this.radio2.setToolTipText(PaletteUtils.getBundleString("HINT_ShowAllClasses"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)this.radio2, gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.radio1);
            buttonGroup.add(this.radio2);
            this.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_SelectBeansDialog"));
        }

        void setBeans(List list, List list2) {
            if (list == null) {
                this.radio1.setEnabled(false);
            } else {
                this.radio1.setEnabled(true);
                this.radio1.setSelected(true);
                this.setDisplayedBeans(list);
            }
            if (list2 != null && list == null) {
                this.radio2.setSelected(true);
                this.setDisplayedBeans(list2);
            }
        }

        void setDisplayedBeans(final List list) {
            this.list.setModel(new AbstractListModel(){

                public int getSize() {
                    return list.size();
                }

                public Object getElementAt(int n) {
                    return list.get(n);
                }
            });
        }

        List getSelectedBeans() {
            Object[] objectArray = this.list.getSelectedValues();
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            return arrayList;
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 300);
        }
    }

    private static class ItemInfoRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        private static final Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public ItemInfoRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = ((BeanInstaller.ItemInfo)object).classname;
            this.setToolTipText(string);
            int n2 = string.lastIndexOf(46);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            this.setText(string);
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }

    class Listener
    implements ListSelectionListener,
    ActionListener {
        Listener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ChooseBeansWizardPanel.this.fireStateChanged();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("SHOW MARKED".equals(actionEvent.getActionCommand())) {
                ChooseBeansWizardPanel.this.beanSelector.setDisplayedBeans(ChooseBeansWizardPanel.this.markedBeans);
            } else if ("SHOW ALL".equals(actionEvent.getActionCommand())) {
                if (ChooseBeansWizardPanel.this.allBeans == null) {
                    ChooseBeansWizardPanel.this.allBeans = BeanInstaller.findJavaBeans(ChooseBeansWizardPanel.this.currentFiles);
                    if (ChooseBeansWizardPanel.this.libraryNameMap != null) {
                        ChooseBeansWizardPanel.remapLibraryNames(ChooseBeansWizardPanel.this.allBeans, ChooseBeansWizardPanel.this.libraryNameMap);
                        ChooseBeansWizardPanel.this.libraryNameMap = null;
                    }
                    Collections.sort(ChooseBeansWizardPanel.this.allBeans);
                }
                ChooseBeansWizardPanel.this.beanSelector.setDisplayedBeans(ChooseBeansWizardPanel.this.allBeans);
            }
        }
    }
}

