/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;

public class FallbackDefaultJavaPlatform
extends JavaPlatform {
    public FallbackDefaultJavaPlatform() {
        this.setSystemProperties(System.getProperties());
    }

    public String getDisplayName() {
        return System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.version");
    }

    public Map getProperties() {
        return Collections.singletonMap("platform.ant.name", "default_platform");
    }

    private static ClassPath sysProp2CP(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            URL uRL;
            File file = new File(stringTokenizer.nextToken());
            if (!file.exists()) continue;
            try {
                uRL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
            if (FileUtil.isArchiveFile((URL)uRL)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            }
            arrayList.add(uRL);
        }
        return ClassPathSupport.createClassPath((URL[])arrayList.toArray(new URL[arrayList.size()]));
    }

    private static ClassPath sampleClass2CP(Class clazz) {
        URL[] uRLArray;
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = codeSource.getLocation();
        } else {
            uRLArray = new URL[]{};
        }
        return ClassPathSupport.createClassPath((URL[])uRLArray);
    }

    public ClassPath getBootstrapLibraries() {
        ClassPath classPath = FallbackDefaultJavaPlatform.sysProp2CP("sun.boot.class.path");
        return classPath != null ? classPath : FallbackDefaultJavaPlatform.sampleClass2CP(Object.class);
    }

    public ClassPath getStandardLibraries() {
        ClassPath classPath = FallbackDefaultJavaPlatform.sysProp2CP("java.class.path");
        return classPath != null ? classPath : FallbackDefaultJavaPlatform.sampleClass2CP(Dependency.class);
    }

    public String getVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public Specification getSpecification() {
        return new Specification("J2SE", Dependency.JAVA_SPEC);
    }

    public Collection getInstallFolders() {
        return Collections.singleton(FileUtil.toFileObject((File)new File(System.getProperty("java.home"))));
    }

    public FileObject findTool(String string) {
        return null;
    }

    public ClassPath getSourceFolders() {
        return ClassPathSupport.createClassPath((URL[])new URL[0]);
    }

    public List getJavadocFolders() {
        return Collections.emptyList();
    }
}

