/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.platform.wizard.PlatformInstallIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class PlatformsCustomizer
extends JPanel
implements PropertyChangeListener,
VetoableChangeListener,
ExplorerManager.Provider {
    private static final String TEMPLATE = "Templates/Services/Platforms/org-netbeans-api-java-Platform/javaplatform.xml";
    private static final String STORAGE = "Services/Platforms/org-netbeans-api-java-Platform";
    private PlatformCategoriesChildren children;
    private ExplorerManager manager;
    private final JavaPlatform initialPlatform;
    private JButton addButton;
    private JPanel cards;
    private JPanel clientArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel messageArea;
    private JTextField platformHome;
    private JTextField platformName;
    private BeanTreeView platforms;
    private JButton removeButton;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PlatformsCustomizer(JavaPlatform javaPlatform) {
        this.initialPlatform = javaPlatform == null ? JavaPlatformManager.getDefault().getDefaultPlatform() : javaPlatform;
        this.initComponents();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray.length != 1) {
                this.selectPlatform(null);
            } else {
                this.selectPlatform(nodeArray[0]);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Node[] nodeArray;
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length > 1) {
            throw new PropertyVetoException("Invalid length", propertyChangeEvent);
        }
    }

    public synchronized ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.setRootContext((Node)new AbstractNode((Children)this.getChildren()));
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.manager.addVetoableChangeListener((VetoableChangeListener)this);
        }
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.expandPlatforms(this.initialPlatform);
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.platforms = new PlatformsView();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.cards = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.platformName = new JTextField();
        this.jLabel2 = new JLabel();
        this.platformHome = new JTextField();
        this.clientArea = new JPanel();
        this.messageArea = new JPanel();
        this.jLabel3 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.platforms.setPreferredSize(new Dimension(200, 334));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 12, 12, 6);
        this.add((Component)this.platforms, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle");
        this.platforms.getAccessibleContext().setAccessibleName(resourceBundle.getString("AN_PlatformsCustomizerPlatforms"));
        this.platforms.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_PlatformsCustomizerPlatforms"));
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("MNE_AddPlatform").charAt(0));
        this.addButton.setText(resourceBundle.getString("CTL_AddPlatform"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlatformsCustomizer.this.addNewPlatform(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_AddPlatform"));
        this.removeButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("MNE_Remove").charAt(0));
        this.removeButton.setText(resourceBundle.getString("CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlatformsCustomizer.this.removePlatform(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_Remove"));
        this.cards.setLayout(new CardLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("MNE_PlatformName").charAt(0));
        this.jLabel1.setLabelFor(this.platformName);
        this.jLabel1.setText(resourceBundle.getString("CTL_PlatformName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.platformName.setColumns(25);
        this.platformName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.platformName, gridBagConstraints);
        this.platformName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_PlatformName"));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/platform/ui/Bundle").getString("MNE_PlatformHome").charAt(0));
        this.jLabel2.setLabelFor(this.platformHome);
        this.jLabel2.setText(resourceBundle.getString("CTL_PlatformHome"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.platformHome.setColumns(25);
        this.platformHome.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel1.add((Component)this.platformHome, gridBagConstraints);
        this.platformHome.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_PlatformHome"));
        this.clientArea.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.clientArea, gridBagConstraints);
        this.cards.add((Component)this.jPanel1, "card2");
        this.messageArea.setLayout(new GridBagLayout());
        this.cards.add((Component)this.messageArea, "card3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 12, 12);
        this.add((Component)this.cards, gridBagConstraints);
        this.jLabel3.setLabelFor((Component)this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("TXT_PlatformsList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_PlatformsCustomizer"));
    }

    private void removePlatform(ActionEvent actionEvent) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length != 1) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Illegal number of selected nodes");
            }
            return;
        }
        DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Can not find platform definition for node: " + nodeArray[0].getDisplayName()));
            }
            return;
        }
        try {
            dataObject.delete();
            this.getChildren().refreshPlatforms();
            this.expandPlatforms(null);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewPlatform(ActionEvent actionEvent) {
        try {
            WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)PlatformInstallIterator.create());
            DataObject dataObject = DataObject.find((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(TEMPLATE));
            wizardDescriptor.putProperty("targetTemplate", (Object)dataObject);
            DataFolder dataFolder = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(STORAGE));
            wizardDescriptor.putProperty("targetFolder", (Object)dataFolder);
            wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
            wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
            wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
            wizardDescriptor.setTitle(NbBundle.getMessage((Class)PlatformsCustomizer.class, (String)"CTL_AddPlatformTitle"));
            wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            try {
                dialog.setVisible(true);
                if (wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION) {
                    this.getChildren().refreshPlatforms();
                    Set set = wizardDescriptor.getInstantiatedObjects();
                    this.expandPlatforms(set.size() == 0 ? null : (JavaPlatform)set.iterator().next());
                }
            }
            finally {
                dialog.dispose();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private synchronized PlatformCategoriesChildren getChildren() {
        if (this.children == null) {
            this.children = new PlatformCategoriesChildren();
        }
        return this.children;
    }

    private void selectPlatform(Node node) {
        Object object;
        this.clientArea.removeAll();
        this.messageArea.removeAll();
        this.removeButton.setEnabled(false);
        if (node == null) {
            ((CardLayout)this.cards.getLayout()).last(this.cards);
            return;
        }
        JPanel jPanel = this.messageArea;
        JavaPlatform javaPlatform = (JavaPlatform)node.getLookup().lookup(JavaPlatform.class);
        if (javaPlatform != null) {
            this.removeButton.setEnabled(PlatformsCustomizer.isDefaultPLatform(javaPlatform));
            if (javaPlatform.getInstallFolders().size() != 0) {
                File file;
                this.platformName.setText(node.getDisplayName());
                object = javaPlatform.getInstallFolders().iterator();
                if (object.hasNext() && (file = FileUtil.toFile((FileObject)((FileObject)object.next()))) != null) {
                    this.platformHome.setText(file.getAbsolutePath());
                }
                jPanel = this.clientArea;
            }
        }
        if (node.hasCustomizer() && (object = node.getCustomizer()) != null) {
            PlatformsCustomizer.addComponent(jPanel, (Component)object);
        }
        jPanel.revalidate();
        object = (CardLayout)this.cards.getLayout();
        if (jPanel == this.clientArea) {
            ((CardLayout)object).first(this.cards);
        } else {
            ((CardLayout)object).last(this.cards);
        }
    }

    private static void addComponent(Container container, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        ((GridBagLayout)container.getLayout()).setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private static boolean isDefaultPLatform(JavaPlatform javaPlatform) {
        JavaPlatform javaPlatform2 = JavaPlatformManager.getDefault().getDefaultPlatform();
        return javaPlatform2 != null && !javaPlatform2.equals(javaPlatform);
    }

    private void expandPlatforms(JavaPlatform javaPlatform) {
        ExplorerManager explorerManager = this.getExplorerManager();
        Node node = explorerManager.getRootContext();
        PlatformsCustomizer.expandAllNodes(this.platforms, node, explorerManager, javaPlatform);
    }

    private static void expandAllNodes(BeanTreeView beanTreeView, Node node, ExplorerManager explorerManager, JavaPlatform javaPlatform) {
        beanTreeView.expandNode(node);
        Children children = node.getChildren();
        if (children == Children.LEAF) {
            if (javaPlatform != null && javaPlatform.equals(node.getLookup().lookup(JavaPlatform.class))) {
                try {
                    explorerManager.setSelectedNodes(new Node[]{node});
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            return;
        }
        Node[] nodeArray = children.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            PlatformsCustomizer.expandAllNodes(beanTreeView, nodeArray[i], explorerManager, javaPlatform);
        }
    }

    static {
        $assertionsDisabled = !PlatformsCustomizer.class.desiredAssertionStatus();
    }

    private static class PlatformCategoriesChildren
    extends Children.Keys {
        private PlatformCategoriesChildren() {
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshPlatforms();
        }

        protected void removeNotify() {
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof PlatformCategoriesDescriptor) {
                PlatformCategoriesDescriptor platformCategoriesDescriptor = (PlatformCategoriesDescriptor)object;
                return new Node[]{new PlatformCategoryNode(platformCategoriesDescriptor)};
            }
            if (object instanceof Node) {
                return new Node[]{new FilterNode((Node)object, Children.LEAF)};
            }
            return new Node[0];
        }

        private void refreshPlatforms() {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(PlatformsCustomizer.STORAGE);
            if (fileObject != null) {
                HashMap<String, PlatformCategoriesDescriptor> hashMap = new HashMap<String, PlatformCategoriesDescriptor>();
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObjectArray[i]);
                        Node node = dataObject.getNodeDelegate();
                        JavaPlatform javaPlatform = (JavaPlatform)node.getLookup().lookup(class$org$netbeans$api$java$platform$JavaPlatform == null ? PlatformsCustomizer.class$("org.netbeans.api.java.platform.JavaPlatform") : class$org$netbeans$api$java$platform$JavaPlatform);
                        if (javaPlatform != null) {
                            String string = javaPlatform.getSpecification().getName();
                            if (string != null) {
                                PlatformCategoriesDescriptor platformCategoriesDescriptor = (PlatformCategoriesDescriptor)hashMap.get(string = string.toUpperCase(Locale.ENGLISH));
                                if (platformCategoriesDescriptor == null) {
                                    platformCategoriesDescriptor = new PlatformCategoriesDescriptor(string);
                                    hashMap.put(string, platformCategoriesDescriptor);
                                }
                                platformCategoriesDescriptor.add(node);
                                continue;
                            }
                            ErrorManager.getDefault().log("Platform: " + javaPlatform.getDisplayName() + " has invalid specification.");
                            continue;
                        }
                        ErrorManager.getDefault().log("Platform node for : " + node.getDisplayName() + " has no platform in its lookup.");
                        continue;
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                    }
                }
                ArrayList arrayList = new ArrayList(hashMap.values());
                Collections.sort(arrayList);
                this.setKeys(arrayList);
            }
        }
    }

    private static class PlatformCategoriesDescriptor
    implements Comparable {
        private final String categoryName;
        private final List platforms;
        private boolean changed = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public PlatformCategoriesDescriptor(String string) {
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            this.categoryName = string;
            this.platforms = new ArrayList();
        }

        public String getName() {
            return this.categoryName;
        }

        public List getPlatform() {
            if (this.changed) {
                Collections.sort(this.platforms, new PlatformNodeComparator());
                this.changed = false;
            }
            return Collections.unmodifiableList(this.platforms);
        }

        public void add(Node node) {
            this.platforms.add(node);
            this.changed = true;
        }

        public int hashCode() {
            return this.categoryName.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof PlatformCategoriesDescriptor) {
                PlatformCategoriesDescriptor platformCategoriesDescriptor = (PlatformCategoriesDescriptor)object;
                return this.categoryName.equals(platformCategoriesDescriptor.categoryName) && this.platforms.size() == platformCategoriesDescriptor.platforms.size();
            }
            return false;
        }

        public int compareTo(Object object) {
            if (!(object instanceof PlatformCategoriesDescriptor)) {
                throw new IllegalArgumentException();
            }
            PlatformCategoriesDescriptor platformCategoriesDescriptor = (PlatformCategoriesDescriptor)object;
            return this.categoryName.compareTo(platformCategoriesDescriptor.categoryName);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$platform$ui$PlatformsCustomizer == null ? (class$org$netbeans$modules$java$platform$ui$PlatformsCustomizer = PlatformsCustomizer.class$("org.netbeans.modules.java.platform.ui.PlatformsCustomizer")) : class$org$netbeans$modules$java$platform$ui$PlatformsCustomizer).desiredAssertionStatus();
        }
    }

    private static class PlatformCategoryNode
    extends AbstractNode {
        private final PlatformCategoriesDescriptor desc;
        private Node iconDelegate;

        public PlatformCategoryNode(PlatformCategoriesDescriptor platformCategoriesDescriptor) {
            super((Children)new PlatformsChildren(platformCategoriesDescriptor.getPlatform()));
            this.desc = platformCategoriesDescriptor;
            this.iconDelegate = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        }

        public String getName() {
            return this.desc.getName();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public Image getIcon(int n) {
            return this.iconDelegate.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.iconDelegate.getOpenedIcon(n);
        }
    }

    private static class PlatformNodeComparator
    implements Comparator {
        private PlatformNodeComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof Node) || !(object2 instanceof Node)) {
                throw new IllegalArgumentException();
            }
            String string = ((Node)object).getDisplayName();
            String string2 = ((Node)object2).getDisplayName();
            return string.compareTo(string2);
        }
    }

    private static class PlatformsChildren
    extends Children.Keys {
        private List platforms;

        public PlatformsChildren(List list) {
            this.platforms = list;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.platforms);
        }

        protected void removeNotify() {
            super.removeNotify();
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{new FilterNode((Node)object, Children.LEAF)};
        }
    }

    private static class PlatformsView
    extends BeanTreeView {
        public PlatformsView() {
            this.setPopupAllowed(false);
            this.setDefaultActionAllowed(false);
            this.setRootVisible(false);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(false);
            this.setBorder(UIManager.getBorder("Nb.ScrollPane.border"));
        }
    }
}

