/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.project.classpath;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.project.classpath.ProjectClassPathModifierAccessor;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class ProjectClassPathModifier {
    private ProjectClassPathModifier() {
    }

    public static boolean addLibraries(Library[] libraryArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible != null) {
            if (extensible.pcmi != null) {
                assert (extensible.sg != null);
                assert (extensible.classPathType != null);
                return ProjectClassPathModifierAccessor.INSTANCE.addLibraries(libraryArray, extensible.pcmi, extensible.sg, extensible.classPathType);
            }
            if (extensible.pcpe != null) {
                boolean bl = false;
                for (int i = 0; i < libraryArray.length; ++i) {
                    bl |= extensible.pcpe.addLibrary(libraryArray[i]);
                }
                return bl;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean removeLibraries(Library[] libraryArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible != null && extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeLibraries(libraryArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException();
    }

    public static boolean addRoots(URL[] uRLArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible != null) {
            if (extensible.pcmi != null) {
                assert (extensible.sg != null);
                assert (extensible.classPathType != null);
                return ProjectClassPathModifierAccessor.INSTANCE.addRoots(uRLArray, extensible.pcmi, extensible.sg, extensible.classPathType);
            }
            if (extensible.pcpe != null) {
                boolean bl = false;
                for (int i = 0; i < uRLArray.length; ++i) {
                    FileObject fileObject2;
                    URL uRL = uRLArray[i];
                    if ("jar".equals(uRL.getProtocol())) {
                        uRL = FileUtil.getArchiveFile((URL)uRL);
                    }
                    if ((fileObject2 = URLMapper.findFileObject((URL)uRL)) == null) {
                        throw new UnsupportedOperationException("Adding of a non existent root is not supported by project.");
                    }
                    bl |= extensible.pcpe.addArchiveFile(fileObject2);
                }
                return bl;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean removeRoots(URL[] uRLArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible != null && extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeRoots(uRLArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException();
    }

    public static boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible != null) {
            assert (antArtifactArray.length == uRIArray.length);
            if (extensible.pcmi != null) {
                assert (extensible.sg != null);
                assert (extensible.classPathType != null);
                return ProjectClassPathModifierAccessor.INSTANCE.addAntArtifacts(antArtifactArray, uRIArray, extensible.pcmi, extensible.sg, extensible.classPathType);
            }
            if (extensible.pcpe != null) {
                boolean bl = false;
                for (int i = 0; i < antArtifactArray.length; ++i) {
                    bl |= extensible.pcpe.addAntArtifact(antArtifactArray[i], uRIArray[i]);
                }
                return bl;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible != null && extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeAntArtifacts(antArtifactArray, uRIArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException();
    }

    private static Extensible findExtensible(FileObject fileObject, String string) {
        ProjectClassPathExtender projectClassPathExtender;
        assert (fileObject != null);
        assert (string != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ProjectClassPathModifierImplementation projectClassPathModifierImplementation = (ProjectClassPathModifierImplementation)project.getLookup().lookup(ProjectClassPathModifierImplementation.class);
        if (projectClassPathModifierImplementation != null) {
            SourceGroup[] sourceGroupArray = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(projectClassPathModifierImplementation);
            assert (sourceGroupArray != null) : "Class: " + projectClassPathModifierImplementation.getClass() + " returned null as source groups.";
            for (SourceGroup sourceGroup : sourceGroupArray) {
                if (fileObject != sourceGroup.getRootFolder() && !FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject) || !sourceGroup.contains(fileObject)) continue;
                String[] stringArray = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(projectClassPathModifierImplementation, sourceGroup);
                assert (stringArray != null) : "Class: " + projectClassPathModifierImplementation.getClass() + " returned null as classpath types.";
                for (String string2 : stringArray) {
                    if (!string.equals(string2)) continue;
                    return new Extensible(projectClassPathModifierImplementation, sourceGroup, string2);
                }
            }
        } else if (string.equals("classpath/compile") && (projectClassPathExtender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class)) != null) {
            return new Extensible(projectClassPathExtender);
        }
        return null;
    }

    private static final class Extensible {
        private final String classPathType;
        private final SourceGroup sg;
        private final ProjectClassPathModifierImplementation pcmi;
        private final ProjectClassPathExtender pcpe;

        private Extensible(ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string) {
            assert (projectClassPathModifierImplementation != null);
            assert (sourceGroup != null);
            assert (string != null);
            this.pcmi = projectClassPathModifierImplementation;
            this.sg = sourceGroup;
            this.classPathType = string;
            this.pcpe = null;
        }

        private Extensible(ProjectClassPathExtender projectClassPathExtender) {
            assert (projectClassPathExtender != null);
            this.pcpe = projectClassPathExtender;
            this.pcmi = null;
            this.sg = null;
            this.classPathType = "classpath/compile";
        }
    }
}

