/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.classpath.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener,
Runnable {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final File projectFolder;
    private List<PathResourceImplementation> resources;
    private final PropertyEvaluator evaluator;
    private boolean dirty = false;
    private final List<String> propertyNames;

    public ProjectClassPathImplementation(File file, String[] stringArray, PropertyEvaluator propertyEvaluator) {
        assert (file != null && stringArray != null && propertyEvaluator != null);
        this.projectFolder = file;
        this.evaluator = propertyEvaluator;
        this.propertyNames = Arrays.asList(stringArray);
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && !this.propertyNames.contains(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (!this.dirty) {
            this.dirty = true;
            ProjectManager.mutex().postReadRequest((Runnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.dirty = false;
        List<PathResourceImplementation> list = this.getPath();
        boolean bl = false;
        ProjectClassPathImplementation projectClassPathImplementation = this;
        synchronized (projectClassPathImplementation) {
            if (this.resources != null && !((Object)this.resources).equals(list)) {
                this.resources = list;
                bl = true;
            }
        }
        if (bl) {
            this.support.firePropertyChange("resources", null, null);
        }
    }

    private List<PathResourceImplementation> getPath() {
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        for (String string : this.propertyNames) {
            String string2 = this.evaluator.getProperty(string);
            if (string2 == null) continue;
            for (String string3 : PropertyUtils.tokenizePath((String)string2)) {
                File file = PropertyUtils.resolveFile((File)this.projectFolder, (String)string3);
                try {
                    URL uRL = file.toURI().toURL();
                    if (FileUtil.isArchiveFile((URL)uRL) || file.isFile() && file.length() < 4L) {
                        uRL = FileUtil.getArchiveRoot((URL)uRL);
                    } else if (!file.exists()) {
                        assert (!uRL.toExternalForm().endsWith("/")) : file;
                        uRL = new URL(uRL.toExternalForm() + "/");
                    } else if (file.isFile()) {
                        ErrorManager.getDefault().log(65536, "ProjectClassPathImplementation: file: " + file.getAbsolutePath() + " is not a valid archive file.");
                        continue;
                    }
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                }
            }
        }
        return Collections.unmodifiableList(arrayList);
    }
}

