/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public final class JavaAntLogger
extends AntLogger {
    private static final Pattern STACK_TRACE = Pattern.compile("(?:\t|\\[catch\\] )at ((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)");
    private static final Pattern EXCEPTION_MESSAGE = Pattern.compile("(?:Exception in thread \"(?:main|Main Thread)\" )?(?:(?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)+)([a-zA-Z_$][a-zA-Z0-9_$]*(?:: .+)?)");
    private static final Pattern CLASSPATH_ARGS = Pattern.compile("\r?\n'-classpath'\r?\n'(.*)'\r?\n");
    private static final Pattern JAVA_EXECUTABLE = Pattern.compile("^Executing '(.*)' with arguments:$", 8);
    private static final String[] TASKS_OF_INTEREST = new String[]{"java", "junit", "exec", "nb-run"};
    private static final int[] LEVELS_OF_INTEREST = new int[]{3, 2, 1, 0};

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        return LEVELS_OF_INTEREST;
    }

    private SessionData getSessionData(AntSession antSession) {
        SessionData sessionData = (SessionData)antSession.getCustomData((AntLogger)this);
        if (sessionData == null) {
            sessionData = new SessionData();
            antSession.putCustomData((AntLogger)this, (Object)sessionData);
        }
        return sessionData;
    }

    public void messageLogged(AntEvent antEvent) {
        String string;
        String string2;
        Object object;
        AntSession antSession = antEvent.getSession();
        int n = antEvent.getLogLevel();
        int n2 = antSession.getVerbosity();
        SessionData sessionData = this.getSessionData(antSession);
        String string3 = antEvent.getMessage();
        assert (string3 != null);
        Matcher matcher = STACK_TRACE.matcher(string3);
        if (matcher.matches()) {
            FileObject fileObject2;
            object = matcher.group(1);
            string2 = matcher.group(2);
            string = ((String)object).replace('.', '/') + string2;
            int n3 = Integer.parseInt(matcher.group(3));
            for (FileObject fileObject2 : JavaAntLogger.getCurrentSourceRootsForClasspath(sessionData)) {
                FileObject fileObject3 = fileObject2.getFileObject(string);
                if (fileObject3 == null) continue;
                JavaAntLogger.hyperlink(string3, antSession, antEvent, fileObject3, n, n2, sessionData, n3);
                break;
            }
            if (!antEvent.isConsumed() && (fileObject2 = GlobalPathRegistry.getDefault().findResource(string)) != null) {
                JavaAntLogger.hyperlink(string3, antSession, antEvent, fileObject2, n, n2, sessionData, n3);
            }
        } else {
            sessionData.possibleExceptionText = string3;
            sessionData.lastExceptionMessage = null;
        }
        if (n == 3) {
            object = CLASSPATH_ARGS.matcher(string3);
            if (((Matcher)object).find()) {
                string2 = ((Matcher)object).group(1);
                sessionData.setClasspath(string2);
            }
            if (((Matcher)(object = JAVA_EXECUTABLE.matcher(string3))).find() && (string = this.findPlatformSources(string2 = ((Matcher)object).group(1))) != null) {
                sessionData.setPlatformSources((ClassPath)string);
            }
        }
    }

    private ClassPath findPlatformSources(String string) {
        for (JavaPlatform javaPlatform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            File file;
            FileObject fileObject = javaPlatform.findTool("java");
            if (fileObject == null || !(file = FileUtil.toFile((FileObject)fileObject)).getAbsolutePath().startsWith(string)) continue;
            return javaPlatform.getSourceFolders();
        }
        return null;
    }

    private static void hyperlink(String string, AntSession antSession, AntEvent antEvent, FileObject fileObject, int n, int n2, SessionData sessionData, int n3) {
        block3: {
            if (n <= n2 && !antEvent.isConsumed()) {
                antEvent.consume();
                try {
                    antSession.println(string, true, antSession.createStandardHyperlink(fileObject.getURL(), JavaAntLogger.guessExceptionMessage(sessionData), n3, -1, -1, -1));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)fileStateInvalidException);
                }
            }
        }
    }

    private static Collection getCurrentSourceRootsForClasspath(SessionData sessionData) {
        if (sessionData.classpath == null) {
            return Collections.EMPTY_SET;
        }
        if (sessionData.classpathSourceRoots == null) {
            String string;
            sessionData.classpathSourceRoots = new LinkedHashSet<FileObject>();
            StringTokenizer stringTokenizer = new StringTokenizer(sessionData.classpath, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                FileObject[] fileObjectArray;
                FileObject[] fileObjectArray2;
                string = stringTokenizer.nextToken();
                File file = FileUtil.normalizeFile((File)new File(string));
                try {
                    fileObjectArray2 = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    throw new AssertionError((Object)malformedURLException);
                }
                if (FileUtil.isArchiveFile((URL)fileObjectArray2) && (fileObjectArray = FileUtil.getArchiveRoot((URL)fileObjectArray2)) != null) {
                    fileObjectArray2 = fileObjectArray;
                }
                fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObjectArray2).getRoots();
                sessionData.classpathSourceRoots.addAll(Arrays.asList(fileObjectArray));
            }
            if (sessionData.platformSources != null) {
                sessionData.classpathSourceRoots.addAll(Arrays.asList(sessionData.platformSources.getRoots()));
            } else {
                string = JavaPlatform.getDefault();
                if (string != null) {
                    sessionData.classpathSourceRoots.addAll(Arrays.asList(string.getSourceFolders().getRoots()));
                }
            }
        }
        return sessionData.classpathSourceRoots;
    }

    private static String guessExceptionMessage(SessionData sessionData) {
        if (sessionData.possibleExceptionText != null) {
            if (sessionData.lastExceptionMessage == null) {
                Matcher matcher = EXCEPTION_MESSAGE.matcher(sessionData.possibleExceptionText);
                if (matcher.matches()) {
                    sessionData.lastExceptionMessage = matcher.group(1);
                } else {
                    sessionData.possibleExceptionText = null;
                }
            }
            return sessionData.lastExceptionMessage;
        }
        return null;
    }

    private static final class SessionData {
        public ClassPath platformSources = null;
        public String classpath = null;
        public Collection<FileObject> classpathSourceRoots = null;
        public String possibleExceptionText = null;
        public String lastExceptionMessage = null;

        public void setClasspath(String string) {
            this.classpath = string;
            this.classpathSourceRoots = null;
        }

        public void setPlatformSources(ClassPath classPath) {
            this.platformSources = classPath;
            this.classpathSourceRoots = null;
        }
    }
}

