/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.project.JavaTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class JavaTargetChooserPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private static final String FOLDER_TO_DELETE = "folderToDelete";
    private final SpecificationVersion JDK_14 = new SpecificationVersion("1.4");
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private JavaTargetChooserPanelGUI gui;
    private WizardDescriptor.Panel bottomPanel;
    private WizardDescriptor wizard;
    private Project project;
    private SourceGroup[] folders;
    private int type;
    private boolean isValidPackageRequired;

    public JavaTargetChooserPanel(Project project, SourceGroup[] sourceGroupArray, WizardDescriptor.Panel panel, int n) {
        this(project, sourceGroupArray, panel, n, false);
    }

    public JavaTargetChooserPanel(Project project, SourceGroup[] sourceGroupArray, WizardDescriptor.Panel panel, int n, boolean bl) {
        this.project = project;
        this.folders = sourceGroupArray;
        this.bottomPanel = panel;
        this.type = n;
        if (panel != null) {
            panel.addChangeListener((ChangeListener)this);
        }
        this.isValidPackageRequired = bl;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new JavaTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.type);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx helpCtx;
        if (this.bottomPanel != null && (helpCtx = this.bottomPanel.getHelp()) != null) {
            return helpCtx;
        }
        return null;
    }

    public boolean isValid() {
        String string;
        if (this.gui == null || this.gui.getTargetName() == null) {
            this.setErrorMessage(null);
            return false;
        }
        if (this.type == 1) {
            if (!JavaTargetChooserPanel.isValidPackageName(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
        } else if (this.type == 2) {
            assert ("package-info".equals(this.gui.getTargetName()));
            if (!JavaTargetChooserPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
        } else {
            if (!JavaTargetChooserPanel.isValidTypeIdentifier(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidClass");
                return false;
            }
            if (!JavaTargetChooserPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
        }
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        boolean bl = true;
        FileObject fileObject2 = this.gui.getRootFolder();
        SpecificationVersion specificationVersion = null;
        if (this.type != 1) {
            string = SourceLevelQuery.getSourceLevel((FileObject)fileObject2);
            specificationVersion = string != null ? new SpecificationVersion(string) : null;
        }
        string = JavaTargetChooserPanel.canUseFileName(fileObject2, this.gui.getPackageFileName(), this.gui.getTargetName(), fileObject.getExt());
        if (this.gui != null) {
            this.setLocalizedErrorMessage(string);
        }
        if (string != null) {
            bl = false;
        }
        if (this.type != 1 && bl && this.gui.getPackageName().length() == 0 && specificationVersion != null && this.JDK_14.compareTo((Object)specificationVersion) <= 0) {
            if (this.isValidPackageRequired) {
                this.setErrorMessage("ERR_JavaTargetChooser_CantUseDefaultPackage");
                return false;
            }
            this.setErrorMessage("ERR_JavaTargetChooser_DefaultPackage");
        }
        String string2 = (String)fileObject.getAttribute("javac.source");
        if (specificationVersion != null && string2 != null && specificationVersion.compareTo((Object)new SpecificationVersion(string2)) < 0) {
            this.setErrorMessage("ERR_JavaTargetChooser_WrongPlatform");
        }
        if (bl && this.bottomPanel != null && !this.bottomPanel.isValid()) {
            return false;
        }
        return bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        Object object2;
        this.wizard = (WizardDescriptor)object;
        if (this.gui != null) {
            object2 = Templates.getTargetFolder((WizardDescriptor)this.wizard);
            this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), (FileObject)object2);
        }
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings(object);
        }
        if (this.gui != null && (object2 = this.gui.getClientProperty("NewFileWizard_Title")) != null) {
            this.wizard.putProperty("NewFileWizard_Title", object2);
        }
    }

    public void storeSettings(Object object) {
        Object object2 = ((WizardDescriptor)object).getValue();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(object2) || WizardDescriptor.CANCEL_OPTION.equals(object2) || WizardDescriptor.CLOSED_OPTION.equals(object2)) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings(object);
            }
            Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)object), (FileObject)this.getTargetFolderFromGUI((WizardDescriptor)object));
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)object), (String)this.gui.getTargetName());
        }
        ((WizardDescriptor)object).putProperty("NewFileWizard_Title", null);
        if (WizardDescriptor.FINISH_OPTION.equals(object2)) {
            this.wizard.putProperty(FOLDER_TO_DELETE, null);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }

    private void setErrorMessage(String string) {
        if (string == null) {
            this.setLocalizedErrorMessage("");
        } else {
            this.setLocalizedErrorMessage(NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)string));
        }
    }

    private void setLocalizedErrorMessage(String string) {
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    private FileObject getTargetFolderFromGUI(WizardDescriptor wizardDescriptor) {
        assert (this.gui != null);
        FileObject fileObject = this.gui.getRootFolder();
        FileObject fileObject2 = null;
        if (this.type != 1) {
            String string = this.gui.getPackageFileName();
            fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 == null) {
                try {
                    FileObject fileObject3;
                    fileObject2 = fileObject;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                    String string2 = null;
                    while (stringTokenizer.hasMoreTokens() && (fileObject3 = fileObject2.getFileObject(string2 = stringTokenizer.nextToken(), "")) != null) {
                        fileObject2 = fileObject3;
                    }
                    fileObject2 = fileObject2.createFolder(string2);
                    fileObject3 = (FileObject)wizardDescriptor.getProperty(FOLDER_TO_DELETE);
                    if (fileObject3 == null) {
                        wizardDescriptor.putProperty(FOLDER_TO_DELETE, (Object)fileObject2);
                    } else if (!fileObject3.equals(fileObject2)) {
                        fileObject3.delete();
                        wizardDescriptor.putProperty(FOLDER_TO_DELETE, (Object)fileObject2);
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        fileObject2 = fileObject2.createFolder(string2);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        } else {
            fileObject2 = fileObject;
        }
        return fileObject2;
    }

    static boolean isValidPackageName(String string) {
        if (string.length() > 0 && string.charAt(0) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidTypeIdentifier(String string) {
        return string != null && !"".equals(string) && Utilities.isJavaIdentifier((String)string);
    }

    public static final String canUseFileName(FileObject fileObject, String string, String string2, String string3) {
        CharSequence charSequence;
        String string4 = string2;
        if (string2 != null) {
            string2 = string2.replace('.', '/');
        }
        if (string3 != null && string3.length() > 0) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(string2);
            ((StringBuffer)charSequence).append('.');
            ((StringBuffer)charSequence).append(string3);
            string2 = ((StringBuffer)charSequence).toString();
        }
        if (string3 != null && string3.length() > 0) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(string4);
            ((StringBuffer)charSequence).append('.');
            ((StringBuffer)charSequence).append(string3);
            string4 = ((StringBuffer)charSequence).toString();
        }
        charSequence = string + "/" + string2;
        if (fileObject == null) {
            return NbBundle.getMessage(JavaTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!fileObject.canWrite()) {
            return NbBundle.getMessage(JavaTargetChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (JavaTargetChooserPanel.existFileName(fileObject, (String)charSequence)) {
            return NbBundle.getMessage(JavaTargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)string4);
        }
        return null;
    }

    private static boolean existFileName(FileObject fileObject, String string) {
        boolean bl = false;
        File file = FileUtil.toFile((FileObject)fileObject);
        bl = file.exists() ? new File(file, string).exists() : fileObject.getFileObject(string) != null;
        return bl;
    }
}

