/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.project.JavaProjectSettings;
import org.netbeans.modules.java.project.PackageDisplayUtils;
import org.netbeans.spi.java.project.support.ui.PackageRootNode;
import org.netbeans.spi.java.project.support.ui.PackageViewChildren;
import org.netbeans.spi.java.project.support.ui.TreeRootNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageView {
    private PackageView() {
    }

    public static Node createPackageView(SourceGroup sourceGroup) {
        return new RootNode(sourceGroup);
    }

    public static Node findPath(Node node, Object object) {
        PackageRootNode.PathFinder pathFinder = (PackageRootNode.PathFinder)node.getLookup().lookup(PackageRootNode.PathFinder.class);
        if (pathFinder != null) {
            return pathFinder.findPath(node, object);
        }
        TreeRootNode.PathFinder pathFinder2 = (TreeRootNode.PathFinder)node.getLookup().lookup(TreeRootNode.PathFinder.class);
        if (pathFinder2 != null) {
            return pathFinder2.findPath(node, object);
        }
        return null;
    }

    public static ComboBoxModel createListView(SourceGroup sourceGroup) {
        TreeSet<PackageItem> treeSet = new TreeSet<PackageItem>();
        PackageView.findNonExcludedPackages(null, treeSet, sourceGroup.getRootFolder(), sourceGroup, false);
        return new DefaultComboBoxModel<PackageItem>(treeSet.toArray(new PackageItem[treeSet.size()]));
    }

    static void findNonExcludedPackages(PackageViewChildren packageViewChildren, Collection<PackageItem> collection, FileObject fileObject, SourceGroup sourceGroup, boolean bl) {
        if (bl) {
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(PackageView.class, (String)"PackageView.find_packages_progress", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)));
            progressHandle.start(1000);
            PackageView.findNonExcludedPackages(packageViewChildren, collection, fileObject, sourceGroup, progressHandle, 0, 1000);
            progressHandle.finish();
        } else {
            PackageView.findNonExcludedPackages(packageViewChildren, collection, fileObject, sourceGroup, null, 0, 0);
        }
    }

    private static void findNonExcludedPackages(PackageViewChildren packageViewChildren, Collection<PackageItem> collection, FileObject fileObject, SourceGroup sourceGroup, ProgressHandle progressHandle, int n, int n2) {
        assert (fileObject.isFolder()) : "Package view only accepts folders";
        if (progressHandle != null) {
            String string = FileUtil.getRelativePath((FileObject)packageViewChildren.getRoot(), (FileObject)fileObject);
            assert (string != null) : fileObject + " in " + packageViewChildren.getRoot();
            progressHandle.progress(string.replace('/', '.'), n);
        }
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!VisibilityQuery.getDefault().isVisible(fileObject2) || !sourceGroup.contains(fileObject2)) continue;
            if (fileObject2.isFolder()) {
                arrayList.add(fileObject2);
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl2 || !bl) {
            if (collection != null) {
                collection.add(new PackageItem(sourceGroup, fileObject, !bl2));
            } else {
                packageViewChildren.add(fileObject, !bl2);
            }
        }
        if (!arrayList.isEmpty()) {
            int n3 = (n2 - n) / arrayList.size();
            int n4 = 0;
            for (FileObject fileObject2 : arrayList) {
                PackageView.findNonExcludedPackages(packageViewChildren, collection, fileObject2, sourceGroup, progressHandle, n + n4 * n3, n + (n4 + 1) * n3);
                ++n4;
            }
        }
    }

    public static ListCellRenderer listRenderer() {
        return new PackageListCellRenderer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PackageItem
    implements Comparable<PackageItem> {
        private static Map<Image, Icon> image2icon = new IdentityHashMap<Image, Icon>();
        private final boolean empty;
        private final FileObject pkg;
        private final String pkgname;
        private Icon icon;

        public PackageItem(SourceGroup sourceGroup, FileObject fileObject, boolean bl) {
            this.pkg = fileObject;
            this.empty = bl;
            String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
            assert (string != null) : "No " + fileObject + " in " + sourceGroup;
            this.pkgname = string.replace('/', '.');
        }

        public String toString() {
            return this.pkgname;
        }

        public String getLabel() {
            return PackageDisplayUtils.getDisplayLabel(this.pkgname);
        }

        public Icon getIcon() {
            if (this.icon == null) {
                Image image = PackageDisplayUtils.getIcon(this.pkg, this.pkgname, this.empty);
                this.icon = image2icon.get(image);
                if (this.icon == null) {
                    this.icon = new ImageIcon(image);
                    image2icon.put(image, this.icon);
                }
            }
            return this.icon;
        }

        @Override
        public int compareTo(PackageItem packageItem) {
            return this.pkgname.compareTo(packageItem.pkgname);
        }
    }

    private static final class PackageListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public PackageListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            if (object instanceof PackageItem) {
                PackageItem packageItem = (PackageItem)object;
                this.setText(packageItem.getLabel());
                this.setIcon(packageItem.getIcon());
            } else {
                String string = (String)object;
                this.setText(string);
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private static final class RootNode
    extends FilterNode
    implements PropertyChangeListener {
        private SourceGroup sourceGroup;
        private static boolean IN_UNIT_TEST = false;

        private RootNode(SourceGroup sourceGroup) {
            super(RootNode.getOriginalNode(sourceGroup));
            this.sourceGroup = sourceGroup;
            JavaProjectSettings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, JavaProjectSettings.class));
            sourceGroup.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("packageViewType".equals(string) || "containership".equals(string)) {
                if (IN_UNIT_TEST) {
                    this.changeOriginal(RootNode.getOriginalNode(this.sourceGroup), true);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            RootNode.this.changeOriginal(RootNode.getOriginalNode(RootNode.this.sourceGroup), true);
                        }
                    });
                }
            }
        }

        private static Node getOriginalNode(SourceGroup sourceGroup) {
            FileObject fileObject = sourceGroup.getRootFolder();
            if (fileObject == null || !fileObject.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            switch (JavaProjectSettings.getPackageViewType()) {
                case 0: {
                    return new PackageRootNode(sourceGroup);
                }
                case 1: {
                    return new TreeRootNode(sourceGroup);
                }
            }
            assert (false) : "Unknown PackageView Type";
            return new PackageRootNode(sourceGroup);
        }

        static {
            try {
                Class.forName("junit.framework.TestCase");
                IN_UNIT_TEST = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

