/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public class NbToolTip
extends FileChangeAdapter {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.tooltip");
    private static final HashMap mime2tip = new HashMap();
    private static int lastRequestId;
    private String mimeType;
    private Annotation[] tipAnnotations;
    private RequestProcessor toolTipRP = new RequestProcessor("ToolTip-Evaluator", 1);

    static synchronized void buildToolTip(JTextComponent jTextComponent) {
        String string = NbEditorUtilities.getMimeType(jTextComponent.getDocument());
        NbToolTip nbToolTip = NbToolTip.getTip(string);
        nbToolTip.buildTip(jTextComponent);
    }

    private static int newRequestId() {
        return ++lastRequestId;
    }

    private static int getLastRequestId() {
        return lastRequestId;
    }

    private NbToolTip(String string) {
        this.mimeType = string;
    }

    private static NbToolTip getTip(String string) {
        NbToolTip nbToolTip = (NbToolTip)((Object)mime2tip.get(string));
        if (nbToolTip == null) {
            nbToolTip = new NbToolTip(string);
            mime2tip.put(string, nbToolTip);
        }
        return nbToolTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Annotation[] getTipAnnotations() {
        FileObject fileObject = NbToolTip.class;
        synchronized (NbToolTip.class) {
            Object object;
            Annotation[] annotationArray = this.tipAnnotations;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (annotationArray != null) return annotationArray;
            if (debug) {
                System.err.println("Searching for tooltip annotations for mimeType=" + this.mimeType);
            }
            fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + this.mimeType + "/ToolTips");
            if (debug) {
                System.err.println("tooltip annotation folder=" + fileObject);
            }
            if (fileObject == null) return annotationArray;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                object = (FileObject)enumeration.nextElement();
                if (debug) {
                    System.err.println("tooltip annotation fileobject=" + object);
                }
                try {
                    DataObject dataObject = DataObject.find((FileObject)object);
                    InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                    if (debug) {
                        System.err.println("tooltip annotation instanceCookie=" + instanceCookie);
                    }
                    if (instanceCookie == null) continue;
                    Object object2 = instanceCookie.instanceCreate();
                    if (debug) {
                        System.err.println("tooltip annotation instance=" + object2);
                    }
                    if (!(object2 instanceof Annotation)) continue;
                    if (debug) {
                        System.err.println("Found tooltip annotation=" + object2 + ", class " + object2.getClass() + " for mimeType=" + this.mimeType);
                    }
                    arrayList.add(object2);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            annotationArray = arrayList.toArray(new Annotation[arrayList.size()]);
            object = NbToolTip.class;
            synchronized (NbToolTip.class) {
                this.tipAnnotations = annotationArray;
                // ** MonitorExit[var5_6 /* !! */ ] (shouldn't be in output)
                fileObject.addFileChangeListener((FileChangeListener)this);
                return annotationArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTip(JTextComponent jTextComponent) {
        block13: {
            EditorCookie editorCookie;
            DataObject dataObject;
            ExtEditorUI extEditorUI;
            ToolTipSupport toolTipSupport;
            BaseTextUI baseTextUI;
            Object object;
            TextUI textUI = jTextComponent.getUI();
            if (textUI != null && textUI instanceof BaseTextUI && (object = (baseTextUI = (BaseTextUI)textUI).getToolTipText(jTextComponent, (toolTipSupport = (extEditorUI = (ExtEditorUI)baseTextUI.getEditorUI()).getToolTipSupport()).getLastMouseEvent().getPoint())) != null) {
                return;
            }
            baseTextUI = this.getTipAnnotations();
            if (baseTextUI != null && (extEditorUI = ExtUtilities.getExtEditorUI((JTextComponent)jTextComponent)) != null && (toolTipSupport = extEditorUI.getToolTipSupport()) != null && (object = Utilities.getDocument((JTextComponent)jTextComponent)) != null && (dataObject = NbEditorUtilities.getDataObject((Document)object)) != null && dataObject.isValid() && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                StyledDocument styledDocument;
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (IOException iOException) {
                    styledDocument = null;
                }
                if (styledDocument != object) {
                    return;
                }
                object.readLock();
                try {
                    int n = jTextComponent.viewToModel(toolTipSupport.getLastMouseEvent().getPoint());
                    if (n < 0) break block13;
                    try {
                        Line.Part part;
                        Line line;
                        int n2 = Utilities.getLineOffset((BaseDocument)object, (int)n);
                        int n3 = n - Utilities.getRowStart((JTextComponent)jTextComponent, (int)n);
                        Line.Set set = editorCookie.getLineSet();
                        if (set != null && (line = set.getCurrent(n2)) != null && (part = line.createPart(n3, 0)) != null) {
                            BaseKit baseKit;
                            AnnotationDesc annotationDesc = object.getAnnotations().getActiveAnnotation(n2);
                            if (annotationDesc != null && (n < annotationDesc.getOffset() || n >= annotationDesc.getOffset() + annotationDesc.getLength())) {
                                annotationDesc = null;
                            }
                            if ((baseKit = Utilities.getKit((JTextComponent)jTextComponent)) instanceof NbEditorKit) {
                                int n4 = NbToolTip.newRequestId();
                                this.toolTipRP.post((Runnable)new Request(annotationDesc, (Annotation[])baseTextUI, part, toolTipSupport, (AbstractDocument)object, (NbEditorKit)baseKit, n4));
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                finally {
                    object.readUnlock();
                }
            }
        }
    }

    private static class Request
    implements Runnable,
    PropertyChangeListener,
    DocumentListener {
        private ToolTipSupport tts;
        private Annotation[] annos;
        private AnnotationDesc annoDesc;
        private Line.Part linePart;
        private AbstractDocument doc;
        private NbEditorKit kit;
        private int requestId;
        private boolean documentModified;

        Request(AnnotationDesc annotationDesc, Annotation[] annotationArray, Line.Part part, ToolTipSupport toolTipSupport, AbstractDocument abstractDocument, NbEditorKit nbEditorKit, int n) {
            this.annoDesc = annotationDesc;
            this.annos = annotationArray;
            this.linePart = part;
            this.tts = toolTipSupport;
            this.doc = abstractDocument;
            this.kit = nbEditorKit;
            this.requestId = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.tts == null) {
                return;
            }
            if (this.tts == null || this.tts.getStatus() == 0) {
                return;
            }
            if (!this.isRequestValid()) {
                return;
            }
            if (this.tts != null) {
                this.tts.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.kit.toolTipAnnotationsLock(this.doc);
            try {
                this.doc.readLock();
                try {
                    int n;
                    if (!this.isRequestValid()) {
                        return;
                    }
                    for (n = 0; n < this.annos.length; ++n) {
                        this.annos[n].attach((Annotatable)this.linePart);
                    }
                    if (this.annoDesc != null && this.tts != null) {
                        this.tts.setToolTipText(this.annoDesc.getShortDescription());
                        this.annoDesc.addPropertyChangeListener((PropertyChangeListener)this);
                    } else {
                        for (n = 0; n < this.annos.length; ++n) {
                            String string = this.annos[n].getShortDescription();
                            if (string != null && this.tts != null) {
                                this.tts.setToolTipText(string);
                            }
                            this.annos[n].addPropertyChangeListener((PropertyChangeListener)this);
                        }
                    }
                }
                finally {
                    this.doc.readUnlock();
                }
            }
            finally {
                this.kit.toolTipAnnotationsUnlock(this.doc);
            }
        }

        private boolean isRequestValid() {
            return NbToolTip.getLastRequestId() == this.requestId && !this.documentModified && this.isDocumentValid();
        }

        private boolean isDocumentValid() {
            EditorCookie editorCookie;
            DataObject dataObject = NbEditorUtilities.getDataObject(this.doc);
            if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                StyledDocument styledDocument;
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (IOException iOException) {
                    styledDocument = null;
                }
                return styledDocument == this.doc;
            }
            return false;
        }

        private void dismiss() {
            if (this.tts != null) {
                this.tts.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.tts = null;
            if (this.annoDesc != null) {
                this.annoDesc.removePropertyChangeListener((PropertyChangeListener)this);
            } else {
                for (int i = 0; i < this.annos.length; ++i) {
                    this.annos[i].removePropertyChangeListener((PropertyChangeListener)this);
                    this.annos[i].detach();
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("shortDescription".equals(string) || "shortDescription".equals(string)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    final String string2 = (String)propertyChangeEvent.getNewValue();
                    Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                        public void run() {
                            if (Request.this.tts != null) {
                                Request.this.tts.setToolTipText(string2);
                            }
                        }
                    });
                }
            } else if ("status".equals(string) && (Integer)propertyChangeEvent.getNewValue() == 0) {
                this.dismiss();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentModified = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentModified = true;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

