/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;

public final class KitsTracker {
    private static final Logger LOG = Logger.getLogger(KitsTracker.class.getName());
    private static final Set ALREADY_LOGGED = Collections.synchronizedSet(new HashSet(10));
    private static KitsTracker instance = null;
    private final HashMap mimeType2kitClass = new HashMap();
    private final ArrayList eventSources = new ArrayList();
    private boolean needsReloading = true;
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fileEvent) {
            KitsTracker.this.invalidateCache();
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (fileEvent.getFile().isFolder()) {
                KitsTracker.this.invalidateCache();
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (fileRenameEvent.getFile().isFolder()) {
                KitsTracker.this.invalidateCache();
            }
        }
    };

    public static synchronized KitsTracker getInstance() {
        if (instance == null) {
            instance = new KitsTracker();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMimeTypesForKitClass(Class clazz) {
        HashMap hashMap = this.mimeType2kitClass;
        synchronized (hashMap) {
            if (this.needsReloading) {
                this.reload();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.mimeType2kitClass.keySet()) {
                Class clazz2 = (Class)this.mimeType2kitClass.get(string);
                if (clazz != clazz2) continue;
                arrayList.add(string);
            }
            return arrayList;
        }
    }

    public String findMimeType(Class clazz) {
        List list = this.getMimeTypesForKitClass(clazz);
        if (list.size() == 0) {
            if (LOG.isLoggable(Level.WARNING)) {
                KitsTracker.logOnce(Level.WARNING, "No mime type uses editor kit implementation class: " + clazz);
            }
            return null;
        }
        if (list.size() == 1) {
            return (String)list.get(0);
        }
        if (LOG.isLoggable(Level.WARNING)) {
            KitsTracker.logOnce(Level.WARNING, "Ambiguous mime types for editor kit implementation class: " + clazz + "; mime types: " + list);
        }
        return null;
    }

    private KitsTracker() {
    }

    private void reload() {
        for (FileObject[] fileObjectArray : this.eventSources) {
            fileObjectArray.removeFileChangeListener(this.fcl);
        }
        this.mimeType2kitClass.clear();
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors");
        if (fileObject != null) {
            FileObject[] fileObjectArray;
            fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!fileObjectArray[i].isFolder()) continue;
                FileObject[] fileObjectArray2 = fileObjectArray[i].getChildren();
                for (int j = 0; j < fileObjectArray2.length; ++j) {
                    if (!fileObjectArray2[j].isFolder()) continue;
                    String string = fileObjectArray[i].getNameExt() + "/" + fileObjectArray2[j].getNameExt();
                    MimePath mimePath = MimePath.parse((String)string);
                    EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)mimePath).lookup(EditorKit.class);
                    if (editorKit != null) {
                        String string2;
                        if (!(editorKit.getContentType().equals(string) || null != (string2 = KitsTracker.getGenericPartOfCompoundMimeType(string)) && string2.equals(editorKit.getContentType()))) {
                            LOG.warning("Inconsistent mime type declaration for the kit: " + editorKit + "; mimeType from the kit is '" + editorKit.getContentType() + ", but the kit is registered for '" + string + "'");
                        }
                        this.mimeType2kitClass.put(string, editorKit.getClass());
                        continue;
                    }
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("No kit for '" + string + "'");
                }
                fileObjectArray[i].addFileChangeListener(this.fcl);
                this.eventSources.add(fileObjectArray[i]);
            }
            fileObject.addFileChangeListener(this.fcl);
            this.eventSources.add(fileObject);
        }
        this.needsReloading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCache() {
        HashMap hashMap = this.mimeType2kitClass;
        synchronized (hashMap) {
            this.needsReloading = true;
        }
    }

    private static String getGenericPartOfCompoundMimeType(String string) {
        int n = string.lastIndexOf(43);
        if (n != -1 && n < string.length() - 1) {
            int n2 = string.indexOf(47);
            String string2 = string.substring(0, n2 + 1);
            String string3 = string.substring(n + 1);
            if (string3.equals("xml")) {
                string2 = "text/";
            }
            return string2 + string3;
        }
        return null;
    }

    private static void logOnce(Level level, String string) {
        if (!ALREADY_LOGGED.contains(string)) {
            LOG.log(level, string);
            ALREADY_LOGGED.add(string);
        }
    }
}

