/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.NbEditorSettingsInitializer;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class OptionSupport
extends SystemOption {
    static final long serialVersionUID = 2002899758839584077L;
    static final String OPTIONS_PREFIX = "OPTIONS_";
    private Class kitClass;
    private String typeName;
    private HashMap initializerValuesMap;
    private transient SettingsInitializer settingsInitializer;
    private static final HashMap kitClass2Type = new HashMap();

    public OptionSupport(Class clazz, String string) {
        this.kitClass = clazz;
        this.typeName = string;
        this.initializerValuesMap = new HashMap();
        kitClass2Type.put(clazz, string);
        Settings.Initializer initializer = this.getSettingsInitializer();
        Settings.removeInitializer((String)initializer.getName());
        Settings.addInitializer((Settings.Initializer)initializer, (int)3);
        Settings.reset();
    }

    public Class getKitClass() {
        return this.kitClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static String getTypeName(Class clazz) {
        return (String)kitClass2Type.get(clazz);
    }

    public String displayName() {
        return this.getString(OPTIONS_PREFIX + this.typeName);
    }

    Settings.KitAndValue[] getSettingValueHierarchy(String string) {
        return Settings.getValueHierarchy((Class)this.kitClass, (String)string);
    }

    public Object getSettingValue(String string) {
        NbEditorSettingsInitializer.init();
        return Settings.getValue((Class)this.kitClass, (String)string);
    }

    protected final boolean getSettingBoolean(String string) {
        Boolean bl = (Boolean)this.getSettingValue(string);
        return bl != null ? bl : false;
    }

    protected final int getSettingInteger(String string) {
        Integer n = (Integer)this.getSettingValue(string);
        return n != null ? n : 0;
    }

    public void setSettingValue(String string, Object object) {
        this.setSettingValue(string, object, string);
    }

    public void setSettingValue(String string, Object object, String string2) {
        this.initializerValuesMap.put(string, object);
        Object object2 = this.getSettingValue(string);
        if (object2 == null && object == null || object2 != null && object2.equals(object)) {
            return;
        }
        Settings.setValue((Class)this.kitClass, (String)string, (Object)object);
    }

    public void doSetSettingValue(String string, Object object, String string2) {
        this.initializerValuesMap.put(string, object);
        Settings.setValue((Class)this.kitClass, (String)string, (Object)object);
    }

    protected void setSettingBoolean(String string, boolean bl, String string2) {
        this.setSettingValue(string, bl ? Boolean.TRUE : Boolean.FALSE, string2);
    }

    protected void setSettingInteger(String string, int n, String string2) {
        this.setSettingValue(string, new Integer(n));
    }

    protected String getString(String string) {
        return NbBundle.getMessage(OptionSupport.class, (String)string);
    }

    public static String[] mergeStringArrays(String[] stringArray, String[] stringArray2) {
        return NbEditorUtilities.mergeStringArrays(stringArray, stringArray2);
    }

    protected String getSettingsInitializerName() {
        return this.getTypeName() + "-options-initalizer";
    }

    protected void updateSettingsMap(Class clazz, Map map) {
        if (clazz == this.getKitClass()) {
            map.putAll(this.initializerValuesMap);
        }
    }

    Settings.Initializer getSettingsInitializer() {
        if (this.settingsInitializer == null) {
            this.settingsInitializer = new SettingsInitializer();
        }
        return this.settingsInitializer;
    }

    class SettingsInitializer
    implements Settings.Initializer {
        String name;
        private volatile boolean updating = false;

        SettingsInitializer() {
        }

        public String getName() {
            if (this.name == null) {
                this.name = OptionSupport.this.getSettingsInitializerName();
            }
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSettingsMap(Class clazz, Map map) {
            if (!this.updating) {
                this.updating = true;
                try {
                    OptionSupport.this.updateSettingsMap(clazz, map);
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }
}

