/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.MIMEOptionFolder;
import org.netbeans.modules.editor.options.MultiPropertyFolder;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptionUtilities {
    private static final Logger LOG = Logger.getLogger(OptionUtilities.class.getName());
    public static final String DEFAULT_FOLDER = "Defaults";

    private OptionUtilities() {
    }

    private static String wrap(String string) {
        return string.length() == 1 ? "0" + string : string;
    }

    public static String color2String(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#");
        stringBuffer.append(OptionUtilities.wrap(Integer.toHexString(color.getRed()).toUpperCase()));
        stringBuffer.append(OptionUtilities.wrap(Integer.toHexString(color.getGreen()).toUpperCase()));
        stringBuffer.append(OptionUtilities.wrap(Integer.toHexString(color.getBlue()).toUpperCase()));
        return stringBuffer.toString();
    }

    public static Color string2Color(String string) {
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static int string2Int(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int getFontStyle(String string) {
        string = string.toLowerCase();
        int n = 0;
        if (string.indexOf("bold") != -1) {
            n |= 1;
        }
        if (string.indexOf("italic") != -1) {
            n |= 2;
        }
        return n;
    }

    public static String style2String(int n) {
        if (1 == n) {
            return "bold";
        }
        if (2 == n) {
            return "italic";
        }
        if (3 == n) {
            return "bold-italic";
        }
        return "plain";
    }

    public static Map getMapDiff(Map map, Map map2, boolean bl) {
        Object v;
        HashMap hashMap = new HashMap();
        for (Object object : map2.keySet()) {
            v = map2.get(object);
            if (!v.equals(map.get(object))) {
                hashMap.put(object, map2.get(object));
                continue;
            }
            if (!bl || map.containsKey(object)) continue;
            hashMap.put(object, map2.get(object));
        }
        for (Object object : map.keySet()) {
            v = map.get(object);
            if (map2.containsKey(object)) continue;
            hashMap.put(object, "");
        }
        return hashMap;
    }

    public static String keysToString(KeyStroke[] keyStrokeArray) {
        if (keyStrokeArray == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            stringBuffer.append(Utilities.keyToString((KeyStroke)keyStrokeArray[i]));
            if (i >= keyStrokeArray.length - 1) continue;
            stringBuffer.append("$");
        }
        return stringBuffer.toString();
    }

    public static String keyToString(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "NULL";
        }
        return Utilities.keyToString((KeyStroke)keyStroke);
    }

    public static KeyStroke stringToKey(String string) {
        if (string.equals("NULL")) {
            return null;
        }
        return Utilities.stringToKey((String)string);
    }

    public static KeyStroke[] stringToKeys(String string) {
        if (string.equals("NULL")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(), "$");
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            KeyStroke keyStroke = OptionUtilities.stringToKey(string);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    public static void printDefaultAbbrevs(Map map) {
        System.out.println("-----------------------------------------------------------");
        System.out.println("<?xml version=\"1.0\"?>");
        System.out.println("<!DOCTYPE catalog PUBLIC \"-//NetBeans//DTD Editor Abbreviations settings 1.0//EN\"");
        System.out.println(" \"http://www.netbeans.org/dtds/EditorAbbreviations-1_0.dtd\">");
        System.out.println("");
        System.out.println("<abbrevs>");
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            System.out.println("<abbrev key=\"" + string + "\">" + string2 + "</" + "abbrev" + ">");
        }
        System.out.println("</abbrevs>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDefaultAbbrevs(Map map, FileObject fileObject) {
        Document document = XMLUtil.createDocument((String)"abbrevs", null, (String)"-//NetBeans//DTD Editor Abbreviations settings 1.0//EN", (String)"http://www.netbeans.org/dtds/EditorAbbreviations-1_0.dtd");
        Element element = document.getDocumentElement();
        for (String string : map.keySet()) {
            if (!(map.get(string) instanceof String)) continue;
            String string2 = (String)map.get(string);
            Element element2 = document.createElement("abbrev");
            element2.setAttribute("key", string);
            element2.appendChild(document.createTextNode(string2));
            element.appendChild(element2);
        }
        document.getDocumentElement().normalize();
        try {
            FileLock fileLock = fileObject.lock();
            try {
                XMLUtil.write((Document)document, (OutputStream)fileObject.getOutputStream(fileLock), (String)"UTF-8");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDefaultMacros(Map map, FileObject fileObject) {
        Document document = XMLUtil.createDocument((String)"macros", null, (String)"-//NetBeans//DTD Editor Macros settings 1.0//EN", (String)"http://www.netbeans.org/dtds/EditorMacros-1_0.dtd");
        Element element = document.getDocumentElement();
        for (String string : map.keySet()) {
            if (!(map.get(string) instanceof String)) continue;
            String string2 = (String)map.get(string);
            Element element2 = document.createElement("macro");
            element2.setAttribute("name", string);
            element2.appendChild(document.createTextNode(string2));
            element.appendChild(element2);
        }
        document.getDocumentElement().normalize();
        try {
            FileLock fileLock = fileObject.lock();
            try {
                XMLUtil.write((Document)document, (OutputStream)fileObject.getOutputStream(fileLock), (String)"UTF-8");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDefaultKeyBindings(List list, FileObject fileObject) {
        Map map = OptionUtilities.makeKeyBindingsMap(list);
        Document document = XMLUtil.createDocument((String)"bindings", null, (String)"-//NetBeans//DTD Editor KeyBindings settings 1.0//EN", (String)"http://www.netbeans.org/dtds/EditorKeyBindings-1_0.dtd");
        Element element = document.getDocumentElement();
        for (String string : map.keySet()) {
            MultiKeyBinding multiKeyBinding;
            if (!(map.get(string) instanceof MultiKeyBinding) || (multiKeyBinding = (MultiKeyBinding)map.get(string)) == null) continue;
            Element element2 = document.createElement("bind");
            element2.setAttribute("key", string);
            element2.setAttribute("actionName", multiKeyBinding.actionName);
            element.appendChild(element2);
        }
        document.getDocumentElement().normalize();
        try {
            FileLock fileLock = fileObject.lock();
            try {
                XMLUtil.write((Document)document, (OutputStream)fileObject.getOutputStream(fileLock), (String)"UTF-8");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String insetsToString(Insets insets) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(insets.top);
        stringBuffer.append(',');
        stringBuffer.append(insets.left);
        stringBuffer.append(',');
        stringBuffer.append(insets.bottom);
        stringBuffer.append(',');
        stringBuffer.append(insets.right);
        return stringBuffer.toString();
    }

    public static Insets parseInsets(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[4];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n > 3) {
                return null;
            }
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            ++n;
        }
        if (n != 4) {
            return null;
        }
        return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static String dimensionToString(Dimension dimension) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dimension.width);
        stringBuffer.append(',');
        stringBuffer.append(dimension.height);
        return stringBuffer.toString();
    }

    public static Dimension parseDimension(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[2];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n > 1) {
                return null;
            }
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            ++n;
        }
        if (n != 2) {
            return null;
        }
        return new Dimension(nArray[0], nArray[1]);
    }

    public static Map makeKeyBindingsMap(List list) {
        HashMap<String, MultiKeyBinding> hashMap = new HashMap<String, MultiKeyBinding>();
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            String string;
            Object e = list.get(i);
            if (!(e instanceof MultiKeyBinding)) {
                if (MultiKeyBinding.class.getClassLoader().equals(e.getClass().getClassLoader()) || !bl) continue;
                System.err.println("Different classloaders:");
                System.err.println(MultiKeyBinding.class.getClassLoader());
                System.err.println(e.getClass().getClassLoader());
                bl = false;
                continue;
            }
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)e;
            String string2 = string = multiKeyBinding.keys == null ? OptionUtilities.keyToString(multiKeyBinding.key) : OptionUtilities.keysToString(multiKeyBinding.keys);
            if (string == null) continue;
            hashMap.put(string, multiKeyBinding);
        }
        return hashMap;
    }

    public static List getGlobalAttribs(String string) {
        MIMEOptionFolder mIMEOptionFolder = AllOptionsFolder.getDefault().getMIMEFolder();
        if (mIMEOptionFolder == null) {
            return new ArrayList();
        }
        MultiPropertyFolder multiPropertyFolder = mIMEOptionFolder.getMPFolder(string, false);
        if (multiPropertyFolder != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Enumeration enumeration = multiPropertyFolder.getDataFolder().getPrimaryFile().getAttributes();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string2 = (String)enumeration.nextElement();
                if (string2.indexOf("/") == -1 || !((object = multiPropertyFolder.getDataFolder().getPrimaryFile().getAttribute(string2)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
                arrayList.add(string2);
            }
            return arrayList;
        }
        return new ArrayList();
    }

    public static List getGlobalPopupAttribs() {
        return OptionUtilities.getGlobalAttribs("Popup");
    }

    public static List getGlobalPopupMenuItems() {
        return OptionUtilities.getGlobalMenuItems("Popup");
    }

    public static List getGlobalMenuItems(String string) {
        MIMEOptionFolder mIMEOptionFolder = AllOptionsFolder.getDefault().getMIMEFolder();
        if (mIMEOptionFolder == null) {
            return new ArrayList();
        }
        MultiPropertyFolder multiPropertyFolder = mIMEOptionFolder.getMPFolder(string, false);
        if (multiPropertyFolder != null) {
            return multiPropertyFolder.getProperties();
        }
        return new ArrayList();
    }

    public static List getPopupStrings(List list) {
        return OptionUtilities.getPopupStrings(list, false);
    }

    public static List getPopupStrings(List list, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof DataObject)) continue;
            DataObject dataObject = (DataObject)list.get(i);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            if (instanceCookie != null) {
                try {
                    if (SystemAction.class.isAssignableFrom(instanceCookie.instanceClass())) {
                        arrayList.add(instanceCookie.instanceName());
                    } else if (Action.class.isAssignableFrom(instanceCookie.instanceClass())) {
                        arrayList.add(instanceCookie.instanceCreate());
                    }
                    if (!JSeparator.class.isAssignableFrom(instanceCookie.instanceClass())) continue;
                    arrayList.add(bl ? new JSeparator() : null);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                continue;
            }
            if ("org-openide-windows-TopComponent".equals(dataObject.getName())) {
                arrayList.add(dataObject.getName().replace('-', '.'));
                continue;
            }
            arrayList.add(dataObject.getName());
        }
        return arrayList;
    }

    public static List arrangeMergedFolderObjects(Set set, Set set2) {
        int n;
        ArrayList arrayList = new ArrayList(set);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            DataObject dataObject = (DataObject)arrayList.get(n);
            arrayList2.add(dataObject.getPrimaryFile().getNameExt());
        }
        for (n = 0; n < set2.size(); ++n) {
            for (String string : set2) {
                int n2;
                int n3 = string.indexOf(47);
                if (n3 == -1) {
                    LOG.warning("Ignoring invalid ordering attribute: '" + string + "'");
                    continue;
                }
                String string2 = string.substring(0, n3);
                String string3 = string.substring(n3 + 1);
                int n4 = arrayList2.indexOf(string2);
                if (n4 <= (n2 = arrayList2.indexOf(string3)) || n2 <= -1) continue;
                arrayList2.add(n2, (String)arrayList2.remove(n4));
                arrayList.add(n2, arrayList.remove(n4));
            }
        }
        return arrayList;
    }

    public static List arrangeMergedPopup(Set set, Set set2) {
        List list = OptionUtilities.arrangeMergedFolderObjects(set, set2);
        return OptionUtilities.getPopupStrings(list);
    }
}

