/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.io.File;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class SharabilityQuery {
    private static final Lookup.Result<SharabilityQueryImplementation> implementations = Lookup.getDefault().lookupResult(SharabilityQueryImplementation.class);
    public static final int UNKNOWN = 0;
    public static final int SHARABLE = 1;
    public static final int NOT_SHARABLE = 2;
    public static final int MIXED = 3;

    private SharabilityQuery() {
    }

    public static int getSharability(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        File file2 = FileUtil.normalizeFile((File)file);
        for (SharabilityQueryImplementation sharabilityQueryImplementation : implementations.allInstances()) {
            int n = sharabilityQueryImplementation.getSharability(file2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }
}

