/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.Doc;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;

public final class JavadocGenerator {
    private final SourceVersion srcVersion;

    public JavadocGenerator(SourceVersion sourceVersion) {
        this.srcVersion = sourceVersion;
    }

    public String generateComment(TypeElement typeElement, CompilationInfo compilationInfo) {
        StringBuilder stringBuilder = new StringBuilder("/**\n * \n");
        if (typeElement.getNestingKind() == NestingKind.TOP_LEVEL) {
            stringBuilder.append(" * @author " + System.getProperty("user.name") + "\n");
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0) {
            for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
                stringBuilder.append(" * @param " + typeParameterElement.getSimpleName().toString() + " \n");
            }
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(compilationInfo, typeElement)) {
            stringBuilder.append(" * @deprecated\n");
        }
        stringBuilder.append(" */\n");
        return stringBuilder.toString();
    }

    public String generateComment(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        StringBuilder stringBuilder = new StringBuilder("/**\n * \n");
        for (VariableElement annotatedConstruct : executableElement.getParameters()) {
            stringBuilder.append(" * @param ").append(annotatedConstruct.getSimpleName().toString()).append(" \n");
        }
        if (executableElement.getReturnType().getKind() != TypeKind.VOID) {
            stringBuilder.append(" * @return \n");
        }
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            stringBuilder.append(" * @throws ").append(typeElement.getQualifiedName().toString()).append(" \n");
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(compilationInfo, executableElement)) {
            stringBuilder.append(" * @deprecated\n");
        }
        stringBuilder.append(" */\n");
        return stringBuilder.toString();
    }

    public String generateComment(VariableElement variableElement, CompilationInfo compilationInfo) {
        StringBuilder stringBuilder = new StringBuilder("/**\n * \n");
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(compilationInfo, variableElement)) {
            stringBuilder.append(" * @deprecated\n");
        }
        stringBuilder.append(" */\n");
        return stringBuilder.toString();
    }

    public String generateComment(Element element, CompilationInfo compilationInfo) {
        switch (element.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return this.generateComment((TypeElement)element, compilationInfo);
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return this.generateComment((ExecutableElement)element, compilationInfo);
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                return this.generateComment((VariableElement)element, compilationInfo);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)element.getKind()) + ", " + element.getClass() + ": " + element.toString());
    }

    public String generateInheritComment() {
        return "/** {@inheritDoc} */";
    }

    public static String indentJavadoc(String string, String string2) {
        return string.replace("\n *", "\n" + string2 + " *") + string2;
    }

    public static String guessIndentation(Document document, Position position) throws BadLocationException {
        int n;
        String string = document.getText(0, document.getLength());
        for (n = position.getOffset(); n >= 0 && string.charAt(n) != '\n'; --n) {
        }
        return string.substring(n + 1, position.getOffset());
    }

    public static String guessJavadocIndentation(CompilationInfo compilationInfo, Document document, Doc doc) throws BadLocationException {
        int n;
        Position[] positionArray = JavadocUtilities.findDocBounds(compilationInfo, document, doc);
        if (positionArray == null) {
            return "";
        }
        String string = document.getText(0, document.getLength());
        int n2 = 0;
        for (int i = positionArray[0].getOffset() - 1; i >= 0; --i) {
            n = string.charAt(i);
            if (n != 10 && Character.isWhitespace((char)n)) continue;
            n2 = positionArray[0].getOffset() - i;
            break;
        }
        char[] cArray = new char[n2];
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = 32;
        }
        return String.valueOf(cArray);
    }
}

