/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javadoc.hints.JavadocGenerator;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavadocHintProvider
implements CancellableTask<CompilationInfo> {
    private static final Severity hintSeverity = Severity.WARNING;
    private static final int NOPOS = -2;
    private final FileObject file;
    private boolean cancel = false;
    private static int CREATE_JAVADOC_HINT_LIMIT = Integer.MAX_VALUE;
    private static int FIX_JAVADOC_HINT_LIMIT = Integer.MAX_VALUE;
    private static Access access;

    public JavadocHintProvider(FileObject fileObject) {
        this.file = fileObject;
    }

    public void cancel() {
        this.cancel = true;
    }

    boolean isCanceled() {
        return this.cancel;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        JavadocHintProvider.readSettings();
        if (CREATE_JAVADOC_HINT_LIMIT <= 0 && FIX_JAVADOC_HINT_LIMIT <= 0) {
            return;
        }
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        Analyzer analyzer = new Analyzer(compilationInfo, document);
        try {
            analyzer.scan(compilationInfo.getCompilationUnit(), arrayList);
        }
        catch (CancelException cancelException) {
            return;
        }
        HintsController.setErrors((FileObject)this.file, (String)"javadoc", arrayList);
    }

    private static void readSettings() {
        if (access != null) {
            return;
        }
        String string = System.getProperty("org.netbeans.modules.javadoc.hints.MissingJavadocLimit");
        try {
            if (string != null) {
                CREATE_JAVADOC_HINT_LIMIT = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
        }
        string = System.getProperty("org.netbeans.modules.javadoc.hints.FixJavadocTagLimit");
        try {
            if (string != null) {
                FIX_JAVADOC_HINT_LIMIT = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
        }
        string = System.getProperty("org.netbeans.modules.javadoc.hints.Visibility");
        access = Access.resolve(string);
    }

    private static SourceVersion resolveSourceVersion(FileObject fileObject) {
        String string = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
        if (string == null) {
            return SourceVersion.latest();
        }
        if (string.startsWith("1.6")) {
            return SourceVersion.RELEASE_6;
        }
        if (string.startsWith("1.5")) {
            return SourceVersion.RELEASE_5;
        }
        if (string.startsWith("1.4")) {
            return SourceVersion.RELEASE_4;
        }
        if (string.startsWith("1.3")) {
            return SourceVersion.RELEASE_3;
        }
        if (string.startsWith("1.2")) {
            return SourceVersion.RELEASE_2;
        }
        if (string.startsWith("1.1")) {
            return SourceVersion.RELEASE_1;
        }
        if (string.startsWith("1.0")) {
            return SourceVersion.RELEASE_1;
        }
        return SourceVersion.latest();
    }

    private static void doOpen(final FileObject fileObject, final int n) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JavadocHintProvider.doOpenImpl(fileObject, n);
            }
        });
    }

    private static boolean doOpenImpl(FileObject fileObject, int n) {
        try {
            StyledDocument styledDocument;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (editorCookie != null && lineCookie != null && n != -1 && (styledDocument = editorCookie.openDocument()) != null) {
                Line line;
                int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
                int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2);
                int n4 = n - n3;
                if (n2 != -1 && (line = lineCookie.getLineSet().getCurrent(n2)) != null) {
                    line.show(2, n4);
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Access {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE;


        public static Access resolve(String string) {
            if (string != null) {
                if ("public".equals(string = string.trim().toLowerCase())) {
                    return PUBLIC;
                }
                if ("protected".equals(string)) {
                    return PROTECTED;
                }
                if ("private".equals(string)) {
                    return PRIVATE;
                }
                if ("package".equals(string)) {
                    return PACKAGE;
                }
            }
            return PROTECTED;
        }

        public boolean isAccesible(Set<Modifier> set) {
            switch (this) {
                case PRIVATE: {
                    return true;
                }
                case PACKAGE: {
                    return !set.contains((Object)Modifier.PRIVATE);
                }
                case PROTECTED: {
                    return set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PROTECTED);
                }
                case PUBLIC: {
                    return set.contains((Object)Modifier.PUBLIC);
                }
            }
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddTagFix
    implements Fix,
    CancellableTask<WorkingCopy> {
        private final ElementHandle methodHandle;
        private final String paramName;
        private final int index;
        private final FileObject file;
        private final SourceVersion spec;
        private final String descKey;
        private final Kind kind;
        private Position insertPosition;
        String insertJavadoc;
        private int openOffset;
        Document doc;

        private AddTagFix(ElementHandle elementHandle, String string, int n, FileObject fileObject, SourceVersion sourceVersion, String string2, Kind kind) {
            this.methodHandle = elementHandle;
            this.paramName = string;
            this.index = n;
            this.file = fileObject;
            this.spec = sourceVersion;
            this.descKey = string2;
            this.kind = kind;
        }

        public static Fix createAddParamTagFix(ExecutableElement executableElement, String string, FileObject fileObject, SourceVersion sourceVersion) {
            return new AddTagFix(ElementHandle.create((Element)executableElement), string, -1, fileObject, sourceVersion, "MISSING_PARAM_HINT", Kind.PARAM);
        }

        public static Fix createAddTypeParamTagFix(TypeElement typeElement, String string, FileObject fileObject, SourceVersion sourceVersion) {
            return new AddTagFix(ElementHandle.create((Element)typeElement), string, -1, fileObject, sourceVersion, "MISSING_TYPEPARAM_HINT", Kind.TYPEPARAM);
        }

        public static Fix createAddReturnTagFix(ExecutableElement executableElement, FileObject fileObject, SourceVersion sourceVersion) {
            return new AddTagFix(ElementHandle.create((Element)executableElement), "", -1, fileObject, sourceVersion, "MISSING_RETURN_HINT", Kind.RETURN);
        }

        public static Fix createAddThrowsTagFix(ExecutableElement executableElement, String string, int n, FileObject fileObject, SourceVersion sourceVersion) {
            return new AddTagFix(ElementHandle.create((Element)executableElement), string, n, fileObject, sourceVersion, "MISSING_THROWS_HINT", Kind.THROWS);
        }

        public static Fix createAddDeprecatedTagFix(Element element, FileObject fileObject, SourceVersion sourceVersion) {
            return new AddTagFix(ElementHandle.create((Element)element), "", -1, fileObject, sourceVersion, "MISSING_DEPRECATED_HINT", Kind.DEPRECATED);
        }

        public String getText() {
            return NbBundle.getMessage(JavadocHintProvider.class, (String)this.descKey, (Object)this.paramName);
        }

        public ChangeInfo implement() {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            try {
                javaSource.runModificationTask((CancellableTask)this).commit();
                if (this.doc == null || this.insertPosition == null || this.insertJavadoc == null) {
                    return null;
                }
                int n = this.insertPosition.getOffset() + this.openOffset;
                this.insertJavadoc();
                JavadocHintProvider.doOpen(this.file, n);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            catch (IOException iOException) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            return null;
        }

        public void run(final WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            final Element element = this.methodHandle.resolve((CompilationInfo)workingCopy);
            if (element == null) {
                return;
            }
            final Doc doc = workingCopy.getElementUtilities().javaDocFor(element);
            this.doc = workingCopy.getDocument();
            if (this.doc == null) {
                return;
            }
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                public void run() {
                    try {
                        AddTagFix.this.computeInsertPositionAndJavadoc((CompilationInfo)workingCopy, element, doc);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                    }
                }
            });
        }

        private void computeInsertPositionAndJavadoc(CompilationInfo compilationInfo, Element element, Doc doc) throws BadLocationException {
            boolean[] blArray = new boolean[1];
            switch (this.kind) {
                case PARAM: {
                    this.insertPosition = this.getParamInsertPosition(compilationInfo, this.doc, (ExecutableElement)element, doc, blArray);
                    this.insertJavadoc = "@param " + this.paramName + " ";
                    break;
                }
                case TYPEPARAM: {
                    this.insertPosition = this.getTypeParamInsertPosition(compilationInfo, this.doc, (TypeElement)element, doc, blArray);
                    this.insertJavadoc = "@param " + this.paramName + " ";
                    break;
                }
                case RETURN: {
                    this.insertPosition = this.getReturnInsertPosition(compilationInfo, this.doc, doc, blArray);
                    this.insertJavadoc = "@return ";
                    break;
                }
                case THROWS: {
                    this.insertPosition = this.getThrowsInsertPosition(compilationInfo, this.doc, (ExecutableMemberDoc)doc, blArray);
                    this.insertJavadoc = "@throws " + this.paramName + " ";
                    break;
                }
                case DEPRECATED: {
                    this.insertPosition = this.getDeprecatedInsertPosition(compilationInfo, this.doc, doc, blArray);
                    this.insertJavadoc = "@deprecated ";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Position[] positionArray = JavadocUtilities.findDocBounds(compilationInfo, this.doc, doc);
            int n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)positionArray[0].getOffset());
            int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)positionArray[1].getOffset());
            int n3 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.insertPosition.getOffset());
            String string = JavadocGenerator.guessJavadocIndentation(compilationInfo, this.doc, doc);
            if (n == n3 && n3 == n2) {
                this.insertJavadoc = '\n' + string + "* " + this.insertJavadoc;
                this.openOffset = this.insertJavadoc.length();
                this.insertJavadoc = this.insertJavadoc + '\n' + string;
            } else if (n3 == n2 && !blArray[0]) {
                this.openOffset = 2 + this.insertJavadoc.length();
                this.insertJavadoc = "* " + this.insertJavadoc + '\n' + string;
            } else if (blArray[0]) {
                this.insertJavadoc = '\n' + string + "* " + this.insertJavadoc;
                this.openOffset = this.insertJavadoc.length();
            } else {
                this.openOffset = this.insertJavadoc.length();
                this.insertJavadoc = this.insertJavadoc + '\n' + string + "* ";
            }
        }

        private void insertJavadoc() throws BadLocationException {
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                public void run() {
                    try {
                        AddTagFix.this.doc.insertString(AddTagFix.this.insertPosition.getOffset(), AddTagFix.this.insertJavadoc, null);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                    }
                }
            });
        }

        public void cancel() {
        }

        private Position getDeprecatedInsertPosition(CompilationInfo compilationInfo, Document document, Doc doc, boolean[] blArray) throws BadLocationException {
            return this.getTagInsertPosition(compilationInfo, document, doc, null, false, blArray);
        }

        private Position getTypeParamInsertPosition(CompilationInfo compilationInfo, Document document, TypeElement typeElement, Doc doc, boolean[] blArray) throws BadLocationException {
            Tag[] tagArray = doc.tags("@param");
            Tag tag = null;
            boolean bl = true;
            if (tagArray.length > 0) {
                int n = this.findParamIndex(typeElement.getTypeParameters(), this.paramName);
                tag = n < tagArray.length ? tagArray[n] : tagArray[tagArray.length - 1];
                bl = n < tagArray.length;
            } else {
                tagArray = doc.tags();
                if (tagArray.length > 0) {
                    tag = tagArray[0];
                }
            }
            return this.getTagInsertPosition(compilationInfo, document, doc, tag, bl, blArray);
        }

        private Position getThrowsInsertPosition(CompilationInfo compilationInfo, Document document, ExecutableMemberDoc executableMemberDoc, boolean[] blArray) throws BadLocationException {
            ThrowsTag[] throwsTagArray = executableMemberDoc.throwsTags();
            ThrowsTag throwsTag = null;
            boolean bl = true;
            if (throwsTagArray.length > 0) {
                int n = this.index;
                throwsTag = n < throwsTagArray.length ? throwsTagArray[n] : throwsTagArray[throwsTagArray.length - 1];
                bl = n < throwsTagArray.length;
            } else {
                throwsTagArray = executableMemberDoc.tags("@return");
                if (throwsTagArray.length == 0) {
                    throwsTagArray = executableMemberDoc.tags("@param");
                }
                if (throwsTagArray.length == 0) {
                    throwsTagArray = executableMemberDoc.tags();
                } else {
                    bl = false;
                }
                if (throwsTagArray.length > 0) {
                    throwsTag = throwsTagArray[0];
                }
            }
            return this.getTagInsertPosition(compilationInfo, document, (Doc)executableMemberDoc, (Tag)throwsTag, bl, blArray);
        }

        private Position getReturnInsertPosition(CompilationInfo compilationInfo, Document document, Doc doc, boolean[] blArray) throws BadLocationException {
            Tag[] tagArray = doc.tags("@param");
            Tag tag = null;
            boolean bl = true;
            if (tagArray.length > 0) {
                tag = tagArray[tagArray.length - 1];
                bl = false;
            } else {
                tagArray = doc.tags();
                if (tagArray.length > 0) {
                    tag = tagArray[0];
                }
            }
            return this.getTagInsertPosition(compilationInfo, document, doc, tag, bl, blArray);
        }

        private Position getParamInsertPosition(CompilationInfo compilationInfo, Document document, ExecutableElement executableElement, Doc doc, boolean[] blArray) throws BadLocationException {
            Tag[] tagArray = doc.tags("@param");
            Tag tag = null;
            boolean bl = true;
            if (tagArray.length > 0) {
                int n = this.findParamIndex(executableElement.getParameters(), this.paramName);
                tag = n < tagArray.length ? tagArray[n] : tagArray[tagArray.length - 1];
                bl = n < tagArray.length;
            } else {
                tagArray = doc.tags();
                if (tagArray.length > 0) {
                    tag = tagArray[0];
                }
            }
            return this.getTagInsertPosition(compilationInfo, document, doc, tag, bl, blArray);
        }

        private Position getTagInsertPosition(CompilationInfo compilationInfo, Document document, Doc doc, Tag tag, boolean bl, boolean[] blArray) throws BadLocationException {
            Position[] positionArray = null;
            if (tag != null) {
                positionArray = JavadocUtilities.findTagBounds(compilationInfo, document, tag, blArray);
                if (bl) {
                    blArray[0] = false;
                }
            } else {
                positionArray = JavadocUtilities.findLastTokenBounds(compilationInfo, document, doc);
                bl = false;
                blArray[0] = false;
            }
            return bl ? positionArray[0] : positionArray[1];
        }

        private int findParamIndex(List<? extends Element> list, String string) {
            int n = 0;
            for (Element element : list) {
                if (string.contentEquals(element.getSimpleName())) {
                    return n;
                }
                ++n;
            }
            throw new IllegalArgumentException("Unknown param: " + string);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Kind {
            PARAM,
            RETURN,
            THROWS,
            TYPEPARAM,
            DEPRECATED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Analyzer
    extends TreePathScanner<Void, List<ErrorDescription>> {
        private final CompilationInfo javac;
        private final SourceVersion spec;
        private final FixAll fixAll = new FixAll();
        private final Document doc;
        private int createJavadocHintCounter = JavadocHintProvider.access$100();
        private int fixJavadocHintCounter = JavadocHintProvider.access$200();

        Analyzer(CompilationInfo compilationInfo, Document document) {
            this.javac = compilationInfo;
            this.doc = document;
            this.spec = JavadocHintProvider.resolveSourceVersion(compilationInfo.getFileObject());
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, List<ErrorDescription> list) {
            return (Void)this.scan(compilationUnitTree.getTypeDecls(), list);
        }

        @Override
        public Void visitClass(ClassTree classTree, List<ErrorDescription> list) {
            if (access.isAccesible(classTree.getModifiers().getFlags())) {
                this.processNode(classTree, list);
                return (Void)this.scan(classTree.getMembers(), list);
            }
            return null;
        }

        @Override
        public Void visitMethod(MethodTree methodTree, List<ErrorDescription> list) {
            Tree tree = this.getCurrentPath().getParentPath().getLeaf();
            if (tree.getKind() == Tree.Kind.CLASS && (this.javac.getTreeUtilities().isInterface((ClassTree)tree) || this.javac.getTreeUtilities().isAnnotation((ClassTree)tree) || access.isAccesible(methodTree.getModifiers().getFlags()))) {
                this.processNode(methodTree, list);
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, List<ErrorDescription> list) {
            if (access.isAccesible(variableTree.getModifiers().getFlags())) {
                this.processNode(variableTree, list);
            }
            return null;
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, List<ErrorDescription> list) {
            return null;
        }

        void processNode(Tree tree, List<ErrorDescription> list) {
            this.checkTaskState();
            if (this.javac.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return;
            }
            Element element = this.javac.getTrees().getElement(this.getCurrentPath());
            if (element == null) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, "Cannot resolve element for " + tree + " in " + JavadocHintProvider.this.file);
                return;
            }
            if (this.isGuarded(tree)) {
                return;
            }
            String string = this.javac.getElements().getDocComment(element);
            if (string == null) {
                if (this.createJavadocHintCounter <= 0 || JavadocUtilities.hasInheritedDoc(this.javac, element)) {
                    return;
                }
                try {
                    Position[] positionArray = this.createSignaturePositions(tree);
                    ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)hintSeverity, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_JAVADOC_DESC"), (LazyFixList)this.createGenerateFixes(element), (Document)this.doc, (Position)positionArray[0], (Position)positionArray[1]);
                    list.add(errorDescription);
                    if (--this.createJavadocHintCounter <= 0) {
                        ErrorDescription errorDescription2 = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"OUT_OF_MISSING_JD_LIMIT_DESC", (Object)CREATE_JAVADOC_HINT_LIMIT), (Document)this.doc, (Position)positionArray[0], (Position)positionArray[1]);
                        list.add(errorDescription2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                }
            } else {
                if (this.fixJavadocHintCounter <= 0) {
                    return;
                }
                try {
                    Doc doc = this.javac.getElementUtilities().javaDocFor(element);
                    if (doc.isMethod() || doc.isConstructor()) {
                        ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)doc;
                        ExecutableElement executableElement = (ExecutableElement)element;
                        MethodTree methodTree = (MethodTree)tree;
                        this.processParameters(executableElement, methodTree, executableMemberDoc, list);
                        this.processReturn(executableElement, methodTree, executableMemberDoc, list);
                        this.processThrows(executableElement, methodTree, executableMemberDoc, list);
                    } else if (doc.isClass() || doc.isInterface()) {
                        TypeElement typeElement = (TypeElement)element;
                        ClassDoc classDoc = (ClassDoc)doc;
                        ClassTree classTree = (ClassTree)tree;
                        this.processTypeParameters(typeElement, classTree, classDoc, list);
                    } else if (doc.isAnnotationType()) {
                        this.processAnnTypeParameters(element, tree, doc, list);
                    } else if (doc.isAnnotationTypeElement()) {
                        AnnotationTypeElementDoc annotationTypeElementDoc = (AnnotationTypeElementDoc)doc;
                        ExecutableElement executableElement = (ExecutableElement)element;
                        MethodTree methodTree = (MethodTree)tree;
                        this.processAnnTypeParameters(executableElement, methodTree, (Doc)annotationTypeElementDoc, list);
                        this.processReturn(executableElement, methodTree, (ExecutableMemberDoc)annotationTypeElementDoc, list);
                        this.processAnnTypeThrows(executableElement, methodTree, annotationTypeElementDoc, list);
                    }
                    this.processDeprecatedAnnotation(element, doc, list);
                }
                catch (OutOfLimitException outOfLimitException) {
                    // empty catch block
                }
            }
        }

        private void processDeprecatedAnnotation(Element element, Doc doc, List<ErrorDescription> list) {
            if (SourceVersion.RELEASE_5.compareTo(this.spec) > 0) {
                return;
            }
            Tag[] tagArray = doc.tags("@deprecated");
            AnnotationMirror annotationMirror = JavadocUtilities.findDeprecated(this.javac, element);
            if (annotationMirror != null) {
                if (tagArray.length == 0) {
                    try {
                        Position[] positionArray = this.createPositions(this.javac.getTrees().getTree(element, annotationMirror));
                        ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)hintSeverity, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_DEPRECATED_DESC"), Collections.singletonList(AddTagFix.createAddDeprecatedTagFix(element, JavadocHintProvider.this.file, this.spec)), (Document)this.doc, (Position)positionArray[0], (Position)positionArray[1]);
                        this.addTagHint(list, errorDescription);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                    }
                } else if (tagArray.length > 1) {
                    boolean bl = true;
                    for (Tag tag : tagArray) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        this.addRemoveTagFix(tag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_DEPRECATED_DESC"), element, list);
                    }
                }
            } else {
                if (tagArray.length > 1) {
                    boolean bl = true;
                    for (Tag tag : tagArray) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        this.addRemoveTagFix(tag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_DEPRECATED_DESC"), element, list);
                    }
                }
                if (tagArray.length > 0) {
                    // empty if block
                }
            }
        }

        private void processReturn(ExecutableElement executableElement, MethodTree methodTree, ExecutableMemberDoc executableMemberDoc, List<ErrorDescription> list) {
            Tag tag;
            int n;
            TypeMirror typeMirror = executableElement.getReturnType();
            Tree tree = methodTree.getReturnType();
            Tag[] tagArray = executableMemberDoc.tags("@return");
            if (typeMirror.getKind() == TypeKind.VOID) {
                for (n = 0; n < tagArray.length; ++n) {
                    tag = tagArray[n];
                    this.addRemoveTagFix(tag, NbBundle.getMessage(JavadocHintProvider.class, (String)(executableMemberDoc.isMethod() ? "WRONG_RETURN_DESC" : "WRONG_CONSTRUCTOR_RETURN_DESC")), executableElement, list);
                }
            } else {
                for (n = 0; n < tagArray.length; ++n) {
                    tag = tagArray[n];
                    if (n <= 0) continue;
                    this.addRemoveTagFix(tag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_RETURN_DESC"), executableElement, list);
                }
            }
            if (typeMirror.getKind() != TypeKind.VOID && tagArray.length == 0 && JavadocUtilities.findReturnTag(this.javac, (MethodDoc)executableMemberDoc, true) == null) {
                try {
                    Position[] positionArray = this.createPositions(tree);
                    tag = ErrorDescriptionFactory.createErrorDescription((Severity)hintSeverity, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_RETURN_DESC"), Collections.singletonList(AddTagFix.createAddReturnTagFix(executableElement, JavadocHintProvider.this.file, this.spec)), (Document)this.doc, (Position)positionArray[0], (Position)positionArray[1]);
                    this.addTagHint(list, (ErrorDescription)tag);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processThrows(ExecutableElement executableElement, MethodTree methodTree, ExecutableMemberDoc executableMemberDoc, List<ErrorDescription> list) {
            Object object;
            Object object2;
            Object object32;
            void expressionTree;
            List<? extends ExpressionTree> list2 = methodTree.getThrows();
            ThrowsTag[] throwsTagArray = executableMemberDoc.throwsTags();
            HashMap<String, ThrowsTag> hashMap = new HashMap<String, ThrowsTag>();
            ThrowsTag[] throwsTagArray2 = throwsTagArray;
            int n = throwsTagArray2.length;
            boolean bl = false;
            while (expressionTree < n) {
                object32 = throwsTagArray2[expressionTree];
                object2 = object32.exceptionType();
                object = null;
                object = object2 != null ? object32.exceptionType().qualifiedTypeName() : object32.exceptionName();
                if (hashMap.containsKey(object)) {
                    this.addRemoveTagFix((Tag)object32, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_THROWS_DESC", (Object)object32.name(), (Object)object32.exceptionName()), executableElement, list);
                } else {
                    hashMap.put((String)object, (ThrowsTag)object32);
                }
                ++expressionTree;
            }
            int n2 = 0;
            for (ExpressionTree expressionTree2 : list2) {
                ++n2;
                object32 = new TreePath(this.getCurrentPath(), expressionTree2);
                object2 = this.javac.getTrees().getElement((TreePath)object32);
                object = (TypeElement)object2;
                boolean element = hashMap.remove(object.getQualifiedName().toString()) != null;
                if (element || !executableMemberDoc.isConstructor() && (!executableMemberDoc.isMethod() || JavadocUtilities.findThrowsTag(this.javac, (MethodDoc)executableMemberDoc, object.getQualifiedName().toString(), true) != null)) continue;
                try {
                    Position[] badLocationException = this.createPositions(expressionTree2);
                    ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)hintSeverity, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_THROWS_DESC", (Object)object.getQualifiedName().toString()), Collections.singletonList(AddTagFix.createAddThrowsTagFix(executableElement, object.getQualifiedName().toString(), n2, JavadocHintProvider.this.file, this.spec)), (Document)this.doc, (Position)badLocationException[0], (Position)badLocationException[1]);
                    this.addTagHint(list, errorDescription);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                }
            }
            TypeMirror typeMirror = this.javac.getElements().getTypeElement("java.lang.RuntimeException").asType();
            for (Object object32 : hashMap.values()) {
                Element element;
                object2 = object32.exceptionType();
                object = null;
                if (object2 != null) {
                    object = object2.asClassDoc();
                }
                if (object != null && (element = this.javac.getElementUtilities().elementFor((Doc)object)) != null && this.javac.getTypes().isSubtype(element.asType(), typeMirror)) break;
                this.addRemoveTagFix((Tag)object32, NbBundle.getMessage(JavadocHintProvider.class, (String)"UNKNOWN_THROWABLE_DESC", (Object)object32.name(), (Object)object32.exceptionName()), executableElement, list);
            }
        }

        private void processAnnTypeThrows(ExecutableElement executableElement, MethodTree methodTree, AnnotationTypeElementDoc annotationTypeElementDoc, List<ErrorDescription> list) {
            Tag[] tagArray;
            for (Tag tag : tagArray = annotationTypeElementDoc.tags("@throws")) {
                ThrowsTag throwsTag = (ThrowsTag)tag;
                this.addRemoveTagFix((Tag)throwsTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"ILLEGAL_ANNOTATION_TYPE_THROWS_DESC", (Object)throwsTag.name(), (Object)throwsTag.exceptionName()), executableElement, list);
            }
        }

        private void processAnnTypeParameters(Element element, Tree tree, Doc doc, List<ErrorDescription> list) {
            Tag[] tagArray;
            for (Tag tag : tagArray = doc.tags("@param")) {
                ParamTag paramTag = (ParamTag)tag;
                this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"ILLEGAL_ANNOTATION_TYPE_PARAM_DESC", (Object)paramTag.parameterName()), element, list);
            }
        }

        private void processParameters(ExecutableElement executableElement, MethodTree methodTree, ExecutableMemberDoc executableMemberDoc, List<ErrorDescription> list) {
            int n;
            List<? extends VariableTree> list2 = methodTree.getParameters();
            Tag[] tagArray = executableMemberDoc.tags("@param");
            HashMap<String, ParamTag> hashMap = new HashMap<String, ParamTag>();
            for (Tag object2 : tagArray) {
                ParamTag paramTag = (ParamTag)object2;
                if (paramTag.isTypeParameter()) continue;
                if (hashMap.containsKey(paramTag.parameterName())) {
                    this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_PARAM_DESC", (Object)paramTag.parameterName()), executableElement, list);
                    continue;
                }
                hashMap.put(paramTag.parameterName(), paramTag);
            }
            for (VariableTree variableTree : list2) {
                n = hashMap.remove(variableTree.getName().toString()) != null ? 1 : 0;
                if (n != 0 || !executableMemberDoc.isConstructor() && (!executableMemberDoc.isMethod() || JavadocUtilities.findParamTag(this.javac, (MethodDoc)executableMemberDoc, variableTree.getName().toString(), true) != null)) continue;
                try {
                    Position[] positionArray = this.createPositions(variableTree);
                    ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)hintSeverity, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_PARAM_DESC", (Object)variableTree.getName()), Collections.singletonList(AddTagFix.createAddParamTagFix(executableElement, variableTree.getName().toString(), JavadocHintProvider.this.file, this.spec)), (Document)this.doc, (Position)positionArray[0], (Position)positionArray[1]);
                    this.addTagHint(list, errorDescription);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                }
            }
            for (ParamTag paramTag : hashMap.values()) {
                n = 0;
                for (TypeParameterElement typeParameterElement : executableElement.getTypeParameters()) {
                    if (!paramTag.parameterName().equals(typeParameterElement.getSimpleName().toString())) continue;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"UNKNOWN_PARAM_DESC", (Object)paramTag.parameterName()), executableElement, list);
            }
        }

        private void processTypeParameters(TypeElement typeElement, ClassTree classTree, ClassDoc classDoc, List<ErrorDescription> list) {
            ParamTag paramTag;
            List<? extends TypeParameterTree> list2 = classTree.getTypeParameters();
            Tag[] tagArray = classDoc.tags("@param");
            HashMap<String, ParamTag> hashMap = new HashMap<String, ParamTag>();
            for (Tag positionArray : tagArray) {
                paramTag = (ParamTag)positionArray;
                if (hashMap.containsKey(paramTag.parameterName())) {
                    this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(JavadocHintProvider.class, (String)"DUPLICATE_TYPEPARAM_DESC", (Object)paramTag.parameterName()), typeElement, list);
                    continue;
                }
                hashMap.put(paramTag.parameterName(), paramTag);
            }
            for (TypeParameterTree typeParameterTree : list2) {
                int n = hashMap.remove(typeParameterTree.getName().toString()) != null ? 1 : 0;
                if (n != 0) continue;
                try {
                    Position[] positionArray = this.createPositions(typeParameterTree);
                    paramTag = ErrorDescriptionFactory.createErrorDescription((Severity)hintSeverity, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_TYPEPARAM_DESC", (Object)typeParameterTree.getName()), Collections.singletonList(AddTagFix.createAddTypeParamTagFix(typeElement, typeParameterTree.getName().toString(), JavadocHintProvider.this.file, this.spec)), (Document)this.doc, (Position)positionArray[0], (Position)positionArray[1]);
                    this.addTagHint(list, (ErrorDescription)paramTag);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                }
            }
            for (ParamTag paramTag2 : hashMap.values()) {
                this.addRemoveTagFix((Tag)paramTag2, NbBundle.getMessage(JavadocHintProvider.class, (String)"UNKNOWN_TYPEPARAM_DESC", (Object)paramTag2.parameterName()), typeElement, list);
            }
        }

        Position[] createPositions(Tree tree) throws BadLocationException {
            Position[] positionArray = new Position[2];
            int n = (int)this.javac.getTrees().getSourcePositions().getStartPosition(this.javac.getCompilationUnit(), tree);
            int n2 = (int)this.javac.getTrees().getSourcePositions().getEndPosition(this.javac.getCompilationUnit(), tree);
            positionArray[0] = this.doc.createPosition(n);
            positionArray[1] = this.doc.createPosition(n2);
            return positionArray;
        }

        Position[] createSignaturePositions(final Tree tree) throws BadLocationException {
            final Position[] positionArray = new Position[2];
            final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
            NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                public void run() {
                    try {
                        TokenSequence<JavaTokenId> tokenSequence = null;
                        if (tree.getKind() == Tree.Kind.METHOD) {
                            tokenSequence = JavadocUtilities.findMethodNameToken(Analyzer.this.javac, (ClassTree)Analyzer.this.getCurrentPath().getParentPath().getLeaf(), (MethodTree)tree);
                        } else if (tree.getKind() == Tree.Kind.CLASS) {
                            tokenSequence = JavadocUtilities.findClassNameToken(Analyzer.this.javac, (ClassTree)tree);
                        } else if (Tree.Kind.VARIABLE == tree.getKind()) {
                            tokenSequence = JavadocUtilities.findVariableNameToken(Analyzer.this.javac, (VariableTree)tree, Analyzer.this.javac.getTreeUtilities().isEnum((ClassTree)Analyzer.this.getCurrentPath().getParentPath().getLeaf()));
                        }
                        if (tokenSequence != null) {
                            positionArray[0] = Analyzer.this.doc.createPosition(tokenSequence.offset());
                            positionArray[1] = Analyzer.this.doc.createPosition(tokenSequence.offset() + tokenSequence.token().length());
                            return;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationExceptionArray[0] = badLocationException;
                    }
                }
            });
            if (badLocationExceptionArray[0] != null) {
                throw (BadLocationException)new BadLocationException(badLocationExceptionArray[0].getMessage(), badLocationExceptionArray[0].offsetRequested()).initCause(badLocationExceptionArray[0]);
            }
            return positionArray;
        }

        private boolean isGuarded(Tree tree) {
            GuardedSectionManager guardedSectionManager = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)this.doc));
            if (guardedSectionManager != null) {
                try {
                    int n = (int)this.javac.getTrees().getSourcePositions().getStartPosition(this.javac.getCompilationUnit(), tree);
                    Position position = this.doc.createPosition(n);
                    for (GuardedSection guardedSection : guardedSectionManager.getGuardedSections()) {
                        if (!guardedSection.contains(position, false)) continue;
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                    return true;
                }
            }
            return false;
        }

        private void addRemoveTagFix(Tag tag, String string, Element element, List<ErrorDescription> list) {
            try {
                Position[] positionArray = JavadocUtilities.findTagNameBounds(this.javac, this.doc, tag);
                if (positionArray == null) {
                    throw new BadLocationException("no position for " + tag, -1);
                }
                ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)hintSeverity, (String)string, Collections.singletonList(new RemoveTagFix(tag.name(), JavadocUtilities.TagHandle.create(tag), ElementHandle.create((Element)element), JavadocHintProvider.this.file, this.spec)), (Document)this.doc, (Position)positionArray[0], (Position)positionArray[1]);
                this.addTagHint(list, errorDescription);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
            }
        }

        JavadocLazyFixList createGenerateFixes(Element element) {
            ArrayList<Fix> arrayList = new ArrayList<Fix>(3);
            ElementHandle elementHandle = ElementHandle.create((Element)element);
            String string = element.getKind() == ElementKind.CONSTRUCTOR ? element.getEnclosingElement().getSimpleName().toString() : element.getSimpleName().toString();
            JavadocLazyFixList javadocLazyFixList = new JavadocLazyFixList(arrayList, this.fixAll);
            GenerateJavadocFix generateJavadocFix = new GenerateJavadocFix(string, elementHandle, this.javac.getFileObject(), this.spec);
            arrayList.add(generateJavadocFix);
            this.fixAll.addFix(generateJavadocFix);
            return javadocLazyFixList;
        }

        private void addTagHint(List<ErrorDescription> list, ErrorDescription errorDescription) {
            list.add(errorDescription);
            this.checkTaskState();
            if (--this.fixJavadocHintCounter <= 0) {
                try {
                    ErrorDescription errorDescription2 = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"OUT_OF_TAG_FIXES_LIMIT_DESC", (Object)FIX_JAVADOC_HINT_LIMIT), (Document)this.doc, (Position)errorDescription.getRange().getBegin().getPosition(), (Position)errorDescription.getRange().getEnd().getPosition());
                    list.add(errorDescription2);
                }
                catch (IOException iOException) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.INFO, iOException.getMessage(), iOException);
                }
                throw new OutOfLimitException();
            }
        }

        private void checkTaskState() {
            if (JavadocHintProvider.this.isCanceled()) {
                throw new CancelException();
            }
        }
    }

    private static final class CancelException
    extends RuntimeException {
        private CancelException() {
        }

        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    private static final class FixAll
    implements Fix {
        private List<GenerateJavadocFix> allJavadocFixes = new ArrayList<GenerateJavadocFix>();

        private FixAll() {
        }

        public void addFix(GenerateJavadocFix generateJavadocFix) {
            this.allJavadocFixes.add(generateJavadocFix);
        }

        public boolean isReady() {
            return this.allJavadocFixes.size() > 1;
        }

        public String getText() {
            return NbBundle.getMessage(JavadocHintProvider.class, (String)"FIX_ALL_HINT");
        }

        public ChangeInfo implement() {
            for (GenerateJavadocFix generateJavadocFix : this.allJavadocFixes) {
                generateJavadocFix.implement(false);
            }
            return null;
        }
    }

    private static final class GenerateJavadocFix
    implements Fix {
        private String name;
        private final ElementHandle handle;
        private final FileObject file;
        private Position position;
        private final SourceVersion spec;

        GenerateJavadocFix(String string, ElementHandle elementHandle, FileObject fileObject, SourceVersion sourceVersion) {
            this.name = string;
            this.handle = elementHandle;
            this.file = fileObject;
            this.spec = sourceVersion;
        }

        public String getText() {
            return NbBundle.getMessage(JavadocHintProvider.class, (String)"MISSING_JAVADOC_HINT", (Object)this.name);
        }

        public ChangeInfo implement() {
            return this.implement(true);
        }

        public ChangeInfo implement(final boolean bl) {
            final String[] stringArray = new String[1];
            final Document[] documentArray = new Document[1];
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            try {
                javaSource.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        Element element = GenerateJavadocFix.this.handle.resolve((CompilationInfo)workingCopy);
                        Tree tree = null;
                        if (element != null) {
                            tree = SourceUtils.treeFor((CompilationInfo)workingCopy, (Element)element);
                        }
                        if (tree != null) {
                            JavadocGenerator javadocGenerator = new JavadocGenerator(GenerateJavadocFix.this.spec);
                            String string = javadocGenerator.generateComment(element, (CompilationInfo)workingCopy);
                            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)0, (String)string);
                            workingCopy.getTreeMaker().addComment(tree, comment, true);
                            stringArray[0] = string;
                            documentArray[0] = workingCopy.getDocument();
                            if (documentArray[0] == null) {
                                return;
                            }
                            GenerateJavadocFix.this.position = documentArray[0].createPosition((int)workingCopy.getTrees().getSourcePositions().getStartPosition(workingCopy.getCompilationUnit(), tree));
                        }
                    }
                }).commit();
            }
            catch (IOException iOException) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            try {
                if (documentArray[0] == null) {
                    return null;
                }
                NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)documentArray[0]), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            String string = JavadocGenerator.guessIndentation(documentArray[0], GenerateJavadocFix.this.position);
                            String string2 = JavadocGenerator.indentJavadoc(stringArray[0], string);
                            documentArray[0].insertString(GenerateJavadocFix.this.position.getOffset(), string2, null);
                            int n = string2.indexOf("\n");
                            n = string2.indexOf("\n", n + 1);
                            n = GenerateJavadocFix.this.position.getOffset() + n - string2.length();
                            if (bl) {
                                JavadocHintProvider.doOpen(GenerateJavadocFix.this.file, n);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                });
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JavadocLazyFixList
    implements LazyFixList {
        private List<Fix> contexFixes;
        private FixAll fixAll;

        public JavadocLazyFixList(List<Fix> list, FixAll fixAll) {
            this.contexFixes = list;
            this.fixAll = fixAll;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public List<Fix> getFixes() {
            if (this.fixAll.isReady()) {
                this.contexFixes.add(this.fixAll);
            }
            return this.contexFixes;
        }

        public boolean isComputed() {
            return true;
        }
    }

    private static final class OutOfLimitException
    extends RuntimeException {
        private OutOfLimitException() {
        }

        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RemoveTagFix
    implements Fix,
    CancellableTask<WorkingCopy> {
        private String tagName;
        private final JavadocUtilities.TagHandle tagHandle;
        private final ElementHandle handle;
        private final FileObject file;
        private final SourceVersion spec;
        private Position[] tagBounds;
        private Document doc;

        RemoveTagFix(String string, JavadocUtilities.TagHandle tagHandle, ElementHandle elementHandle, FileObject fileObject, SourceVersion sourceVersion) {
            this.tagName = string;
            this.tagHandle = tagHandle;
            this.handle = elementHandle;
            this.file = fileObject;
            this.spec = sourceVersion;
        }

        public String getText() {
            return NbBundle.getMessage(JavadocHintProvider.class, (String)"REMOVE_TAG_HINT", (Object)this.tagName);
        }

        public ChangeInfo implement() {
            return this.implement(true);
        }

        private void removeTag(final CompilationInfo compilationInfo, Element element) throws IOException, BadLocationException {
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            if (doc != null) {
                final Tag tag = this.tagHandle.resolve(doc);
                if (tag == null) {
                    return;
                }
                final Document document = compilationInfo.getDocument();
                if (document == null) {
                    return;
                }
                NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)document), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            RemoveTagFix.access$1602(RemoveTagFix.this, JavadocUtilities.findTagBounds(compilationInfo, document, tag));
                        }
                        catch (BadLocationException badLocationException) {
                            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                        }
                    }
                });
            }
        }

        private void removeTag() throws BadLocationException {
            if (this.tagBounds == null || this.doc == null) {
                return;
            }
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                public void run() {
                    try {
                        RemoveTagFix.this.doc.remove(RemoveTagFix.this.tagBounds[0].getOffset(), RemoveTagFix.this.tagBounds[1].getOffset() - RemoveTagFix.this.tagBounds[0].getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                    }
                }
            });
        }

        public ChangeInfo implement(boolean bl) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            try {
                javaSource.runModificationTask((CancellableTask)this).commit();
                this.removeTag();
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            catch (IOException iOException) {
                Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            return null;
        }

        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            Element element = this.handle.resolve((CompilationInfo)workingCopy);
            Tree tree = null;
            if (element != null) {
                tree = SourceUtils.treeFor((CompilationInfo)workingCopy, (Element)element);
            }
            if (tree != null) {
                this.removeTag((CompilationInfo)workingCopy, element);
                this.doc = workingCopy.getDocument();
            }
        }

        static /* synthetic */ Position[] access$1602(RemoveTagFix removeTagFix, Position[] positionArray) {
            removeTagFix.tagBounds = positionArray;
            return positionArray;
        }
    }
}

