/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.ArrayList;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.netbeans.modules.javadoc.search.SearchThreadJdk12;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

class JavadocSearchEngineImpl
extends JavadocSearchEngine {
    private ArrayList tasks;
    private IndexSearchThread.DocIndexItemConsumer diiConsumer;

    JavadocSearchEngineImpl() {
    }

    public void search(String[] stringArray, final JavadocSearchEngine.SearchEngineCallback searchEngineCallback) throws NoJavadocException {
        FileObject[] fileObjectArray = JavadocRegistry.getDefault().getDocRoots();
        this.tasks = new ArrayList(fileObjectArray.length);
        this.diiConsumer = new IndexSearchThread.DocIndexItemConsumer(){

            public void addDocIndexItem(DocIndexItem docIndexItem) {
                searchEngineCallback.addItem(docIndexItem);
            }

            public void indexSearchThreadFinished(IndexSearchThread indexSearchThread) {
                JavadocSearchEngineImpl.this.tasks.remove(indexSearchThread);
                if (JavadocSearchEngineImpl.this.tasks.isEmpty()) {
                    searchEngineCallback.finished();
                }
            }
        };
        if (fileObjectArray.length <= 0) {
            searchEngineCallback.finished();
            throw new NoJavadocException();
        }
        String string = stringArray[0];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            JavadocSearchType javadocSearchType = JavadocRegistry.getDefault().findSearchType(fileObjectArray[i]);
            if (javadocSearchType == null) {
                ErrorManager.getDefault().log("NO Search type for " + fileObjectArray[i]);
                continue;
            }
            FileObject fileObject = javadocSearchType.getDocFileObject(fileObjectArray[i]);
            if (fileObject == null) {
                ErrorManager.getDefault().log("NO Index files fot " + fileObjectArray[i]);
                continue;
            }
            IndexSearchThread indexSearchThread = javadocSearchType.getSearchThread(string, fileObject, this.diiConsumer);
            this.tasks.add(indexSearchThread);
            indexSearchThread.go();
        }
    }

    public void stop() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            SearchThreadJdk12 searchThreadJdk12 = (SearchThreadJdk12)this.tasks.get(i);
            searchThreadJdk12.finish();
        }
    }
}

