/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;

public final class Diagnostics
implements Appendable {
    private static PrintWriter log;
    private static String path;

    public static synchronized void init() {
        if (log != null) {
            return;
        }
        path = System.getProperty("svnLog");
        if (path != null && !path.trim().equals("")) {
            try {
                log = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "utf8"));
                System.setProperty("svnClientAdapter.logger.Appendable", "org.netbeans.modules.subversion.Diagnostics");
                System.err.println("Subversion diagnostics: ON");
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public Diagnostics() {
        Diagnostics.init();
    }

    public static synchronized void println(String string) {
        if (log != null) {
            log.println(Thread.currentThread().getName() + ": " + string);
            log.flush();
        }
    }

    public static synchronized void printTrace() {
        if (log != null) {
            String string = Utils.getStackTrace();
            log.println(string);
            log.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Appendable append(CharSequence charSequence) throws IOException {
        try {
            PrintWriter printWriter = log.append(Thread.currentThread().getName() + ": " + charSequence);
            return printWriter;
        }
        finally {
            log.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
        try {
            PrintWriter printWriter = log.append(charSequence, n, n2);
            return printWriter;
        }
        finally {
            log.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Appendable append(char c) throws IOException {
        try {
            PrintWriter printWriter = log.append(c);
            return printWriter;
        }
        finally {
            log.flush();
        }
    }

    public String toString() {
        return "" + path;
    }
}

