/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.IOException;
import org.openide.ErrorManager;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class OutputLogger
implements ISVNNotifyListener {
    private InputOutput log;
    private boolean ignoreCommand = false;
    private String repositoryRootString;

    public static OutputLogger getLogger(SVNUrl sVNUrl) {
        if (sVNUrl != null) {
            return new OutputLogger(sVNUrl);
        }
        return new NullLogger();
    }

    private OutputLogger(SVNUrl sVNUrl) {
        this.repositoryRootString = sVNUrl.toString();
        this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
    }

    private OutputLogger() {
    }

    public void logCommandLine(String string) {
        this.logln(string, false);
        this.flushLog();
    }

    public void logCompleted(String string) {
        this.logln(string, this.ignoreCommand);
        this.flushLog();
    }

    public void logError(String string) {
        this.logln(string, false);
        this.flushLog();
    }

    public void logMessage(String string) {
        this.logln(string, this.ignoreCommand);
        this.flushLog();
    }

    public void logRevision(long l, String string) {
    }

    public void onNotify(File file, SVNNodeKind sVNNodeKind) {
    }

    public void setCommand(int n) {
        this.ignoreCommand = n == 19 || n == 12 || n == 25 || n == 13 || n == 11;
    }

    private void logln(String string, boolean bl) {
        this.log(string + "\n", null, bl);
    }

    private void log(String string, OutputListener outputListener, boolean bl) {
        if (bl) {
            return;
        }
        if (this.log.isClosed()) {
            this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
            try {
                this.log.getOut().reset();
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.notify((Throwable)iOException);
            }
        }
        if (outputListener != null) {
            try {
                this.log.getOut().println(string, outputListener);
            }
            catch (IOException iOException) {
                this.log.getOut().write(string);
            }
        } else {
            this.log.getOut().write(string);
        }
    }

    public void closeLog() {
        this.log.getOut().flush();
        this.log.getOut().close();
    }

    public void flushLog() {
        this.log.getOut().flush();
    }

    private static class NullLogger
    extends OutputLogger {
        private NullLogger() {
        }

        public void logCommandLine(String string) {
        }

        public void logCompleted(String string) {
        }

        public void logError(String string) {
        }

        public void logMessage(String string) {
        }

        public void logRevision(long l, String string) {
        }

        public void onNotify(File file, SVNNodeKind sVNNodeKind) {
        }

        public void setCommand(int n) {
        }

        public void closeLog() {
        }

        public void flushLog() {
        }
    }
}

