/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnModuleConfig {
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_DEFAULT_VALUES = "defaultValues";
    public static final String PROP_TEXT_ANNOTATIONS_FORMAT = "textAnnotations";
    public static final String KEY_EXECUTABLE_BINARY = "svnExecBinary";
    public static final String KEY_ANNOTATION_FORMAT = "annotationFormat";
    private static final String RECENT_URL = "repository.recentURL";
    private static final String SHOW_CHECKOUT_COMPLETED = "checkoutCompleted.showCheckoutCompleted";
    private static final String URL_EXP = "annotator.urlExp";
    private static final String ANNOTATION_EXP = "annotator.annotationExp";
    public static final String TEXT_ANNOTATIONS_FORMAT_DEFAULT = "{DEFAULT}";
    private static final SvnModuleConfig INSTANCE = new SvnModuleConfig();
    private Set<String> exclusions;
    private TableSorter importTableSorter;
    private TableSorter commitTableSorter;

    public static SvnModuleConfig getDefault() {
        return INSTANCE;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(SvnModuleConfig.class);
    }

    public boolean getShowCheckoutCompleted() {
        return this.getPreferences().getBoolean(SHOW_CHECKOUT_COMPLETED, true);
    }

    public Pattern[] getIgnoredFilePatterns() {
        return SvnModuleConfig.getDefaultFilePatterns();
    }

    public boolean isExcludedFromCommit(String string) {
        return this.getCommitExclusions().contains(string);
    }

    public void addExclusionPaths(Collection<String> collection) {
        Set<String> set = this.getCommitExclusions();
        if (set.addAll(collection)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(set));
        }
    }

    public void removeExclusionPaths(Collection<String> collection) {
        Set<String> set = this.getCommitExclusions();
        if (set.removeAll(collection)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(set));
        }
    }

    public String getExecutableBinaryPath() {
        return this.getPreferences().get(KEY_EXECUTABLE_BINARY, "");
    }

    public void setExecutableBinaryPath(String string) {
        this.getPreferences().put(KEY_EXECUTABLE_BINARY, string);
    }

    public String getAnnotationFormat() {
        return this.getPreferences().get(KEY_ANNOTATION_FORMAT, this.getDefaultAnnotationFormat());
    }

    public String getDefaultAnnotationFormat() {
        return "[{" + Annotator.ANNOTATION_STATUS + "} {" + Annotator.ANNOTATION_FOLDER + "}]";
    }

    public void setAnnotationFormat(String string) {
        this.getPreferences().put(KEY_ANNOTATION_FORMAT, string);
    }

    public void setShowCheckoutCompleted(boolean bl) {
        this.getPreferences().putBoolean(SHOW_CHECKOUT_COMPLETED, bl);
    }

    public RepositoryConnection getRepositoryConnection(String string) {
        List<RepositoryConnection> list = this.getRecentUrls();
        for (RepositoryConnection repositoryConnection : list) {
            if (!string.equals(repositoryConnection.getUrl())) continue;
            return repositoryConnection;
        }
        return null;
    }

    public void insertRecentUrl(RepositoryConnection repositoryConnection) {
        Preferences preferences = this.getPreferences();
        List list = Utils.getStringList((Preferences)preferences, (String)RECENT_URL);
        for (String string : list) {
            RepositoryConnection repositoryConnection2 = RepositoryConnection.parse(string);
            if (!repositoryConnection2.equals(repositoryConnection)) continue;
            Utils.removeFromArray((Preferences)preferences, (String)RECENT_URL, (String)string);
        }
        Utils.insert((Preferences)preferences, (String)RECENT_URL, (String)RepositoryConnection.getString(repositoryConnection), (int)-1);
    }

    public void setRecentUrls(List<RepositoryConnection> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = 0;
        Object object = list.iterator();
        while (object.hasNext()) {
            ++n;
            RepositoryConnection repositoryConnection = object.next();
            arrayList.add(RepositoryConnection.getString(repositoryConnection));
        }
        object = this.getPreferences();
        Utils.put((Preferences)object, (String)RECENT_URL, arrayList);
    }

    public List<RepositoryConnection> getRecentUrls() {
        Preferences preferences = this.getPreferences();
        List list = Utils.getStringList((Preferences)preferences, (String)RECENT_URL);
        ArrayList<RepositoryConnection> arrayList = new ArrayList<RepositoryConnection>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RepositoryConnection repositoryConnection = RepositoryConnection.parse((String)iterator.next());
            arrayList.add(repositoryConnection);
        }
        return arrayList;
    }

    public void setAnnotationExpresions(List<AnnotationExpression> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        ArrayList<String> arrayList2 = new ArrayList<String>(list.size());
        int n = 0;
        Object object = list.iterator();
        while (object.hasNext()) {
            ++n;
            AnnotationExpression annotationExpression = object.next();
            arrayList.add(annotationExpression.getUrlExp());
            arrayList2.add(annotationExpression.getAnnotationExp());
        }
        object = this.getPreferences();
        Utils.put((Preferences)object, (String)URL_EXP, arrayList);
        Utils.put((Preferences)object, (String)ANNOTATION_EXP, arrayList2);
    }

    public List<AnnotationExpression> getAnnotationExpresions() {
        Preferences preferences = this.getPreferences();
        List list = Utils.getStringList((Preferences)preferences, (String)URL_EXP);
        List list2 = Utils.getStringList((Preferences)preferences, (String)ANNOTATION_EXP);
        List<AnnotationExpression> list3 = new ArrayList<AnnotationExpression>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            list3.add(new AnnotationExpression((String)list.get(i), (String)list2.get(i)));
        }
        if (list3.size() < 1) {
            list3 = this.getDefaultAnnotationExpresions();
        }
        return list3;
    }

    public List<AnnotationExpression> getDefaultAnnotationExpresions() {
        ArrayList<AnnotationExpression> arrayList = new ArrayList<AnnotationExpression>(1);
        arrayList.add(new AnnotationExpression(".*/(branches|tags)/(.+?)/.*", "\\2"));
        return arrayList;
    }

    public TableSorter getImportTableSorter() {
        return this.importTableSorter;
    }

    public void setImportTableSorter(TableSorter tableSorter) {
        this.importTableSorter = tableSorter;
    }

    public TableSorter getCommitTableSorter() {
        return this.commitTableSorter;
    }

    public void setCommitTableSorter(TableSorter tableSorter) {
        this.commitTableSorter = tableSorter;
    }

    private synchronized Set<String> getCommitExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<String>(Utils.getStringList((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS));
        }
        return this.exclusions;
    }

    private static Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }
}

