/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JButton;
import org.netbeans.modules.subversion.Diagnostics;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.AcceptCertificatePanel;
import org.netbeans.modules.subversion.client.CommandReport;
import org.netbeans.modules.subversion.client.MissingSvnClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.config.CertificateFile;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.ProxySettings;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SvnClientExceptionHandler {
    private final ISVNClientAdapter adapter;
    private final SvnClient client;
    private final int handledExceptions;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String CHARSET_NAME = "ASCII7";
    private CertificateFailure[] failures = new CertificateFailure[]{new CertificateFailure(1, "certificate is not yet valid", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureNotYetValid")), new CertificateFailure(2, "certificate has expired", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureHasExpired")), new CertificateFailure(4, "certificate issued for a different hostname", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureWrongHostname")), new CertificateFailure(8, "issuer is not trusted", NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CertFailureNotTrusted"))};
    public static final int EX_UNKNOWN = 0;
    public static final int EX_ACTION_CANCELED_BY_USER = 2;
    public static final int EX_AUTHENTICATION = 4;
    public static final int EX_NO_CERTIFICATE = 8;
    public static final int EX_WRONG_URL = 16;
    public static final int EX_NO_HOST_CONNECTION = 32;
    public static final int EX_UNVERSIONED_RESOURCE = 64;
    public static final int EX_WRONG_URL_IN_REVISION = 128;
    public static final int EX_URL_NON_EXISTENT = 256;
    public static final int EX_HTTP_405 = 512;
    public static final int EX_IS_ALREADY_WC = 1024;
    public static final int EX_CLOSED_CONNECTION = 2048;
    public static final int EX_COMMIT_FAILED = 4096;
    public static final int EX_FILE_ALREADY_EXISTS = 8192;
    public static final int EX_IS_OUT_OF_DATE = 16384;
    public static final int EX_NO_SVN_CLIENT = 32768;
    public static final int EX_HANDLED_EXCEPTIONS = 44;
    public static final int EX_DEFAULT_HANDLED_EXCEPTIONS = 44;
    private final SVNClientException exception;
    private final int exceptionMask;
    static final String ACTION_CANCELED_BY_USER = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_ActionCanceledByUser");

    public SvnClientExceptionHandler(SVNClientException sVNClientException, ISVNClientAdapter iSVNClientAdapter, SvnClient svnClient, int n) {
        this.exception = sVNClientException;
        this.adapter = iSVNClientAdapter;
        this.client = svnClient;
        this.handledExceptions = n;
        this.exceptionMask = SvnClientExceptionHandler.getMask(sVNClientException.getMessage());
    }

    public boolean handleException() throws Exception {
        if (this.exceptionMask != 0) {
            if ((this.handledExceptions & this.exceptionMask & 0x20) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
            if ((this.handledExceptions & this.exceptionMask & 8) == this.exceptionMask) {
                return this.handleNoCertificateError();
            }
            if ((this.handledExceptions & this.exceptionMask & 4) == this.exceptionMask) {
                return this.handleRepositoryConnectError();
            }
        }
        throw this.getException();
    }

    private boolean handleRepositoryConnectError() {
        boolean bl;
        SVNUrl sVNUrl = this.client.getSvnUrl();
        String string = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_ConnectionParameters");
        Repository repository = new Repository(string);
        repository.selectUrl(sVNUrl, true);
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Retry"));
        Object object = repository.show(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_AuthFailed"), new HelpCtx(this.getClass()), new Object[]{jButton, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel")});
        boolean bl2 = bl = object == jButton;
        if (bl) {
            RepositoryConnection repositoryConnection = repository.getSelectedRC();
            String string2 = repositoryConnection.getUsername();
            String string3 = repositoryConnection.getPassword();
            this.adapter.setUsername(string2);
            this.adapter.setPassword(string3);
            SvnModuleConfig.getDefault().insertRecentUrl(repositoryConnection);
        }
        return bl;
    }

    private boolean handleNoCertificateError() throws Exception {
        SSLSocket sSLSocket;
        SVNUrl sVNUrl = this.client.getSvnUrl();
        String string = SvnUtils.ripUserFromHost(sVNUrl.getHost());
        String string2 = sVNUrl.getProtocol() + "://" + string + ":" + sVNUrl.getPort();
        File file = CertificateFile.getSystemCertFile(string2);
        File file2 = CertificateFile.getNBCertFile(string2);
        if (!file2.exists() && file.exists()) {
            FileUtils.copyFile(file, CertificateFile.getNBCertFile(string2));
            return true;
        }
        try {
            sSLSocket = this.getSSLSocket(sVNUrl.getProtocol(), string, sVNUrl.getPort());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return false;
        }
        if (sSLSocket == null) {
            return false;
        }
        X509Certificate x509Certificate = null;
        Certificate[] certificateArray = null;
        try {
            certificateArray = sSLSocket.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            ErrorManager.getDefault().notify((Throwable)sSLPeerUnverifiedException);
            return false;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            Diagnostics.println("Cert[" + i + "] type - " + certificateArray[i].getType());
            if (!(certificateArray[i] instanceof X509Certificate)) continue;
            x509Certificate = (X509Certificate)certificateArray[i];
            Diagnostics.println("Cert[" + i + "] - notAfter " + x509Certificate.getNotAfter());
            Diagnostics.println("Cert[" + i + "] - notBefore " + x509Certificate.getNotBefore());
            try {
                x509Certificate.checkValidity();
                break;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                Diagnostics.println("Cert[" + i + "] - " + certificateExpiredException);
                continue;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                Diagnostics.println("Cert[" + i + "] - " + certificateNotYetValidException);
            }
        }
        AcceptCertificatePanel acceptCertificatePanel = new AcceptCertificatePanel();
        acceptCertificatePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        acceptCertificatePanel.certificatePane.setText(this.getCertMessage(x509Certificate, string));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)acceptCertificatePanel, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptPermanently"));
        JButton jButton2 = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptTemp"));
        JButton jButton3 = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_Reject"));
        dialogDescriptor.setOptions(new Object[]{jButton, jButton2, jButton3});
        this.showDialog(dialogDescriptor);
        if (dialogDescriptor.getValue() != jButton && dialogDescriptor.getValue() != jButton2) {
            return false;
        }
        CertificateFile certificateFile = null;
        try {
            boolean bl = dialogDescriptor.getValue() == jButton2;
            certificateFile = new CertificateFile(x509Certificate, sVNUrl.getProtocol() + "://" + string + ":" + sVNUrl.getPort(), this.getFailuresMask(), bl);
            certificateFile.store();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            ErrorManager.getDefault().notify((Throwable)certificateEncodingException);
            return false;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
        return true;
    }

    private SSLSocket getSSLSocket(String string, String string2, int n) throws Exception {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        ProxySettings proxySettings = new ProxySettings();
        String string3 = "";
        int n2 = -1;
        if (string.startsWith("https")) {
            string3 = proxySettings.getHttpsHost();
            n2 = proxySettings.getHttpsPort();
        }
        if (string3.equals("")) {
            string3 = proxySettings.getHttpHost();
            n2 = proxySettings.getHttpPort();
        }
        Socket socket = new Socket(Proxy.NO_PROXY);
        if (proxySettings.isDirect()) {
            socket.connect(new InetSocketAddress(string2, n));
        } else {
            boolean bl = false;
            try {
                socket.connect(new InetSocketAddress(string2, n));
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                socket.connect(new InetSocketAddress(string3, n2));
                this.connectProxy(socket, string2, n, string3, n2);
            }
        }
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(null, trustManagerArray, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string2, n, true);
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    private void connectProxy(Socket socket, String string, int n, String string2, int n2) throws IOException {
        byte[] byArray;
        String string3 = "CONNECT " + string + ":" + n + " HTTP/1.0\r\n" + "Connection: Keep-Alive\r\n\r\n";
        try {
            byArray = string3.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string3.getBytes();
        }
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = new byte[200];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        while (n4 < 2) {
            byte by = (byte)inputStream.read();
            if (by < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (by == 10) {
                bl = true;
                ++n4;
                continue;
            }
            if (by == 13) continue;
            n4 = 0;
            if (bl || n3 >= byArray2.length) continue;
            byArray2[n3++] = by;
        }
        String string4 = "";
        try {
            string4 = new String(byArray2, 0, n3, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string4 = new String(byArray2, 0, n3);
        }
        if (!this.isOKresponse(string4.toLowerCase())) {
            throw new IOException("Unable to connect through proxy " + string2 + ":" + n2 + ".  Proxy returns \"" + string4 + "\"");
        }
    }

    private boolean isOKresponse(String string) {
        return string.startsWith("http/1.1 200") || string.startsWith("http/1.0 200");
    }

    private void showDialog(DialogDescriptor dialogDescriptor) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private String getCertMessage(X509Certificate x509Certificate, String string) {
        CertificateFailure[] certificateFailureArray = this.getCertFailures();
        Object[] objectArray = new Object[]{string, x509Certificate.getNotBefore(), x509Certificate.getNotAfter(), x509Certificate.getIssuerDN().getName(), this.getFingerprint(x509Certificate, "SHA1"), this.getFingerprint(x509Certificate, "MD5")};
        String string2 = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_BadCertificate", (Object[])objectArray);
        for (int i = 0; i < certificateFailureArray.length; ++i) {
            string2 = certificateFailureArray[i].message + string2;
        }
        return string2;
    }

    private CertificateFailure[] getCertFailures() {
        ArrayList<CertificateFailure> arrayList = new ArrayList<CertificateFailure>();
        String string = this.getException().getMessage();
        for (int i = 0; i < this.failures.length; ++i) {
            if (string.indexOf(this.failures[i].error) <= -1) continue;
            arrayList.add(this.failures[i]);
        }
        return arrayList.toArray(new CertificateFailure[arrayList.size()]);
    }

    private int getFailuresMask() {
        CertificateFailure[] certificateFailureArray = this.getCertFailures();
        if (certificateFailureArray.length == 0) {
            return 15;
        }
        int n = 0;
        for (int i = 0; i < certificateFailureArray.length; ++i) {
            n |= certificateFailureArray[i].mask;
        }
        return n;
    }

    private String getFingerprint(X509Certificate x509Certificate, String string) {
        try {
            String string2 = new BASE64Encoder().encode(x509Certificate.getEncoded());
            string2 = string2.replace(NEWLINE, "");
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray = new BASE64Decoder().decodeBuffer(string2);
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            String string3 = "";
            for (int i = 0; i < byArray2.length; ++i) {
                String string4 = Integer.toHexString(byArray2[i] & 0xFF);
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                string3 = string3 + string4 + (i < byArray2.length - 1 ? ":" : "");
            }
            return string3;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            ErrorManager.getDefault().notify(1, (Throwable)certificateEncodingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ErrorManager.getDefault().notify(1, (Throwable)noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return "";
    }

    private SVNClientException getException() {
        return this.exception;
    }

    private static int getMask(String string) {
        if (string == null || string.trim().equals("")) {
            return 0;
        }
        if (SvnClientExceptionHandler.isAuthentication(string = string.toLowerCase())) {
            return 4;
        }
        if (SvnClientExceptionHandler.isCancelledAction(string)) {
            return 2;
        }
        if (SvnClientExceptionHandler.isNoCertificate(string)) {
            return 8;
        }
        if (SvnClientExceptionHandler.isWrongUrl(string)) {
            return 16;
        }
        if (SvnClientExceptionHandler.isNoHostConnection(string)) {
            return 32;
        }
        if (SvnClientExceptionHandler.isUnversionedResource(string)) {
            return 64;
        }
        if (SvnClientExceptionHandler.isWrongURLInRevision(string)) {
            return 128;
        }
        if (SvnClientExceptionHandler.isHTTP405(string)) {
            return 512;
        }
        if (SvnClientExceptionHandler.isAlreadyAWorkingCopy(string)) {
            return 1024;
        }
        if (SvnClientExceptionHandler.isClosedConnection(string)) {
            return 2048;
        }
        if (SvnClientExceptionHandler.isCommitFailed(string)) {
            return 4096;
        }
        if (SvnClientExceptionHandler.isNoSvnClient(string)) {
            return 32768;
        }
        return 0;
    }

    private static boolean isCancelledAction(String string) {
        return string.equals(ACTION_CANCELED_BY_USER);
    }

    private static boolean isAuthentication(String string) {
        return string.indexOf("authentication error from server: username not found") > -1 || string.indexOf("authorization failed") > -1 || string.indexOf("authentication error from server: password incorrect") > -1 || string.indexOf("can't get password") > -1;
    }

    private static boolean isNoCertificate(String string) {
        return string.indexOf("server certificate verification failed") > -1;
    }

    public static boolean isWrongUrl(String string) {
        return (string = string.toLowerCase()).indexOf("(not a valid url)") > -1;
    }

    private static boolean isNoHostConnection(String string) {
        return string.indexOf("host not found") > -1 || string.indexOf("could not connect to server") > -1 || string.indexOf("could not resolve hostname") > -1;
    }

    public static boolean isUnversionedResource(String string) {
        return (string = string.toLowerCase()).indexOf("(not a versioned resource)") > -1 || string.indexOf("is not a working copy") > -1;
    }

    public static boolean isWrongURLInRevision(String string) {
        if ((string = string.toLowerCase()).indexOf("no such revision") > -1) {
            return true;
        }
        int n = string.indexOf("unable to find repository location for");
        if (n > -1 && string.indexOf("in revision", n + 23) > -1) {
            return true;
        }
        n = string.indexOf("url");
        return n > -1 && string.indexOf("non-existent in that revision", n + 3) > -1;
    }

    private static boolean isHTTP405(String string) {
        return string.indexOf("405") > -1;
    }

    private static boolean isAlreadyAWorkingCopy(String string) {
        return string.indexOf("is already a working copy for a different url") > -1;
    }

    private static boolean isClosedConnection(String string) {
        return string.indexOf("could not read status line: an existing connection was forcibly closed by the remote host.") > -1;
    }

    private static boolean isCommitFailed(String string) {
        return string.indexOf("commit failed (details follow)") > -1;
    }

    public static boolean isFileAlreadyExists(String string) {
        return (string = string.toLowerCase()).indexOf("file already exists") > -1 || string.indexOf("mkcol") > -1 && SvnClientExceptionHandler.isHTTP405(string);
    }

    private static boolean isOutOfDate(String string) {
        return string.indexOf("out of date") > -1;
    }

    private static boolean isNoSvnClient(String string) {
        string = string.toLowerCase();
        return string.equals("command line client adapter is not available");
    }

    public static void notifyException(Exception exception, boolean bl, boolean bl2) {
        if (SvnClientExceptionHandler.isNoSvnClient(exception.getMessage())) {
            if (bl2) {
                SvnClientExceptionHandler.notifyNoClient();
            }
            return;
        }
        if (SvnClientExceptionHandler.isCancelledAction(exception.getMessage())) {
            SvnClientExceptionHandler.cancelledAction();
            return;
        }
        ErrorManager.getDefault().notify(1, (Throwable)exception);
        if (bl) {
            String string = SvnClientExceptionHandler.getCustomizedMessage(exception);
            if (string == null) {
                string = exception instanceof SVNClientException ? SvnClientExceptionHandler.parseExceptionMessage((SVNClientException)((Object)exception)) : exception.getMessage();
            }
            SvnClientExceptionHandler.annotate(string);
        }
    }

    private static void notifyNoClient() {
        MissingSvnClient missingSvnClient = new MissingSvnClient();
        missingSvnClient.show();
    }

    private static String getCustomizedMessage(Exception exception) {
        String string = null;
        if (SvnClientExceptionHandler.isHTTP405(exception.getMessage())) {
            string = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error405");
        } else if (SvnClientExceptionHandler.isOutOfDate(exception.getMessage())) {
            string = exception.getMessage() + "\n\n" + NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_Error_OutOfDate") + "\n";
        }
        return string;
    }

    public static String parseExceptionMessage(SVNClientException sVNClientException) {
        String string = sVNClientException.getMessage();
        int n = string.lastIndexOf("svn: ");
        if (n > -1) {
            string = string.substring(n + 5);
        }
        return string;
    }

    private static void annotate(String string) {
        CommandReport commandReport = new CommandReport(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_SubversionCommandError"), string);
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_CommandReport_OK"));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)commandReport, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), -1, 0, new Object[]{jButton}, (Object)jButton);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    private static void cancelledAction() {
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_OK"));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)ACTION_CANCELED_BY_USER, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_ActionCanceled_Title"), -1, 2, new Object[]{jButton}, (Object)jButton);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    static void handleInvalidKeyException(InvalidKeyException invalidKeyException) {
        ErrorManager.getDefault().notify(1, (Throwable)invalidKeyException);
        String string = NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_InvalidKeyException");
        SvnClientExceptionHandler.annotate(string);
    }

    private class CertificateFailure {
        int mask;
        String error;
        String message;

        CertificateFailure(int n, String string, String string2) {
            this.mask = n;
            this.error = string;
            this.message = string2;
        }
    }
}

