/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SvnWcUtils {
    private static final String ENTRIES = "entries";
    public static final String[] ADMIN_DIR_NAMES = new String[]{".svn", "_svn"};
    private static final String PROPS = "props";
    private static final String PROPS_BASE = "prop-base";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");

    public static File getSvnFile(File file, String string) throws IOException {
        for (int i = 0; i < ADMIN_DIR_NAMES.length; ++i) {
            File file2 = new File(file, ADMIN_DIR_NAMES[i] + "/" + string);
            if (!file2.canRead()) continue;
            return file2;
        }
        return null;
    }

    public static File getPropertiesFile(File file, boolean bl) throws IOException {
        if (file.isFile()) {
            if (bl) {
                return SvnWcUtils.getSvnFile(file.getParentFile(), "prop-base/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(bl));
            }
            return SvnWcUtils.getSvnFile(file.getParentFile(), "props/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(bl));
        }
        return SvnWcUtils.getSvnFile(file, bl ? "/dir-prop-base" : "/dir-props");
    }

    private static String getPropFileNameSuffix(boolean bl) {
        if (bl) {
            return ".svn-base";
        }
        return ".svn-work";
    }

    public static File getTextBaseFile(File file) throws IOException {
        return SvnWcUtils.getSvnFile(file.getParentFile(), "text-base/" + file.getName() + ".svn-base");
    }

    public static Date parseSvnDate(String string) throws ParseException {
        Date date = null;
        if (string != null) {
            date = dateFormat.parse(string);
        }
        return date;
    }

    static File getEntriesFile(File file) throws IOException {
        return SvnWcUtils.getSvnFile(!file.isDirectory() ? file.getParentFile() : file, ENTRIES);
    }
}

