/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.netbeans.modules.subversion.client.parser.LocalSubversionException;
import org.netbeans.modules.subversion.client.parser.SvnWcUtils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingCopyDetails {
    static final String FILE_ATTRIBUTE_VALUE = "file";
    static final String IS_HANDLED = "handled";
    private static final char SLASH_N = '\n';
    private static final char SLASH_R = '\r';
    static final String VERSION_ATTR_KEY = "wc-version";
    static final String VERSION_UNKNOWN = "";
    static final String VERSION_13 = "1.3";
    static final String VERSION_14 = "1.4";
    private final File file;
    private final Map<String, String> attributes;
    private Properties workingSvnProperties = null;
    private Properties baseSvnProperties = null;
    protected File propertiesFile = null;
    private File basePropertiesFile = null;
    private File textBaseFile = null;

    private WorkingCopyDetails(File file, Map<String, String> map) {
        this.file = file;
        this.attributes = map;
    }

    public static WorkingCopyDetails createWorkingCopy(File file, Map<String, String> map) {
        String string;
        String string2 = string = map != null ? map.get(VERSION_ATTR_KEY) : VERSION_UNKNOWN;
        if (string != null) {
            if (string.equals(VERSION_13)) {
                return new WorkingCopyDetails(file, map);
            }
            if (string.equals(VERSION_14)) {
                return new WorkingCopyDetails(file, (Map)map){

                    public boolean propertiesExist() throws IOException {
                        return this.getAttributes().containsKey("has-props");
                    }

                    public boolean propertiesModified() throws IOException {
                        return this.getAttributes().containsKey("has-prop-mods");
                    }

                    File getPropertiesFile() throws IOException {
                        if (this.propertiesFile == null) {
                            boolean bl = this.getBooleanValue("has-prop-mods");
                            this.propertiesFile = SvnWcUtils.getPropertiesFile(this.getFile(), !bl);
                        }
                        return this.propertiesFile;
                    }
                };
            }
            if (string.equals(VERSION_UNKNOWN)) {
                WorkingCopyDetails workingCopyDetails = new WorkingCopyDetails(file, map);
                if (!workingCopyDetails.isHandled()) {
                    return workingCopyDetails;
                }
                throw new UnsupportedOperationException("Unknown SVN working copy version: " + string);
            }
            throw new UnsupportedOperationException("Unknown SVN working copy version: " + string);
        }
        ErrorManager.getDefault().log(16, "Could not determine the SVN working copy version for " + file + ". Falling back on 1.3");
        return new WorkingCopyDetails(file, map);
    }

    protected Map<String, String> getAttributes() {
        return this.attributes;
    }

    protected File getFile() {
        return this.file;
    }

    public String getValue(String string, String string2) {
        String string3 = this.getValue(string);
        return string3 != null ? string3 : string2;
    }

    public String getValue(String string) {
        if (string == null) {
            return null;
        }
        return this.getAttributes() != null ? this.getAttributes().get(string) : null;
    }

    public long getLongValue(String string) throws LocalSubversionException {
        try {
            String string2 = this.getValue(string);
            if (string2 == null) {
                return -1L;
            }
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LocalSubversionException(numberFormatException);
        }
    }

    public Date getDateValue(String string) throws LocalSubversionException {
        try {
            String string2 = this.getValue(string);
            if (string2 == null || string2.equals(VERSION_UNKNOWN)) {
                return null;
            }
            return SvnWcUtils.parseSvnDate(string2);
        }
        catch (ParseException parseException) {
            throw new LocalSubversionException(parseException);
        }
    }

    public boolean getBooleanValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    public boolean isHandled() {
        return this.getBooleanValue(IS_HANDLED);
    }

    public boolean isFile() {
        return this.getAttributes() != null ? FILE_ATTRIBUTE_VALUE.equals(this.getAttributes().get("kind")) : false;
    }

    File getPropertiesFile() throws IOException {
        if (this.propertiesFile == null) {
            this.propertiesFile = SvnWcUtils.getPropertiesFile(this.file, false);
        }
        return this.propertiesFile;
    }

    File getBasePropertiesFile() throws IOException {
        if (this.basePropertiesFile == null) {
            this.basePropertiesFile = SvnWcUtils.getPropertiesFile(this.file, true);
        }
        return this.basePropertiesFile;
    }

    private File getTextBaseFile() throws IOException {
        if (this.textBaseFile == null) {
            this.textBaseFile = SvnWcUtils.getTextBaseFile(this.file);
        }
        return this.textBaseFile;
    }

    private Properties getWorkingSvnProperties() throws IOException {
        if (this.workingSvnProperties == null) {
            this.workingSvnProperties = this.loadProperties(this.getPropertiesFile());
        }
        return this.workingSvnProperties;
    }

    private Properties getBaseSvnProperties() throws IOException {
        if (this.baseSvnProperties == null) {
            this.baseSvnProperties = this.loadProperties(this.getBasePropertiesFile());
        }
        return this.baseSvnProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean propertiesExist() throws IOException {
        boolean bl = false;
        File file = this.getPropertiesFile();
        boolean bl2 = bl = file != null ? file.exists() : false;
        if (bl) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                int n;
                int n2 = ((InputStream)fileInputStream).read();
                for (n = 0; n2 != -1 && n < 5; ++n) {
                    n2 = ((InputStream)fileInputStream).read();
                }
                bl = n > 4;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return bl;
    }

    public boolean propertiesModified() throws IOException {
        Properties properties;
        File file = this.getPropertiesFile();
        File file2 = this.getBasePropertiesFile();
        if (file == null && file2 != null) {
            return true;
        }
        if (file != null && file2 == null) {
            return true;
        }
        if (file == null && file2 == null) {
            return false;
        }
        Properties properties2 = this.getBaseSvnProperties();
        return !properties2.equals(properties = this.getWorkingSvnProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        Properties properties = new Properties();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string = bufferedReader.readLine();
            String string2 = null;
            String string3 = VERSION_UNKNOWN;
            boolean bl = true;
            while (string != null) {
                if (!bl) {
                    if (string2 == null) {
                        string2 = string;
                    } else {
                        string3 = string;
                        properties.setProperty(string2, string3);
                        string2 = null;
                        string3 = VERSION_UNKNOWN;
                    }
                }
                bl = !bl;
                string = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
        return properties;
    }

    public boolean textModified() throws IOException {
        boolean bl = false;
        if (this.file.exists()) {
            File file = this.getTextBaseFile();
            if (this.file == null && file != null) {
                return true;
            }
            if (this.file != null && file == null) {
                return true;
            }
            if (this.file == null && file == null) {
                return false;
            }
            Properties properties = this.getWorkingSvnProperties();
            String string = VERSION_UNKNOWN;
            if (properties != null) {
                string = properties.getProperty("svn:special", "none");
            }
            if (string.equals("*")) {
                if (this.isSymbolicLink()) {
                    bl = false;
                }
            } else {
                String string2 = properties != null ? properties.getProperty("svn:keywords") : null;
                bl = string2 != null ? this.isModifiedByLine(string2.trim()) : this.isModifiedByByte();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSymbolicLink() throws IOException {
        boolean bl = false;
        File file = this.getTextBaseFile();
        if (file != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                bl = string.startsWith("link");
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isModifiedByByte() throws IOException {
        boolean bl = false;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(this.textBaseFile));
            inputStream2 = new BufferedInputStream(new FileInputStream(this.file));
            int n = inputStream.read();
            int n2 = inputStream2.read();
            while (n != -1) {
                if (n != n2) {
                    boolean bl2 = false;
                    if ('\n' == (char)n && '\r' == (char)n2) {
                        n2 = inputStream2.read();
                        bl2 = '\n' == (char)n2;
                    } else if ('\n' == (char)n2 && '\r' == (char)n) {
                        n = inputStream.read();
                        boolean bl3 = bl2 = '\n' == (char)n;
                    }
                    if (!bl2) {
                        boolean bl4 = true;
                        return bl4;
                    }
                }
                n = inputStream.read();
                n2 = inputStream2.read();
            }
            bl = n2 != -1;
        }
        finally {
            if (inputStream2 != null) {
                inputStream2.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isModifiedByLine(String string) throws IOException {
        Object object;
        boolean bl = false;
        String[] stringArray = string.split(" ");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i].toLowerCase();
            if (((String)object).equals("date") || ((String)object).equals("lastchangeddate")) {
                arrayList.add("LastChangedDate");
                arrayList.add("Date");
                continue;
            }
            if (((String)object).equals("revision") || ((String)object).equals("rev") || ((String)object).equals("lastchangedrevision")) {
                arrayList.add("LastChangedRevision");
                arrayList.add("Revision");
                arrayList.add("Rev");
                continue;
            }
            if (((String)object).equals("author") || ((String)object).equals("lastchangedby")) {
                arrayList.add("LastChangedBy");
                arrayList.add("Author");
                continue;
            }
            if (((String)object).equals("url") || ((String)object).equals("headurl")) {
                arrayList.add("HeadURL");
                arrayList.add("URL");
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        BufferedReader bufferedReader = null;
        object = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.textBaseFile));
            object = new BufferedReader(new FileReader(this.file));
            String string2 = bufferedReader.readLine();
            String string3 = ((BufferedReader)object).readLine();
            while (string2 != null && string3 != null) {
                if (!string3.equals(string2)) {
                    int n;
                    boolean bl2 = false;
                    for (n = 0; n < stringArray.length; ++n) {
                        String string4 = "$" + stringArray[n];
                        if (string3.indexOf(string4) <= -1) continue;
                        bl2 = this.compareKeywordLines(string3, string2, stringArray);
                        break;
                    }
                    if (!bl2) {
                        n = 1;
                        return n != 0;
                    }
                }
                string2 = bufferedReader.readLine();
                string3 = ((BufferedReader)object).readLine();
            }
            bl = string2 != null || string3 != null;
        }
        finally {
            if (object != null) {
                ((BufferedReader)object).close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return bl;
    }

    private boolean compareKeywordLines(String string, String string2, String[] stringArray) {
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '$') {
                for (int j = 0; j < stringArray.length; ++j) {
                    String string3 = stringArray[j];
                    boolean bl = false;
                    for (int k = 0; k < string3.length(); ++k) {
                        if (i + k + 1 > string2.length() - 1 || string3.charAt(k) != string2.charAt(i + k + 1)) {
                            bl = false;
                            break;
                        }
                        bl = true;
                    }
                    if (!bl) continue;
                    if (this.checkFollowingString(string2, i += string3.length(), "$")) {
                        ++i;
                    } else if (this.checkFollowingString(string2, i, ":$")) {
                        i += 2;
                    } else {
                        return false;
                    }
                    n += string3.length() + 1;
                    while (++n < string.length() && string.charAt(n) != '$') {
                    }
                    if (n < string.length()) break;
                    return false;
                }
            }
            if (string.charAt(n) != string2.charAt(i)) {
                return false;
            }
            if (++n < string.length()) continue;
            return i == string2.length() - 1;
        }
        return n == string.length() - 2;
    }

    private boolean checkFollowingString(String string, int n, String string2) {
        if (string.length() < n + string2.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (string.charAt(n + i + 1) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

