/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.subversion.util.FileUtils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KVFile {
    private Map<Key, byte[]> map;
    private Map<String, Key> keyMap;
    private final File file;

    public KVFile(File file) {
        this.file = file;
        try {
            if (file.exists()) {
                this.parse();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    protected byte[] getValue(Key key) {
        return this.getMap().get(key);
    }

    protected String getStringValue(Key key) {
        try {
            byte[] byArray = this.getValue(key);
            if (byArray == null) {
                return null;
            }
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorManager.getDefault().notify(65536, (Throwable)unsupportedEncodingException);
            return null;
        }
    }

    protected void setValue(Key key, byte[] byArray) {
        this.getMap().put(key, byArray);
    }

    public Map<Key, byte[]> getMap() {
        if (this.map == null) {
            this.map = new TreeMap<Key, byte[]>();
        }
        return this.map;
    }

    private Map<String, Key> getKeyMap() {
        if (this.keyMap == null) {
            this.keyMap = new HashMap<String, Key>();
        }
        return this.keyMap;
    }

    protected Key getKey(Key key) {
        Key key2 = this.getKey(key.getName());
        if (key2 == null) {
            this.setKey(key);
            return key;
        }
        return key2;
    }

    private Key getKey(String string) {
        return this.getKeyMap().get(string);
    }

    protected void setKey(Key key) {
        this.getKeyMap().put(key.getName(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = FileUtils.createInputStream(this.file);
            int n = 0;
            while (!this.checkEOF(bufferedInputStream)) {
                int n2 = this.readEntryLength(bufferedInputStream);
                byte[] byArray = new byte[n2];
                ((InputStream)bufferedInputStream).read(byArray);
                ((InputStream)bufferedInputStream).read();
                int n3 = this.readEntryLength(bufferedInputStream);
                byte[] byArray2 = new byte[n3];
                ((InputStream)bufferedInputStream).read(byArray2);
                Key key = new Key(n, new String(byArray, "UTF8"));
                this.setKey(key);
                this.getMap().put(key, byArray2);
                ((InputStream)bufferedInputStream).read();
                ++n;
            }
        }
        catch (EOFException eOFException) {
            if (this.getMap().size() > 0) {
                throw new EOFException(this.file.getAbsolutePath());
            }
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    private boolean checkEOF(InputStream inputStream) throws IOException {
        inputStream.mark(3);
        byte[] byArray = new byte[3];
        inputStream.read(byArray);
        inputStream.reset();
        if (byArray[0] == -1 || byArray[1] == -1 || byArray[2] == -1) {
            throw new EOFException();
        }
        return byArray[0] == 69 && byArray[1] == 78 && byArray[2] == 68;
    }

    private int readEntryLength(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte by = (byte)inputStream.read();
        while (by != 10) {
            if (by == -1) {
                throw new EOFException();
            }
            byteArrayOutputStream.write(by);
            by = (byte)inputStream.read();
        }
        String string = byteArrayOutputStream.toString();
        return Integer.decode(string.substring(2));
    }

    public void store() throws IOException {
        this.store(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file) throws IOException {
        OutputStream outputStream = null;
        try {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            outputStream = FileUtils.createOutputStream(file);
            for (Key key : this.getMap().keySet()) {
                byte[] byArray = this.map.get(key);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("K ");
                stringBuffer.append(key.getName().length());
                stringBuffer.append("\n");
                stringBuffer.append(key.getName());
                stringBuffer.append("\n");
                stringBuffer.append("V ");
                stringBuffer.append(byArray.length);
                stringBuffer.append("\n");
                outputStream.write(stringBuffer.toString().getBytes("UTF8"));
                outputStream.write(byArray);
                outputStream.write("\n".getBytes());
            }
            outputStream.write("END\n".getBytes());
            outputStream.flush();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }

    protected File getFile() {
        return this.file;
    }

    void setValue(Key key, String string) {
        this.setValue(key, string.getBytes());
    }

    protected static class Key
    implements Comparable {
        private final int idx;
        private final String name;

        protected Key(int n, String string) {
            this.name = string;
            this.idx = n;
        }

        public int getIndex() {
            return this.idx;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            return key.getIndex() == this.getIndex() && key.getName().equals(this.getName());
        }

        public int hashCode() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getName());
            stringBuffer.append(this.getIndex());
            return stringBuffer.toString().hashCode();
        }

        public int compareTo(Object object) {
            if (!(object instanceof Key)) {
                return 0;
            }
            Key key = (Key)object;
            if (key.getIndex() < this.getIndex()) {
                return 1;
            }
            if (key.getIndex() > this.getIndex()) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.name;
        }
    }
}

