/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.blame;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.blame.AnnotateLine;
import org.netbeans.modules.subversion.ui.blame.AnnotationMark;
import org.netbeans.modules.subversion.ui.blame.AnnotationMarkInstaller;
import org.netbeans.modules.subversion.ui.blame.AnnotationMarkProvider;
import org.netbeans.modules.subversion.ui.blame.LinesReader;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationBar
extends JComponent
implements Accessible,
PropertyChangeListener,
DocumentListener,
ChangeListener,
ActionListener,
Runnable,
ComponentListener {
    private final JTextComponent textComponent;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument doc;
    private final Caret caret;
    private Timer caretTimer;
    private boolean annotated;
    private Map<Element, AnnotateLine> elementAnnotations;
    private String elementAnnotationsSubstitute;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private Color selectedColor = Color.BLUE;
    private String recentStatusMessage;
    private String recentRevision;
    RequestProcessor requestProcessor = null;
    private RequestProcessor.Task latestAnnotationTask = null;
    private boolean recentRevisionCanBeRolledBack;

    public AnnotationBar(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.doc = this.editorUI.getDocument();
        this.caret = this.textComponent.getCaret();
    }

    public void annotate() {
        this.annotated = true;
        this.elementAnnotations = null;
        this.doc.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.editorUI.addPropertyChangeListener((PropertyChangeListener)this);
        this.revalidate();
    }

    public void setAnnotationMessage(String string) {
        this.elementAnnotationsSubstitute = string;
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationLines(File file, List<AnnotateLine> list) {
        Object object;
        Object object2;
        Object object3;
        LinkedList<AnnotateLine> linkedList = new LinkedList<AnnotateLine>(list);
        int n = linkedList.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i + 1;
        }
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffProvider != null) {
            object3 = new LinesReader(linkedList);
            object2 = Utils.getDocumentReader((Document)this.doc);
            try {
                int n2;
                int n3;
                int n4;
                int n5;
                Object object4;
                int n6;
                object = diffProvider.computeDiff((Reader)object3, (Reader)object2);
                for (n6 = 0; n6 < ((Difference[])object).length; ++n6) {
                    object4 = object[n6];
                    if (object4.getType() == 1) continue;
                    n5 = object4.getFirstEnd() - object4.getFirstStart() + 1;
                    if (object4.getType() == 2) {
                        n4 = object4.getFirstEnd() - object4.getFirstStart();
                        n3 = object4.getSecondEnd() - object4.getSecondStart();
                        if (n3 >= n4) continue;
                        n2 = object4.getSecondStart();
                        n5 = n4 - n3;
                    } else {
                        n2 = object4.getSecondStart() + 1;
                    }
                    n4 = n2 + n5 - 1;
                    while (n4 < n) {
                        int n7 = n4++;
                        nArray[n7] = nArray[n7] - n5;
                    }
                }
                for (n6 = ((Difference[])object).length - 1; n6 >= 0; --n6) {
                    object4 = object[n6];
                    if (object4.getType() == 0) continue;
                    n5 = object4.getSecondEnd() - object4.getSecondStart() + 1;
                    if (object4.getType() == 2) {
                        n4 = object4.getFirstEnd() - object4.getFirstStart();
                        n3 = object4.getSecondEnd() - object4.getSecondStart();
                        if (n3 <= n4) continue;
                        n5 = n3 - n4;
                        n2 = object4.getFirstStart();
                    } else {
                        n2 = object4.getFirstStart() + 1;
                    }
                    n4 = n2 - 1;
                    while (n4 < n) {
                        int n8 = n4++;
                        nArray[n8] = nArray[n8] + n5;
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, "Cannot compute local diff required for annotations, ignoring...");
                errorManager.notify(1, (Throwable)iOException);
            }
        }
        try {
            this.doc.atomicLock();
            object3 = (StyledDocument)this.doc;
            object2 = linkedList.iterator();
            this.elementAnnotations = Collections.synchronizedMap(new HashMap(linkedList.size()));
            while (object2.hasNext()) {
                object = (AnnotateLine)object2.next();
                int n9 = nArray[((AnnotateLine)object).getLineNum() - 1];
                try {
                    int n10 = NbDocument.findLineOffset((StyledDocument)object3, (int)(n9 - 1));
                    Element element = object3.getParagraphElement(n10);
                    this.elementAnnotations.put(element, (AnnotateLine)object);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    ErrorManager.getDefault().notify(1, (Throwable)indexOutOfBoundsException);
                }
            }
        }
        finally {
            this.doc.atomicUnlock();
        }
        this.caret.addChangeListener(this);
        this.caretTimer = new Timer(500, this);
        this.caretTimer.setRepeats(false);
        this.onCurrentLine();
        this.revalidate();
        this.repaint();
    }

    private File getCurrentFile() {
        File file = null;
        DataObject dataObject = (DataObject)this.doc.getProperty((Object)"stream");
        if (dataObject != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            file = FileUtil.toFile((FileObject)fileObject);
        }
        return file;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AnnotationBar.this.createPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.setToolTipText("");
    }

    private JPopupMenu createPopup() {
        ResourceBundle resourceBundle = NbBundle.getBundle(AnnotationBar.class);
        JPopupMenu jPopupMenu = new JPopupMenu();
        final File file = this.getCurrentFile();
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("CTL_MenuItem_DiffToRevision"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AnnotationBar.this.recentRevision != null && AnnotationBar.this.getPreviousRevision(AnnotationBar.this.recentRevision) != null) {
                    DiffAction.diff(file, AnnotationBar.this.getPreviousRevision(AnnotationBar.this.recentRevision), AnnotationBar.this.recentRevision);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(resourceBundle.getString("CTL_MenuItem_Revert"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationBar.this.revert(file, AnnotationBar.this.recentRevision);
            }
        });
        jPopupMenu.add(jMenuItem2);
        jMenuItem2.setEnabled(this.recentRevisionCanBeRolledBack);
        JMenuItem jMenuItem3 = new JMenuItem(resourceBundle.getString("CTL_MenuItem_CloseAnnotations"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationBar.this.hideBar();
            }
        });
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add(jMenuItem3);
        jMenuItem.setVisible(false);
        jMenuItem2.setVisible(false);
        if (this.recentRevision != null) {
            if (this.getPreviousRevision(this.recentRevision) != null) {
                String string = resourceBundle.getString("CTL_MenuItem_DiffToRevision");
                jMenuItem.setText(MessageFormat.format(string, this.recentRevision, this.getPreviousRevision(this.recentRevision)));
                jMenuItem.setVisible(true);
            }
            jMenuItem2.setVisible(true);
        }
        return jPopupMenu;
    }

    private void revert(File file, String string) {
        SVNUrl sVNUrl;
        final Context context = new Context(file);
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl, sVNUrl, SVNRevision.HEAD);
        final RevertModifications revertModifications = new RevertModifications(repositoryFile, string);
        if (!revertModifications.showDialog()) {
            return;
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                RevertModificationsAction.performRevert(context, revertModifications, this);
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(AnnotationBar.class, (String)"MSG_Revert_Progress"));
    }

    private String getPreviousRevision(String string) {
        return Long.toString(Long.parseLong(string) - 1L);
    }

    void hideBar() {
        this.annotated = false;
        this.revalidate();
        this.release();
    }

    private RequestProcessor getRequestProcessor() {
        if (this.requestProcessor == null) {
            this.requestProcessor = new RequestProcessor("AnnotationBarRP", 1, true);
        }
        return this.requestProcessor;
    }

    private void onCurrentLine() {
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        this.latestAnnotationTask = this.getRequestProcessor().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResourceBundle resourceBundle = NbBundle.getBundle(AnnotationBar.class);
        StatusBar statusBar = this.editorUI.getStatusBar();
        this.recentStatusMessage = resourceBundle.getString("CTL_StatusBar_WaitFetchAnnotation");
        statusBar.setText("main", this.recentStatusMessage);
        this.recentRevisionCanBeRolledBack = false;
        int n = -1;
        int n2 = this.caret.getDot();
        try {
            n = Utilities.getLineOffset((BaseDocument)this.doc, (int)n2);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)badLocationException, "Can not get line for caret at offset " + n2);
            errorManager.notify((Throwable)badLocationException);
            this.clearRecentFeedback();
            return;
        }
        AnnotateLine annotateLine = this.getAnnotateLine(n);
        if (annotateLine == null) {
            AnnotationMarkProvider annotationMarkProvider = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (annotationMarkProvider != null) {
                annotationMarkProvider.setMarks(Collections.<AnnotationMark>emptyList());
            }
            this.clearRecentFeedback();
            if (this.recentRevision != null) {
                this.recentRevision = null;
                this.repaint();
            }
            return;
        }
        String string = annotateLine.getRevision();
        if (!string.equals(this.recentRevision)) {
            this.recentRevision = string;
            this.recentRevisionCanBeRolledBack = annotateLine.canBeRolledBack();
            this.repaint();
            AnnotationMarkProvider annotationMarkProvider = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (annotationMarkProvider != null) {
                Iterator<Map.Entry<Element, AnnotateLine>> iterator;
                ArrayList<AnnotationMark> arrayList = new ArrayList<AnnotationMark>(this.elementAnnotations.size());
                Map.Entry<Element, AnnotateLine> entry = this.elementAnnotations;
                synchronized (entry) {
                    iterator = new HashSet<Map.Entry<Element, AnnotateLine>>(this.elementAnnotations.entrySet()).iterator();
                }
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    AnnotateLine annotateLine2 = (AnnotateLine)entry.getValue();
                    if (string.equals(annotateLine2.getRevision())) {
                        Element element = (Element)entry.getKey();
                        if (!this.elementAnnotations.containsKey(element)) continue;
                        int n3 = element.getStartOffset();
                        int n4 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)n3);
                        AnnotationMark annotationMark = new AnnotationMark(n4, string);
                        arrayList.add(annotationMark);
                    }
                    if (!Thread.interrupted()) continue;
                    this.clearRecentFeedback();
                    return;
                }
                annotationMarkProvider.setMarks(arrayList);
            }
        }
        if (annotateLine.getCommitMessage() != null) {
            this.recentStatusMessage = annotateLine.getCommitMessage();
            statusBar.setText("main", annotateLine.getAuthor() + ": " + this.recentStatusMessage);
        } else {
            this.clearRecentFeedback();
        }
    }

    private void clearRecentFeedback() {
        StatusBar statusBar = this.editorUI.getStatusBar();
        if (statusBar.getText("main") == this.recentStatusMessage) {
            statusBar.setText("main", "");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = this.textComponent.getSize();
        dimension.width = n = this.annotated ? this.getBarWidth() : 0;
        dimension.height *= 2;
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBarWidth() {
        Object object;
        String string = "";
        if (this.elementAnnotations == null) {
            string = this.elementAnnotationsSubstitute;
        } else {
            object = this.elementAnnotations;
            synchronized (object) {
                for (AnnotateLine annotateLine : this.elementAnnotations.values()) {
                    String string2 = this.getDisplayName(annotateLine);
                    if (string2.length() <= string.length()) continue;
                    string = string2;
                }
            }
        }
        object = string.toCharArray();
        int n = this.getGraphics().getFontMetrics().charsWidth((char[])object, 0, ((Object)object).length);
        return n + 4;
    }

    private String getDisplayName(AnnotateLine annotateLine) {
        return annotateLine.getRevision() + "  " + annotateLine.getAuthor();
    }

    private void release() {
        AnnotationMarkProvider annotationMarkProvider;
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        this.textComponent.removeComponentListener(this);
        this.doc.removeDocumentListener((DocumentListener)this);
        this.caret.removeChangeListener(this);
        if (this.caretTimer != null) {
            this.caretTimer.removeActionListener(this);
        }
        this.elementAnnotations = null;
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        if ((annotationMarkProvider = AnnotationMarkInstaller.getMarkProvider(this.textComponent)) != null) {
            annotationMarkProvider.setMarks(Collections.<AnnotationMark>emptyList());
        }
        this.clearRecentFeedback();
    }

    private void paintView(View view, Graphics graphics, int n) {
        JTextComponent jTextComponent = this.editorUI.getComponent();
        if (jTextComponent == null) {
            return;
        }
        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
        Element element = baseTextUI.getRootView(jTextComponent).getElement();
        int n2 = element.getElementIndex(view.getStartOffset());
        String string = "";
        AnnotateLine annotateLine = null;
        if (this.elementAnnotations != null) {
            annotateLine = this.getAnnotateLine(n2);
            if (annotateLine != null) {
                string = this.getDisplayName(annotateLine);
            }
        } else {
            string = this.elementAnnotationsSubstitute;
        }
        if (annotateLine != null && annotateLine.getRevision().equals(this.recentRevision)) {
            graphics.setColor(this.selectedColor());
        } else {
            graphics.setColor(this.foregroundColor());
        }
        graphics.drawString(string, 2, n + this.editorUI.getLineAscent());
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.editorUI == null) {
            return null;
        }
        int n = this.getLineFromMouseEvent(mouseEvent);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.elementAnnotations != null) {
            AnnotateLine annotateLine = this.getAnnotateLine(n);
            if (annotateLine != null) {
                Object object;
                String string = NbBundle.getMessage(AnnotationBar.class, (String)"TT_Annotation");
                try {
                    string = XMLUtil.toElementContent((String)annotateLine.getAuthor());
                }
                catch (CharConversionException charConversionException) {
                    object = ErrorManager.getDefault();
                    object.annotate((Throwable)charConversionException, "CVS.AB: can not HTML escape: " + annotateLine.getAuthor());
                    object.notify(1, (Throwable)charConversionException);
                }
                stringBuffer.append("<html><!-- line=" + n++ + " -->" + annotateLine.getRevision() + " - <b>" + string + "</b>");
                if (annotateLine.getDate() != null) {
                    stringBuffer.append(" " + DateFormat.getDateInstance().format(annotateLine.getDate()));
                }
                if (annotateLine.getCommitMessage() != null) {
                    String string2 = null;
                    try {
                        string2 = XMLUtil.toElementContent((String)annotateLine.getCommitMessage());
                    }
                    catch (CharConversionException charConversionException) {
                        ErrorManager errorManager = ErrorManager.getDefault();
                        errorManager.annotate((Throwable)charConversionException, "CVS.AB: can not HTML escape: " + annotateLine.getCommitMessage());
                        errorManager.notify(1, (Throwable)charConversionException);
                    }
                    if (string2 != null) {
                        object = string2.replaceAll(System.getProperty("line.separator"), "<br>");
                        stringBuffer.append("<p>" + (String)object);
                    }
                }
            }
        } else {
            stringBuffer.append(this.elementAnnotationsSubstitute);
        }
        return stringBuffer.toString();
    }

    private AnnotateLine getAnnotateLine(int n) {
        StyledDocument styledDocument = (StyledDocument)this.doc;
        int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
        Element element = styledDocument.getParagraphElement(n2);
        AnnotateLine annotateLine = this.elementAnnotations.get(element);
        if (annotateLine != null) {
            int n3 = element.getStartOffset();
            int n4 = element.getEndOffset();
            try {
                int n5 = n4 - n3;
                String string = this.doc.getText(n3, n5 - 1);
                String string2 = annotateLine.getContent();
                if (string.equals(string2)) {
                    return annotateLine;
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)badLocationException, "CVS.AB: can not locate line annotation.");
                errorManager.notify(1, (Throwable)badLocationException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        block11: {
            super.paintComponent(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            JTextComponent jTextComponent = this.editorUI.getComponent();
            if (jTextComponent == null) {
                return;
            }
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            View view = Utilities.getDocumentView((JTextComponent)jTextComponent);
            if (view == null) {
                return;
            }
            graphics.setColor(this.backgroundColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
            abstractDocument.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int n = baseTextUI.getPosFromY(rectangle.y);
                    int n2 = view.getViewIndex(n, Position.Bias.Forward);
                    int n3 = view.getViewCount();
                    if (n2 < 0 || n2 >= n3) break block11;
                    Rectangle rectangle2 = baseTextUI.modelToView(jTextComponent, view.getView(n2).getStartOffset());
                    int n4 = rectangle2 == null ? 0 : rectangle2.y;
                    int n5 = rectangle.y + rectangle.height;
                    for (int i = n2; i < n3; ++i) {
                        View view2 = view.getView(i);
                        this.paintView(view2, graphics, n4);
                        if ((n4 += this.editorUI.getLineHeight()) < n5) continue;
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
    }

    private Color backgroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Color foregroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.foregroundColor;
    }

    private Color selectedColor() {
        if (this.backgroundColor == this.backgroundColor()) {
            return this.selectedColor;
        }
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.selectedColor;
    }

    private int getLineFromMouseEvent(MouseEvent mouseEvent) {
        int n = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent jTextComponent = this.editorUI.getComponent();
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                int n2 = baseTextUI.viewToModel(jTextComponent, new Point(0, mouseEvent.getY()));
                n = Utilities.getLineOffset((BaseDocument)this.doc, (int)n2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string) && propertyChangeEvent.getNewValue() == null) {
            this.release();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.elementAnnotations != null) {
            Element[] elementArray = documentEvent.getDocument().getRootElements();
            Map<Element, AnnotateLine> map = this.elementAnnotations;
            synchronized (map) {
                for (int i = 0; i < elementArray.length; ++i) {
                    Element element;
                    AnnotateLine annotateLine;
                    Element[] elementArray2;
                    Element element2 = elementArray[i];
                    DocumentEvent.ElementChange elementChange = documentEvent.getChange(element2);
                    if (elementChange == null) continue;
                    Element[] elementArray3 = elementChange.getChildrenRemoved();
                    if (elementArray3.length == (elementArray2 = elementChange.getChildrenAdded()).length) {
                        for (int j = 0; j < elementArray3.length; ++j) {
                            annotateLine = this.elementAnnotations.get(elementArray3[j]);
                            if (annotateLine == null) continue;
                            this.elementAnnotations.remove(elementArray3[j]);
                            this.elementAnnotations.put(elementArray2[j], annotateLine);
                        }
                        continue;
                    }
                    if (elementArray3.length != 1 || elementArray2.length <= 0 || (annotateLine = this.elementAnnotations.get(element = elementArray3[0])) == null) continue;
                    this.elementAnnotations.remove(element);
                    this.elementAnnotations.put(elementArray2[0], annotateLine);
                }
            }
        }
        this.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() == 0) {
            this.hideBar();
        }
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        assert (changeEvent.getSource() == this.caret);
        this.caretTimer.restart();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        assert (actionEvent.getSource() == this.caretTimer);
        this.onCurrentLine();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

