/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.BrowserClient;
import org.netbeans.modules.subversion.ui.browser.BrowserPanel;
import org.netbeans.modules.subversion.ui.browser.RepositoryPathNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class Browser
implements VetoableChangeListener,
BrowserClient {
    public static final int BROWSER_SHOW_FILES = 1;
    public static final int BROWSER_SINGLE_SELECTION_ONLY = 2;
    public static final int BROWSER_FILES_SELECTION_ONLY = 4;
    public static final int BROWSER_FOLDERS_SELECTION_ONLY = 8;
    public static final int BROWSER_SELECT_ANYTHING = 12;
    private final int mode;
    private static final RepositoryFile[] EMPTY_ROOT = new RepositoryFile[0];
    private static final Action[] EMPTY_ACTIONS = new Action[0];
    private final BrowserPanel panel;
    private RepositoryFile repositoryRoot;
    private Action[] nodeActions;
    private SvnProgressSupport support;
    private boolean keepWarning = false;
    private boolean initialSelection = true;

    public Browser(String string, int n, RepositoryFile repositoryFile, RepositoryFile[] repositoryFileArray, BrowserAction[] browserActionArray) {
        this.mode = n;
        this.panel = new BrowserPanel(string, NbBundle.getMessage(Browser.class, (String)"ACSN_RepositoryTree"), NbBundle.getMessage(Browser.class, (String)"ACSD_RepositoryTree"), (n & 2) == 2);
        this.panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryPathNode.class, (String)"CTL_Browser_Prompt"));
        this.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        if (browserActionArray != null) {
            this.nodeActions = browserActionArray;
            this.panel.setActions(browserActionArray);
            for (int i = 0; i < browserActionArray.length; ++i) {
                browserActionArray[i].setBrowser(this);
            }
        } else {
            this.nodeActions = EMPTY_ACTIONS;
        }
        this.repositoryRoot = repositoryFile;
        RepositoryPathNode repositoryPathNode = RepositoryPathNode.createRepositoryPathNode((BrowserClient)this, repositoryFile);
        Node[] nodeArray = this.getSelectedNodes(repositoryPathNode, repositoryFile, repositoryFileArray);
        this.getExplorerManager().setRootContext((Node)repositoryPathNode);
        if (nodeArray == null) {
            nodeArray = new Node[]{};
        }
        try {
            this.getExplorerManager().setSelectedNodes(nodeArray);
            for (int i = 0; i < nodeArray.length; ++i) {
                this.getExplorerManager().setExploredContext(nodeArray[i]);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
        }
    }

    private Node[] getSelectedNodes(RepositoryPathNode repositoryPathNode, RepositoryFile repositoryFile, RepositoryFile[] repositoryFileArray) {
        if (repositoryFileArray == null || repositoryFileArray.length <= 0) {
            return null;
        }
        RepositoryPathNode repositoryPathNode2 = null;
        ArrayList<RepositoryPathNode> arrayList = new ArrayList<RepositoryPathNode>(repositoryFileArray.length);
        for (int i = 0; i < repositoryFileArray.length; ++i) {
            String[] stringArray = repositoryFileArray[i].getPathSegments();
            repositoryPathNode2 = repositoryPathNode;
            RepositoryFile repositoryFile2 = repositoryFile;
            for (int j = 0; j < stringArray.length; ++j) {
                repositoryFile2 = repositoryFile2.appendPath(stringArray[j]);
                RepositoryPathNode repositoryPathNode3 = RepositoryPathNode.createRepositoryPathNode((BrowserClient)this, repositoryFile2);
                repositoryPathNode2.getChildren().add(new Node[]{repositoryPathNode3});
                repositoryPathNode2 = repositoryPathNode3;
            }
            arrayList.add(repositoryPathNode2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public void cancel() {
        Node node = this.getExplorerManager().getRootContext();
        if (node != null) {
            this.getExplorerManager().setRootContext(Node.EMPTY);
            try {
                node.destroy();
                if (this.support != null) {
                    this.support.cancel();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public List listRepositoryPath(RepositoryPathNode.RepositoryPathEntry repositoryPathEntry, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        ISVNDirEntry[] iSVNDirEntryArray;
        ArrayList<RepositoryPathNode.RepositoryPathEntry> arrayList;
        try {
            this.support = svnProgressSupport;
            if (repositoryPathEntry.getSvnNodeKind().equals((Object)SVNNodeKind.FILE)) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            SvnClient svnClient = Subversion.getInstance().getClient(this.repositoryRoot.getRepositoryUrl(), svnProgressSupport);
            if (svnProgressSupport.isCanceled()) {
                List list = null;
                return list;
            }
            arrayList = new ArrayList<RepositoryPathNode.RepositoryPathEntry>();
            iSVNDirEntryArray = svnClient.getList(repositoryPathEntry.getRepositoryFile().getFileUrl(), repositoryPathEntry.getRepositoryFile().getRevision(), false);
            if (iSVNDirEntryArray == null || iSVNDirEntryArray.length == 0) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            for (int i = 0; i < iSVNDirEntryArray.length; ++i) {
                ISVNDirEntry iSVNDirEntry;
                if (svnProgressSupport.isCanceled()) {
                    iSVNDirEntry = null;
                    return iSVNDirEntry;
                }
                iSVNDirEntry = iSVNDirEntryArray[i];
                if (iSVNDirEntry.getNodeKind() != SVNNodeKind.DIR && (iSVNDirEntry.getNodeKind() != SVNNodeKind.FILE || (this.mode & 1) != 1)) continue;
                RepositoryFile repositoryFile = repositoryPathEntry.getRepositoryFile();
                RepositoryPathNode.RepositoryPathEntry repositoryPathEntry2 = new RepositoryPathNode.RepositoryPathEntry(repositoryFile.appendPath(iSVNDirEntry.getPath()), iSVNDirEntry.getNodeKind(), (SVNRevision)iSVNDirEntry.getLastChangedRevision(), iSVNDirEntry.getLastChangedDate(), iSVNDirEntry.getLastCommitAuthor());
                arrayList.add(repositoryPathEntry2);
            }
        }
        catch (SVNClientException sVNClientException) {
            if (SvnClientExceptionHandler.isWrongURLInRevision(sVNClientException.getMessage())) {
                iSVNDirEntryArray = null;
                return iSVNDirEntryArray;
            }
            svnProgressSupport.annotate(sVNClientException);
            throw sVNClientException;
        }
        finally {
            this.support = null;
        }
        return arrayList;
    }

    public JPanel getBrowserPanel() {
        return this.panel;
    }

    public Node[] getSelectedNodes() {
        return this.getExplorerManager().getSelectedNodes();
    }

    public RepositoryFile[] getSelectedFiles() {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length == 0) {
            return EMPTY_ROOT;
        }
        RepositoryFile[] repositoryFileArray = new RepositoryFile[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            repositoryFileArray[i] = ((RepositoryPathNode)nodeArray[i]).getEntry().getRepositoryFile();
        }
        return repositoryFileArray;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            boolean bl = !this.initialSelection;
            this.initialSelection = false;
            if (!this.keepWarning) {
                this.panel.warning(null);
            }
            this.keepWarning = false;
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            Node[] nodeArray2 = (Node[])propertyChangeEvent.getOldValue();
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            if ((this.mode & 4) == 4 && this.checkForNodeType(nodeArray, SVNNodeKind.DIR)) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_FileSelectionOnly"));
                if (bl) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", propertyChangeEvent);
            }
            if ((this.mode & 8) == 8 && this.checkForNodeType(nodeArray, SVNNodeKind.FILE)) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_FolderSelectionOnly"));
                if (bl) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", propertyChangeEvent);
            }
            if (nodeArray2.length == 0 && nodeArray.length == 1) {
                return;
            }
            if (nodeArray2.length != 0 && this.areDisjunct(nodeArray2, nodeArray)) {
                return;
            }
            Node node = null;
            node = nodeArray2.length > 0 ? nodeArray2[0] : nodeArray[0];
            if (!this.selectionIsAtLevel(nodeArray, this.getNodeLevel(node))) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_NoMultiSelection"));
                if (bl) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }
    }

    private boolean checkForNodeType(Node[] nodeArray, SVNNodeKind sVNNodeKind) {
        for (int i = 0; i < nodeArray.length; ++i) {
            RepositoryPathNode repositoryPathNode;
            if (!(nodeArray[i] instanceof RepositoryPathNode) || (repositoryPathNode = (RepositoryPathNode)nodeArray[i]).getEntry().getSvnNodeKind() != sVNNodeKind) continue;
            return true;
        }
        return false;
    }

    private boolean selectionIsAtLevel(Node[] nodeArray, int n) {
        for (int i = 0; i < nodeArray.length; ++i) {
            if (this.getNodeLevel(nodeArray[i]) == n) continue;
            return false;
        }
        return true;
    }

    private boolean areDisjunct(Node[] nodeArray, Node[] nodeArray2) {
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!this.isInArray(nodeArray[i], nodeArray2)) continue;
            return false;
        }
        return true;
    }

    private int getNodeLevel(Node node) {
        int n = 0;
        while (node != null) {
            node = node.getParentNode();
            ++n;
        }
        return n;
    }

    private boolean isInArray(Node node, Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            if (node != nodeArray[i]) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getExplorerManager().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getExplorerManager().removePropertyChangeListener(propertyChangeListener);
    }

    ExplorerManager getExplorerManager() {
        return this.panel.getExplorerManager();
    }

    public Action[] getActions() {
        return this.nodeActions;
    }

    void setSelectedNodes(Node[] nodeArray) throws PropertyVetoException {
        this.getExplorerManager().setSelectedNodes(nodeArray);
    }
}

