/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.io.File;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.SwitchTo;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchToAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Switch";
    }

    protected int getFileEnabledStatus() {
        return -8;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1 && this.getContext(nodeArray).getRoots().size() > 0;
    }

    protected void performContextAction(Node[] nodeArray) {
        SVNUrl sVNUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        final File file = context.getRootFiles()[0];
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl, sVNUrl, SVNRevision.HEAD);
        File[] fileArray = Subversion.getInstance().getStatusCache().listFiles(context, 6612);
        boolean bl = fileArray.length > 0;
        final SwitchTo switchTo = new SwitchTo(repositoryFile, file, bl);
        if (switchTo.showDialog()) {
            ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

                public void perform() {
                    RepositoryFile repositoryFile = switchTo.getRepositoryFile();
                    SwitchToAction.performSwitch(repositoryFile, file, this);
                }
            };
            progressSupport.start(this.createRequestProcessor(nodeArray));
        }
    }

    static void performSwitch(RepositoryFile repositoryFile, File file, SvnProgressSupport svnProgressSupport) {
        File[][] fileArray = Utils.splitFlatOthers((File[])new File[]{file});
        boolean bl = fileArray[0].length <= 0;
        try {
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(repositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            svnClient.switchToUrl(file, repositoryFile.getFileUrl(), repositoryFile.getRevision(), bl);
            SwitchToAction.refreshRecursively(file);
            Subversion.getInstance().refreshAllAnnotations();
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
    }

    private static void refreshRecursively(File file) {
        Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        if (!file.isFile()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                SwitchToAction.refreshRecursively(fileArray[i]);
            }
        }
    }
}

