/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.diff.DiffStreamSource;
import org.openide.util.NbBundle;

public final class Setup {
    public static final int DIFFTYPE_LOCAL = 0;
    public static final int DIFFTYPE_REMOTE = 1;
    public static final int DIFFTYPE_ALL = 2;
    public static final String REVISION_PRISTINE = "PRISTINE";
    public static final String REVISION_BASE = "BASE";
    public static final String REVISION_CURRENT = "LOCAL";
    public static final String REVISION_HEAD = "HEAD";
    private final File baseFile;
    private final String firstRevision;
    private final String secondRevision;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffView view;
    private String title;

    public Setup(File file, int n) {
        String string;
        String string2;
        this.baseFile = file;
        FileInformation fileInformation = Subversion.getInstance().getStatusCache().getStatus(file);
        int n2 = fileInformation.getStatus();
        ResourceBundle resourceBundle = NbBundle.getBundle(Setup.class);
        switch (n) {
            case 0: 
            case 1: {
                if (Setup.match(n2, 4100)) {
                    this.firstRevision = REVISION_BASE;
                    string2 = resourceBundle.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(n2, 512)) {
                    this.firstRevision = null;
                    string2 = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(n2, 2304)) {
                    this.firstRevision = REVISION_BASE;
                    string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                    break;
                }
                this.firstRevision = REVISION_BASE;
                string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                break;
            }
            case 2: {
                if (Setup.match(n2, 512)) {
                    this.firstRevision = REVISION_HEAD;
                    string2 = resourceBundle.getString("MSG_DiffPanel_RemoteNew");
                    break;
                }
                if (Setup.match(n2, 4100)) {
                    this.firstRevision = null;
                    string2 = resourceBundle.getString("MSG_DiffPanel_NoBaseRevision");
                    break;
                }
                if (Setup.match(n2, 1024)) {
                    this.firstRevision = null;
                    string2 = resourceBundle.getString("MSG_DiffPanel_RemoteDeleted");
                    break;
                }
                this.firstRevision = REVISION_HEAD;
                string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_RemoteModified"), this.firstRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + n);
            }
        }
        switch (n) {
            case 0: 
            case 2: {
                if (Setup.match(n2, 64)) {
                    this.secondRevision = REVISION_CURRENT;
                    string = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_LocalConflict"), this.secondRevision);
                    break;
                }
                if (Setup.match(n2, 4100)) {
                    this.secondRevision = REVISION_CURRENT;
                    string = resourceBundle.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(n2, 512)) {
                    this.secondRevision = null;
                    string = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(n2, 2304)) {
                    this.secondRevision = null;
                    string = resourceBundle.getString("MSG_DiffPanel_LocalDeleted");
                    break;
                }
                this.secondRevision = REVISION_CURRENT;
                string = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_LocalModified"), this.secondRevision);
                break;
            }
            case 1: {
                if (Setup.match(n2, 4100)) {
                    this.secondRevision = null;
                    string = resourceBundle.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(n2, 512)) {
                    this.secondRevision = REVISION_HEAD;
                    string = resourceBundle.getString("MSG_DiffPanel_RemoteNew");
                    break;
                }
                if (Setup.match(n2, 1024)) {
                    this.secondRevision = null;
                    string = resourceBundle.getString("MSG_DiffPanel_RemoteDeleted");
                    break;
                }
                this.secondRevision = REVISION_HEAD;
                string = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_RemoteModified"), this.secondRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + n);
            }
        }
        this.firstSource = new DiffStreamSource(file, this.firstRevision, string2);
        this.secondSource = new DiffStreamSource(file, this.secondRevision, string);
        this.title = "<html>" + Subversion.getInstance().getAnnotator().annotateNameHtml(file, fileInformation);
    }

    public Setup(File file, String string, String string2) {
        this.baseFile = file;
        this.firstRevision = string;
        this.secondRevision = string2;
        this.firstSource = new DiffStreamSource(file, string, string);
        this.secondSource = new DiffStreamSource(file, string2, string2);
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setView(DiffView diffView) {
        this.view = diffView;
    }

    public DiffView getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    public String toString() {
        return this.title;
    }

    void initSources() throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init();
        }
        if (this.secondSource != null) {
            this.secondSource.init();
        }
    }

    private static boolean match(int n, int n2) {
        return (n & n2) != 0;
    }
}

