/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener,
DiffSetupSource {
    private static final String SUMMARY_REVERT_PROPERTY = "Summary-Revert-";
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;
    private List<RepositoryRevision> results;

    public SummaryView(SearchHistoryPanel searchHistoryPanel, List<RepositoryRevision> list) {
        this.master = searchHistoryPanel;
        this.results = list;
        this.dispResults = this.expandResults(list);
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getMimeLookup((String)"text/x-java").lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fontColorSettings.getFontColors("highlight-search");
        this.message = searchHistoryPanel.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        searchHistoryPanel.addComponentListener(this);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        int[] nArray = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(nArray);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private List expandResults(List<RepositoryRevision> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (RepositoryRevision repositoryRevision : list) {
            arrayList.add(repositoryRevision);
            List<RepositoryRevision.Event> list2 = repositoryRevision.getEvents();
            for (RepositoryRevision.Event event : list2) {
                arrayList.add(event);
            }
        }
        return arrayList;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.diffPrevious(n);
        }
        if ((rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + n)) != null && rectangle2.contains(point)) {
            this.revertModifications(new int[]{n});
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public Collection getSetups() {
        int[] nArray;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length == 0) {
            return this.master.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> hashSet2 = new HashSet<RepositoryRevision>();
        for (int n : nArray = this.resultsList.getSelectedIndices()) {
            Object e = this.dispResults.get(n);
            if (e instanceof RepositoryRevision) {
                hashSet2.add((RepositoryRevision)e);
                continue;
            }
            hashSet.add((RepositoryRevision.Event)e);
        }
        return this.master.getSetups(hashSet2.toArray(new RepositoryRevision[hashSet2.size()]), hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    private void onPopup(MouseEvent mouseEvent) {
        RepositoryRevision.Event event;
        boolean bl;
        int[] nArray = this.resultsList.getSelectedIndices();
        if (nArray.length == 0) {
            int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(n);
            nArray = new int[]{n};
        }
        final int[] nArray2 = nArray;
        JPopupMenu jPopupMenu = new JPopupMenu();
        Object var5_6 = null;
        RepositoryRevision repositoryRevision = null;
        Object e = this.dispResults.get(nArray2[0]);
        if (e instanceof RepositoryRevision) {
            bl = true;
            repositoryRevision = (RepositoryRevision)this.dispResults.get(nArray2[0]);
            event = null;
        } else {
            bl = false;
            event = (RepositoryRevision.Event)this.dispResults.get(nArray2[0]);
            repositoryRevision = event.getLogInfoHeader();
        }
        long l = repositoryRevision.getLog().getRevision().getNumber();
        if (l > 1L) {
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", var5_6)){
                {
                    super(string);
                    this.setEnabled(nArray2.length == 1);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.diffPrevious(nArray2[0]);
                }
            }));
        }
        jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
            {
                super(string);
                this.setEnabled(true);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SummaryView.this.revertModifications(nArray2);
            }
        }));
        if (!bl) {
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)l)){
                {
                    super(string);
                    this.setEnabled(nArray2.length == 1 && !bl);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            SummaryView.rollback(event);
                        }
                    });
                }
            }));
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(string);
                    this.setEnabled(nArray2.length == 1 && !bl && event.getFile() != null);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            SummaryView.this.view(nArray2[0]);
                        }
                    });
                }
            }));
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    static void rollback(final RepositoryRevision.Event event) {
        SVNUrl sVNUrl = event.getLogInfoHeader().getRepositoryRootUrl();
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                SummaryView.rollback(event, this);
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(SummaryView.class, (String)"MSG_Rollback_Progress"));
    }

    private static void rollback(RepositoryRevision.Event event, SvnProgressSupport svnProgressSupport) {
        File file = event.getFile();
        File file2 = file.getParentFile();
        file2.mkdirs();
        try {
            File file3 = VersionsCache.getInstance().getFileRevision(event.getFile(), Long.toString(event.getLogInfoHeader().getLog().getRevision().getNumber()));
            file.delete();
            FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)file3), (FileObject)FileUtil.toFileObject((File)file2), (String)file.getName(), (String)"");
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void revertModifications(int[] nArray) {
        HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> hashSet2 = new HashSet<RepositoryRevision>();
        for (int n : nArray) {
            Object e = this.dispResults.get(n);
            if (e instanceof RepositoryRevision) {
                hashSet2.add((RepositoryRevision)e);
                continue;
            }
            hashSet.add((RepositoryRevision.Event)e);
        }
        SummaryView.revert(this.master, hashSet2.toArray(new RepositoryRevision[hashSet2.size()]), hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
    }

    static void revert(final SearchHistoryPanel searchHistoryPanel, final RepositoryRevision[] repositoryRevisionArray, final RepositoryRevision.Event[] eventArray) {
        SVNUrl sVNUrl;
        try {
            sVNUrl = searchHistoryPanel.getSearchRepositoryRootUrl();
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                SummaryView.revertImpl(searchHistoryPanel, repositoryRevisionArray, eventArray, this);
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
    }

    private static void revertImpl(SearchHistoryPanel searchHistoryPanel, RepositoryRevision[] repositoryRevisionArray, RepositoryRevision.Event[] eventArray, SvnProgressSupport svnProgressSupport) {
        Context context;
        RevertModifications revertModifications;
        SVNUrl sVNUrl;
        try {
            sVNUrl = searchHistoryPanel.getSearchRepositoryRootUrl();
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl, sVNUrl, SVNRevision.HEAD);
        for (RepositoryRevision object : repositoryRevisionArray) {
            revertModifications = new RevertModifications(repositoryFile, Long.toString(object.getLog().getRevision().getNumber()));
            context = new Context(searchHistoryPanel.getRoots());
            RevertModificationsAction.performRevert(context, revertModifications, svnProgressSupport);
        }
        for (RepositoryRevision.Event event : eventArray) {
            if (event.getFile() == null) continue;
            revertModifications = new RevertModifications(repositoryFile, Long.toString(event.getLogInfoHeader().getLog().getRevision().getNumber()));
            context = new Context(event.getFile());
            RevertModificationsAction.performRevert(context, revertModifications, svnProgressSupport);
        }
    }

    private void view(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event event = (RepositoryRevision.Event)e;
            FileObject fileObject = FileUtil.toFileObject((File)event.getFile());
            Utils.openFile((FileObject)fileObject, (String)event.getLogInfoHeader().getLog().getRevision().toString());
        }
    }

    private void diffPrevious(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event event = (RepositoryRevision.Event)e;
            this.master.showDiff(event);
        } else {
            RepositoryRevision repositoryRevision = (RepositoryRevision)e;
            this.master.showDiff(repositoryRevision);
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String string, Color color, Color color2) {
            StringBuilder stringBuilder = new StringBuilder(100);
            if (color.equals(UIManager.getColor("List.foreground"))) {
                stringBuilder.append("<html><a href=\"\">");
                stringBuilder.append(string);
                stringBuilder.append("</a>");
            } else {
                stringBuilder.append("<html><a href=\"\" style=\"color:");
                stringBuilder.append("rgb(");
                stringBuilder.append(color.getRed());
                stringBuilder.append(",");
                stringBuilder.append(color.getGreen());
                stringBuilder.append(",");
                stringBuilder.append(color.getBlue());
                stringBuilder.append(")");
                stringBuilder.append("\">");
                stringBuilder.append(string);
                stringBuilder.append("</a>");
            }
            this.setText(stringBuilder.toString());
            this.setBackground(color2);
        }
    }

    private class SummaryCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private static final double DARKEN_FACTOR = 0.95;
        private Style selectedStyle;
        private Style normalStyle;
        private Style filenameStyle;
        private Style indentStyle;
        private Style noindentStyle;
        private Style hiliteStyle;
        private JTextPane textPane = new JTextPane();
        private JPanel actionsPane = new JPanel();
        private DateFormat defaultFormat;
        private int index;
        private HyperlinkLabel diffLink;
        private HyperlinkLabel revertLink;

        public SummaryCellRenderer() {
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, UIManager.getColor("List.selectionForeground"));
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.filenameStyle, true);
            this.indentStyle = this.textPane.addStyle("indent", null);
            StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
            this.noindentStyle = this.textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            Color color = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
            if (color != null) {
                StyleConstants.setBackground(this.hiliteStyle, color);
            }
            if ((color = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                StyleConstants.setForeground(this.hiliteStyle, color);
            }
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.add((Component)this.actionsPane, "Last");
            this.actionsPane.setLayout(new FlowLayout(4, 2, 5));
            this.diffLink = new HyperlinkLabel();
            this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
            this.actionsPane.add(this.diffLink);
            this.revertLink = new HyperlinkLabel();
            this.actionsPane.add(this.revertLink);
            this.textPane.setBorder(null);
        }

        public Color darker(Color color) {
            return new Color(Math.max((int)((double)color.getRed() * 0.95), 0), Math.max((int)((double)color.getGreen() * 0.95), 0), Math.max((int)((double)color.getBlue() * 0.95), 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof RepositoryRevision) {
                this.renderContainer(jList, (RepositoryRevision)object, n, bl);
            } else {
                this.renderRevision(jList, (RepositoryRevision.Event)object, n, bl);
            }
            return this;
        }

        private void renderContainer(JList jList, RepositoryRevision repositoryRevision, int n, boolean bl) {
            Style style;
            Color color;
            Color color2;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            if (bl) {
                color2 = UIManager.getColor("List.selectionForeground");
                color = UIManager.getColor("List.selectionBackground");
                style = this.selectedStyle;
            } else {
                color2 = UIManager.getColor("List.foreground");
                color = UIManager.getColor("List.background");
                color = this.darker(color);
                style = this.normalStyle;
            }
            this.textPane.setBackground(color);
            this.actionsPane.setBackground(color);
            this.index = n;
            try {
                int n2;
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.noindentStyle, false);
                styledDocument.insertString(0, Long.toString(repositoryRevision.getLog().getRevision().getNumber()), null);
                styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.filenameStyle, false);
                styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + repositoryRevision.getLog().getAuthor(), null);
                styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + this.defaultFormat.format(repositoryRevision.getLog().getDate()), null);
                String string = repositoryRevision.getLog().getMessage();
                if (string.endsWith("\n")) {
                    string = string.substring(0, string.length() - 1);
                }
                styledDocument.insertString(styledDocument.getLength(), "\n", null);
                styledDocument.insertString(styledDocument.getLength(), string, null);
                if (SummaryView.this.message != null && !bl && (n2 = string.indexOf(SummaryView.this.message)) != -1) {
                    int n3 = string.length();
                    int n4 = styledDocument.getLength();
                    styledDocument.setCharacterAttributes(n4 - n3 + n2, SummaryView.this.message.length(), this.hiliteStyle, false);
                }
                if (string != null && (n2 = SummaryView.this.master.getWidth()) > 0) {
                    FontMetrics fontMetrics = jList.getFontMetrics(jList.getFont());
                    Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.textPane.getGraphics());
                    int n5 = -1;
                    int n6 = 0;
                    while (n6 != -1) {
                        n6 = string.indexOf(10, n6 + 1);
                        ++n5;
                    }
                    int n7 = (int)(rectangle2D.getWidth() / (double)(n2 - 80) + 1.0);
                    int n8 = fontMetrics.getHeight() * (n7 + ++n5) + 0;
                    this.textPane.setPreferredSize(new Dimension(n2 - 50, n8));
                }
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            this.actionsPane.setVisible(true);
            this.diffLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Diff"), color2, color);
            this.revertLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Revert"), color2, color);
        }

        private void renderRevision(JList jList, RepositoryRevision.Event event, int n, boolean bl) {
            Style style;
            Color color;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            if (bl) {
                Color color2 = UIManager.getColor("List.selectionForeground");
                color = UIManager.getColor("List.selectionBackground");
                style = this.selectedStyle;
            } else {
                Color color3 = UIManager.getColor("List.foreground");
                color = UIManager.getColor("List.background");
                style = this.normalStyle;
            }
            this.textPane.setBackground(color);
            this.actionsPane.setVisible(false);
            this.index = -1;
            try {
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.indentStyle, false);
                styledDocument.insertString(styledDocument.getLength(), String.valueOf(event.getChangedPath().getAction()), null);
                styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + event.getChangedPath().getPath(), null);
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.index == -1) {
                return;
            }
            Rectangle rectangle = this.actionsPane.getBounds();
            Rectangle rectangle2 = this.diffLink.getBounds();
            rectangle2.setBounds(rectangle2.x, rectangle2.y + rectangle.y, rectangle2.width, rectangle2.height);
            SummaryView.this.resultsList.putClientProperty("Summary-Diff-" + this.index, rectangle2);
            rectangle2 = this.revertLink.getBounds();
            rectangle2.setBounds(rectangle2.x, rectangle2.y + rectangle.y, rectangle2.width, rectangle2.height);
            SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_REVERT_PROPERTY + this.index, rectangle2);
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        public Object getElementAt(int n) {
            return SummaryView.this.dispResults.get(n);
        }
    }
}

