/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.search.SvnSearchPanel;
import org.netbeans.modules.subversion.ui.search.SvnSearchView;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SvnSearch
implements ActionListener,
DocumentListener {
    private static final String DATE_FROM = "svnSearch.dateFrom";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final SvnSearchPanel panel;
    private RepositoryFile repositoryRoot;
    private SvnSearchView searchView;
    private SvnProgressSupport support;
    private NoContentPanel noContentPanel;

    public SvnSearch(RepositoryFile repositoryFile) {
        this.repositoryRoot = repositoryFile;
        this.panel = new SvnSearchPanel();
        this.panel.listButton.addActionListener(this);
        this.panel.dateFromTextField.getDocument().addDocumentListener(this);
        String string = DATE_FORMAT.format(new Date(System.currentTimeMillis() - 604800000L));
        this.panel.dateFromTextField.setText(SvnModuleConfig.getDefault().getPreferences().get(DATE_FROM, string));
        this.searchView = new SvnSearchView();
        this.panel.listPanel.setLayout(new BorderLayout());
        this.panel.listPanel.add(this.searchView.getComponent());
        this.noContentPanel = new NoContentPanel();
        this.panel.noContentPanel.setLayout(new BorderLayout());
        this.panel.noContentPanel.add((Component)this.noContentPanel);
        this.noContentPanel.setLabel(NbBundle.getMessage(SvnSearch.class, (String)"LBL_NoResults_SearchNotPerformed"));
        this.panel.listPanel.setVisible(false);
        this.panel.noContentPanel.setVisible(true);
    }

    public void cancel() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listLogEntries() {
        this.noContentPanel.setLabel(NbBundle.getMessage(SvnSearch.class, (String)"LBL_NoResults_SearchInProgress"));
        this.panel.listPanel.setVisible(false);
        this.panel.noContentPanel.setVisible(true);
        final SVNRevision sVNRevision = this.getRevisionFrom();
        if (sVNRevision instanceof SVNRevision.DateSpec) {
            SvnModuleConfig.getDefault().getPreferences().put(DATE_FROM, this.panel.dateFromTextField.getText().trim());
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(this.repositoryRoot.getRepositoryUrl());
        try {
            this.support = new SvnProgressSupport(){

                protected void perform() {
                    ISVNLogMessage[] iSVNLogMessageArray;
                    try {
                        SvnClient svnClient = Subversion.getInstance().getClient(SvnSearch.this.repositoryRoot.getRepositoryUrl(), (SvnProgressSupport)this);
                        iSVNLogMessageArray = svnClient.getLogMessages(SvnSearch.this.repositoryRoot.getRepositoryUrl(), SVNRevision.HEAD, sVNRevision);
                    }
                    catch (SVNClientException sVNClientException) {
                        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
                        abstractNode.setDisplayName(NbBundle.getMessage(SvnSearch.class, (String)"LBL_Error"));
                        abstractNode.setShortDescription(sVNClientException.getLocalizedMessage());
                        return;
                    }
                    if (this.isCanceled()) {
                        return;
                    }
                    ArrayList<ISVNLogMessage> arrayList = new ArrayList<ISVNLogMessage>(iSVNLogMessageArray.length);
                    if (sVNRevision instanceof SVNRevision.DateSpec) {
                        long l = ((SVNRevision.DateSpec)sVNRevision).getDate().getTime();
                        for (int i = 0; i < iSVNLogMessageArray.length; ++i) {
                            if (iSVNLogMessageArray[i].getDate().getTime() < l) continue;
                            arrayList.add(iSVNLogMessageArray[i]);
                        }
                        iSVNLogMessageArray = arrayList.toArray(new ISVNLogMessage[arrayList.size()]);
                    }
                    final ISVNLogMessage[] iSVNLogMessageArray2 = iSVNLogMessageArray;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ((SvnSearch)SvnSearch.this).panel.listPanel.setVisible(true);
                            ((SvnSearch)SvnSearch.this).panel.noContentPanel.setVisible(false);
                            SvnSearch.this.searchView.setResults(iSVNLogMessageArray2);
                        }
                    });
                }
            };
            this.support.start(requestProcessor, this.repositoryRoot.getRepositoryUrl(), NbBundle.getMessage(SvnSearch.class, (String)"LBL_Search_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    public JPanel getSearchPanel() {
        return this.panel;
    }

    public SVNRevision getSelectedRevision() {
        return this.searchView.getSelectedValue();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.searchView.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.searchView.removeListSelectionListener(listSelectionListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.listButton) {
            this.listLogEntries();
        }
    }

    private SVNRevision getRevisionFrom() {
        String string = this.panel.dateFromTextField.getText().trim();
        if (string.equals("")) {
            return new SVNRevision.Number(1L);
        }
        try {
            return new SVNRevision.DateSpec(DATE_FORMAT.parse(string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    private void validateUserInput() {
        boolean bl = false;
        String string = this.panel.dateFromTextField.getText();
        if (string.equals("")) {
            bl = true;
        } else {
            try {
                DATE_FORMAT.parse(this.panel.dateFromTextField.getText());
                bl = true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.panel.listButton.setEnabled(bl);
    }
}

