/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.openide.ErrorManager;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

class SvnSearchView
implements ComponentListener {
    private JList resultsList;
    private ISVNLogMessage[] lm;
    private AttributeSet searchHiliteAttrs;
    private JScrollPane pane;

    public SvnSearchView() {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getMimeLookup((String)"text/x-java").lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fontColorSettings.getFontColors("highlight-search");
        this.resultsList = new JList(new SvnSearchListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.setCellRenderer(new SvnSearchListCellRenderer());
        this.resultsList.addComponentListener(this);
        this.pane = new JScrollPane(this.resultsList, 22, 31);
    }

    JComponent getComponent() {
        return this.pane;
    }

    public void componentResized(ComponentEvent componentEvent) {
        int[] nArray = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SvnSearchListModel());
        this.resultsList.setSelectedIndices(nArray);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setResults(ISVNLogMessage[] iSVNLogMessageArray) {
        this.lm = iSVNLogMessageArray;
        this.resultsList.setModel(new SvnSearchListModel());
    }

    SVNRevision getSelectedValue() {
        Object e = this.resultsList.getSelectedValue();
        if (e == null) {
            return null;
        }
        if (!(e instanceof ISVNLogMessage)) {
            return null;
        }
        ISVNLogMessage iSVNLogMessage = (ISVNLogMessage)e;
        return iSVNLogMessage.getRevision();
    }

    void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.resultsList.addListSelectionListener(listSelectionListener);
    }

    void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.resultsList.removeListSelectionListener(listSelectionListener);
    }

    private class SvnSearchListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private static final double DARKEN_FACTOR = 0.95;
        private Style selectedStyle;
        private Style normalStyle;
        private Style boldStyle;
        private Style hiliteStyle;
        private JTextPane textPane = new JTextPane();
        private DateFormat defaultFormat;
        private int index;

        public SvnSearchListCellRenderer() {
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, UIManager.getColor("List.selectionForeground"));
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.boldStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.boldStyle, true);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            StyleConstants.setBackground(this.hiliteStyle, (Color)SvnSearchView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background));
            StyleConstants.setForeground(this.hiliteStyle, (Color)SvnSearchView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground));
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.textPane.setBorder(null);
        }

        public Color darker(Color color) {
            return new Color(Math.max((int)((double)color.getRed() * 0.95), 0), Math.max((int)((double)color.getGreen() * 0.95), 0), Math.max((int)((double)color.getBlue() * 0.95), 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ISVNLogMessage) {
                int n2;
                Style style;
                ISVNLogMessage iSVNLogMessage = (ISVNLogMessage)object;
                StyledDocument styledDocument = this.textPane.getStyledDocument();
                if (bl) {
                    this.textPane.setBackground(UIManager.getColor("List.selectionBackground"));
                    style = this.selectedStyle;
                } else {
                    Color color = UIManager.getColor("List.background");
                    this.textPane.setBackground((n & 1) == 0 ? color : this.darker(color));
                    style = this.normalStyle;
                }
                try {
                    styledDocument.remove(0, styledDocument.getLength());
                    styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                    styledDocument.insertString(0, iSVNLogMessage.getRevision().toString(), null);
                    styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.boldStyle, false);
                    styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + iSVNLogMessage.getAuthor(), null);
                    styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + this.defaultFormat.format(iSVNLogMessage.getDate()), null);
                    styledDocument.insertString(styledDocument.getLength(), "\n" + iSVNLogMessage.getMessage(), null);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                if (iSVNLogMessage.getMessage() != null && (n2 = SvnSearchView.this.resultsList.getWidth()) > 0) {
                    FontMetrics fontMetrics = jList.getFontMetrics(jList.getFont());
                    Rectangle2D rectangle2D = fontMetrics.getStringBounds(iSVNLogMessage.getMessage(), this.textPane.getGraphics());
                    int n3 = -1;
                    int n4 = 0;
                    while (n4 != -1) {
                        n4 = iSVNLogMessage.getMessage().indexOf(10, n4 + 1);
                        ++n3;
                    }
                    int n5 = (int)(rectangle2D.getWidth() / (double)(n2 - 80) + 1.0);
                    int n6 = fontMetrics.getHeight() * (n5 + n3 + 1) + 0;
                    this.textPane.setPreferredSize(new Dimension(n2 - 50, n6));
                }
            }
            return this;
        }
    }

    private class SvnSearchListModel
    extends AbstractListModel {
        private SvnSearchListModel() {
        }

        public int getSize() {
            if (SvnSearchView.this.lm == null) {
                return 0;
            }
            return SvnSearchView.this.lm.length;
        }

        public Object getElementAt(int n) {
            return SvnSearchView.this.lm[n];
        }
    }
}

