/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RevertModificationsAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Revert";
    }

    protected int getFileEnabledStatus() {
        return 7672;
    }

    protected int getDirectoryEnabledStatus() {
        return 7672;
    }

    protected void performContextAction(Node[] nodeArray) {
        SVNUrl sVNUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        final Context context = this.getContext(nodeArray);
        File file = context.getRootFiles()[0];
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl, sVNUrl, SVNRevision.HEAD);
        final RevertModifications revertModifications = new RevertModifications(repositoryFile);
        if (!revertModifications.showDialog()) {
            return;
        }
        ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

            public void perform() {
                RevertModificationsAction.performRevert(context, revertModifications, this);
            }
        };
        progressSupport.start(this.createRequestProcessor(nodeArray));
    }

    public static void performRevert(Context context, RevertModifications revertModifications, SvnProgressSupport svnProgressSupport) {
        RevertModifications.RevisionInterval revisionInterval;
        boolean bl;
        SvnClient svnClient;
        try {
            svnClient = Subversion.getInstance().getClient(context, svnProgressSupport);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        File[] fileArray = context.getFiles();
        File[][] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
        for (int i = 0; i < fileArray2.length; ++i) {
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            fileArray = fileArray2[i];
            boolean bl2 = bl = i == 1;
            if (!bl) {
                fileArray = SvnUtils.flatten(fileArray, 6608);
            }
            try {
                revisionInterval = revertModifications.getRevisionInterval();
                if (revisionInterval != null) {
                    for (int j = 0; j < fileArray.length; ++j) {
                        if (svnProgressSupport.isCanceled()) {
                            return;
                        }
                        SVNUrl sVNUrl = SvnUtils.getRepositoryUrl(fileArray[j]);
                        revisionInterval = RevertModificationsAction.recountStartRevision(svnClient, sVNUrl, revisionInterval);
                        svnClient.merge(sVNUrl, revisionInterval.endRevision, sVNUrl, revisionInterval.startRevision, fileArray[j], false, bl);
                    }
                    continue;
                }
                if (svnProgressSupport.isCanceled()) {
                    return;
                }
                if (fileArray.length <= 0) continue;
                svnClient.revert(fileArray, bl);
                continue;
            }
            catch (SVNClientException sVNClientException) {
                svnProgressSupport.annotate(sVNClientException);
            }
        }
        if (svnProgressSupport.isCanceled()) {
            return;
        }
        if (revertModifications.revertNewFiles()) {
            File[] fileArray3 = Subversion.getInstance().getStatusCache().listFiles(context.getRootFiles(), 4100);
            for (bl = false; bl < fileArray3.length; bl += 1) {
                revisionInterval = FileUtil.toFileObject((File)fileArray3[bl]);
                try {
                    if (revisionInterval == null) continue;
                    revisionInterval.delete();
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }

    private static void refreshRecursively(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                RevertModificationsAction.refreshRecursively(file2);
            }
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        fileStatusCache.refreshCached(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    private static void addFileSystem(Set set, File file) {
        FileObject fileObject;
        while ((fileObject = FileUtil.toFileObject((File)file)) == null) {
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        try {
            set.add(fileObject.getFileSystem());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    private static RevertModifications.RevisionInterval recountStartRevision(SvnClient svnClient, SVNUrl sVNUrl, RevertModifications.RevisionInterval revisionInterval) throws SVNClientException {
        long l;
        if (revisionInterval.startRevision.equals((Object)SVNRevision.HEAD)) {
            ISVNInfo iSVNInfo = svnClient.getInfo(sVNUrl);
            revisionInterval.startRevision = iSVNInfo.getRevision();
        }
        if ((l = Long.parseLong(revisionInterval.startRevision.toString())) > 0L) {
            --l;
        }
        revisionInterval.startRevision = new SVNRevision.Number(l);
        return revisionInterval;
    }
}

