/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.repositorystep;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.WizardStepProgressSupport;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStepPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryStep
extends AbstractStep
implements WizardDescriptor.AsynchronousValidatingPanel,
PropertyChangeListener {
    private Repository repository;
    private RepositoryStepPanel panel;
    private RepositoryFile repositoryFile;
    private int repositoryModeMask;
    private WizardStepProgressSupport support;

    public RepositoryStep() {
        this.repositoryModeMask = 0;
    }

    public RepositoryStep(int n) {
        this.repositoryModeMask = n;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(RepositoryStep.class);
    }

    protected JComponent createComponent() {
        if (this.repository == null) {
            this.repositoryModeMask = this.repositoryModeMask | 2 | 4 | 0x20;
            String string = NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Location");
            this.repository = new Repository(this.repositoryModeMask, string);
            this.repository.addPropertyChangeListener(this);
            this.panel = new RepositoryStepPanel();
            this.panel.repositoryPanel.setLayout(new BorderLayout());
            this.panel.repositoryPanel.add(this.repository.getPanel());
            this.valid();
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateBeforeNext() {
        try {
            if (this.support != null) {
                this.support.performInCurrentThread(NbBundle.getMessage(RepositoryStep.class, (String)"BK2012"));
            }
        }
        finally {
            this.support = null;
        }
    }

    public void prepareValidation() {
        this.support = new RepositoryStepProgressSupport(this.panel.progressPanel);
        try {
            SVNUrl sVNUrl = this.getSelectedRepositoryConnection().getSvnUrl();
            this.support.setRepositoryRoot(sVNUrl);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
        }
        this.support.startProgress();
    }

    private void storeHistory() {
        RepositoryConnection repositoryConnection = this.getSelectedRepositoryConnection();
        if (repositoryConnection != null) {
            SvnModuleConfig.getDefault().insertRecentUrl(repositoryConnection);
        }
    }

    public RepositoryFile getRepositoryFile() {
        return this.repositoryFile;
    }

    private RepositoryConnection getSelectedRepositoryConnection() {
        try {
            return this.repository.getSelectedRC();
        }
        catch (Exception exception) {
            this.invalid(exception.getLocalizedMessage());
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("valid")) {
            if (this.repository.isValid()) {
                this.valid(this.repository.getMessage());
            } else {
                this.invalid(this.repository.getMessage());
            }
        }
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        public RepositoryStepProgressSupport(JPanel jPanel) {
            super(jPanel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform() {
            String string;
            block26: {
                block27: {
                    block28: {
                        block29: {
                            block24: {
                                block25: {
                                    RepositoryConnection repositoryConnection = RepositoryStep.this.getSelectedRepositoryConnection();
                                    if (repositoryConnection == null) {
                                        return;
                                    }
                                    string = null;
                                    try {
                                        SvnClient svnClient;
                                        RepositoryStep.this.invalid(null);
                                        SVNUrl sVNUrl = repositoryConnection.getSvnUrl();
                                        try {
                                            int n = 8;
                                            svnClient = Subversion.getInstance().getClient(sVNUrl, repositoryConnection.getUsername(), repositoryConnection.getPassword(), n);
                                        }
                                        catch (SVNClientException sVNClientException) {
                                            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                                            string = NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Invalid", (Object)repositoryConnection.getUrl());
                                            if (this.isCanceled()) {
                                                RepositoryStep.this.valid(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"));
                                                return;
                                            }
                                            if (string == null) {
                                                RepositoryStep.this.valid();
                                                RepositoryStep.this.storeHistory();
                                                return;
                                            }
                                            RepositoryStep.this.valid(string);
                                            return;
                                        }
                                        RepositoryStep.this.repositoryFile = null;
                                        ISVNInfo iSVNInfo = null;
                                        try {
                                            RepositoryStep.this.repository.storeConfigValues();
                                            iSVNInfo = svnClient.getInfo(sVNUrl);
                                        }
                                        catch (SVNClientException sVNClientException) {
                                            this.annotate(sVNClientException);
                                            string = SvnClientExceptionHandler.parseExceptionMessage(sVNClientException);
                                        }
                                        if (this.isCanceled()) {
                                            if (!this.isCanceled()) break block24;
                                            break block25;
                                        }
                                        if (iSVNInfo != null) {
                                            SVNUrl sVNUrl2 = iSVNInfo.getRepository();
                                            if (sVNUrl2 == null) {
                                                sVNUrl2 = repositoryConnection.getSvnUrl();
                                            }
                                            SVNRevision sVNRevision = repositoryConnection.getSvnRevision();
                                            String[] stringArray = sVNUrl2.getPathSegments();
                                            String[] stringArray2 = repositoryConnection.getSvnUrl().getPathSegments();
                                            String[] stringArray3 = new String[stringArray2.length - stringArray.length];
                                            System.arraycopy(stringArray2, stringArray.length, stringArray3, 0, stringArray3.length);
                                            RepositoryStep.this.repositoryFile = new RepositoryFile(sVNUrl2, stringArray3, sVNRevision);
                                            if (!this.isCanceled()) break block26;
                                            break block27;
                                        }
                                        string = NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Invalid", (Object)repositoryConnection.getUrl());
                                        if (!this.isCanceled()) break block28;
                                        break block29;
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                                        return;
                                    }
                                }
                                RepositoryStep.this.valid(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"));
                                return;
                            }
                            if (string == null) {
                                RepositoryStep.this.valid();
                                RepositoryStep.this.storeHistory();
                                return;
                            }
                            RepositoryStep.this.valid(string);
                            return;
                        }
                        RepositoryStep.this.valid(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"));
                        return;
                    }
                    if (string == null) {
                        RepositoryStep.this.valid();
                        RepositoryStep.this.storeHistory();
                        return;
                    }
                    RepositoryStep.this.valid(string);
                    return;
                }
                RepositoryStep.this.valid(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"));
                return;
            }
            if (string == null) {
                RepositoryStep.this.valid();
                RepositoryStep.this.storeHistory();
                return;
            }
            RepositoryStep.this.valid(string);
            return;
            finally {
                if (this.isCanceled()) {
                    RepositoryStep.this.valid(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"));
                } else if (string == null) {
                    RepositoryStep.this.valid();
                    RepositoryStep.this.storeHistory();
                } else {
                    RepositoryStep.this.valid(string);
                }
            }
        }

        public void setEditable(boolean bl) {
            RepositoryStep.this.repository.setEditable(bl);
        }
    }
}

