/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class DocumentsRegistry {
    public static final String DOCUMENT_ID_PROP = "id";
    public static final String COMPONENT_ID_PROP = "componentId";
    private static final WeakReference[] EMPTY = new WeakReference[0];
    private static WeakReference[] docRefs = EMPTY;
    private static int docRefsCount;
    private static final ArrayList<Integer> docAct;
    private static WeakReference[] compRefs;
    private static int compRefsCount;
    private static final ArrayList<Integer> compAct;
    public static final String PROP_ACTIVE_COMPONENT = "org.netbeans.modules.editor.lib2.DocumentsRegistry.PROP_ACTIVE_COMPONENT";
    public static final String PROP_ACTIVE_DOCUMENT = "org.netbeans.modules.editor.lib2.DocumentsRegistry.PROP_ACTIVE_DOCUMENT";
    private static final PropertyChangeSupport PCS;
    private static int consolidateCounter;

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PCS.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PCS.removePropertyChangeListener(propertyChangeListener);
    }

    public static synchronized int getID(Document document) {
        Integer n = DocumentsRegistry.getIDInteger(document);
        return n != null ? n : -1;
    }

    public static synchronized int getID(JTextComponent jTextComponent) {
        return DocumentsRegistry.getIDImpl(jTextComponent);
    }

    public static synchronized Document getDocument(int n) {
        if (n < 0 || n >= docRefsCount) {
            return null;
        }
        WeakReference weakReference = docRefs[n];
        return weakReference != null ? (Document)weakReference.get() : null;
    }

    public static synchronized JTextComponent getComponent(int n) {
        if (n < 0 || n >= compRefsCount) {
            return null;
        }
        WeakReference weakReference = compRefs[n];
        return weakReference != null ? (JTextComponent)weakReference.get() : null;
    }

    public static synchronized int addDocument(Document document) {
        Integer n = DocumentsRegistry.getIDInteger(document);
        if (n != null) {
            return n;
        }
        if (docRefsCount >= docRefs.length) {
            docRefs = DocumentsRegistry.realloc(docRefs);
        }
        DocumentsRegistry.docRefs[DocumentsRegistry.docRefsCount] = new WeakReference<Document>(document);
        document.putProperty(DOCUMENT_ID_PROP, new Integer(docRefsCount));
        return docRefsCount++;
    }

    public static synchronized int addComponent(JTextComponent jTextComponent) {
        int n = DocumentsRegistry.getIDImpl(jTextComponent);
        if (n != -1) {
            if (compRefs[n] == null) {
                DocumentsRegistry.compRefs[n] = new WeakReference<JTextComponent>(jTextComponent);
            }
            return n;
        }
        if (compRefsCount >= compRefs.length) {
            compRefs = DocumentsRegistry.realloc(compRefs);
        }
        DocumentsRegistry.compRefs[DocumentsRegistry.compRefsCount] = new WeakReference<JTextComponent>(jTextComponent);
        jTextComponent.putClientProperty(COMPONENT_ID_PROP, new Integer(compRefsCount));
        return compRefsCount++;
    }

    public static synchronized int removeComponent(JTextComponent jTextComponent) {
        int n = DocumentsRegistry.getIDImpl(jTextComponent);
        if (n != -1) {
            DocumentsRegistry.compRefs[n] = null;
            for (int i = compAct.size() - 1; i >= 0; --i) {
                if (compAct.get(i) != n) continue;
                compAct.remove(i);
                break;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(JTextComponent jTextComponent) {
        boolean bl = true;
        Class<DocumentsRegistry> clazz = DocumentsRegistry.class;
        synchronized (DocumentsRegistry.class) {
            int n;
            int n2 = DocumentsRegistry.getIDImpl(jTextComponent);
            if (n2 == -1) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int n3 = compAct.size();
            for (n = 0; n < n3; ++n) {
                int n4 = compAct.get(n);
                if (n4 != n2) continue;
                if (n == 0) break;
                compAct.add(0, compAct.remove(n));
                bl = true;
                break;
            }
            if (n == n3) {
                compAct.add(0, n2);
                bl = true;
            }
            if (DocumentsRegistry.doActivate(jTextComponent.getDocument())) {
                bl = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (bl) {
                PCS.firePropertyChange(PROP_ACTIVE_COMPONENT, null, jTextComponent);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(Document document) {
        Class<DocumentsRegistry> clazz = DocumentsRegistry.class;
        synchronized (DocumentsRegistry.class) {
            boolean bl = DocumentsRegistry.doActivate(document);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bl) {
                PCS.firePropertyChange(PROP_ACTIVE_DOCUMENT, null, document);
            }
            return;
        }
    }

    public static synchronized Document getMostActiveDocument() {
        return DocumentsRegistry.getValidDoc(0, true);
    }

    public static synchronized Document getLeastActiveDocument() {
        int n = docAct.size() - 1;
        return DocumentsRegistry.getValidDoc(n, false);
    }

    public static Document getLessActiveDocument(Document document) {
        return DocumentsRegistry.getLessActiveDocument(DocumentsRegistry.getID(document));
    }

    public static synchronized Document getLessActiveDocument(int n) {
        return DocumentsRegistry.getNextActiveDoc(n, true);
    }

    public static Document getMoreActiveDocument(Document document) {
        return DocumentsRegistry.getMoreActiveDocument(DocumentsRegistry.getID(document));
    }

    public static synchronized Document getMoreActiveDocument(int n) {
        return DocumentsRegistry.getNextActiveDoc(n, false);
    }

    public static synchronized Iterator getDocumentIterator() {
        DocumentsRegistry.consolidate();
        ArrayList<Document> arrayList = new ArrayList<Document>();
        int n = docAct.size();
        for (int i = 0; i < n; ++i) {
            Object t;
            int n2 = docAct.get(i);
            WeakReference weakReference = docRefs[n2];
            if (weakReference == null || (t = weakReference.get()) == null) continue;
            arrayList.add((Document)t);
        }
        return arrayList.iterator();
    }

    public static synchronized JTextComponent getMostActiveComponent() {
        return DocumentsRegistry.getValidComp(0, true);
    }

    public static synchronized JTextComponent getLeastActiveComponent() {
        int n = compAct.size() - 1;
        return DocumentsRegistry.getValidComp(n, false);
    }

    public static JTextComponent getLessActiveComponent(JTextComponent jTextComponent) {
        return DocumentsRegistry.getLessActiveComponent(DocumentsRegistry.getID(jTextComponent));
    }

    public static synchronized JTextComponent getLessActiveComponent(int n) {
        return DocumentsRegistry.getNextActiveComp(n, true);
    }

    public static JTextComponent getMoreActiveComponent(JTextComponent jTextComponent) {
        return DocumentsRegistry.getMoreActiveComponent(DocumentsRegistry.getID(jTextComponent));
    }

    public static synchronized JTextComponent getMoreActiveComponent(int n) {
        return DocumentsRegistry.getNextActiveComp(n, false);
    }

    public static synchronized Iterator getComponentIterator() {
        DocumentsRegistry.consolidate();
        ArrayList<JTextComponent> arrayList = new ArrayList<JTextComponent>();
        int n = compAct.size();
        for (int i = 0; i < n; ++i) {
            Object t;
            int n2 = compAct.get(i);
            WeakReference weakReference = compRefs[n2];
            if (weakReference == null || (t = weakReference.get()) == null) continue;
            arrayList.add((JTextComponent)t);
        }
        return arrayList.iterator();
    }

    private static WeakReference[] realloc(WeakReference[] weakReferenceArray) {
        WeakReference[] weakReferenceArray2 = new WeakReference[weakReferenceArray.length * 2 + 4];
        System.arraycopy(weakReferenceArray, 0, weakReferenceArray2, 0, weakReferenceArray.length);
        return weakReferenceArray2;
    }

    private static void consolidate() {
        while (++consolidateCounter >= 20) {
            WeakReference weakReference;
            int n;
            int n2;
            consolidateCounter = 0;
            for (n2 = docAct.size() - 1; n2 >= 0; --n2) {
                n = docAct.get(n2);
                weakReference = docRefs[n];
                if (weakReference == null || weakReference.get() != null) continue;
                docAct.remove(n2);
                DocumentsRegistry.docRefs[n] = null;
            }
            for (n2 = compAct.size() - 1; n2 >= 0; --n2) {
                n = compAct.get(n2);
                weakReference = compRefs[n];
                if (weakReference == null || weakReference.get() != null) continue;
                compAct.remove(n2);
                DocumentsRegistry.compRefs[n] = null;
            }
        }
    }

    private static int getIDImpl(JTextComponent jTextComponent) {
        Integer n = jTextComponent == null ? null : (Integer)jTextComponent.getClientProperty(COMPONENT_ID_PROP);
        return n == null ? -1 : n;
    }

    private static Integer getIDInteger(Document document) {
        if (document == null) {
            return null;
        }
        return (Integer)document.getProperty(DOCUMENT_ID_PROP);
    }

    private static boolean doActivate(Document document) {
        Integer n = DocumentsRegistry.getIDInteger(document);
        if (n == null) {
            return false;
        }
        int n2 = n != null ? n : -1;
        int n3 = docAct.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = docAct.get(i);
            if (n4 != n2) continue;
            if (i == 0) {
                return false;
            }
            docAct.add(0, docAct.remove(i));
            return true;
        }
        docAct.add(0, n);
        return true;
    }

    private static Document getValidDoc(int n, boolean bl) {
        DocumentsRegistry.consolidate();
        int n2 = docAct.size();
        while (n >= 0 && n < n2) {
            Document document;
            int n3 = docAct.get(n);
            WeakReference weakReference = docRefs[n3];
            Document document2 = document = weakReference != null ? (Document)weakReference.get() : null;
            if (document != null) {
                return document;
            }
            n += bl ? 1 : -1;
        }
        return null;
    }

    private static Document getNextActiveDoc(int n, boolean bl) {
        int n2;
        DocumentsRegistry.consolidate();
        int n3 = docAct.size();
        int n4 = n2 = bl ? 0 : n3 - 1;
        while (n2 >= 0 && n2 < n3) {
            if (docAct.get(n2) == n) {
                return DocumentsRegistry.getValidDoc(n2 += bl ? 1 : -1, bl);
            }
            n2 += bl ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getValidComp(int n, boolean bl) {
        DocumentsRegistry.consolidate();
        int n2 = compAct.size();
        while (n >= 0 && n < n2) {
            JTextComponent jTextComponent;
            int n3 = compAct.get(n);
            WeakReference weakReference = compRefs[n3];
            JTextComponent jTextComponent2 = jTextComponent = weakReference != null ? (JTextComponent)weakReference.get() : null;
            if (jTextComponent != null) {
                return jTextComponent;
            }
            n += bl ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getNextActiveComp(int n, boolean bl) {
        int n2;
        int n3 = compAct.size();
        int n4 = n2 = bl ? 0 : n3 - 1;
        while (n2 >= 0 && n2 < n3) {
            if (compAct.get(n2) == n) {
                return DocumentsRegistry.getValidComp(n2 += bl ? 1 : -1, bl);
            }
            n2 += bl ? 1 : -1;
        }
        return null;
    }

    public static synchronized String registryToString() {
        WeakReference weakReference;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Document References:\n");
        for (n = 0; n < docRefsCount; ++n) {
            weakReference = docRefs[n];
            stringBuffer.append("docRefs[" + n + "]=" + (weakReference != null ? weakReference.get() : "null") + "\n");
        }
        stringBuffer.append("Component References:\n");
        for (n = 0; n < compRefsCount; ++n) {
            weakReference = compRefs[n];
            stringBuffer.append("compRefs[" + n + "]=" + (weakReference != null ? weakReference.get() : "null") + "\n");
        }
        stringBuffer.append("\nActive Document Indexes:\n");
        for (n = 0; n < docAct.size(); ++n) {
            stringBuffer.append(docAct.get(n));
            if (n == docAct.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("\nActive Component Indexes:\n");
        for (n = 0; n < compAct.size(); ++n) {
            stringBuffer.append(compAct.get(n));
            if (n == compAct.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private DocumentsRegistry() {
    }

    static {
        docAct = new ArrayList();
        compRefs = EMPTY;
        compAct = new ArrayList();
        PCS = new PropertyChangeSupport(DocumentsRegistry.class);
    }
}

