/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public final class SyntaxHighlighting
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private static final Logger LOG = Logger.getLogger(SyntaxHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.SyntaxHighlighting";
    private final HashMap<String, WeakHashMap<TokenId, AttributeSet>> attribsCache = new HashMap();
    private final HashMap<String, FontColorSettings> fcsCache = new HashMap();
    private final Document document;
    private final String mimeTypeForHack;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    public SyntaxHighlighting(Document document) {
        this.document = document;
        String string = (String)document.getProperty("mimeType");
        this.mimeTypeForHack = string != null && string.startsWith("test") ? string : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int n, int n2) {
        SyntaxHighlighting syntaxHighlighting = this;
        synchronized (syntaxHighlighting) {
            if (this.hierarchy == null) {
                this.hierarchy = TokenHierarchy.get((Document)this.document);
                if (this.hierarchy != null) {
                    this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
                }
            }
            if (this.hierarchy != null) {
                return new HSImpl(this.version, this.hierarchy, n, n2);
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
        SyntaxHighlighting syntaxHighlighting = this;
        synchronized (syntaxHighlighting) {
            ++this.version;
        }
        this.fireHighlightsChange(tokenHierarchyEvent.affectedStartOffset(), tokenHierarchyEvent.affectedEndOffset());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HSImpl
    implements HighlightsSequence {
        private static final int S_NORMAL = 1;
        private static final int S_EMBEDDED_HEAD = 2;
        private static final int S_EMBEDDED_TAIL = 3;
        private static final int S_DONE = 4;
        private long version;
        private TokenHierarchy<? extends Document> scanner;
        private List<TokenSequence<? extends TokenId>> sequences;
        private int startOffset;
        private int endOffset;
        private int state;

        public HSImpl(long l, TokenHierarchy<? extends Document> tokenHierarchy, int n, int n2) {
            this.version = l;
            this.scanner = tokenHierarchy;
            this.startOffset = n;
            this.endOffset = n2;
            this.sequences = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveNext() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                TokenSequence tokenSequence;
                this.checkVersion();
                if (this.sequences == null) {
                    tokenSequence = this.scanner.tokenSequence();
                    tokenSequence.move(this.startOffset);
                    this.sequences = new ArrayList<TokenSequence<? extends TokenId>>();
                    this.sequences.add(tokenSequence);
                    this.state = 1;
                }
                switch (this.state) {
                    case 1: {
                        this.state = this.moveTheSequence();
                        break;
                    }
                    case 2: {
                        tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        tokenSequence.moveStart();
                        if (tokenSequence.moveNext()) {
                            this.state = 1;
                            break;
                        }
                        throw new IllegalStateException("Invalid state");
                    }
                    case 3: {
                        this.sequences.remove(this.sequences.size() - 1);
                        this.state = this.moveTheSequence();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid state: " + this.state);
                    }
                }
                if (this.state == 1) {
                    tokenSequence = this.sequences.get(this.sequences.size() - 1);
                    TokenSequence tokenSequence2 = tokenSequence.embedded();
                    while (tokenSequence2 != null && tokenSequence2.moveNext()) {
                        this.sequences.add(this.sequences.size(), (TokenSequence<? extends TokenId>)tokenSequence2);
                        if (tokenSequence2.offset() > tokenSequence.offset()) {
                            this.state = 2;
                            break;
                        }
                        tokenSequence = tokenSequence2;
                        tokenSequence2 = tokenSequence.embedded();
                    }
                } else if (this.state == 4) {
                    SyntaxHighlighting.this.attribsCache.clear();
                }
                return this.state != 4;
            }
        }

        @Override
        public int getStartOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                switch (this.state) {
                    case 1: {
                        TokenSequence<? extends TokenId> tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        return tokenSequence.offset();
                    }
                    case 2: {
                        TokenSequence<? extends TokenId> tokenSequence = this.sequences.get(this.sequences.size() - 2);
                        return tokenSequence.offset();
                    }
                    case 3: {
                        TokenSequence<? extends TokenId> tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        tokenSequence.moveEnd();
                        if (tokenSequence.movePrevious()) {
                            return tokenSequence.offset() + tokenSequence.token().length();
                        }
                        throw new IllegalStateException("Invalid state");
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state: " + this.state);
            }
        }

        @Override
        public int getEndOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                switch (this.state) {
                    case 1: {
                        TokenSequence<? extends TokenId> tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        return tokenSequence.offset() + tokenSequence.token().length();
                    }
                    case 2: {
                        TokenSequence<? extends TokenId> tokenSequence = this.sequences.get(this.sequences.size() - 1);
                        tokenSequence.moveStart();
                        if (tokenSequence.moveNext()) {
                            return tokenSequence.offset();
                        }
                        TokenSequence<? extends TokenId> tokenSequence2 = this.sequences.get(this.sequences.size() - 2);
                        return tokenSequence2.offset() + tokenSequence2.token().length();
                    }
                    case 3: {
                        TokenSequence<? extends TokenId> tokenSequence = this.sequences.get(this.sequences.size() - 2);
                        return tokenSequence.offset() + tokenSequence.token().length();
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state: " + this.state);
            }
        }

        @Override
        public AttributeSet getAttributes() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                switch (this.state) {
                    case 1: {
                        return this.findAttribs(this.sequences.size() - 1);
                    }
                    case 2: 
                    case 3: {
                        return this.findAttribs(this.sequences.size() - 2);
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state: " + this.state);
            }
        }

        private AttributeSet findAttribs(int n) {
            AttributeSet attributeSet;
            TokenSequence<? extends TokenId> tokenSequence = this.sequences.get(n);
            TokenId tokenId = tokenSequence.token().id();
            String string = SyntaxHighlighting.this.mimeTypeForHack != null ? this.languagePathToMimePathHack(tokenSequence.languagePath()) : tokenSequence.languagePath().mimePath();
            WeakHashMap<TokenId, AttributeSet> weakHashMap = (WeakHashMap<TokenId, AttributeSet>)SyntaxHighlighting.this.attribsCache.get(string);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap<TokenId, AttributeSet>();
                SyntaxHighlighting.this.attribsCache.put(string, weakHashMap);
            }
            if ((attributeSet = (AttributeSet)weakHashMap.get(tokenId)) == null) {
                attributeSet = this.findTokenAttribs(tokenId, string, (Language<? extends TokenId>)tokenSequence.languagePath().innerLanguage());
                if (n > 0) {
                    AttributeSet attributeSet2 = this.findAttribs(n - 1);
                    attributeSet = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributeSet, attributeSet2});
                }
                weakHashMap.put(tokenId, attributeSet);
            }
            return attributeSet;
        }

        private AttributeSet findTokenAttribs(TokenId tokenId, String string, Language<? extends TokenId> language) {
            Object object;
            FontColorSettings fontColorSettings = (FontColorSettings)SyntaxHighlighting.this.fcsCache.get(string);
            if (fontColorSettings == null) {
                object = MimeLookup.getLookup((MimePath)MimePath.parse((String)string));
                fontColorSettings = (FontColorSettings)object.lookup(FontColorSettings.class);
                SyntaxHighlighting.this.fcsCache.put(string, fontColorSettings);
            }
            object = this.findFontAndColors(fontColorSettings, tokenId, language);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(string + ":" + tokenId.name() + " -> " + object);
            }
            return object != null ? object : SimpleAttributeSet.EMPTY;
        }

        private String languagePathToMimePathHack(LanguagePath languagePath) {
            if (languagePath.size() == 1) {
                return SyntaxHighlighting.this.mimeTypeForHack;
            }
            if (languagePath.size() > 1) {
                return SyntaxHighlighting.this.mimeTypeForHack + "/" + languagePath.subPath(1).mimePath();
            }
            throw new IllegalStateException("LanguagePath should not be empty.");
        }

        private AttributeSet findFontAndColors(FontColorSettings fontColorSettings, TokenId tokenId, Language language) {
            AttributeSet attributeSet;
            block2: {
                String string;
                Object object;
                String string2 = tokenId.name();
                attributeSet = fontColorSettings.getTokenFontColors(string2);
                if (attributeSet == null && (object = tokenId.primaryCategory()) != null) {
                    attributeSet = fontColorSettings.getTokenFontColors((String)object);
                }
                if (attributeSet != null) break block2;
                object = language.nonPrimaryTokenCategories(tokenId);
                Iterator iterator = object.iterator();
                while (iterator.hasNext() && (attributeSet = fontColorSettings.getTokenFontColors(string = (String)iterator.next())) == null) {
                }
            }
            return attributeSet;
        }

        private int moveTheSequence() {
            TokenSequence<? extends TokenId> tokenSequence = this.sequences.get(this.sequences.size() - 1);
            if (tokenSequence.moveNext() && tokenSequence.offset() < this.endOffset) {
                return 1;
            }
            if (this.sequences.size() > 1) {
                TokenSequence<? extends TokenId> tokenSequence2 = this.sequences.get(this.sequences.size() - 2);
                tokenSequence.moveEnd();
                if (tokenSequence.movePrevious()) {
                    if (tokenSequence.offset() + tokenSequence.token().length() < tokenSequence2.offset() + tokenSequence2.token().length()) {
                        return 3;
                    }
                    this.sequences.remove(this.sequences.size() - 1);
                    return this.moveTheSequence();
                }
                throw new IllegalStateException("Invalid state");
            }
            this.sequences.clear();
            return 4;
        }

        private void checkVersion() {
            if (this.version != SyntaxHighlighting.this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

