/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.highlighting.support;

import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.modules.editor.lib2.highlighting.OffsetGapList;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OffsetsBag
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(OffsetsBag.class.getName());
    private Document document;
    private OffsetGapList<Mark> marks;
    private boolean mergeHighlights;
    private long version = 0L;
    private DocL docListener;

    public OffsetsBag(Document document) {
        this(document, false);
    }

    public OffsetsBag(Document document, boolean bl) {
        this.document = document;
        this.mergeHighlights = bl;
        this.marks = new OffsetGapList();
        this.docListener = new DocL(this);
        this.document.addDocumentListener(this.docListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlight(int n, int n2, AttributeSet attributeSet) {
        int[] nArray;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            nArray = this.addHighlightImpl(n, n2, attributeSet);
            if (nArray != null) {
                ++this.version;
            }
        }
        if (nArray != null) {
            this.fireHighlightsChange(nArray[0], nArray[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllHighlights(HighlightsSequence highlightsSequence) {
        int[] nArray;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            nArray = this.addAllHighlightsImpl(highlightsSequence);
            if (nArray != null) {
                ++this.version;
            }
        }
        if (nArray != null) {
            this.fireHighlightsChange(nArray[0], nArray[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlights(HighlightsSequence highlightsSequence) {
        if (highlightsSequence instanceof Seq) {
            this.setHighlights(((Seq)highlightsSequence).getBag());
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            int[] nArray = this.clearImpl();
            int[] nArray2 = this.addAllHighlightsImpl(highlightsSequence);
            if (nArray != null) {
                n = nArray[0];
                n2 = nArray[1];
            }
            if (nArray2 != null) {
                if (n == Integer.MAX_VALUE || n > nArray2[0]) {
                    n = nArray2[0];
                }
                if (n2 == Integer.MIN_VALUE || n2 < nArray2[1]) {
                    n2 = nArray2[1];
                }
            }
            if (n < n2) {
                ++this.version;
            }
        }
        if (n < n2) {
            this.fireHighlightsChange(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlights(OffsetsBag offsetsBag) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            OffsetGapList<Mark> offsetGapList2;
            int[] nArray = this.clearImpl();
            int[] nArray2 = null;
            OffsetGapList<Mark> offsetGapList3 = offsetGapList2 = offsetsBag.getMarks();
            synchronized (offsetGapList3) {
                Iterator iterator = offsetGapList2.iterator();
                while (iterator.hasNext()) {
                    Mark mark = (Mark)iterator.next();
                    this.marks.add(this.marks.size(), new Mark(mark.getOffset(), mark.getAttributes()));
                }
                if (this.marks.size() > 0) {
                    nArray2 = new int[]{((Mark)this.marks.get(0)).getOffset(), ((Mark)this.marks.get(this.marks.size() - 1)).getOffset()};
                }
            }
            if (nArray != null) {
                n = nArray[0];
                n2 = nArray[1];
            }
            if (nArray2 != null) {
                if (n == Integer.MAX_VALUE || n > nArray2[0]) {
                    n = nArray2[0];
                }
                if (n2 == Integer.MIN_VALUE || n2 < nArray2[1]) {
                    n2 = nArray2[1];
                }
            }
            if (n < n2) {
                ++this.version;
            }
        }
        if (n < n2) {
            this.fireHighlightsChange(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlights(int n, int n2, boolean bl) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        if (n == n2) {
            return;
        }
        assert (n < n2) : "Start offset must be before the end offset. startOffset = " + n + ", endOffset = " + n2;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            if (this.marks.isEmpty()) {
                return;
            }
            int n5 = this.indexBeforeOffset(n);
            int n6 = this.indexBeforeOffset(n2, n5 < 0 ? 0 : n5, this.marks.size() - 1);
            if (bl) {
                if (n5 == n6) {
                    if (n5 != -1 && ((Mark)this.marks.get(n5)).getAttributes() != null) {
                        AttributeSet attributeSet = ((Mark)this.marks.get(n5)).getAttributes();
                        if (((Mark)this.marks.get(n5)).getOffset() == n) {
                            this.marks.set(n5, new Mark(n2, attributeSet));
                        } else {
                            this.marks.add(n5 + 1, new Mark(n, null));
                            this.marks.add(n5 + 2, new Mark(n2, attributeSet));
                        }
                        n3 = n;
                        n4 = n2;
                    }
                    n5 = Integer.MAX_VALUE;
                    n6 = Integer.MIN_VALUE;
                } else {
                    assert (n6 != -1) : "Invalid range: startIdx = " + n5 + " endIdx = " + n6;
                    if (((Mark)this.marks.get(n6)).getAttributes() != null) {
                        this.marks.set(n6, new Mark(n2, ((Mark)this.marks.get(n6)).getAttributes()));
                        n4 = n2;
                        --n6;
                    }
                    if (n5 != -1 && ((Mark)this.marks.get(n5)).getAttributes() != null) {
                        if (++n5 <= n6) {
                            this.marks.set(n5, new Mark(n, null));
                        } else {
                            this.marks.add(n5, new Mark(n, null));
                        }
                        n3 = n;
                    }
                    ++n5;
                }
            } else {
                if (n5 == -1 || ((Mark)this.marks.get(n5)).getAttributes() == null) {
                    ++n5;
                }
                if (n6 != -1 && ((Mark)this.marks.get(n6)).getAttributes() != null) {
                    ++n6;
                }
            }
            if (n5 <= n6) {
                if (n3 == Integer.MAX_VALUE) {
                    n3 = ((Mark)this.marks.get(n5)).getOffset();
                }
                if (n4 == Integer.MIN_VALUE) {
                    n4 = ((Mark)this.marks.get(n6)).getOffset();
                }
                this.marks.remove(n5, n6 - n5 + 1);
            }
            if (n3 < n4) {
                ++this.version;
            }
        }
        if (n3 < n4) {
            this.fireHighlightsChange(n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlightsSequence getHighlights(int n, int n2) {
        if (LOG.isLoggable(Level.FINE) && n >= n2) {
            LOG.fine("startOffset must be less than endOffset: startOffset = " + n + " endOffset = " + n2);
        }
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            return new Seq(this.version, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int[] nArray;
        OffsetGapList<Mark> offsetGapList = this.marks;
        synchronized (offsetGapList) {
            nArray = this.clearImpl();
            if (nArray != null) {
                ++this.version;
            }
        }
        if (nArray != null) {
            this.fireHighlightsChange(nArray[0], nArray[1]);
        }
    }

    OffsetGapList<Mark> getMarks() {
        return this.marks;
    }

    Document getDocument() {
        return this.document;
    }

    private int[] addHighlightImpl(int n, int n2, AttributeSet attributeSet) {
        if (n == n2) {
            return null;
        }
        assert (n < n2) : "Start offset must be before the end offset. startOffset = " + n + ", endOffset = " + n2;
        assert (attributeSet != null) : "Highlight attributes must not be null.";
        if (this.mergeHighlights) {
            this.merge(n, n2, attributeSet);
        } else {
            this.trim(n, n2, attributeSet);
        }
        return new int[]{n, n2};
    }

    private void merge(int n, int n2, AttributeSet attributeSet) {
        Object object;
        AttributeSet attributeSet2 = null;
        int n3 = this.indexBeforeOffset(n);
        if (n3 < 0) {
            n3 = 0;
            this.marks.add(n3, new Mark(n, attributeSet));
        } else {
            Mark mark = (Mark)this.marks.get(n3);
            object = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributeSet, mark.getAttributes()});
            attributeSet2 = mark.getAttributes();
            if (mark.getOffset() == n) {
                mark.setAttributes((AttributeSet)object);
            } else {
                this.marks.add(++n3, new Mark(n, (AttributeSet)object));
            }
        }
        int n4 = n3 + 1;
        while (true) {
            if (n4 < this.marks.size()) {
                object = (Mark)this.marks.get(n4);
                if (((OffsetGapList.Offset)object).getOffset() >= n2) {
                    if (((OffsetGapList.Offset)object).getOffset() <= n2) break;
                    this.marks.add(n4, new Mark(n2, attributeSet2));
                    break;
                }
            } else {
                this.marks.add(n4, new Mark(n2, attributeSet2));
                break;
            }
            attributeSet2 = ((Mark)object).getAttributes();
            ((Mark)object).setAttributes(AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributeSet, attributeSet2}));
            ++n4;
        }
    }

    private void trim(int n, int n2, AttributeSet attributeSet) {
        int n3;
        int n4 = this.indexBeforeOffset(n2, (n3 = this.indexBeforeOffset(n)) < 0 ? 0 : n3, this.marks.size() - 1);
        if (n3 == n4) {
            AttributeSet attributeSet2 = null;
            if (n3 != -1 && ((Mark)this.marks.get(n3)).getAttributes() != null) {
                attributeSet2 = ((Mark)this.marks.get(n3)).getAttributes();
            }
            if (n3 != -1 && ((Mark)this.marks.get(n3)).getOffset() == n) {
                ((Mark)this.marks.get(n3)).setAttributes(attributeSet);
            } else {
                this.marks.add(++n3, new Mark(n, attributeSet));
            }
            this.marks.add(++n3, new Mark(n2, attributeSet2));
        } else {
            assert (n4 != -1) : "Invalid range: startIdx = " + n3 + " endIdx = " + n4;
            this.marks.set(n4, new Mark(n2, ((Mark)this.marks.get(n4)).getAttributes()));
            if (++n3 <= --n4) {
                this.marks.set(n3, new Mark(n, attributeSet));
            } else {
                this.marks.add(n3, new Mark(n, attributeSet));
            }
            if (++n3 <= n4) {
                this.marks.remove(n3, n4 - n3 + 1);
            }
        }
    }

    private int[] addAllHighlightsImpl(HighlightsSequence highlightsSequence) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        while (highlightsSequence.moveNext()) {
            this.addHighlightImpl(highlightsSequence.getStartOffset(), highlightsSequence.getEndOffset(), highlightsSequence.getAttributes());
            if (n == Integer.MAX_VALUE) {
                n = highlightsSequence.getStartOffset();
            }
            n2 = highlightsSequence.getEndOffset();
        }
        if (n != Integer.MAX_VALUE && n2 != Integer.MIN_VALUE) {
            return new int[]{n, n2};
        }
        return null;
    }

    private int[] clearImpl() {
        if (!this.marks.isEmpty()) {
            int n = ((Mark)this.marks.get(0)).getOffset();
            int n2 = ((Mark)this.marks.get(this.marks.size() - 1)).getOffset();
            this.marks.clear();
            return new int[]{n, n2};
        }
        return null;
    }

    private int indexBeforeOffset(int n, int n2, int n3) {
        int n4 = this.marks.findElementIndex(n, n2, n3);
        if (n4 < 0) {
            n4 = -n4 - 1;
            return n4 - 1;
        }
        return n4;
    }

    private int indexBeforeOffset(int n) {
        return this.indexBeforeOffset(n, 0, this.marks.size() - 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DocL
    extends WeakReference<OffsetsBag>
    implements DocumentListener,
    Runnable {
        private Document document;

        public DocL(OffsetsBag offsetsBag) {
            super(offsetsBag, Utilities.activeReferenceQueue());
            this.document = offsetsBag.getDocument();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            OffsetsBag offsetsBag = (OffsetsBag)this.get();
            if (offsetsBag != null) {
                OffsetGapList offsetGapList = offsetsBag.marks;
                synchronized (offsetGapList) {
                    offsetsBag.marks.defaultInsertUpdate(documentEvent.getOffset(), documentEvent.getLength());
                }
            } else {
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            OffsetsBag offsetsBag = (OffsetsBag)this.get();
            if (offsetsBag != null) {
                OffsetGapList offsetGapList = offsetsBag.marks;
                synchronized (offsetGapList) {
                    offsetsBag.marks.defaultRemoveUpdate(documentEvent.getOffset(), documentEvent.getLength());
                }
            } else {
                this.run();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void run() {
            Document document = this.document;
            if (document != null) {
                document.removeDocumentListener(this);
                this.document = null;
            }
        }
    }

    static final class Mark
    extends OffsetGapList.Offset {
        private AttributeSet attribs;

        public Mark(int n, AttributeSet attributeSet) {
            super(n);
            this.attribs = attributeSet;
        }

        public AttributeSet getAttributes() {
            return this.attribs;
        }

        public void setAttributes(AttributeSet attributeSet) {
            this.attribs = attributeSet;
        }
    }

    private final class Seq
    implements HighlightsSequence {
        private long version;
        private int startOffset;
        private int endOffset;
        private int idx = -1;

        public Seq(long l, int n, int n2) {
            this.version = l;
            this.startOffset = n;
            this.endOffset = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            OffsetGapList offsetGapList = OffsetsBag.this.marks;
            synchronized (offsetGapList) {
                this.checkVersion();
                if (this.idx == -1) {
                    this.idx = OffsetsBag.this.indexBeforeOffset(this.startOffset);
                    if (this.idx == -1 && OffsetsBag.this.marks.size() > 0) {
                        this.idx = 0;
                    }
                } else {
                    ++this.idx;
                }
                while (this.isIndexValid(this.idx)) {
                    if (((Mark)OffsetsBag.this.marks.get(this.idx)).getAttributes() != null) {
                        return true;
                    }
                    ++this.idx;
                }
                return false;
            }
        }

        public int getStartOffset() {
            OffsetGapList offsetGapList = OffsetsBag.this.marks;
            synchronized (offsetGapList) {
                assert (this.idx != -1) : "Sequence not initialized, call moveNext() first.";
                this.checkVersion();
                if (this.isIndexValid(this.idx)) {
                    return Math.max(((Mark)OffsetsBag.this.marks.get(this.idx)).getOffset(), this.startOffset);
                }
                throw new NoSuchElementException();
            }
        }

        public int getEndOffset() {
            OffsetGapList offsetGapList = OffsetsBag.this.marks;
            synchronized (offsetGapList) {
                assert (this.idx != -1) : "Sequence not initialized, call moveNext() first.";
                this.checkVersion();
                if (this.isIndexValid(this.idx)) {
                    return Math.min(((Mark)OffsetsBag.this.marks.get(this.idx + 1)).getOffset(), this.endOffset);
                }
                throw new NoSuchElementException();
            }
        }

        public AttributeSet getAttributes() {
            OffsetGapList offsetGapList = OffsetsBag.this.marks;
            synchronized (offsetGapList) {
                assert (this.idx != -1) : "Sequence not initialized, call moveNext() first.";
                this.checkVersion();
                if (this.isIndexValid(this.idx)) {
                    return ((Mark)OffsetsBag.this.marks.get(this.idx)).getAttributes();
                }
                throw new NoSuchElementException();
            }
        }

        private boolean isIndexValid(int n) {
            return n >= 0 && n + 1 < OffsetsBag.this.marks.size() && ((Mark)OffsetsBag.this.marks.get(n)).getOffset() < this.endOffset && ((Mark)OffsetsBag.this.marks.get(n + 1)).getOffset() > this.startOffset;
        }

        private OffsetsBag getBag() {
            return OffsetsBag.this;
        }

        private void checkVersion() {
            if (OffsetsBag.this.version != this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

